/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright: Przemyslaw Jeziorski (przjez@gmail.com)
***************************************************************************/
#include<Program_signaling.h>

mxArray *readMatlab(MATFile *mfp, const char *var_name);

int main(int argc, char *argv[]) {
  long *mySeed = (long *) mxMalloc(4*sizeof(long));
  double *mySeedInit;
  int threadsN = 48;
  int size;
  double *miscVector;
  double *domains;
  double *parameters;
  double *clicks;
  ThreadMomentStructure *input;
  double *output;
  mxArray *temp;
  MATFile *mfp;
  int i,k,j,k2;
  mxArray *outputMx;

  myfile = fopen ("output_gf.txt","a");

  if ((mfp = matOpen(argv[1], "r")) == NULL) {
    fprintf(stderr, "Cannot open MAT-file %s\n", argv[1]);
    #ifdef DEBUG
      fprintf(myfile, "Cannot open MAT-file %s\n", argv[1]);
    #endif
    #ifdef COUT_DEBUG
      printf("Cannot open MAT-file %s\n", argv[1]);
    #endif
    exit(1);
  } else {
    #ifdef DEBUG
      fprintf(myfile, "Opening MAT-file %s\n", argv[1]);
    #endif
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", argv[1]);
    #endif
  }

  mySeedInit = mxGetPr(readMatlab(mfp, "seed"));
  temp=readMatlab(mfp, "misc");
  miscVector = mxGetPr(temp);
  size = mxGetN(temp);
  domains = mxGetPr(readMatlab(mfp, "domains"));
  weights = mxGetPr(readMatlab(mfp, "position_weights"));
  clicks = mxGetPr(readMatlab(mfp, "clicks"));

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n", argv[1]);
    exit(EXIT_FAILURE);
  }

  if ((mfp = matOpen(argv[2], "r")) == NULL) {
    fprintf(stderr, "Cannot open MAT-file %s\n", argv[2]);
    #ifdef DEBUG
      fprintf(myfile, "Cannot open MAT-file %s\n", argv[2]);
    #endif
    #ifdef COUT_DEBUG
      printf("Cannot open MAT-file %s\n", argv[2]);
    #endif
    exit(1);
  } else {
    #ifdef DEBUG
      fprintf(myfile, "Opening MAT-file %s\n", argv[2]);
    #endif
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", argv[2]);
    #endif
  }

  parameters = mxGetPr(readMatlab(mfp, "parameters"));

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n", argv[2]);
    exit(EXIT_FAILURE);
  }

  mySeed[0] = (long) mySeedInit[0];
  mySeed[1] = (long) mySeedInit[1];
  mySeed[2] = (long) mySeedInit[2];
  mySeed[3] = (long) mySeedInit[3];

  seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

  createGenerators(threadsN, mySeed, seed);

  data = (dataStruct *) mxMalloc(size*sizeof(dataStruct));
  k=0;
  k2=0;
  for (i=0;i<size;++i) {
    data[i].searchString=miscVector[2*i+1];
    data[i].numberOfAds=miscVector[2*i];
    for (j=0;j<data[i].numberOfAds;++j) {
      data[i].domains[j]=domains[k+j];
    }
    k+=9;
    for (j=0;j<5;++j) {
      data[i].clicks[j]=clicks[k2];
      k2++;
    }
  }

  jump=size/SMP+1;

#ifdef THREADS
  pthread_t thread_id[SMP];
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
#endif
  input = (ThreadMomentStructure *) malloc(SMP*sizeof(ThreadMomentStructure));
  for (j=0;j<SMP;j++) {
    input[j].thread=j;
    input[j].start=jump*j;
    input[j].stop=MIN(jump*(j+1),size);
    for (i=0;i<NO_PARAMETERS;++i) {
      input[j].parameters[i]=parameters[i];
    }
#ifdef THREADS
    pthread_create(&thread_id[j], &attr, realdata_counterThread, (void *) &input[j] );
#else
    momentThread((void *) &input[j]);
#endif
  }
#ifdef THREADS
  pthread_attr_destroy(&attr);
  for (j=0;j<SMP;j++) {
    pthread_join(thread_id[j], NULL);
  }
#endif
  
  outputMx = mxCreateDoubleMatrix(NO_GF,1,mxREAL);
  output = mxGetPr(outputMx);

  for (i=0;i<NO_GF;++i) {
    output[i]=0;
  }

  for (j=0;j<SMP;j++) {
    for (i=0;i<NO_GF;++i) {
      output[i]+=input[j].gf[i];
    }
  }

  if ((mfp = matOpen(argv[3], "w")) == NULL) {
    fprintf(stderr, "Cannot open MAT-file %s\n", argv[3]);
    #ifdef DEBUG
      fprintf(myfile, "Cannot open MAT-file %s\n", argv[3]);
    #endif
    #ifdef COUT_DEBUG
      printf("Cannot open MAT-file %s\n", argv[3]);
    #endif
    exit(1);
  } else {
    #ifdef DEBUG
      fprintf(myfile, "Opening MAT-file %s\n", argv[3]);
    #endif
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", argv[3]);
    #endif
  }


  matPutVariable(mfp, "realdata_counter", outputMx);

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n", argv[3]);
    exit(EXIT_FAILURE);
  }

  fclose(myfile);
  /*printf("Error %d %d %d\n",number,number2,at_least_1);*/
}

mxArray *readMatlab(MATFile *mfp, const char *var_name) {
  mxArray *array_ptr;
  int *from, *to;

  if ((array_ptr = matGetVariable(mfp, var_name)) == NULL) {
    fprintf(stderr, "Cannot read matlab variable %s\n", var_name);
    #ifdef COUT_DEBUG
    printf("Cannot read matlab variable %s\n", var_name);
      #endif
      #ifdef DEBUG
        fprintf(myfile, "Cannot read matlab variable %s\n", var_name);
      #endif
      exit(1);
  }
  if ((mxGetNumberOfElements(array_ptr) == 1) && mxIsNumeric(array_ptr)) {
    #ifdef COUT_DEBUG
      printf("Reading matlab variable %s = %f\n", var_name, mxGetScalar(array_ptr));
    #endif
    #ifdef DEBUG
      fprintf(myfile, "Reading matlab variable %s = %f\n", var_name, mxGetScalar(array_ptr));
    #endif
  } else {
    #ifdef COUT_DEBUG
      printf("Reading matlab variable %s (", var_name);
    #endif
    #ifdef DEBUG
      fprintf(myfile, "Reading matlab variable %s (", var_name);
    #endif
    from = (int *) mxGetDimensions(array_ptr);
    to = from+mxGetNumberOfDimensions(array_ptr)-1;
    for (; from<to; from++) {
      #ifdef COUT_DEBUG
        printf("%dx", *from);
      #endif
      #ifdef DEBUG
        fprintf(myfile, "%dx", *from);
      #endif
    }
    #ifdef COUT_DEBUG
      printf("%d)\n", *from);
    #endif
    #ifdef DEBUG
      fprintf(myfile, "%d)\n", *from);
    #endif
  }

  return array_ptr;
}
