/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright: Przemyslaw Jeziorski (przjez@gmail.com)
***************************************************************************/
#include<Program_signaling.h>

int kill_moments[] = { 5, 6, 7, 12, 13, 14, 15, 18, 19, 29, 30, 53, 54, 77, 78, 79, 80, 84, 85, 90 };
double grid[] = {-2.020182870, -0.9585724646, 0, 0.9585724646, 2.020182870};
double gauss_weights[] = {0.0112574113226171,         0.222075921976139,         0.533333334211809,         0.222075921976139,        0.0112574113226171};

int SequentialSearch(int *domains, int domain, int n) {
  int i;
  for (i=0;i<n;++i) {
    if (domains[i]==domain) {
      return i;
    }
  }

  return -1;
}

void counterFactual1(double *parameters, double *results) {
  int string, i, j, offset, n;
  double output[NO_MOMENTS];
  double output2[NO_MOMENTS];
  int domains_fixed_effects_weather[] = { 97, 258, 20, 397, 0 }; /* weather */
  int domains_fixed_effects_white_pages[] = { 57, 388, 121, 81, 0 }; /* white pages */
  int domains_fixed_effects_games[] = { 39, 25, 129, 88,0 }; /* Games */
  int domains_fixed_effects_sex[] = { 54, 5, 297, 2484,0 }; /* Sex */
  int *domains_fixed_effects;
  dataStruct data;

  for(n=0;n<100;n++) {
    results[n]=0;
  }

  for(n=0;n<1000;n++) {
    printf("%d\n",n);
    for(string=0;string<4;++string) {
      switch (string) {
      case 0: /* Games */
        offset = 0;
        domains_fixed_effects=domains_fixed_effects_games;
        break;
      case 1: /* Weather */
        offset = 24;
        domains_fixed_effects=domains_fixed_effects_weather;
        break;
      case 2: /* White pages */
        offset = 48;
        domains_fixed_effects=domains_fixed_effects_white_pages;
        break;
      case 3: /* Sex */
        offset = 72;
        domains_fixed_effects=domains_fixed_effects_sex;
        break;
      default:
        return;
      }
      for(i=0;i<5;i++) {
        for(j=0;j<5;j++) {
          data.numberOfAds=2;
          data.searchString=string;
          data.domains[0]=domains_fixed_effects[j];
          data.domains[1]=domains_fixed_effects[i];
	        bundleChoice(parameters, data, output, 0, output2);
	        results[25*string+5*i+j]+=output[offset+1];
        }
      }
    }
  }
  for(n=0;n<100;n++) {
    results[n]/=1000;
  }
}
 
void greedyIncrementalUtility(double *parameters, double *u, double *u_exp, double *cost, int *idx, int length) {
  int i,j;
  double u_temp[3][3];
  double max;

  switch (length) {
  case 1:
    idx[0]=0;
    return;
  case 2:
    if ((u[0]+cost[0])>=(u[1]+cost[1])) {
      idx[0]=0;
      idx[1]=1;
    } else {
      idx[1]=0;
      idx[0]=1;
    }
    return;
  case 3:
    u_temp[0][1] = pow(u_exp[0]+u_exp[1],1/(1+parameters[M1_R]))-u[0]+cost[1];
    u_temp[0][2] = pow(u_exp[0]+u_exp[2],1/(1+parameters[M1_R]))-u[0]+cost[2];
    u_temp[1][0] = pow(u_exp[1]+u_exp[0],1/(1+parameters[M1_R]))-u[1]+cost[0];
    u_temp[1][2] = pow(u_exp[1]+u_exp[2],1/(1+parameters[M1_R]))-u[1]+cost[2];
    u_temp[2][0] = pow(u_exp[2]+u_exp[0],1/(1+parameters[M1_R]))-u[2]+cost[0];
    u_temp[2][1] = pow(u_exp[2]+u_exp[1],1/(1+parameters[M1_R]))-u[2]+cost[1];

    max = -1e10;
    for(i=0;i<3;++i) {
      if((u[i]+cost[i])>max) {
        idx[0]=i;
	max=u[i]+cost[i];
      }
    }

    max = -1e10;
    for(i=0;i<3;++i) {
      if(i==idx[0]) continue;
      if(u_temp[idx[0]][i]>max) {
        idx[1]=i;
	max=u_temp[idx[0]][i];
      }
    }
    for (j=2;j>=0;--j) {
      if ((idx[0]!=j) && (idx[1]!=j)) {
        idx[2]=j;
        return;
      }
    }
  }
}

void incrementalUtility(double *parameters, double *u, double *u_exp, double *cost, int *idx, int length) {
  double temp;
  double u_temp[3][3];
  double max;
  int i,j;

  switch (length) {
  case 1:
    idx[0]=0;
    return;
  case 2:
    if ((u[0]+cost[0])>=(u[1]+cost[1])) {
      idx[0]=0;
      idx[1]=1;
    } else {
      idx[1]=0;
      idx[0]=1;
    }
    return;
  case 3:
    u_temp[0][1] = pow(u_exp[0]+u_exp[1],1/(1+parameters[M1_R]))+cost[0]+cost[1];
    u_temp[0][2] = pow(u_exp[0]+u_exp[2],1/(1+parameters[M1_R]))+cost[0]+cost[2];
    u_temp[1][0] = pow(u_exp[1]+u_exp[0],1/(1+parameters[M1_R]))+cost[1]+cost[0];
    u_temp[1][2] = pow(u_exp[1]+u_exp[2],1/(1+parameters[M1_R]))+cost[1]+cost[2];
    u_temp[2][0] = pow(u_exp[2]+u_exp[0],1/(1+parameters[M1_R]))+cost[2]+cost[0];
    u_temp[2][1] = pow(u_exp[2]+u_exp[1],1/(1+parameters[M1_R]))+cost[2]+cost[1];

    max = -1e10;
    for (i=0;i<3;++i) {
      for (j=0;j<3;++j) {
        if (j==i) continue;
        if ((u_temp[i][j]+u[i]+cost[i])>max) {
          max=u_temp[i][j]+u[i]+cost[i];
          idx[0]=i;
        }
      }
    }
    max = -1e10;
    for (j=0;j<3;++j) {
      if (j==idx[0]) continue;
      if (u_temp[idx[0]][j]>max) {
        max=u_temp[idx[0]][j];
        idx[1]=j;
      }
    }

    for (j=2;j>=0;--j) {
      if ((idx[0]!=j) && (idx[1]!=j)) {
        idx[2]=j;
        return;
      }
    }
  }
}

int next_comb(int *comb, int k, int n) {
  int i = k - 1;
  ++comb[i];
  while ((i > 0) && (comb[i] >= n - k + 1 + i)) {
    --i;
    ++comb[i];
  }

  if (comb[0] > n - k) /* Combination (n-k, n-k+1, ..., n) reached */
    return false; /* No more combinations can be generated */

  /* comb now looks like (..., x, n, n, n, ..., n).
  Turn it into (..., x, x + 1, x + 2, ...) */
  for (i = i + 1; i < k; ++i) {
    comb[i] = comb[i - 1] + 1;
  }

  return true;
}

void make_choice_signaling(double *parameters, int number_of_choices, double **utilities_grid, double *u_noexp,
                 double *positions, int *choice, int *best_nest, double u0, double R, int *actual_positions) {
  int biggest_nest, k, z, c, i;
  double cost;
  double candidate;
  int idx[number_of_choices];
  double RR = 1/(1+R);


//  double V4[number_of_choices-3][GRID_SIZE+1][number_of_choices-2][GRID_SIZE+1][number_of_choices-1][GRID_SIZE+1][number_of_choices][GRID_SIZE+1];
  double V3[number_of_choices-2][GRID_SIZE+1][number_of_choices-1][GRID_SIZE+1][number_of_choices][GRID_SIZE+1];
  double V2[number_of_choices-1][GRID_SIZE+1][number_of_choices][GRID_SIZE+1];
  double V1[number_of_choices][GRID_SIZE+1];
  int policy2[number_of_choices-1][GRID_SIZE+1][number_of_choices][GRID_SIZE+1];
  int policy1[number_of_choices][GRID_SIZE+1];
  double temp;
  
  char p[4];
  char x[4];

  if(number_of_choices > MAXIMUM_CHOICE) {
    biggest_nest = MAXIMUM_CHOICE;
  } else {
    biggest_nest = number_of_choices;
  }
/*
  // First generate class with 4 clicks
  if(biggest_nest > 3) {
    for(p[0] = 0; p[0] < number_of_choices - 3; p[0]++) {
      for(p[1] = p[0] + 1; p[1] < number_of_choices - 2; p[1]++) {
        for(p[2] = p[1] + 1; p[2] < number_of_choices - 1; p[2]++) {
          for(p[3] = p[2] + 1; p[3] < number_of_choices; p[3]++) {
            cost=0;
            for(k = 0; k < 5; k++) {
//              cost += positions[actual_positions[p[k]]];
            }
            for(x[0] = 0; x[0] <= GRID_SIZE; x[0]++) {
              for(x[1] = 0; x[1] <= GRID_SIZE; x[1]++) {
                for(x[2] = 0; x[2] <= GRID_SIZE; x[2]++) {
                  for(x[3] = 0; x[3] <= GRID_SIZE; x[3]++) {
                    uCum=0;
                    for(k = 0; k < 5; k++) {
//                      uCum += utilities_grid[actual_positions[p[k]]][x[k]];
                    }
                    //printf("%d %d %d %d %d %d %d %d %d\n",p[0],x[0],p[1],x[1],p[2],x[2],p[3],x[3],number_of_choices);
                    V4[p[0]][x[0]][p[1]][x[1]][p[2]][x[2]][p[3]][x[3]] = pow(uCum, 1 / (1 + R)) + cost;
                  }
                }
              }
            }        
          }
        }
      }
    }
  }
*/
  // Generate class with 3 clicks
  if(biggest_nest > 2) {
    for(p[0] = 0; p[0] < number_of_choices - 2; p[0]++) {
      for(p[1] = p[0] + 1; p[1] < number_of_choices - 1; p[1]++) {
        for(p[2] = p[1] + 1; p[2] < number_of_choices; p[2]++) {
          cost=0;
          for(k = 0; k < 3; k++) {
            cost += positions[actual_positions[p[k]]];
          }
          for(x[0] = 0; x[0] <= GRID_SIZE; x[0]++) {
            for(x[1] = 0; x[1] <= GRID_SIZE; x[1]++) {
              for(x[2] = 0; x[2] <= GRID_SIZE; x[2]++) {
                candidate = 0;
                for(k = 0; k < 3; k++) {
                  candidate += utilities_grid[actual_positions[p[k]]][x[k]];
                }
                V3[p[0]][x[0]][p[1]][x[1]][p[2]][x[2]] = pow(candidate, RR) + cost;
              }
            }        
          }
        }
      }
    }
  }

  if(biggest_nest > 1) {
    for(p[0] = 0; p[0] < number_of_choices - 1; p[0]++) {
      for(p[1] = p[0] + 1; p[1] < number_of_choices; p[1]++) {
        cost=0;
        for(k = 0; k < 2; k++) {
          cost += positions[actual_positions[p[k]]];
        }
        for(x[0] = 0; x[0] <= GRID_SIZE; x[0]++) {
          for(x[1] = 0; x[1] <= GRID_SIZE; x[1]++) {
            candidate = 0;
            for(k = 0; k < 2; k++) {
              candidate += utilities_grid[actual_positions[p[k]]][x[k]];
            }
            candidate = pow(candidate, RR) + cost;

            policy2[p[0]][x[0]][p[1]][x[1]] = -1;
            if(biggest_nest > 2) {
              for(c = 0; c < p[0]; c++) {
                temp=0;
                for(z = 0; z < GRID_SIZE; ++z) {
                  temp+=gauss_weights[z]*V3[c][z][p[0]][x[0]][p[1]][x[1]];
                }
                if(temp > candidate) {
                  candidate = temp;
                  policy2[p[0]][x[0]][p[1]][x[1]] = c;
                }
              }
              for(c = p[0]+1; c < p[1]; c++) {
                temp=0;
                for(z = 0; z < GRID_SIZE; ++z) {  
                  temp+=gauss_weights[z]*V3[p[0]][x[0]][c][z][p[1]][x[1]];
                }
                if(temp > candidate) {
                  candidate = temp;
                  policy2[p[0]][x[0]][p[1]][x[1]] = c;
                }
              }
              for(c = p[1]+1; c < number_of_choices; c++) {
                temp=0;
                for(z = 0; z < GRID_SIZE; ++z) {
                  temp+=gauss_weights[z]*V3[p[0]][x[0]][p[1]][x[1]][c][z];
                }
                if(temp > candidate) {
                  candidate = temp;
                  policy2[p[0]][x[0]][p[1]][x[1]] = c;
                }
              }
            }
            V2[p[0]][x[0]][p[1]][x[1]] = candidate;
          }
        }
      }
    }
  }

  // Now one clicks
  if(biggest_nest>0) {
    for(p[0] = 0; p[0] < number_of_choices; p[0]++) {
      for(x[0] = 0; x[0] <= GRID_SIZE; x[0]++) {
        candidate = pow(utilities_grid[actual_positions[p[0]]][x[0]],RR)+positions[actual_positions[p[0]]];

        policy1[p[0]][x[0]] = -1;
        if(biggest_nest > 1) {
          for(c = 0; c < p[0]; c++) {
            temp=0;
            for(z = 0; z < GRID_SIZE; ++z) {  
              temp+=gauss_weights[z]*V2[c][z][p[0]][x[0]];
            }
            if(temp > candidate) {
              candidate = temp;
              policy1[p[0]][x[0]] = c;
            }
          }
          for(c = p[0]+1; c < number_of_choices; c++) {
            temp=0;
            for(z = 0; z < GRID_SIZE; ++z) {      
              temp+=gauss_weights[z]*V2[p[0]][x[0]][c][z];
            }
            if(temp > candidate) {
              candidate = temp;  
              policy1[p[0]][x[0]] = c;
            }
          }
        }
        V1[p[0]][x[0]] = candidate;
      }
    }
  } 

  candidate = u0;
  *best_nest = 0;
  if(biggest_nest>0) {
    for(c = 0; c < number_of_choices; c++) {
      temp=0;
      for(z = 0; z < GRID_SIZE; ++z) {
        temp+=gauss_weights[z]*V1[c][z];
      }

      if(temp>candidate) {
        choice[0]=c;
        *best_nest=1;
        candidate=temp;
      }

      if((*best_nest > 0) && (biggest_nest > 1)) {
        if(policy1[choice[0]][GRID_SIZE]>-1) {
          choice[1]=policy1[choice[0]][GRID_SIZE];
          *best_nest=2;
        }
        if((*best_nest > 1) && (biggest_nest > 2)) {
          // Sorting of choice
          /*for(i = 0; i < 2; i++) {
            idx[i] = i;
          }
          insertionSortInt(choice, idx, 2);*/
          if(choice[0]<choice[1]) {
            idx[1]=0;idx[0]=1;
          } else {
            idx[0]=0;idx[1]=1;
          }
          if(policy2[choice[idx[1]]][GRID_SIZE][choice[idx[0]]][GRID_SIZE] > -1) {
            choice[2]=policy2[choice[idx[1]]][GRID_SIZE][choice[idx[0]]][GRID_SIZE];
            *best_nest = 3;
            /*for(int i = 0; i < 3; i++) {
              idx[i] = i;
            }
            insertionSort(choice, idx, 3);*/
          }
        }
      }
    }
  }
  for(i = 0; i < *best_nest; i++) {
    choice[i] = actual_positions[choice[i]];
  }
}


void make_choice(double *parameters, int number_of_choices, double *utilities, double *u_noexp,
                 double *positions, int *choice_sorted, int *best_nest, double u0, double R, int *actual_positions) {
  int nest;
  int comb[number_of_choices], sorted[number_of_choices], sorted2[number_of_choices], sorted3[number_of_choices];
  int i,j;
  double candidate, maximum = u0;
  int biggest_nest;
  int choice[number_of_choices];
  double u_cost[number_of_choices];
  double u[number_of_choices];
  double u_exp[number_of_choices];
  double cost[number_of_choices];
  int did = 0;
  double RR=1/(1+R);

  *best_nest = 0;

  if (number_of_choices > MAXIMUM_CHOICE) {
    biggest_nest = MAXIMUM_CHOICE;
  } else {
    biggest_nest = number_of_choices;
  }

  for (nest = 1; nest <= biggest_nest; nest++) {
    candidate = 0;
    for (i = 0; i < nest; ++i) {
      comb[i] = i;
      candidate += utilities[actual_positions[i]];
    }

    candidate = pow(candidate, RR);

    for (i = 0; i < nest; ++i) {
      candidate += positions[actual_positions[i]];
    }

    if (candidate > maximum) {
      maximum = candidate;
      for (i = 0; i < nest; ++i) {
        choice[i] = actual_positions[comb[i]];
        *best_nest = nest;
      }
    }

    while (next_comb(comb, nest, number_of_choices)) {
      candidate = 0;
      for (i = 0; i < nest; ++i) {
        candidate += utilities[actual_positions[comb[i]]];
      }

      candidate = pow(candidate, RR);

      for (i = 0; i < nest; ++i) {
        candidate += positions[actual_positions[comb[i]]];
      }

      if (candidate > maximum) {
        maximum = candidate;
        for (i = 0; i < nest; ++i) {
          choice[i] = actual_positions[comb[i]];
          *best_nest = nest;
        }
      }
    }
  }

  for (i = 0; i < *best_nest; i++) {
    u_cost[i] = pow(utilities[choice[i]], RR) + positions[choice[i]];
    sorted[i] = i;
    u[i]=u_noexp[choice[i]];
    u_exp[i]=utilities[choice[i]];
    cost[i]=positions[choice[i]];
  }

/*  incrementalUtility(parameters, u, u_exp, cost, sorted2, *best_nest);*/
  insertionSort(u_cost, sorted, *best_nest);
/*  greedyIncrementalUtility(parameters, u, u_exp, cost, sorted3, *best_nest);*/

  /*
  if(*best_nest>0) {
    at_least_1+=*best_nest;
  }
  */

/*  for(i=0;i<*best_nest;i++) {
    if((sorted2[i]!=sorted[i]) && (jac==0) &&(*best_nest==3)) {
      number++;
      break;
    }
  }

  for(i=0;i<*best_nest;i++) {
    if((sorted2[i]!=sorted3[i]) && (jac==0)) {
      number2++;
      break;
    }
  }*/
  /*  if(did==1) {
      for(j=0;j<*best_nest;j++) {
        printf("%f %f %f\n",u[j],cost[j],u_cost[j]);
        printf("%d %d\n",sorted2[j],sorted[j]);
      }
      getchar();
    }*/

  for (i = 0; i < *best_nest; i++) {
    choice_sorted[i] = choice[sorted[i]];
  }
}

void insertionSort(double *a, int *idx, int length) {
  int i, j, index;
  double value;

  for (i = 1; i < length; ++i) {
    value = a[idx[i]];
    index = idx[i];
    for (j = i - 1; j >= 0 && a[idx[j]] < value; j--) {
      idx[j + 1] = idx[j];
    }
    idx[j + 1] = index;
  }
}

void insertionSortInt(int *a, int *idx, int length) {
  int i, j, index;
  int value;

  for (i = 1; i < length; ++i) {
    value = a[idx[i]];
    index = idx[i];
    for (j = i - 1; j >= 0 && a[idx[j]] < value; j--) {
      idx[j + 1] = idx[j];
    }
    idx[j + 1] = index;
  }
}

/*
        void make_choice_greedy(int number_of_choices, double *utilities, double *position,
            int *choice, int *best_nest, double u0, double cost_ra, double R, double exp_var, double *e) {
          int sorted[] = { 0, 1, 2, 3, 4, 5, 6, 7 };
          int maximum_bundle;
          double cumU = u0;
          int i;

	  R = fabs(R);

          // First sort utilities
          insertionSort(utilities, sorted, number_of_choices);

          maximum_bundle = (MAXIMUM_CHOICE > number_of_choices) ? number_of_choices : MAXIMUM_CHOICE;

          *best_nest = 0;

          for(i = 0; i < maximum_bundle; i++) {
            if (utilities[sorted[i]] < 0) { // Do no click further if next one has negative utility
              break;
            }

            // Compute total utility
            double u_power = Math.Pow(utilities[sorted[i]], R + 1);
            double new_cumU = cumU + u_power;

            if(pow(new_cumU, 1 / (R + 1)) + 0.5 * (exp_var - 1) * cumU * u_power / (pow(cumU + u_power, (1 + 2 * R) / (1 + R)))
               - cost_ra + position[sorted[i]] > pow(cumU, 1 / (R + 1))) {

              choice[i] = sorted[i];
              *best_nest++;

              double ex_post = utilities[sorted[i]] * e[sorted[i]];
              if (ex_post > 0) {
                cumU += Math.Pow(ex_post, R + 1);
              }
            } else {
              break;
            }
          }
        }
*/
void bundleChoice(double *parameters, dataStruct dataLine, double *output, int thread, double *outputd) {
  int domains_fixed_effects_weather[] = { 97, 258, 20, 397 }; /* weather */
  int domains_fixed_effects_white_pages[] = { 57, 388, 121, 81 }; /* white pages */
  int domains_fixed_effects_games[] = { 39, 25, 129, 88 }; /* Games */
  int domains_fixed_effects_sex[] = { 54, 5, 297, 2484 }; /* Sex */
  int *domains_fixed_effects;
  int i,z;
  int dom;
  int r,k;
  double cost_ra;
  double u;

  //double utilities[dataLine.numberOfAds];
  double u_noexp[dataLine.numberOfAds];
  double utilities_base[dataLine.numberOfAds];
  double position_effects[dataLine.numberOfAds];
  double e[dataLine.numberOfAds];
  double R;
  double pos_variance;
  double pos_variance_user;
  double variance = parameters[M1_DESCRIPTION_SIGMA]*parameters[M1_DESCRIPTION_SIGMA];

  int actual_positions[dataLine.numberOfAds];
  int choice[MAXIMUM_CHOICE];
  int best_nest;
  int maximum_bundle = (MAXIMUM_CHOICE < dataLine.numberOfAds) ? MAXIMUM_CHOICE : dataLine.numberOfAds;

  double var_cost = parameters[M1_SIGMA_COST] * parameters[M1_SIGMA_COST];

  int offset;
  int offset_param;

  double position_quality[dataLine.numberOfAds];
  double position_quality_user[dataLine.numberOfAds];
  double **utilities_grid;

  double mu, sigma, sqrtsigma, signal;

  for (i=0;i<NO_MOMENTS;++i) {
    output[i]=0;
    outputd[i]=0;
  }

  // Allocate the grid
  utilities_grid=(double **) malloc(dataLine.numberOfAds*sizeof(double *));
  for(i=0;i<dataLine.numberOfAds;++i) {
    utilities_grid[i]=(double *) malloc((GRID_SIZE+1)*sizeof(double));
  }
  /*
  for(i=0;i<63;++i) {
    printf("%f\n",parameters[i]);
  }
  */

  switch (dataLine.searchString) {
  case 0: /* Games */
    domains_fixed_effects=domains_fixed_effects_games;
    offset = 0;
    offset_param = 0;
    z=0;
    //printf("Games:\n");
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
//            -parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param]);
        z++;
      }
      //printf("%f\n",position_quality[k]);
    }
    //getchar();
    pos_variance = parameters[M1_SIGMA_POS];
    break;
  case 1: /* Weather */
    domains_fixed_effects=domains_fixed_effects_weather;
    offset = 24;
    offset_param = 10;
    z=40;
    //printf("Weather:\n");
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
//          -parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param]);
        z++;
      }
      //printf("%f\n",position_quality[k]);
    }
    pos_variance = parameters[M1_SIGMA_POS+1];
    //getchar();
    break;
  case 2: /* White pages */
    domains_fixed_effects=domains_fixed_effects_white_pages;
    offset = 48;
    offset_param = 20;
    z=80;
    //printf("White pages:\n");
    //for(i=0;i<5;++i) {
      //printf(":%f %f\n", parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param], parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param]);
    //}
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
//            -parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param]);
        z++;
      }
      //printf("%f\n",position_quality[k]);
    }
    pos_variance = parameters[M1_SIGMA_POS+2];
    //getchar();
    break;
  case 3: /* Sex */
    domains_fixed_effects=domains_fixed_effects_sex;
    offset = 72;
    offset_param = 30;
    z=120;
    //printf("Sex:\n");
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
//            -parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param]);
        z++;
      }
      //printf("%f\n",position_quality[k]);
    }
    pos_variance = parameters[M1_SIGMA_POS+3];
    //getchar();
    break;
  default:
    return;
  }

  /* Construct utilities */

  /* Now seed the generators, and the part of utility that does not change */
  for (i = 0; i < dataLine.numberOfAds; i++) {
    /*if (i >= 6) {
        position_effects[i] = parameters[Constants.M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.3 - 100 * parameters[Constants.M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
    } else if (i == 5) {
        position_effects[i] = parameters[Constants.M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.1 - 100 * parameters[Constants.M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
    } else {
        position_effects[i] = parameters[Constants.M1_POSITION_FIXED_EFFECTS + i + offset_param] - 100 * parameters[Constants.M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
    }

    int dom = domains_fixed_effects.SequentialSearch(Convert.ToInt32(domains[i]));
    if (dom >= 0) {
        utilities_base[i] = parameters[Constants.M1_DOMAIN_FIXED_EFFECTS + dom + offset_param] + 100 * parameters[Constants.M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
    } else {
        utilities_base[i] = 100 * parameters[Constants.M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
    }*/
    if (i >= 6) {
      position_effects[i] = parameters[M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.3;
//                            + parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param];
    } else if (i == 5) {
      position_effects[i] = parameters[M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.1;
//                            + parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param];
    } else {
      position_effects[i] = parameters[M1_POSITION_FIXED_EFFECTS + i + offset_param];
//                            + parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param];
    }

    dom = SequentialSearch(domains_fixed_effects,dataLine.domains[i],4);
    if (dom >= 0) {
      utilities_base[i] = parameters[M1_DOMAIN_FIXED_EFFECTS + dom + offset_param];
//                          - parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param];
    } else {
      utilities_base[i] = parameters[M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
//                          - parameters[M1_DOMAIN_FIXED_EFFECTS + 5 + offset_param];
    }
  }

  for (r = 0; r < NO_DRAWS; r++) {
    cost_ra = parameters[M1_SIGMA_COST] * nextNormal(seed[thread]);
    //pos_variance_user = pos_variance;
    pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * nextNormal(seed[thread]);
    pos_variance_user*=pos_variance_user;
    // Compute variance of the posterior
    sigma=1/(1/variance+1/pos_variance_user);
    // Get stardard deviation
    sqrtsigma=sqrt(sigma);
    R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(seed[thread]);

    k = 0;
    for (i = 0; i < dataLine.numberOfAds; i++) {
      // True utility
      u = nextExponential(seed[thread]) + cost_ra;
      position_quality_user[i] = position_quality[i];
      // Compute the kernel of the mean of the posterior (to avoid multiplication)
      signal = utilities_base[i] + sqrt(variance) * nextNormal(seed[thread]);
      mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;

      if (mu > 0) {
//        utilities[i] = pow(u, R + 1);
//        u_noexp[i] = u;
        actual_positions[k] = i;
        // Construct the integration grid
        for(z=0;z<GRID_SIZE;++z) {
          utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
//          utilities_grid[i][z]=utilities[i];
        }
        // Last part of the grid is the true quality
        utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1);
//        utilities_grid[i][GRID_SIZE]=utilities[i];
        k++;
      } else {
        /*
        for(z=0;z<GRID_SIZE;++z) {
          utilities_grid[i][z]=0;
        } 
        // Last part of the grid is the true quality
        utilities_grid[i][GRID_SIZE]=0;
        */
        //utilities[i] = 0;
      }
    }

    /*make_choice_greedy(numberOfAds, utilities, position_effects, choice, out best_nest, 0,
        0,
        parameters[Constants.M1_R], exp_var, e);*/
    make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
    //make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);

    for (i = 0; i < best_nest; i++) {
      if (choice[i] < 7) {
        output[choice[i] + offset] += 1; /* 0..5 Choice */
      }

      dom = -1;
      if (choice[i] < dataLine.numberOfAds) {
        dom = SequentialSearch(domains_fixed_effects,dataLine.domains[choice[i]],4);
      }

      if (dom >= 0) {
        output[7 + dom + offset] += 1;
      }

      if (dom == 0) { /* Domain-position clicks */
        switch (choice[i]) {
        case 0:
          output[offset + 11]++;
          break;
        case 1:
          output[offset + 12]++;
          break;
        case 2:
          output[offset + 13]++;
          break;
        }
      } else {
        if (dom == 1) {
          switch (choice[i]) {
          case 0:
            output[offset + 14]++;
            break;
          case 1:
            output[offset + 15]++;
            break;
          case 2:
            output[offset + 16]++;
            break;
          }
        }
      }

      if ((dataLine.domains[choice[i]] == domains_fixed_effects[1]) && (choice[i] == 1)
          && (dataLine.domains[0] == domains_fixed_effects[0])) {
        output[17 + offset] += 10;
      };

      if ((dataLine.domains[choice[i]] == domains_fixed_effects[1]) && (choice[i] == 1)
          && (dataLine.domains[0] == domains_fixed_effects[2])) {
        output[18 + offset] += 10;
      };

      if ((dataLine.domains[choice[i]] == domains_fixed_effects[2]) && (choice[i] == 1)
          && (dataLine.domains[0] == domains_fixed_effects[1])) {
        output[19 + offset] += 10;
      }

      if ((dataLine.domains[choice[i]] == domains_fixed_effects[0]) && (i < best_nest - 1)) {
        output[20 + offset] += 10;
      };
      if ((dataLine.domains[choice[i]] == domains_fixed_effects[1]) && (i < best_nest - 1)) {
        output[21 + offset] += 10;
      };

      if ((dataLine.domains[choice[i]] == domains_fixed_effects[2]) && (i < best_nest - 1)) {
        output[22 + offset] += 10;
      };

    }

    if (best_nest > 1) {
      if (goBack(choice, best_nest)) {
        output[offset + 23]++;
      }
    }

    if (best_nest == 2) {
      output[96]++;
    }

    if (best_nest == 3) {
      output[97]++;
    }
  } // eND R-LOOP


  for (i = 0; i < NO_MOMENTS; i++) {
    output[i] /= (double)NO_DRAWS;
  }

  // compute data moments
  best_nest=0;
  for (i = 0; i < 5; i++) {
    if(dataLine.clicks[i]==0) break;
    best_nest++;
  }

  for (i = 0; i < best_nest; i++) {
    choice[i]=dataLine.clicks[i]-1;

    if (choice[i] < 7) {
      outputd[choice[i] + offset] += 1; /* 0..5 Choice */
    }

    dom = -1;
    if (choice[i] < dataLine.numberOfAds) {
      dom = SequentialSearch(domains_fixed_effects,dataLine.domains[choice[i]],4);
    }

    if (dom >= 0) {
      outputd[7 + dom + offset] += 1;
    }

    if (dom == 0) { /* Domain-position clicks */
      switch (choice[i]) {
      case 0:
        outputd[offset + 11]++;
        break;
      case 1:
        outputd[offset + 12]++;
        break;
      case 2:
        outputd[offset + 13]++;
        break;
      }
    } else {
      if (dom == 1) {
        switch (choice[i]) {
        case 0:
          outputd[offset + 14]++;
          break;
        case 1:
          outputd[offset + 15]++;
          break;
        case 2:
          outputd[offset + 16]++;
          break;
        }
      }
    }

    if ((dataLine.domains[choice[i]] == domains_fixed_effects[1]) && (choice[i] == 1)
        && (dataLine.domains[0] == domains_fixed_effects[0])) {
      outputd[17 + offset] += 10;
    };

    if ((dataLine.domains[choice[i]] == domains_fixed_effects[1]) && (choice[i] == 1)
        && (dataLine.domains[0] == domains_fixed_effects[2])) {
      outputd[18 + offset] += 10;
    };

    if ((dataLine.domains[choice[i]] == domains_fixed_effects[2]) && (choice[i] == 1)
        && (dataLine.domains[0] == domains_fixed_effects[1])) {
      outputd[19 + offset] += 10;
    }

    if ((dataLine.domains[choice[i]] == domains_fixed_effects[0]) && (i < best_nest - 1)) {
      outputd[20 + offset] += 10;
    };
    if ((dataLine.domains[choice[i]] == domains_fixed_effects[1]) && (i < best_nest - 1)) {
      outputd[21 + offset] += 10;
    };

    if ((dataLine.domains[choice[i]] == domains_fixed_effects[2]) && (i < best_nest - 1)) {
      outputd[22 + offset] += 10;
    };

  }

  if (best_nest > 1) {
    if (goBack(choice, best_nest)) {
      outputd[offset + 23]++;
    }
  }

  if (best_nest == 2) {
    outputd[96]++;
  }

  if (best_nest == 3) {
    outputd[97]++;
  }

  // Free the grid
  for(i=0;i<dataLine.numberOfAds;++i) {
    free(utilities_grid[i]);
  }
  free(utilities_grid);
}

void deleteMoments(double *in1, double *out1) {
  int k = 0;
  int i;
  for (i = 0; i < NO_MOMENTS; i++) {
    if (SequentialSearch(kill_moments,i,KILL_MOMENTS) == -1) {
      out1[k] = in1[i];
      k++;
    }
  }

}
void printInput(double *parameters, double *a, double *moments) {
  int i,j;
  int offset = 24;
  
  fprintf(myfile,"Derivative: %d\n",if_jac);
  fprintf(myfile,"Parameters:\n ");
  fprintf(myfile," Structural parameters: ");
  for (i = 0; i < M1_POSITION_FIXED_EFFECTS; i++) {
    fprintf(myfile,"%f, ",parameters[i]);
  }
  fprintf(myfile,"\n");

  for (j = 0; j < 4; j++) {
    fprintf(myfile," Position Fixed Effects:\n ");
    for (i = M1_POSITION_FIXED_EFFECTS; i < M1_DOMAIN_FIXED_EFFECTS; i++) {
      fprintf(myfile,"%f, ", parameters[i + j * 10]);
    }
    fprintf(myfile,"\n");

    fprintf(myfile," Domain fixed Effects:\n ");
    for (i = M1_DOMAIN_FIXED_EFFECTS; i < M1_DOMAIN_FIXED_EFFECTS + 5; i++) {
      fprintf(myfile,"%f, ",parameters[i + j * 10]);
    }
    fprintf(myfile,"\n");
/*
    fprintf(myfile," Domain precision:\n ");
    for (i = M1_DOMAIN_EXPOST; i < M1_DOMAIN_EXPOST + 5; i++) {
      fprintf(myfile,"%f, ",parameters[i + j * 16]);
    }
    fprintf(myfile,"\n");
*/
  }
}

void printOutput(double *parameters, double *a, double *moments) {
  int i,j;
  int offset = 24;

  fprintf(myfile,"Choice moments:\n");
  for (i = 0; i < 7; i++) {
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i]+moments[i], moments[i], 92136*a[i]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+offset]+moments[i+offset], moments[i+offset], 92136*a[i+offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+2*offset]+moments[i+2*offset], moments[i+2*offset], 92136*a[i+2*offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f\n", i, 92136*a[i+3*offset]+moments[i+3*offset], moments[i+3*offset], 92136*a[i+3*offset]);
  }

  fprintf(myfile,"Domain Choices:\n");
  for (i = 7; i < 11; i++) {
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i]+moments[i], moments[i], 92136*a[i]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+offset]+moments[i+offset], moments[i+offset], 92136*a[i+offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+2*offset]+moments[i+2*offset], moments[i+2*offset], 92136*a[i+2*offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f\n", i, 92136*a[i+3*offset]+moments[i+3*offset], moments[i+3*offset], 92136*a[i+3*offset]);
  }

  fprintf(myfile,"Domain-position Choices:\n");
  for (i = 11; i < 17; i++) {
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i]+moments[i], moments[i], 92136*a[i]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+offset]+moments[i+offset], moments[i+offset], 92136*a[i+offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+2*offset]+moments[i+2*offset], moments[i+2*offset], 92136*a[i+2*offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f\n", i, 92136*a[i+3*offset]+moments[i+3*offset], moments[i+3*offset], 92136*a[i+3*offset]);
  }


  fprintf(myfile,"Conditional Clicks:\n");
  for (i = 17; i < 24; i++) {
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i]+moments[i], moments[i], 92136*a[i]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+offset]+moments[i+offset], moments[i+offset], 92136*a[i+offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f", i, 92136*a[i+2*offset]+moments[i+2*offset], moments[i+2*offset], 92136*a[i+2*offset]);
    fprintf(myfile,"\t%d\t%f (%f) %f\n", i, 92136*a[i+3*offset]+moments[i+3*offset], moments[i+3*offset], 92136*a[i+3*offset]);
  }
  fprintf(myfile,"Bundle Moments:\n");
  for (i = 96; i < 98; i++) {
    fprintf(myfile,"\t%d\t%f (%f) %f\n", i, 92136*a[i]+moments[i], moments[i], 92136*a[i]);
  }
}

void Jacobian_onesided(double *parameters, dataStruct dataLine, double *output, double *moments, int thread, double *momentsd) {
  int i,j,k=0;
  double a2[NO_MOMENTS - KILL_MOMENTS];
  double a1[NO_MOMENTS - KILL_MOMENTS];
  double temp[NO_MOMENTS];
  double tempd[NO_MOMENTS];
  long save_seed[4];
  int offset_param;

  jac=0;
  save_seed[0]=seed[thread][0];
  save_seed[1]=seed[thread][1];
  save_seed[2]=seed[thread][2];
  save_seed[3]=seed[thread][3];
  bundleChoice(parameters, dataLine, moments, thread, momentsd);
  deleteMoments(moments,a1);
  for (i = 0; i < NO_PARAMETERS; i++) {
    
    switch (dataLine.searchString) {
    case 0: /* Games */
      offset_param = 0;
      break;
    case 1: /* Weather */
      offset_param = 10;
      break;
    case 2: /* White pages */
      offset_param = 20;
      break;
    case 3: /* Sex */
      offset_param = 30;
      break;
    }
    if((i<M1_POSITION_FIXED_EFFECTS) || ((i>=offset_param+M1_POSITION_FIXED_EFFECTS) && (i<offset_param+M1_POSITION_FIXED_EFFECTS+10))) {
      jac=1;
      parameters[i] += H2;
      seed[thread][0]=save_seed[0];
      seed[thread][1]=save_seed[1];
      seed[thread][2]=save_seed[2];
      seed[thread][3]=save_seed[3];
      bundleChoice(parameters, dataLine, temp, thread, tempd);
      deleteMoments(temp,a2);
      parameters[i] -= H2;
      for (j = 0; j < NO_MOMENTS - KILL_MOMENTS; j++) {
        output[k] = (a2[j] - a1[j]) / H2;
        k++;
      }
    } else {
      for (j = 0; j < NO_MOMENTS - KILL_MOMENTS; j++) {
        output[k] = 0;
        k++;
      }
    }
  }
}


/*public static double[] VarCovar(double[] output, KeyValuePair<double[], double[]> x) {
    int k = 0;
    for (int i = 0; i < x.Value.Length; i++) {
        for (int j = 0; j < x.Value.Length; j++) {
            output[k] += (x.Key[i] - x.Value[i]) * (x.Key[j] - x.Value[j]);
            k++;
        }
    }

    return output;
}*/


/*public static double[] PopulationMoments(string[] dataLine) {
    int[] domains_fixed_effects_weather = new int[] { 97, 258, 20, 397 }; // weather
    int[] domains_fixed_effects_white_pages = new int[] { 57, 388, 121, 81 }; // white pages
    int[] domains_fixed_effects_games = new int[] { 39, 25, 129, 88 }; // Games
    int[] domains_fixed_effects_sex = new int[] { 54, 5, 297, 2484 }; // Sex
    int[] domains_fixed_effects = new int[4];

    double[] output = new double[Constants.NO_MOMENTS];
    var domains = dataLine[5].Split(';');
    var choice = dataLine[3].Split(';');
    var no_clicks = Convert.ToInt32(dataLine[2]);

    int offset;
    switch (dataLine[9]) {
        case "games":
            domains_fixed_effects_games.CopyTo(domains_fixed_effects, 0);
            offset = 0;
            break;
        case "weather":
            domains_fixed_effects_weather.CopyTo(domains_fixed_effects, 0);
            offset = 24;
            break;
        case "white pages":
            domains_fixed_effects_white_pages.CopyTo(domains_fixed_effects, 0);
            offset = 48;
            break;
        case "sex":
            domains_fixed_effects_sex.CopyTo(domains_fixed_effects, 0);
            offset = 72;
            break;
        default:
            return output;
    }

    for (int i = 0; i < no_clicks; i++) {
        int ch = Convert.ToInt32(choice[i]);
        if (ch < 7) {
            output[ch + offset] += 1; // 0..5 Choice
        }

        int dom = -1;
        if (ch < domains.Length) {
            dom = domains_fixed_effects.SequentialSearch(Convert.ToInt32(domains[ch]));
        }

        if (dom >= 0) {
            output[7 + dom + offset] += 1; // 7..10 Domain choices
        }

        if (dom == 0) {
            switch (ch) {
                case 0:
                    output[offset + 11]++;
                    break;
                case 1:
                    output[offset + 12]++;
                    break;
                case 2:
                    output[offset + 13]++;
                    break;
            }
        } else {
            if (dom == 1) {
                switch (ch) {
                    case 0:
                        output[offset + 14]++;
                        break;
                    case 1:
                        output[offset + 15]++;
                        break;
                    case 2:
                        output[offset + 16]++;
                        break;
                }
            }
        }

        if ((Convert.ToInt32(domains[ch]) == domains_fixed_effects[1]) && (ch == 1) && (Convert.ToInt32(domains[0]) == domains_fixed_effects[0])) {
            output[offset + 17] += 10;
        };

        if ((Convert.ToInt32(domains[ch]) == domains_fixed_effects[1]) && (ch == 1) && (Convert.ToInt32(domains[0]) == domains_fixed_effects[2])) {
            output[offset + 18] += 10;
        };

        if ((Convert.ToInt32(domains[ch]) == domains_fixed_effects[2]) && (ch == 1) && (Convert.ToInt32(domains[0]) == domains_fixed_effects[1])) {
            output[offset + 19] += 10;
        }

        if ((Convert.ToInt32(domains[ch]) == domains_fixed_effects[0]) && (i < no_clicks - 1)) {
            output[offset + 20] += 10;
        };

        if ((Convert.ToInt32(domains[ch]) == domains_fixed_effects[1]) && (i < no_clicks - 1)) {
            output[offset + 21] += 10;
        };

        if ((Convert.ToInt32(domains[ch]) == domains_fixed_effects[2]) && (i < no_clicks - 1)) {
            output[offset + 22] += 10;
        };

    }

    if (no_clicks > 1) {
        if (goBack(choice, no_clicks) == true) {
            output[offset + 23]++;
        }
    }

    if (no_clicks == 2) {
        output[96]++;
    }

    if (no_clicks == 3) {
        output[97]++;
    }

    return output;
}*/

int goBack(int *clicks, int no_clicks) {
  int click = clicks[0];
  int i;
  for (i = 1; i < no_clicks; i++) {
    if (clicks[i] > click) {
      click = clicks[i];
    } else {
      return true;
    }
  }

  return false;
}

void *momentThread(void *inputInit) {
  int j,i;
  int per;
  int per_old=-1;
  double moments[NO_MOMENTS];
  double momentsd[NO_MOMENTS];
  double jacobian[(NO_MOMENTS-KILL_MOMENTS)*NO_PARAMETERS];
  double varcovar_par[NO_MOMENTS-KILL_MOMENTS][NO_MOMENTS-KILL_MOMENTS];
  double jump2;
#ifdef VARCOVAR
  double moments_filtered[NO_MOMENTS - KILL_MOMENTS];
  double momentsd_filtered[NO_MOMENTS - KILL_MOMENTS];
  int m1,m2;
#endif

  ThreadMomentStructure *input = (ThreadMomentStructure *) inputInit;
  for (i=0;i<NO_MOMENTS;++i) {
    input->output[i]=0;
  }
  for (i=0;i<(NO_MOMENTS-KILL_MOMENTS)*NO_PARAMETERS;++i) {
    input->jacobian[i]=0;
  }
#ifdef VARCOVAR
  for(m1=0;m1<NO_MOMENTS-KILL_MOMENTS;++m1) {
    for(m2=0;m2<NO_MOMENTS-KILL_MOMENTS;++m2) {
      input->varcovar[m1][m2]=0;
    }
  }
#endif
  for (j=input->start;j<input->stop;++j) {
    if (input->thread==7) {
      per = (j/(double) jump-7)*100;
      if((per!=per_old) && (per % 1==0)) {
        printf("%d%% ",per);
        fflush(stdout);
        per_old=per;
      }
    }
    if (if_jac) {
      Jacobian_onesided(input->parameters, data[j], jacobian, moments, input->thread, momentsd);
      for (i=0;i<(NO_MOMENTS-KILL_MOMENTS)*NO_PARAMETERS;++i) {
        input->jacobian[i]+=jacobian[i];
      }
    } else {
      bundleChoice(input->parameters, data[j], moments, input->thread, momentsd);
    }
    
#ifdef VARCOVAR
    deleteMoments(moments,moments_filtered);
    deleteMoments(momentsd,momentsd_filtered);
    for(m1=0;m1<NO_MOMENTS-KILL_MOMENTS;++m1) {
      for(m2=0;m2<NO_MOMENTS-KILL_MOMENTS;++m2) {
        input->varcovar[m1][m2]+=(moments_filtered[m1]-momentsd_filtered[m1])*(moments_filtered[m2]-momentsd_filtered[m2]);
      }
    }
#endif

#ifdef FULL_VARCOVAR
    for(m1=0;m1<NO_MOMENTS-KILL_MOMENTS;++m1) {
      varcovar_gl[j][m1]=moments_filtered[m1];
      varcovarm_gl[j][m1]=momentsd_filtered[m1];
    }
#endif
    for (i=0;i<NO_MOMENTS;++i) {
      input->output[i]+=(moments[i]-momentsd[i]);
    }
  }

  if (!if_jac) {
    for (i=0;i<(NO_MOMENTS-KILL_MOMENTS)*NO_PARAMETERS;++i) {
      input->jacobian[i]=0;
    }
  }

  if (input->thread==7) {
    printf("\n");
    fflush(stdout);
  }
}
