/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright: Przemyslaw Jeziorski (przjez@gmail.com)
***************************************************************************/
#ifndef PROG_SIG_H
#define PROG_SIG_H

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include "cuda_generator.h"
#include<mat.h>
#include<pthread.h>

#define M1_SIGMA_COST 0
#define M1_R 1
#define M1_SIGMA_R 2
#define M1_SIGMA_POS 3
#define M1_SIGMA_POS_SIGMA 7
#define M1_DESCRIPTION_SIGMA 8
#define M1_POSITION_FIXED_EFFECTS 9
#define M1_DOMAIN_FIXED_EFFECTS 14

#define DATA_NUMBER_OF_ADS 0
#define DATA_DOMAINS 9
#define DATA_CLICKS 1
#define DATA_DRAWS_EPSILON 17
#define DATA_DRAWS_DOMAIN 19
#define DATA_DRAWS_SUBJECTIVE_QUALITY 18

#define NO_PARAMETERS 49
#define NO_DRAWS 500
#define NO_MOMENTS 98
#define MAXIMUM_CHOICE 3

#define KILL_MOMENTS 20

#define H1 4.64158883 * 10E-6
#define H2 0.001

#ifndef false
#define false (0)
#endif
#ifndef true
#define true (1)
#endif

#define SMP 48

#define GRID_SIZE 5

#define THREADS

#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))

#define NO_REALDATA_COUNTER 86

#define VARCOVAR

double *weights;

FILE *stream;

typedef struct {
  int numberOfAds;
  int searchString;
  int domains[9];
  double composition;
  double clicks[5];
} dataStruct;


seedStruct *seed;
dataStruct *data;
double data_moments_filtered[NO_MOMENTS];

/*int number = 0;
int number2 = 0;*/
int jac;
int if_jac;
int jump;

#define NO_COUNTER 20
#define NO_GF 128

typedef struct {
  double output[NO_MOMENTS];
  int thread,start,stop;
  double jacobian[(NO_MOMENTS-KILL_MOMENTS)*NO_PARAMETERS];
  double parameters[NO_PARAMETERS];
#ifdef VARCOVAR
  double varcovar[NO_MOMENTS-KILL_MOMENTS][NO_MOMENTS-KILL_MOMENTS];
#endif
  double realdata_counter[NO_REALDATA_COUNTER];
  double counterfactuals[NO_COUNTER];
  double gf[NO_GF];
} ThreadMomentStructure;




int SequentialSearch(int *domains, int domain, int n);
void insertionSort(double *a, int *idx, int length);
void insertionSortInt(int *a, int *idx, int length);
void bundleChoice(double *parameters, dataStruct dataLine, double *output, int thread, double *momentsd);
void counterFactual1(double *parameters, double *results);
void greedyIncrementalUtility(double *parameters, double *u, double *u_exp, double *cost, int *idx, int length);
void incrementalUtility(double *parameters, double *u, double *u_exp, double *cost, int *idx, int length);
int next_comb(int *comb, int k, int n);
void make_choice_signaling(double *parameters, int number_of_choices, double **utilities_grid, double *u_noexp,
                     double *positions, int *choice_sorted, int *best_nest, double u0, double R, int *actual_positions);
void make_choice(double *parameters, int number_of_choices, double *utilities, double *u_noexp,
                     double *positions, int *choice_sorted, int *best_nest, double u0, double R, int *actual_positions);
void deleteMoments(double *in1, double *out1);
void printOutput(double *parameters, double *a, double *moments);
void printInput(double *parameters, double *a, double *moments);
void Jacobian_onesided(double *parameters, dataStruct dataLine, double *output, double *moments, int thread, double *momentsd);
void *momentThread(void *inputInit);

FILE *myfile;

void counterfactuals(double *parameters, dataStruct dataLine, int x, double *results);
char *done;
void *counterThread(void *inputInit);

#define NO_DRAWS_COUNTER 1000

#ifdef THREADS
pthread_mutex_t mymutex;
#endif

void *realdata_counterThread(void *inputInit);
#endif

#define NO_DRAWS_GF 1000

#define PARTIAL_SUM 1

#define FULL_VARCOVAR

#ifdef FULL_VARCOVAR
  double **varcovar_gl;
  double **varcovarm_gl;
#endif
