/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright: Przemyslaw Jeziorski (przjez@gmail.com)
***************************************************************************/
#include<Program_signaling.h>

mxArray *readMatlab(MATFile *mfp, const char *var_name);

int main(int argc, char *argv[]) {
  long *mySeed = (long *) mxMalloc(4*sizeof(long));
  double *mySeedInit;
  int threadsN = 48;
  int size;
  double *miscVector;
  double *domains;
  double moments[NO_MOMENTS];
  double *parameters;
  mxArray *parametersMx;
  ThreadMomentStructure *input;
  double *output, *jacobian, *clicks;
  mxArray *temp;
  MATFile *mfp;
  int i,k,j,k2;
  mxArray *jacobianMx, *outputMx;
  double *data_moments;
#ifdef VARCOVAR
  mxArray *varcovarMx;
  double *varcovar;
  int m1, m2;
#endif  
#ifdef FULL_VARCOVAR
  double *varcovar_gl_pr, *varcovarm_gl_pr;
  mxArray *varcovar_gl_Mx, *varcovarm_gl_Mx;
#endif

  myfile = fopen ("output.txt","a");

  if ((mfp = matOpen(argv[1], "r")) == NULL) {
    fprintf(stderr, "Cannot open MAT-file %s\n", argv[1]);
    #ifdef DEBUG
      fprintf(myfile, "Cannot open MAT-file %s\n", argv[1]);
    #endif
    #ifdef COUT_DEBUG
      printf("Cannot open MAT-file %s\n", argv[1]);
    #endif
    exit(1);
  } else {
    #ifdef DEBUG
      fprintf(myfile, "Opening MAT-file %s\n", argv[1]);
    #endif
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", argv[1]);
    #endif
  }

  mySeedInit = mxGetPr(readMatlab(mfp, "seed"));
  temp=readMatlab(mfp, "misc");
  miscVector = mxGetPr(temp);
  size = mxGetN(temp);
  domains = mxGetPr(readMatlab(mfp, "domains"));
  weights = mxGetPr(readMatlab(mfp, "position_weights"));
  data_moments = mxGetPr(readMatlab(mfp, "data_moments"));
  clicks = mxGetPr(readMatlab(mfp, "clicks"));

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n", argv[1]);
    exit(EXIT_FAILURE);
  }

  if ((mfp = matOpen(argv[2], "r")) == NULL) {
    fprintf(stderr, "Cannot open MAT-file %s\n", argv[2]);
    #ifdef DEBUG
      fprintf(myfile, "Cannot open MAT-file %s\n", argv[2]);
    #endif
    #ifdef COUT_DEBUG
      printf("Cannot open MAT-file %s\n", argv[2]);
    #endif
    exit(1);
  } else {
    #ifdef DEBUG
      fprintf(myfile, "Opening MAT-file %s\n", argv[2]);
    #endif
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", argv[2]);
    #endif
  }

  parametersMx = readMatlab(mfp, "parameters");
  parameters = mxGetPr(parametersMx);
  if_jac=mxGetPr(readMatlab(mfp, "if_jac"))[0];
  printInput(parameters, moments, data_moments);

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n", argv[2]);
    exit(EXIT_FAILURE);
  }

  if (!if_jac) {
    jac=0;
  }

  mySeed[0] = (long) mySeedInit[0];
  mySeed[1] = (long) mySeedInit[1];
  mySeed[2] = (long) mySeedInit[2];
  mySeed[3] = (long) mySeedInit[3];

  seed = (seedStruct *) mxMalloc(threadsN*sizeof(seedStruct));

  createGenerators(threadsN, mySeed, seed);

  deleteMoments(data_moments,data_moments_filtered);

  data = (dataStruct *) mxMalloc(size*sizeof(dataStruct));
  k=0;
  k2=0;
  for (i=0;i<size;++i) {
    data[i].searchString=miscVector[2*i+1];
    data[i].numberOfAds=miscVector[2*i];
    for (j=0;j<data[i].numberOfAds;++j) {
      data[i].domains[j]=domains[k+j];
    }
    k+=9;
    for (j=0;j<5;++j) {
      data[i].clicks[j]=clicks[k2];
      k2++;
    }
  }

  jump=size/SMP+1;

#ifdef FULL_VARCOVAR
  varcovar_gl = (double **) malloc(size*sizeof(double *));
  varcovarm_gl = (double **) malloc(size*sizeof(double *));
  for(i=0;i<size;++i) {
    varcovar_gl[i] = (double *) malloc((NO_MOMENTS-KILL_MOMENTS)*sizeof(double));
    varcovarm_gl[i] = (double *) malloc((NO_MOMENTS-KILL_MOMENTS)*sizeof(double));
  }
#endif

#ifdef THREADS
  pthread_t thread_id[SMP];
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);
#endif
  input = (ThreadMomentStructure *) malloc(SMP*sizeof(ThreadMomentStructure));
  for (j=0;j<SMP;j++) {
    input[j].thread=j;
    input[j].start=jump*j;
    input[j].stop=MIN(jump*(j+1),size);
    for (i=0;i<NO_PARAMETERS;++i) {
      input[j].parameters[i]=parameters[i];
    }
#ifdef THREADS
    pthread_create(&thread_id[j], &attr, momentThread, (void *) &input[j] );
#else
    momentThread((void *) &input[j]);
#endif
  }
#ifdef THREADS
  pthread_attr_destroy(&attr);
  for (j=0;j<SMP;j++) {
    pthread_join(thread_id[j], NULL);
  }
#endif

  outputMx = mxCreateDoubleMatrix(NO_MOMENTS-KILL_MOMENTS,1,mxREAL);
  output = mxGetPr(outputMx);

  jacobianMx = mxCreateDoubleMatrix((NO_MOMENTS-KILL_MOMENTS),NO_PARAMETERS,mxREAL);
  jacobian = mxGetPr(jacobianMx);

  for (i=0;i<(NO_MOMENTS-KILL_MOMENTS)*NO_PARAMETERS;++i) {
    jacobian[i]=0;
  }
  for (i=0;i<NO_MOMENTS;++i) {
    moments[i]=0;
  }
#ifdef VARCOVAR
  varcovarMx = mxCreateDoubleMatrix((NO_MOMENTS-KILL_MOMENTS),(NO_MOMENTS-KILL_MOMENTS),mxREAL);
  varcovar = mxGetPr(varcovarMx);
  for (i=0;i<(NO_MOMENTS-KILL_MOMENTS)*(NO_MOMENTS-KILL_MOMENTS);++i) {
    varcovar[i]=0;
  }
#endif

  for (j=0;j<SMP;j++) {
    for (i=0;i<NO_MOMENTS;++i) {
      moments[i]+=input[j].output[i]/size;
    }
    for (i=0;i<(NO_MOMENTS-KILL_MOMENTS)*NO_PARAMETERS;++i) {
      jacobian[i]+=input[j].jacobian[i]/size;
    }
#ifdef VARCOVAR
    i=0;
    for (m1=0;m1<NO_MOMENTS-KILL_MOMENTS;++m1) {
      for (m2=0;m2<NO_MOMENTS-KILL_MOMENTS;++m2) {
        varcovar[i]+=input[j].varcovar[m2][m1]/size;
        i++;
      }
    }
#endif
  }

#ifdef FULL_VARCOVAR
  varcovar_gl_Mx = mxCreateDoubleMatrix(size,(NO_MOMENTS-KILL_MOMENTS),mxREAL);
  varcovar_gl_pr = mxGetPr(varcovar_gl_Mx);
  varcovarm_gl_Mx = mxCreateDoubleMatrix(size,(NO_MOMENTS-KILL_MOMENTS),mxREAL);
  varcovarm_gl_pr = mxGetPr(varcovarm_gl_Mx);
  i=0;
  for(m1=0;m1<NO_MOMENTS-KILL_MOMENTS;++m1) {
    for(j=0;j<size;++j) {
      varcovar_gl_pr[i]=varcovar_gl[j][m1];
      varcovarm_gl_pr[i]=varcovarm_gl[j][m1];
      i++;
    }
  }
#endif

  deleteMoments(moments,output);
/*
  for (i=0;i<NO_MOMENTS;++i) {
    output[i]-=data_moments_filtered[i];
  }*/

  printOutput(parameters, moments, data_moments);

  if ((mfp = matOpen(argv[3], "w")) == NULL) {
    fprintf(stderr, "Cannot open MAT-file %s\n", argv[3]);
    #ifdef DEBUG
      fprintf(myfile, "Cannot open MAT-file %s\n", argv[3]);
    #endif
    #ifdef COUT_DEBUG
      printf("Cannot open MAT-file %s\n", argv[3]);
    #endif
    exit(1);
  } else {
    #ifdef DEBUG
      fprintf(myfile, "Opening MAT-file %s\n", argv[3]);
    #endif
    #ifdef COUT_DEBUG
      printf("Opening MAT-file %s\n", argv[3]);
    #endif
  }


  matPutVariable(mfp, "parameters", parametersMx);
  matPutVariable(mfp, "jacobian", jacobianMx);
  matPutVariable(mfp, "output", outputMx);
#ifdef VARCOVAR
  matPutVariable(mfp, "varcovar", varcovarMx);
#endif
#ifdef FULL_VARCOVAR
  matPutVariable(mfp, "varcovar_gl", varcovar_gl_Mx);
  matPutVariable(mfp, "varcovarm_gl", varcovarm_gl_Mx);
#endif

#ifdef FULL_VARCOVAR
  for(i=0;i<size;++i) {
    free(varcovar_gl[i]);
    free(varcovarm_gl[i]);
  }
  free(varcovar_gl);
  free(varcovarm_gl);
#endif

  if (matClose(mfp) != 0) {
    printf("Error closing file %s\n", argv[3]);
    exit(EXIT_FAILURE);
  }

  fclose(myfile);
  /*printf("Error %d %d %d\n",number,number2,at_least_1);*/
}

mxArray *readMatlab(MATFile *mfp, const char *var_name) {
  mxArray *array_ptr;
  int *from, *to;

  if ((array_ptr = matGetVariable(mfp, var_name)) == NULL) {
    fprintf(stderr, "Cannot read matlab variable %s\n", var_name);
    #ifdef COUT_DEBUG
    printf("Cannot read matlab variable %s\n", var_name);
      #endif
      #ifdef DEBUG
        fprintf(myfile, "Cannot read matlab variable %s\n", var_name);
      #endif
      exit(1);
  }
  if ((mxGetNumberOfElements(array_ptr) == 1) && mxIsNumeric(array_ptr)) {
    #ifdef COUT_DEBUG
      printf("Reading matlab variable %s = %f\n", var_name, mxGetScalar(array_ptr));
    #endif
    #ifdef DEBUG
      fprintf(myfile, "Reading matlab variable %s = %f\n", var_name, mxGetScalar(array_ptr));
    #endif
  } else {
    #ifdef COUT_DEBUG
      printf("Reading matlab variable %s (", var_name);
    #endif
    #ifdef DEBUG
      fprintf(myfile, "Reading matlab variable %s (", var_name);
    #endif
    from = (int *) mxGetDimensions(array_ptr);
    to = from+mxGetNumberOfDimensions(array_ptr)-1;
    for (; from<to; from++) {
      #ifdef COUT_DEBUG
        printf("%dx", *from);
      #endif
      #ifdef DEBUG
        fprintf(myfile, "%dx", *from);
      #endif
    }
    #ifdef COUT_DEBUG
      printf("%d)\n", *from);
    #endif
    #ifdef DEBUG
      fprintf(myfile, "%d)\n", *from);
    #endif
  }

  return array_ptr;
}
