/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright: Przemyslaw Jeziorski (przjez@gmail.com)
***************************************************************************/
#include<Program_signaling.h>

extern double grid[];
/*
int *next(int *s, int N, int cmax, int cmin){
    int i = N-1;
    while(i && s[i] == cmax){
        s[i] = cmin;
        i--;
    }
    if (s[i]!=cmax){
        s[i] ++ ;
        return s;
    }else {
        return NULL;
    }
}*/

int next(int *a, int n) {
# define swap(i, j) {t = a[i]; a[i] = a[j]; a[j] = t;}
  int k, l, t;
 
  /* 1. Find the largest index k such that a[k] < a[k + 1]. If no such
        index exists, the permutation is the last permutation. */
  for (k = n - 1; k && a[k - 1] >= a[k]; k--);
  if (!k--) return 0;
 
  /* 2. Find the largest index l such that a[k] < a[l]. Since k + 1 is
     such an index, l is well defined */
  for (l = n - 1; a[l] <= a[k]; l--);
 
  /* 3. Swap a[k] with a[l] */
  swap(k, l);
 
  /* 4. Reverse the sequence from a[k + 1] to the end */
  for (k++, l = n - 1; l > k; l--, k++)
    swap(k, l);
  return 1;
# undef swap
}

void *counterThread(void *inputInit) {
  ThreadMomentStructure *input = (ThreadMomentStructure *) inputInit;
  int nextIter = 1;
  int i;
  int todo;
  double results[20];
  dataStruct dataLine;

  for(i=0;i<NO_COUNTER;++i) {
    input->counterfactuals[i]=0;
  }

  do {
    nextIter=0;
    pthread_mutex_lock (&mymutex);
    todo=-1;
    for(i=0;i<input->stop;++i) {
      if(done[i]==0) {
        done[i]=1;
        nextIter=1;
        dataLine.numberOfAds=data[i].numberOfAds;
        dataLine.searchString=data[i].searchString;
        todo=i;
        break;
      }
    }
    pthread_mutex_unlock (&mymutex);
    if(todo>-1) {
      counterfactuals(input->parameters, dataLine, i, results);
      for(i=0;i<NO_COUNTER;++i) {
        input->counterfactuals[i]+=data[todo].composition*results[i];
      }
      printf("%d\n",todo);
    }
  } while(nextIter);
}

void counterfactuals(double *parameters, dataStruct dataLine, int x, double *results) {
  int domains_fixed_effects_weather[] = { 1, 2, 3, 4 }; /* weather */
  int domains_fixed_effects_white_pages[] = { 1, 2, 3, 4 }; /* white pages */
  int domains_fixed_effects_games[] = { 1, 2, 3, 4 }; /* Games */
  int domains_fixed_effects_sex[] = { 1, 2, 3, 4 }; /* Sex */
  int *domains_fixed_effects;
  int i,z,j;
  int dom;
  int r,k;
  double cost_ra,u;

  double utilities[dataLine.numberOfAds];
  double u_noexp[dataLine.numberOfAds];
  double utilities_base[dataLine.numberOfAds];
  double position_effects[dataLine.numberOfAds];
  double e[dataLine.numberOfAds];
  double R;
  double pos_variance;
  double pos_variance_user;
  double variance = parameters[M1_DESCRIPTION_SIGMA]*parameters[M1_DESCRIPTION_SIGMA];

  int actual_positions[dataLine.numberOfAds];
  int choice[MAXIMUM_CHOICE];
  int best_nest;
  int maximum_bundle = (MAXIMUM_CHOICE < dataLine.numberOfAds) ? MAXIMUM_CHOICE : dataLine.numberOfAds;

  double var_cost = parameters[M1_SIGMA_COST] * parameters[M1_SIGMA_COST];

  int offset;
  int offset_param;

  double position_quality[dataLine.numberOfAds];
  double position_quality_user[dataLine.numberOfAds];
  double **utilities_grid;

  double mu, sigma, sqrtsigma, signal;

  int thread;
  int dominant;
  int comb[8];
  int perm[8];
  double position_effects_base[dataLine.numberOfAds];
  double position_quality_base[dataLine.numberOfAds];
  double candidateU, candidateCTR;
  double maxU_U, maxU_CTR, maxCTR_CTR, maxCTR_U;
  double tempU,U,CTR;
  long int localseed[4];
  int maxnest,maxnestt;
  int idx[dataLine.numberOfAds];
  double FB_SR_CTR_CTR_total, FB_SR_CTR_U_total, FB_SR_U_CTR_total, FB_SR_U_U_total;
  double FB_LR_CTR_CTR_total, FB_LR_CTR_U_total, FB_LR_U_CTR_total, FB_LR_U_U_total;
  double FB_SR_CTR_CTR, FB_SR_CTR_U, FB_SR_U_CTR, FB_SR_U_U; 
  double FB_LR_CTR_CTR, FB_LR_CTR_U, FB_LR_U_CTR, FB_LR_U_U;

  double draw_ra, draw_var, draw_R, draw_u, draw_signal;
  // Constuct generic domains
  for(i=0;i<dataLine.numberOfAds;++i) {
    dataLine.domains[i]=0;
  }
  dominant=0;
  for(i=0;i<4;i++) {
    if(data[x].domains[i]>0) {
      dataLine.domains[dominant]=data[x].domains[i];
      dominant++;
    }
  }

  // Allocate the grid
  utilities_grid=(double **) malloc(dataLine.numberOfAds*sizeof(double *));
  for(i=0;i<dataLine.numberOfAds;++i) {
    utilities_grid[i]=(double *) malloc((GRID_SIZE+1)*sizeof(double));
  }

  switch (dataLine.searchString) {
  case 0: /* Games */
    domains_fixed_effects=domains_fixed_effects_games;
    offset = 0;
    offset_param = 0;
    z=0;
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality_base[k] = 0;
      for(i=0;i<5;i++) {
        position_quality_base[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
#ifdef BOOTSTRAP
        for(bs=0;bs<NO_BS_DRAWS;++bs) {
          position_quality_base_bs[bs][k]+=weights[z]*(parameters_bs[bs][M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        }
#endif
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS];
    break;
  case 1: /* Weather */
    domains_fixed_effects=domains_fixed_effects_weather;
    offset = 24;
    offset_param = 10;
    z=40;
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality_base[k] = 0;
      for(i=0;i<5;i++) {
        position_quality_base[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
#ifdef BOOTSTRAP
        for(bs=0;bs<NO_BS_DRAWS;++bs) {
          position_quality_base_bs[bs][k]+=weights[z]*(parameters_bs[bs][M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        }
#endif
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS+1];
    break;
  case 2: /* White pages */
    domains_fixed_effects=domains_fixed_effects_white_pages;
    offset = 48;
    offset_param = 20;
    z=80;
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality_base[k] = 0;
      for(i=0;i<5;i++) {
        position_quality_base[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
#ifdef BOOTSTRAP
        for(bs=0;bs<NO_BS_DRAWS;++bs) {
          position_quality_base_bs[bs][k]+=weights[z]*(parameters_bs[bs][M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        }
#endif
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS+2];
    //getchar();
    break;
  case 3: /* Sex */
    domains_fixed_effects=domains_fixed_effects_sex;
    offset = 72;
    offset_param = 30;
    z=120;
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality_base[k] = 0;
      for(i=0;i<5;i++) {
        position_quality_base[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
#ifdef BOOTSTRAP
        for(bs=0;bs<NO_BS_DRAWS;++bs) {
          position_quality_base_bs[bs][k]+=weights[z]*(parameters_bs[bs][M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        }
#endif
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS+3];
#ifdef BOOTSTRAP
    for(bs=0;bs<NO_BS_DRAWS;++bs) {
      pos_variance_bs[bs][k] = parameters_bs[bs][M1_SIGMA_POS+3];
    }
#endif
    break;
  default:
    return;
  }

  /* Construct utilities */
  for (i = 0; i < dataLine.numberOfAds; i++) {
    if (i >= 6) {
      position_effects_base[i] = parameters[M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.3;
    } else if (i == 5) {
      position_effects_base[i] = parameters[M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.1;
    } else {
      position_effects_base[i] = parameters[M1_POSITION_FIXED_EFFECTS + i + offset_param];
    }

    dom = SequentialSearch(domains_fixed_effects,dataLine.domains[i],4);
    if (dom >= 0) {
      utilities_base[i] = parameters[M1_DOMAIN_FIXED_EFFECTS + dom + offset_param];
    } else {
      utilities_base[i] = parameters[M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
    }
#ifdef BOOTSTRAP
    for(bs=0;bs<NO_BS_DRAWS;++bs) {
      if (i >= 6) {
        position_effects_base_bs[bs][i] = parameters_bs[bs][M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.3;
      } else if (i == 5) {
        position_effects_base_bs[bs][i] = parameters_bs[bs][M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.1;
      } else {
        position_effects_base_bs[bs][i] = parameters_bs[bs][M1_POSITION_FIXED_EFFECTS + i + offset_param];
      }

      if (dom >= 0) {
        utilities_base_bs[bs][i] = parameters_bs[bs][M1_DOMAIN_FIXED_EFFECTS + dom + offset_param];
      } else {
        utilities_base_bs[bs][i] = parameters_bs[bs][M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
      }
    }
#endif
  }


  maxU_U=0;
  maxU_CTR=0;
  maxCTR_CTR=0;
  maxCTR_U=0;

  if(dominant>0) {
    for(i=0;i<dominant;i++) comb[i]=i;
    do {
      for(i=0;i<dominant;i++) perm[i]=i;
      do {
        // Permute positions
        // Put dominant firms positions
        for(i=0;i<dominant;++i) {
          position_effects[i]=position_effects_base[comb[perm[i]]];
          position_quality[i]=position_quality_base[comb[perm[i]]];
#ifdef BOOTSTRAP
          for(bs=0;bs<NO_BS_DRAWS;++bs) {
            position_effects_bs[bs][i]=position_effects_base_bs[bs][comb[perm[i]]];
            position_quality_bs[bs][i]=position_quality_base_bs[bs][comb[perm[i]]];
          }
#endif
        }

        // Put other domains
        i=dominant;
        for(j=0;j<dataLine.numberOfAds;++j) {
          if(SequentialSearch(comb,j,dominant)<0) {
            position_effects[i]=position_effects_base[j];
            position_quality[i]=position_quality_base[j];
#ifdef BOOTSTRAP
            for(bs=0;bs<NO_BS_DRAWS;++bs) {
              position_effects_bs[bs][i]=position_effects_base_bs[bs][j];
              position_quality_bs[bs][i]=position_quality_base_bs[bs][j];
            }
#endif
            i++;
          }
        }
        
        /*
        for(i=0;i<dataLine.numberOfAds;++i) dataLine.domains[i]=0;
        for(i=0;i<dominant;++i) dataLine.domains[comb[perm[i]]]=i+1;
        for(i=0;i<dataLine.numberOfAds;++i) printf("%2d ",dataLine.domains[i]);printf("\n");
        for(i=0;i<dataLine.numberOfAds;++i) printf("%f ",position_effects_base[i]);printf("\n");
        for(i=0;i<dataLine.numberOfAds;++i) printf("%f ",position_effects[i]);printf("\n");
        printf("\n");
        getchar();
        */
        U=0;
        CTR=0;
        localseed[0]=789237;localseed[1]=723897436;localseed[2]=8909217837;localseed[3]=98098123;
        for (r = 0; r < NO_DRAWS_COUNTER; r++) {
          draw_ra = nextNormal(localseed);
          draw_var = nextNormal(seed[thread]);
          draw_R = nextNormal(localseed);
 
          cost_ra = parameters[M1_SIGMA_COST] * draw_ra;
          pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * draw_var;
          pos_variance_user*=pos_variance_user;

          // Compute variance of the posterior
          sigma=1/(1/variance+1/pos_variance_user);
          // Get stardard deviation
          sqrtsigma=sqrt(sigma);
          R = parameters[M1_R] + parameters[M1_SIGMA_R] * draw_R;
#ifdef BOOTSTRAP
          for(bs=0;bs<NO_BS_DRAWS;++bs) {
            cost_ra_bs[bs] = parameters_bs[bs][M1_SIGMA_COST] * draw_ra;
            pos_variance_user_bs[bs] = pos_variance_bs[bs] + parameters_bs[bs][M1_SIGMA_POS_SIGMA] * draw_var;
            pos_variance_user_bs[bs]*=pos_variance_user_bs[bs];

            // Compute variance of the posterior
            sigma_bs[bs]=1/(1/variance_bs[bs]+1/pos_variance_user_bs[bs]);
            // Get stardard deviation
            sqrtsigma_bs[bs]=sqrt(sigma_bs[bs]);
            R_bs[bs] = parameters_bs[bs][M1_R] + parameters_bs[bs][M1_SIGMA_R] * draw_R;   
          }
#endif

          k = 0;
          for (i = 0; i < dataLine.numberOfAds; i++) {
            // Known utility shock
            draw_u = nextExponential(seed[thread]);
            u = draw_u + cost_ra;
            position_quality_user[i] = position_quality[i];
            // Mean of the posterior
            draw_signal = nextNormal(seed[thread]);
            signal = utilities_base[i] + sqrt(variance) * draw_signal;
            mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;
   
            if (mu > 0) {
              actual_positions[k] = i;
              // Construct the integration grid
              for(z=0;z<GRID_SIZE;++z) {
                utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
              }
              // Last part of the grid is the true quality
              utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1);
              k++;
            } else {
              utilities[i] = 0;
            }
          }
   
          make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
          //make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
          CTR+=best_nest;

          tempU=0;
          for(i=0;i<best_nest;++i) {
            tempU+=utilities_grid[choice[i]][GRID_SIZE];
          }
          U+=pow(tempU,1/(R+1));
          for(i=0;i<best_nest;++i) {
            U+=position_effects[choice[i]];
          }
        }
        U/=NO_DRAWS_COUNTER;
        CTR/=NO_DRAWS_COUNTER;

        if(maxU_U<U) {
          maxU_U=U;
          maxU_CTR=CTR;
        }
        if(maxCTR_CTR<CTR) {
          maxCTR_U=U;
          maxCTR_CTR=CTR;
        }
      } while (next(perm, dominant));
    } while (next_comb(comb, dominant, dataLine.numberOfAds));
  } else {
    for(i=0;i<dataLine.numberOfAds;++i) {
      position_effects[i]=position_effects_base[i];
      position_quality[i]=position_quality_base[i];
    }

    U=0;
    CTR=0;
    localseed[0]=789237;localseed[1]=723897436;localseed[2]=8909217837;localseed[3]=98098123;
    for (r = 0; r < NO_DRAWS_COUNTER; r++) {
      cost_ra = parameters[M1_SIGMA_COST] * nextNormal(localseed);
      pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * nextNormal(seed[thread]);
      pos_variance_user*=pos_variance_user;

      // Compute variance of the posterior
      sigma=1/(1/variance+1/pos_variance_user);
      // Get stardard deviation
      sqrtsigma=sqrt(sigma);
      R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(localseed);

      k = 0;
      for (i = 0; i < dataLine.numberOfAds; i++) {
        // Known utility shock
        u = nextExponential(seed[thread]) + cost_ra;
        position_quality_user[i] = position_quality[i];
        // Mean of the posterior
        signal = utilities_base[i] + sqrt(variance) * nextNormal(seed[thread]);
        mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;
 
        if (mu > 0) {
          actual_positions[k] = i;
          utilities[i] = pow(MAX(utilities_base[i]+u,0), R + 1); 
          // Construct the integration grid
          for(z=0;z<GRID_SIZE;++z) {
            utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1); 
          }   
          // Last part of the grid is the true quality
          utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1); 
          k++;
        } else {
          utilities[i] = 0;
        }   
      }
   
      make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
      //make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
      CTR+=best_nest;
   
      tempU=0;
      for(i=0;i<best_nest;++i) {
        tempU+=utilities_grid[choice[i]][GRID_SIZE];
      }
      U+=pow(tempU,1/(R+1));
      for(i=0;i<best_nest;++i) {
        U+=position_effects[choice[i]];
      }
    }
    maxU_U=U/NO_DRAWS_COUNTER;
    maxU_CTR=CTR/NO_DRAWS_COUNTER;
    maxCTR_U=U/NO_DRAWS_COUNTER;
    maxCTR_CTR=CTR/NO_DRAWS_COUNTER;
  }

  results[0]=maxU_U; 
  results[1]=maxU_CTR;
  results[2]=maxCTR_U; 
  results[3]=maxCTR_CTR;

  // Assorative matching
  // Sort utilites
  for(i=0;i<dataLine.numberOfAds;++i) idx[i]=i;
  insertionSort(utilities_base,idx,dataLine.numberOfAds);
  // Permute costs
  for(i=0;i<dataLine.numberOfAds;++i) {
    position_effects[i]=position_effects_base[idx[i]];
    position_quality[i]=position_quality_base[idx[i]];
  }

  // Make choices
  U=0;
  CTR=0;
  localseed[0]=789237;localseed[1]=723897436;localseed[2]=8909217837;localseed[3]=98098123;
  for (r = 0; r < NO_DRAWS_COUNTER; r++) {
    cost_ra = parameters[M1_SIGMA_COST] * nextNormal(localseed);
    pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * nextNormal(seed[thread]);
    pos_variance_user*=pos_variance_user;

    // Compute variance of the posterior
    sigma=1/(1/variance+1/pos_variance_user);
    // Get stardard deviation
    sqrtsigma=sqrt(sigma);
    R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(localseed);

    k = 0;
    for (i = 0; i < dataLine.numberOfAds; i++) {
      u = nextExponential(localseed) + cost_ra;
      position_quality_user[i] = position_quality[i];
      // Compute the kernel of the mean of the posterior (to avoid multiplication)
      signal = utilities_base[i] + sqrt(variance) * nextNormal(localseed);
      mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;

      if (mu > 0) {
        actual_positions[k] = i;
        // Construct the integration grid
        for(z=0;z<GRID_SIZE;++z) {
          utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
        }
        // Last part of the grid is the true quality
        utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1);
        k++;
      } else {
        utilities[i] = 0;
      }
    }

    make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
    //make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
    CTR+=best_nest;

    tempU=0;
    for(i=0;i<best_nest;++i) {
      tempU+=utilities_grid[choice[i]][GRID_SIZE];
    }
    U+=pow(tempU,1/(R+1));
    for(i=0;i<best_nest;++i) {
      U+=position_effects[choice[i]];
    }
  }
  U/=NO_DRAWS_COUNTER;
  CTR/=NO_DRAWS_COUNTER;
  results[4]=U;
  results[5]=CTR;

  // Long run
  maxU_U=0;
  maxU_CTR=0;  
  maxCTR_CTR=0;
  maxCTR_U=0;

  if(dominant>0) {
    for(i=0;i<dominant;i++) comb[i]=i;
    do {
      for(i=0;i<dominant;i++) perm[i]=i;
      do {
        // Permute positions
        // Put dominant firms positions
        for(i=0;i<dominant;++i) {
          position_effects[i]=position_effects_base[comb[perm[i]]];
          position_quality[i]=position_quality_base[comb[perm[i]]];
        }
        // Put other domains
        i=dominant;
        for(j=0;j<dataLine.numberOfAds;++j) {
          if(SequentialSearch(comb,j,dominant)<0) {
            position_effects[i]=position_effects_base[j];
            position_quality[i]=position_quality_base[j];
            i++;
          }
        }
        
        /*
        for(i=0;i<dataLine.numberOfAds;++i) dataLine.domains[i]=0;
        for(i=0;i<dominant;++i) dataLine.domains[comb[perm[i]]]=i+1;
        for(i=0;i<dataLine.numberOfAds;++i) printf("%2d ",dataLine.domains[i]);printf("\n");
        for(i=0;i<dataLine.numberOfAds;++i) printf("%f ",position_effects_base[i]);printf("\n");
        for(i=0;i<dataLine.numberOfAds;++i) printf("%f ",position_effects[i]);printf("\n");
        printf("\n");
        getchar();
        */
        U=0;
        CTR=0;
        maxnest=0;
        localseed[0]=789237;localseed[1]=723897436;localseed[2]=8909217837;localseed[3]=98098123;
        for (r = 0; r < NO_DRAWS_COUNTER; r++) {
          cost_ra = parameters[M1_SIGMA_COST] * nextNormal(localseed);
          pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * nextNormal(seed[thread]);
          pos_variance_user*=pos_variance_user;

          // Compute variance of the posterior
          sigma=1/(1/variance+1/pos_variance_user);
          // Get stardard deviation
          sqrtsigma=sqrt(sigma);
          R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(localseed);
   
          k = 0;
          for (i = 0; i < dataLine.numberOfAds; i++) {
            // Known utility shock
            u = nextExponential(seed[thread]) + cost_ra;
            position_quality_user[i] = position_quality[i];
            // Mean of the posterior
            signal = utilities_base[i] + sqrt(variance) * nextNormal(seed[thread]);
            mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;
 
            if (mu > 0) {
              actual_positions[k] = i;
              utilities[i] = pow(MAX(utilities_base[i]+u,0), R + 1);
              // Construct the integration grid
              for(z=0;z<GRID_SIZE;++z) {
                utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
              }
              // Last part of the grid is the true quality
              utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1);
              k++;
            } else {
              utilities[i] = 0;
            }
          }
   
          //make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
          make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
          CTR+=best_nest;

          tempU=0;
          for(i=0;i<best_nest;++i) {
            tempU+=utilities_grid[choice[i]][GRID_SIZE];
          }
          U+=pow(tempU,1/(R+1));
          for(i=0;i<best_nest;++i) {
            U+=position_effects[choice[i]];
          }
        }
        U/=NO_DRAWS_COUNTER;
        CTR/=NO_DRAWS_COUNTER;

        if(maxU_U<U) {
          maxU_U=U;
          maxU_CTR=CTR;
        }
        if(maxCTR_CTR<CTR) {
          maxCTR_U=U;
          maxCTR_CTR=CTR;
        }
      } while (next(perm, dominant));
    } while (next_comb(comb, dominant, dataLine.numberOfAds));
  } else {
    for(i=0;i<dataLine.numberOfAds;++i) {
      position_effects[i]=position_effects_base[i];
      position_quality[i]=position_quality_base[i];
    }

    U=0;
    CTR=0;
    maxnest=0;
    localseed[0]=789237;localseed[1]=723897436;localseed[2]=8909217837;localseed[3]=98098123;
    for (r = 0; r < NO_DRAWS_COUNTER; r++) {
      cost_ra = parameters[M1_SIGMA_COST] * nextNormal(localseed);
      pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * nextNormal(seed[thread]);
      pos_variance_user*=pos_variance_user;

      // Compute variance of the posterior
      sigma=1/(1/variance+1/pos_variance_user);
      // Get stardard deviation
      sqrtsigma=sqrt(sigma);
      R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(localseed);

      k = 0;
      for (i = 0; i < dataLine.numberOfAds; i++) {
        // Known utility shock
        u = nextExponential(seed[thread]) + cost_ra;
        position_quality_user[i] = position_quality[i];
        // Mean of the posterior
        signal = utilities_base[i] + sqrt(variance) * nextNormal(seed[thread]);
        mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;

        if (mu > 0) {
          actual_positions[k] = i;
          utilities[i] = pow(MAX(utilities_base[i]+u,0), R + 1);
          // Construct the integration grid
          for(z=0;z<GRID_SIZE;++z) {
            utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
          }
          // Last part of the grid is the true quality
          utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1);
          k++;
        } else {
          utilities[i] = 0;
        }
      }

      //make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
      make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
      CTR+=best_nest;

      tempU=0;
      for(i=0;i<best_nest;++i) {
        tempU+=utilities_grid[choice[i]][GRID_SIZE];
      }
      U+=pow(tempU,1/(R+1));
      for(i=0;i<best_nest;++i) {
        U+=position_effects[choice[i]];
      }
    }
    maxU_U=U/NO_DRAWS_COUNTER;
    maxU_CTR=CTR/NO_DRAWS_COUNTER;
    maxCTR_U=U/NO_DRAWS_COUNTER;
    maxCTR_CTR=CTR/NO_DRAWS_COUNTER;
  }

  results[6]=maxU_U; 
  results[7]=maxU_CTR;
  results[8]=maxCTR_U; 
  results[9]=maxCTR_CTR;

  // Assorative matching
  // Sort utilites
  for(i=0;i<dataLine.numberOfAds;++i) idx[i]=i;
  insertionSort(utilities_base,idx,dataLine.numberOfAds);
  // Permute costs
  for(i=0;i<dataLine.numberOfAds;++i) {
    position_effects[i]=position_effects_base[idx[i]];
    position_quality[i]=position_quality_base[idx[i]];
  }
  /*
  for(i=0;i<dataLine.numberOfAds;++i) printf("%f\t",utilities_base[i]); printf("\n");
  for(i=0;i<dataLine.numberOfAds;++i) printf("%f\t",position_effects_base[i]); printf("\n");
  for(i=0;i<dataLine.numberOfAds;++i) printf("%f\t",position_effects[i]); printf("\n");
  getchar();
  */
  // Make choices
  U=0;
  CTR=0;
  localseed[0]=789237;localseed[1]=723897436;localseed[2]=8909217837;localseed[3]=98098123;
  for (r = 0; r < NO_DRAWS_COUNTER; r++) {
    cost_ra = parameters[M1_SIGMA_COST] * nextNormal(localseed);
    pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * nextNormal(seed[thread]);
    pos_variance_user*=pos_variance_user;

    // Compute variance of the posterior
    sigma=1/(1/variance+1/pos_variance_user);
    // Get stardard deviation
    sqrtsigma=sqrt(sigma);
    R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(localseed);

    k = 0;
    for (i = 0; i < dataLine.numberOfAds; i++) {
      // Known utility shock
      u = nextExponential(seed[thread]) + cost_ra;
      position_quality_user[i] = position_quality[i];
      // Mean of the posterior
      signal = utilities_base[i] + sqrt(variance) * nextNormal(seed[thread]);
      mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;

      if (mu > 0) {
        actual_positions[k] = i;
        utilities[i] = pow(MAX(utilities_base[i] + u,0), R + 1);
        // Construct the integration grid
        for(z=0;z<GRID_SIZE;++z) {
          utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
        }
        // Last part of the grid is the true quality
        utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i] + u,0), R + 1);
        k++;
      } else {
        utilities[i] = 0;
      }
    }

    //make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
    make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
    CTR+=best_nest;

    tempU=0;
    for(i=0;i<best_nest;++i) {
      tempU+=utilities_grid[choice[i]][GRID_SIZE];
    }
    U+=pow(tempU,1/(R+1));
    for(i=0;i<best_nest;++i) {
      U+=position_effects[choice[i]];
    }
  }
  U/=NO_DRAWS_COUNTER;
  CTR/=NO_DRAWS_COUNTER;
  results[10]=U;
  results[11]=CTR;


  // First best
  FB_SR_CTR_CTR_total=0;
  FB_SR_CTR_U_total=0;
  FB_SR_U_CTR_total=0;
  FB_SR_U_U_total=0;

  FB_LR_CTR_CTR_total=0;
  FB_LR_CTR_U_total=0;
  FB_LR_U_CTR_total=0;
  FB_LR_U_U_total=0;

  localseed[0]=789237;localseed[1]=723897436;localseed[2]=8909217837;localseed[3]=98098123;
  for (r = 0; r < NO_DRAWS_COUNTER; r++) {
    cost_ra = parameters[M1_SIGMA_COST] * nextNormal(localseed);
    pos_variance_user = pos_variance + parameters[M1_SIGMA_POS_SIGMA] * nextNormal(seed[thread]);
    pos_variance_user*=pos_variance_user;

    // Compute variance of the posterior
    sigma=1/(1/variance+1/pos_variance_user);
    // Get stardard deviation
    sqrtsigma=sqrt(sigma);
    R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(localseed);

    k = 0;
    for (i = 0; i < dataLine.numberOfAds; i++) {
      // Known utility shock
      u = nextExponential(seed[thread]) + cost_ra;
      position_quality_user[i] = position_quality[i];
      // Mean of the posterior
      signal = utilities_base[i] + sqrt(variance) * nextNormal(seed[thread]);
      mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;

      if (mu > 0) {
        actual_positions[k] = i;
        utilities[i] = pow(MAX(utilities_base[i]+u,0), R + 1);
        // Construct the integration grid
        for(z=0;z<GRID_SIZE;++z) {
          utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
        }
        // Last part of the grid is the true quality
        utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1);
        k++;
      } else {
        utilities[i] = 0;
      }
    }

    FB_SR_CTR_CTR=0;
    FB_SR_CTR_U=0;
    FB_SR_U_CTR=0;
    FB_SR_U_U=0;

    FB_LR_CTR_CTR=0;
    FB_LR_CTR_U=0;
    FB_LR_U_CTR=0;
    FB_LR_U_U=0;
    // Permute all ads
    for(i=0;i<dataLine.numberOfAds;i++) perm[i]=i;

    do {
      // Permute positions
      // Put dominant firms positions
      for(i=0;i<dataLine.numberOfAds;++i) {
        position_effects[i]=position_effects_base[perm[i]];
        position_quality[i]=position_quality_base[perm[i]];
      }

      make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);

      tempU=0;
      for(i=0;i<best_nest;++i) {
        tempU+=utilities_grid[choice[i]][GRID_SIZE];
      }
      tempU=pow(tempU,1/(R+1));   
      for(i=0;i<best_nest;++i) {
        tempU+=position_effects[choice[i]];
      }
      if(FB_SR_CTR_CTR<best_nest) {
        FB_SR_CTR_CTR=best_nest;
        FB_SR_CTR_U=tempU;  
      }
      if(FB_SR_U_U<tempU) {
        FB_SR_U_CTR=best_nest;
        FB_SR_U_U=tempU;
      }

      make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);

      tempU=0;
      for(i=0;i<best_nest;++i) {
        tempU+=utilities_grid[choice[i]][GRID_SIZE];
      }
      tempU=pow(tempU,1/(R+1));
      for(i=0;i<best_nest;++i) {
        tempU+=position_effects[choice[i]];
      }
      if(FB_LR_CTR_CTR<best_nest) {
        FB_LR_CTR_CTR=best_nest;
        FB_LR_CTR_U=tempU;
      }
      if(FB_LR_U_U<tempU) {
        FB_LR_U_CTR=best_nest;
        FB_LR_U_U=tempU;
      }
    } while (next(perm, dataLine.numberOfAds));

    FB_SR_CTR_CTR_total+=FB_SR_CTR_CTR;
    FB_SR_CTR_U_total+=FB_SR_CTR_U;
    FB_SR_U_CTR_total+=FB_SR_U_CTR;
    FB_SR_U_U_total+=FB_SR_U_U;

    FB_LR_CTR_CTR_total+=FB_LR_CTR_CTR;
    FB_LR_CTR_U_total+=FB_LR_CTR_U;
    FB_LR_U_CTR_total+=FB_LR_U_CTR;
    FB_LR_U_U_total+=FB_LR_U_U;
  }
  FB_SR_CTR_CTR_total/=NO_DRAWS_COUNTER;
  FB_SR_CTR_U_total/=NO_DRAWS_COUNTER;
  FB_SR_U_CTR_total/=NO_DRAWS_COUNTER;
  FB_SR_U_U_total/=NO_DRAWS_COUNTER;

  FB_LR_CTR_CTR_total/=NO_DRAWS_COUNTER;
  FB_LR_CTR_U_total/=NO_DRAWS_COUNTER;
  FB_LR_U_CTR_total/=NO_DRAWS_COUNTER;
  FB_LR_U_U_total/=NO_DRAWS_COUNTER;

  results[12]=FB_SR_U_U_total;
  results[13]=FB_SR_U_CTR_total;
  results[14]=FB_SR_CTR_U_total;
  results[15]=FB_SR_CTR_CTR_total;

  results[16]=FB_LR_U_U_total;
  results[17]=FB_LR_U_CTR_total;
  results[18]=FB_LR_CTR_U_total;
  results[19]=FB_LR_CTR_CTR_total;
/* 
  printf("%f\t%f\n",results[0],results[1]);
  printf("%f\t%f\n",results[2],results[3]);
  printf("%f\t%f\n",results[4],results[5]);
  printf("%f\t%f\n",results[12],results[13]);
  printf("%f\t%f\n",results[14],results[15]);
  printf("%f\t%f\n",results[4],results[5]);
  printf("%f\t%f\n",results[6],results[7]);
  printf("%f\t%f\n",results[8],results[9]);
  printf("%f\t%f\n",results[10],results[11]);
  printf("%d\n",maxnestt);
  getchar();*/

  // Free the grid
  for(i=0;i<dataLine.numberOfAds;++i) {
    free(utilities_grid[i]);
  }
  free(utilities_grid);
}
