clear all

domains=dlmread('domains.csv');
misc=dlmread('miscVector.csv');
seed=[124 3214 234 324];

topdomains=[39, 25, 129, 88;...
  97, 258, 20, 397;...
  57, 388, 121, 81;...
  54, 5, 297, 2484];

data=zeros(size(domains,1),6);

for i=1:size(domains,1)
  line=zeros(1,6);
  line(1:2)=misc(i,:);
  r=3;
  for j=1:4
    idx=find(domains(i,:)==topdomains(misc(i,2)+1,j));
    if(~isempty(idx)) 
      line(r)=j;
      r=r+1;
    end
  end
  data(i,:)=line;
end

fprintf('Data constucted\n');

dataUnique=unique(data,'rows');

fprintf('Data sorted\n')
composition=zeros(size(dataUnique,1),1);
for j=1:size(dataUnique,1)
  for i=1:size(data,1)
    if(norm(data(i,:)-dataUnique(j,:))==0)
      composition(j)=composition(j)+1;
    end
  end
end

load position_weights
position_weights=position_weights';

save counter

load counter

save counterData dataUnique composition seed position_weights

%eval('!./Counterfactuals_matlab counterData.mat parametersFinal.mat resultsCounter.mat &');
load bs_draws
for bs=1:30
  parameters=Y(:,bs);
  save(['bs/counterfactuals' num2str(bs) '.mat'],'parameters');
  eval(['!./Counterfactuals_matlab counterData.mat bs/counterfactuals' num2str(bs) '.mat bs/resultsCounter' num2str(bs) '.mat &']);
end
