/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright: Przemyslaw Jeziorski (przjez@gmail.com)
***************************************************************************/
#ifndef CUDA_GENERATOR_H__
#define CUDA_GENERATOR_H__

#define F_TYPE double

#define H   32768               /* = 2^15 : use in MultModM.           */

#define PI 3.141592653589793

typedef long seedStruct[4];


void createGenerators(int n, long sd[4], seedStruct *g);
void createGeneratorsDefault(int n, seedStruct *g);
void createGeneratorsSaved(int n, F_TYPE *init, seedStruct *g);
void vectorNormalVar(long *g, int n, F_TYPE *output, F_TYPE var);

F_TYPE nextUniform(long *g);
F_TYPE nextNormal(long *g);
F_TYPE nextExponential(long *g);
void vectorNormal(long *g, int n, F_TYPE *output);
#endif
