
clear all

domains=dlmread('domains.csv');
misc=dlmread('miscVector.csv');
seed=[124 3214 234 324];
clicks=dlmread('clicks.csv');

options = optimset('Jacobian','on','GradObj','on','Display','iter', 'MaxFunEvals', 1e6, 'MaxIter', 1e6);%,'DerivativeCheck','on');%,'Hessian','on');

load position_weights
position_weights=position_weights';
misc=misc';
domains=domains';
clicks=clicks';

save input_gf domains misc seed position_weights clicks

eval('!./Goodness_of_fit_matlab input_gf.mat parametersFinal.mat output_gf.mat');
load output_gf

h=figure(1);
set(gcf,'Position',[0 0 1500 400]);
%subplot(2,2,1); bar(realdata_counter(1:8)./realdata_counter(32+[1:8]),'grouped', 'black');
subplot(2,2,1); plot([1:8],realdata_counter(1:8)./realdata_counter(32+[1:8]), 'black');
t=title('Games');set(t,'FontSize',16);
t=ylabel('Probability');set(t,'FontSize',14);
t=xlabel('Time');set(t,'FontSize',14);
ylim([0.4 1]);
set(gca,'FontSize',14);

%subplot(2,2,2); bar(realdata_counter(9:16)./realdata_counter(32+[9:16]),'grouped', 'black');
subplot(2,2,2); plot([1:8],realdata_counter(9:16)./realdata_counter(32+[9:16]), 'black');
t=title('Weather');set(t,'FontSize',16);
t=ylabel('Probability');set(t,'FontSize',14);
t=xlabel('Time');set(t,'FontSize',14);
ylim([0.4 1]);
set(gca,'FontSize',14);

%subplot(2,2,3); bar(realdata_counter(17:24)./realdata_counter(32+[17:24]),'grouped', 'black');
subplot(2,2,3); plot([1:8],realdata_counter(17:24)./realdata_counter(32+[17:24]), 'black');
t=title('White pages');set(t,'FontSize',16);
t=ylabel('Probability');set(t,'FontSize',14);
t=xlabel('Time');set(t,'FontSize',14);
ylim([0.4 1]);
set(gca,'FontSize',14);

%subplot(2,2,4); bar(realdata_counter(25:32)./realdata_counter(32+[25:32]),'grouped', 'black');
subplot(2,2,4); plot([1:8],realdata_counter(25:32)./realdata_counter(32+[25:32]), 'black');
t=title('Sex');set(t,'FontSize',16);
t=ylabel('Probability');set(t,'FontSize',14);
t=xlabel('Time');set(t,'FontSize',14);
ylim([0.4 1]);
set(gca,'FontSize',14);

set(gcf,'PaperPositionMode','auto');
saveas(gcf, 'gf1', 'png');
