/**************************************************************************
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Copyright: Przemyslaw Jeziorski (przjez@gmail.com)
***************************************************************************/
#include<Program_signaling.h>

extern double grid[];

void realdata_counter(double *parameters, dataStruct dataLine, double *output, int thread) {
  int domains_fixed_effects_weather[] = { 97, 258, 20, 397 }; /* weather */
  int domains_fixed_effects_white_pages[] = { 57, 388, 121, 81 }; /* white pages */
  int domains_fixed_effects_games[] = { 39, 25, 129, 88 }; /* Games */
  int domains_fixed_effects_sex[] = { 54, 5, 297, 2484 }; /* Sex */
  int *domains_fixed_effects;
  int i,z;
  int dom;
  int r,k;
  double cost_ra,u;

  double utilities[dataLine.numberOfAds];
  double u_noexp[dataLine.numberOfAds];
  double utilities_base[dataLine.numberOfAds];
  double position_effects[dataLine.numberOfAds];
  double e[dataLine.numberOfAds];
  double R;
  double pos_variance;
  double pos_variance_user;
  double variance = parameters[M1_DESCRIPTION_SIGMA]*parameters[M1_DESCRIPTION_SIGMA];

  int actual_positions[dataLine.numberOfAds];
  int choice[MAXIMUM_CHOICE];
  int best_nest;
  int maximum_bundle = (MAXIMUM_CHOICE < dataLine.numberOfAds) ? MAXIMUM_CHOICE : dataLine.numberOfAds;

  double var_cost = parameters[M1_SIGMA_COST] * parameters[M1_SIGMA_COST];

  int offset;
  int offset_param;

  double position_quality[dataLine.numberOfAds];
  double position_quality_user[dataLine.numberOfAds];
  double **utilities_grid;

  double mu, sigma, sqrtsigma, signal;

  double myoutput[NO_REALDATA_COUNTER];
  double tempU;

  for (i=0;i<NO_REALDATA_COUNTER;++i) {
    myoutput[i]=0;
  }

  // Allocate the grid
  utilities_grid=(double **) malloc(dataLine.numberOfAds*sizeof(double *));
  for(i=0;i<dataLine.numberOfAds;++i) {
    utilities_grid[i]=(double *) malloc((GRID_SIZE+1)*sizeof(double));
  }

  switch (dataLine.searchString) {
  case 0: /* Games */
    domains_fixed_effects=domains_fixed_effects_games;
    offset_param = 0;
    z=0;
    //printf("Games:\n");
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS]*parameters[M1_SIGMA_POS];
    break;
  case 1: /* Weather */
    domains_fixed_effects=domains_fixed_effects_weather;
    offset_param = 10;
    z=40;
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS+1]*parameters[M1_SIGMA_POS+1];
    break;
  case 2: /* White pages */
    domains_fixed_effects=domains_fixed_effects_white_pages;
    offset_param = 20;
    z=80;
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS+2]*parameters[M1_SIGMA_POS+2];
    break;
  case 3: /* Sex */
    domains_fixed_effects=domains_fixed_effects_sex;
    offset_param = 30;
    z=120;
    //printf("Sex:\n");
    for(k=0;k<dataLine.numberOfAds;++k) {
      position_quality[k] = 0;
      for(i=0;i<5;i++) {
        position_quality[k]+=weights[z]*(parameters[M1_DOMAIN_FIXED_EFFECTS + i + offset_param]);
        z++;
      }
    }
    pos_variance = parameters[M1_SIGMA_POS+3]*parameters[M1_SIGMA_POS+3];
    break;
  default:
    return;
  }

  /* Construct utilities */

  /* Now seed the generators, and the part of utility that does not change */
  for (i = 0; i < dataLine.numberOfAds; i++) {
    if (i >= 6) {
      position_effects[i] = parameters[M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.3;
    } else if (i == 5) {
      position_effects[i] = parameters[M1_POSITION_FIXED_EFFECTS + 4 + offset_param] * 1.1;
    } else {
      position_effects[i] = parameters[M1_POSITION_FIXED_EFFECTS + i + offset_param];
    }

    dom = SequentialSearch(domains_fixed_effects,dataLine.domains[i],4);
    if (dom >= 0) {
      utilities_base[i] = parameters[M1_DOMAIN_FIXED_EFFECTS + dom + offset_param];
    } else {
      utilities_base[i] = parameters[M1_DOMAIN_FIXED_EFFECTS + 4 + offset_param];
    }

    offset=6+15+20*dataLine.searchString;
    if(dom>=0) {
      myoutput[offset+dom]+=NO_DRAWS_COUNTER;
    } else {   
      myoutput[offset+4]+=NO_DRAWS_COUNTER;
    }
  }

  for (r = 0; r < NO_DRAWS_COUNTER; r++) {
    cost_ra = parameters[M1_SIGMA_COST] * nextNormal(seed[thread]);
    pos_variance_user = pos_variance;
    // Compute variance of the posterior
    sigma=1/(1/variance+1/pos_variance_user);
    // Get stardard deviation
    sqrtsigma=sqrt(sigma);
    R = parameters[M1_R] + parameters[M1_SIGMA_R] * nextNormal(seed[thread]);

    k = 0;
    for (i = 0; i < dataLine.numberOfAds; i++) {
      // Known utility shock
      u = nextExponential(seed[thread]) + cost_ra;
      position_quality_user[i] = position_quality[i];
      // Mean of the posterior (to avoid multiplication)
      signal = utilities_base[i] + sqrt(variance) * nextNormal(seed[thread]);
      mu=sigma*(signal/variance+position_quality_user[i]/pos_variance_user) + u;

      if (mu > 0) {
        utilities[i] = pow(MAX(utilities_base[i]+u,0), R + 1);
        actual_positions[k] = i;
        // Construct the integration grid
        for(z=0;z<GRID_SIZE;++z) {
          utilities_grid[i][z]=pow(MAX(sqrt(2)*sqrtsigma*grid[z]+mu,0), R + 1);
        }
        // Last part of the grid is the true quality
        utilities_grid[i][GRID_SIZE]=pow(MAX(utilities_base[i]+u,0), R + 1);
        k++;
      } else {
        utilities[i] = 0;
      }
    }
    
    // Regular choice
    make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
    // Record global utility and CRT
    tempU=0;
    for(i=0;i<best_nest;++i) {
      tempU+=utilities_grid[choice[i]][GRID_SIZE];
    }
    myoutput[0]+=pow(tempU,1/(R+1));
    for(i=0;i<best_nest;++i) {
      myoutput[0]+=position_effects[choice[i]];
    } 
    myoutput[1]+=best_nest;
    
    offset=6+20*dataLine.searchString;
    for(i=0;i<best_nest;++i) {
      dom = SequentialSearch(domains_fixed_effects,dataLine.domains[choice[i]],4);
      if(dom>=0) {
        myoutput[offset+dom]++;
      } else {
        myoutput[offset+4]++;
      }
    }


    // R=0
    make_choice_signaling(parameters, k, utilities_grid, u_noexp, position_effects, choice, &best_nest, 0, 0, actual_positions);
    // Record global utility and CRT

    tempU=0;
    for(i=0;i<best_nest;++i) {
      tempU+=utilities_grid[choice[i]][GRID_SIZE];
    }
    myoutput[2]+=pow(tempU,1/(R+1));
    for(i=0;i<best_nest;++i) {
      myoutput[2]+=position_effects[choice[i]];
    }
    myoutput[3]+=best_nest;    
    
    offset=6+5+20*dataLine.searchString;
    for(i=0;i<best_nest;++i) {
      dom = SequentialSearch(domains_fixed_effects,dataLine.domains[choice[i]],4);
      if(dom>=0) {
        myoutput[offset+dom]++;
      } else {
        myoutput[offset+4]++;
      } 
    }


    // sigma=0
    make_choice(parameters, k, utilities, u_noexp, position_effects, choice, &best_nest, 0, R, actual_positions);
    // Record global utility and CRT
    tempU=0;
    for(i=0;i<best_nest;++i) {
      tempU+=utilities_grid[choice[i]][GRID_SIZE];
    }
    myoutput[4]+=pow(tempU,1/(R+1));
    for(i=0;i<best_nest;++i) {
      myoutput[4]+=position_effects[choice[i]];
    }
    myoutput[5]+=best_nest;

    offset=6+10+20*dataLine.searchString;
    for(i=0;i<best_nest;++i) {
      dom = SequentialSearch(domains_fixed_effects,dataLine.domains[choice[i]],4);
      if(dom>=0) {
        myoutput[offset+dom]++;
      } else {
        myoutput[offset+4]++;
      } 
    }
  }
  for (i = 0; i < NO_REALDATA_COUNTER; i++) {
    myoutput[i] /= (double)NO_DRAWS_COUNTER;
    output[i]+=myoutput[i];
  }

  // Free the grid
  for(i=0;i<dataLine.numberOfAds;++i) {
    free(utilities_grid[i]);
  }
  free(utilities_grid);
}

void *realdata_counterThread(void *inputInit) {
  int j,i;
  int per;
  int per_old=-1;

  ThreadMomentStructure *input = (ThreadMomentStructure *) inputInit;
  for (i=0;i<NO_REALDATA_COUNTER;++i) {
    input->realdata_counter[i]=0;
  }

  for (j=input->start;j<input->stop;++j) {
    if (input->thread==7) {
      per = (j/(double) jump-7)*100;
      if((per!=per_old) && (per % 1==0)) {
        printf("%d%% ",per);
	      fflush(stdout);
        per_old=per;
      }
    }
    realdata_counter(input->parameters, data[j], input->realdata_counter, input->thread);
  }

  if (input->thread==7) {
    printf("\n");
    fflush(stdout);
  }
}
