/*
 ***************************************************************************
 * This package contains code for the paper "Mobile Money in Tanzania" by  *
 *                                                                         *
 * Nicholas Economides                                                     *
 * Stern School of Business, NYU; NET Institute; economides@stern.nyu.edu  *
 *                                                                         *
 * and                                                                     *
 *                                                                         *
 * Przemyslaw Jeziorski                                                    *
 * Haas School of Business, UC Berkeley; przemekj@haas.berkeley.edu        *
 *                                                                         *
 * Copyright by Przemyslaw Jeziorski, 2016                                 *
 *                                                                         *
 * This program is free software: you can redistribute it and/or modify    *
 * it under the terms of the GNU General Public License as published by    *
 * the Free Software Foundation, either version 3 of the License, or       *
 * (at your option) any later version.                                     *
 *                                                                         *
 * This program is distributed in the hope that it will be useful,         *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 * GNU General Public License for more details.                            *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.   *
 ***************************************************************************
*/


#ifndef PROBIT_H
#define PROBIT_H

#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include<mat.h>
#include<pthread.h>
#include<dSFMT.h>


#define MOMENTS 106
#define PARAMETERS 62
#define SMP 64
#define RSIM 1
#define DIFF 1e-3

#define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X,Y) ((X) > (Y) ? (X) : (Y))


/* Global data structure */
double *transfersData;
double *distanceData;
double *spanData;
double *urbanData;

typedef struct {
  int thread, start, stop;
  double parameters[PARAMETERS];
  double moments[MOMENTS];
  double moments_data[MOMENTS];
  double varcovar[MOMENTS][MOMENTS];
  int jac;
} ThreadStructure;

void *moments(void *dataIn);

dsfmt_t dsfmt[SMP];

double **readDoubleMatrix(mxArray *in);

double *price_before;
double *price_after;
double *price_counter;
int counterfactual;
double *amounts;

#define BALANCE_UPPER 100000
#define BALANCE_STEP 100

#define PI 3.14159265359

#define PARAM_FIXED 0
#define PARAM_TIME 33
#define PARAM_PRICE_TRANSFER_MEAN 46
#define PARAM_GAMMA1 47
#define PARAM_DISTANCE_MEAN 48
#define PARAM_AGGR_STDDEV 49
#define PARAM_PERSISTENT_STDDEV 50
#define PARAM_SPAN_MEAN 51
#define PARAM_DISTANCE_SPAN_L11 52
#define PARAM_DISTANCE_SPAN_L21 53
#define PARAM_DISTANCE_SPAN_L22 54
#define PARAM_EPSILON_CORRELATION 55
#define PARAM_VARCOVAR_L11 56
#define PARAM_VARCOVAR_L21 57
#define PARAM_VARCOVAR_L22 58
#define PARAM_GAMMA2 59

#define MOMENTS_AFTER 33
#define MOMENTS_TIME 66
#define MOMENTS_DISTANCE_MEAN_BEFORE 80
#define MOMENTS_DISTANCE_STD_BEFORE 81
#define MOMENTS_DISTANCE_MEAN_AFTER 82
#define MOMENTS_DISTANCE_STD_AFTER 83
#define MOMENTS_JOINT_DISTR 84
#define MOMENTS_SAME_CHOICE 93
#define MOMENTS_SPAN_MEAN_BEFORE 94
#define MOMENTS_SPAN_STD_BEFORE 95
#define MOMENTS_SPAN_MEAN_AFTER 96
#define MOMENTS_SPAN_STD_AFTER 97
#define MOMENTS_DISTANCE_CHOICE_COV_BEFORE 98
#define MOMENTS_SPAN_CHOICE_COV_BEFORE 99
#define MOMENTS_DISTANCE_CHOICE_COV_AFTER 100
#define MOMENTS_SPAN_CHOICE_COV_AFTER 101
#define MOMENTS_DISTANCE_SPAN_COV_BEFORE 102
#define MOMENTS_DISTANCE_SPAN_COV_AFTER 103
#define MOMENTS_URBAN_BEFORE 104
#define MOMENTS_URBAN_AFTER 105

#endif
