%{
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % This package contains code for the paper "Mobile Money in Tanzania" by  %
 %                                                                         %
 % Nicholas Economides                                                     %
 % Stern School of Business, NYU; NET Institute; economides@stern.nyu.edu  %
 %                                                                         %
 % and                                                                     %
 %                                                                         %
 % Przemyslaw Jeziorski                                                    %
 % Haas School of Business, UC Berkeley; przemekj@haas.berkeley.edu        %
 %                                                                         %
 % Copyright by Przemyslaw Jeziorski, 2016                                 %
 %                                                                         %
 % This program is free software: you can redistribute it and/or modify    %
 % it under the terms of the GNU General Public License as published by    %
 % the Free Software Foundation, either version 3 of the License, or       %
 % (at your option) any later version.                                     %
 %                                                                         %
 % This program is distributed in the hope that it will be useful,         %
 % but WITHOUT ANY WARRANTY; without even the implied warranty of          %
 % MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           %
 % GNU General Public License for more details.                            %
 %                                                                         %
 % You should have received a copy of the GNU General Public License       %
 % along with this program.  If not, see <http://www.gnu.org/licenses/>.   %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%}

load parametersFinal_cashout
parameters(1)=[];
theta_cashout=parameters;

% Display moments
probit_c_cashout(theta_cashout);

% Optimize
%{
theta_cashout0=theta_cashout;
options = optimset('Jacobian','on','GradObj','on','Display','iter','LargeScale','off');
theta_star_cashout=fminsearch(@(x) probit_c_cashout(x),theta_cashout0,options);
save theta_star_cashout theta_star_cashout
%}
