%{
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % This package contains code for the paper "Mobile Money in Tanzania" by  %
 %                                                                         %
 % Nicholas Economides                                                     %
 % Stern School of Business, NYU; NET Institute; economides@stern.nyu.edu  %
 %                                                                         %
 % and                                                                     %
 %                                                                         %
 % Przemyslaw Jeziorski                                                    %
 % Haas School of Business, UC Berkeley; przemekj@haas.berkeley.edu        %
 %                                                                         %
 % Copyright by Przemyslaw Jeziorski, 2016                                 %
 %                                                                         %
 % This program is free software: you can redistribute it and/or modify    %
 % it under the terms of the GNU General Public License as published by    %
 % the Free Software Foundation, either version 3 of the License, or       %
 % (at your option) any later version.                                     %
 %                                                                         %
 % This program is distributed in the hope that it will be useful,         %
 % but WITHOUT ANY WARRANTY; without even the implied warranty of          %
 % MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           %
 % GNU General Public License for more details.                            %
 %                                                                         %
 % You should have received a copy of the GNU General Public License       %
 % along with this program.  If not, see <http://www.gnu.org/licenses/>.   %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%}


%{
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % This package contains code for the paper "Mobile Money in Tanzania" by  %
 %                                                                         %
 % Nicholas Economides                                                     %
 % Stern School of Business, NYU; NET Institute; economides@stern.nyu.edu  %
 %                                                                         %
 % and                                                                     %
 %                                                                         %
 % Przemyslaw Jeziorski                                                    %
 % Haas School of Business, UC Berkeley; przemekj@haas.berkeley.edu        %
 %                                                                         %
 % Copyright by Przemyslaw Jeziorski, 2016                                 %
 %                                                                         %
 % This program is free software: you can redistribute it and/or modify    %
 % it under the terms of the GNU General Public License as published by    %
 % the Free Software Foundation, either version 3 of the License, or       %
 % (at your option) any later version.                                     %
 %                                                                         %
 % This program is distributed in the hope that it will be useful,         %
 % but WITHOUT ANY WARRANTY; without even the implied warranty of          %
 % MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           %
 % GNU General Public License for more details.                            %
 %                                                                         %
 % You should have received a copy of the GNU General Public License       %
 % along with this program.  If not, see <http://www.gnu.org/licenses/>.   %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%}


load heterogeneity
s{1}='-3\sigma';
s{2}='-\sigma';
s{3}='0';
s{4}='+\sigma';
s{5}='+3\sigma';
for i=1:5
  bar(1:35,[D(1:10,i)' 0 D(11:18,i)' 0 D(19:24,i)' 0 D(25:32,i)']);
  hold on
  xlim([0 36]);ylim([0 0.4]);
  line([11 11],[0 100]);
  line([20 20],[0 100]);
  line([27 27],[0 100]);
  set(gca,'XTick',[0;5.5;11;15.5;20;23.5;27;31;35],'XTicklabel',{'0';'5k';'10k';'30k';'50k';'75k';'100k';'550k';'1000k'});
  set(gca,'fontsize',25,'fontWeight','bold');
  set(gcf,'Position',[0 0 750 300]);
  title(['Conditional transfer size distribution, \kappa=' s{i}]);
  ylabel('Probability');
  xlabel('Transfer size'); 
  hold off
  file=['heterogeneity' num2str(i) '.pdf'];
  export_fig(file,'-transparent');
end
!cp heterogeneity*.pdf ~/Dropbox/MOBILE_BANKING