%{
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % This package contains code for the paper "Mobile Money in Tanzania" by  %
 %                                                                         %
 % Nicholas Economides                                                     %
 % Stern School of Business, NYU; NET Institute; economides@stern.nyu.edu  %
 %                                                                         %
 % and                                                                     %
 %                                                                         %
 % Przemyslaw Jeziorski                                                    %
 % Haas School of Business, UC Berkeley; przemekj@haas.berkeley.edu        %
 %                                                                         %
 % Copyright by Przemyslaw Jeziorski, 2016                                 %
 %                                                                         %
 % This program is free software: you can redistribute it and/or modify    %
 % it under the terms of the GNU General Public License as published by    %
 % the Free Software Foundation, either version 3 of the License, or       %
 % (at your option) any later version.                                     %
 %                                                                         %
 % This program is distributed in the hope that it will be useful,         %
 % but WITHOUT ANY WARRANTY; without even the implied warranty of          %
 % MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           %
 % GNU General Public License for more details.                            %
 %                                                                         %
 % You should have received a copy of the GNU General Public License       %
 % along with this program.  If not, see <http://www.gnu.org/licenses/>.   %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%}


function [y L]=probit(parameters)
  parameters=[-1e16 parameters];

  file = fopen('output_cashout','a');
  price_before=[0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.8 0.8 1 1 1 1 1 1 1.4 1.4 1.4 1.4 1.4 ...
               1.8 3 4 5 5 5 5 5 5 5];
  price_after=[0.5 0.5 0.5 0.5 0.5 0.6 0.6 0.6 0.6 0.6 1 1 1 1.25 1.25 1.25 1.25 1.25 1.5 1.5 1.5 1.5 1.5,...
             2 3 4 5 5 5 5 5 5 5];
  jac=0;

  load amounts

  save parameters_cashout parameters price_before price_after jac amounts

  alpha=parameters(47)

  mu_d=parameters(49);
  gamma1=parameters(48);

  mu_b1=parameters(52);
  gamma2=parameters(60);

  bound=sqrt(1/(4*cos(pi/(33+1))^2)-1e-6);
  rho1=2*atan(parameters(56))/pi*bound;

  L=[parameters(57) 0;parameters(58) parameters(59)];
  omega2=L*L';
  printMatrix(omega2);

  sigma_alpha=sqrt(omega2(1,1));
  sigma_beta=sqrt(omega2(2,2));
  sigma_alpha_beta=omega2(1,2)/(sigma_alpha*sigma_beta);

  fprintf('\n');
  L=[parameters(53) 0;parameters(54) parameters(55)];
  omega2=L*L';
  printMatrix(omega2);
  sigma_d=sqrt(omega2(1,1));
  sigma_b1=sqrt(omega2(2,2));
  sigma_d_b1=omega2(1,2)/(sigma_alpha*sigma_beta);


  for i=1:size(parameters,2)
    fprintf(file,'%f ',parameters(i));
  end
  fprintf(file,'\n');

  fprintf('Transfer dummies:\n');
  fprintf(file,'Transfer dummies:\n');
  for i=1:33
    fprintf('%f ',parameters(i));
    fprintf(file,'%f ',parameters(i));
  end
  fprintf('\n');
  fprintf(file,'\n');
  fprintf('Time dummies:\n');
  fprintf(file,'Time dummies:\n');
  for i=1:6
    fprintf('%f ',parameters(33+i));
    fprintf(file,'%f ',parameters(33+i));
  end
  fprintf('\n');
  fprintf(file,'\n');
  for i=7:13
    fprintf('%f ',parameters(33+i));
    fprintf(file,'%f ',parameters(33+i));
  end
  fprintf('\n');
  fprintf(file,'\n');

  fprintf('Price:\t %f, %f, %f, %f\n',parameters(47), sigma_alpha, sigma_beta, sigma_alpha_beta);
  fprintf(file,'Price:\t %f, %f, %f, %f\n',parameters(47), sigma_alpha, sigma_beta, sigma_alpha_beta);
  fprintf('Persistence:\t %f, %f\n',parameters(50),parameters(51));
  fprintf(file,'Persistence:\t %f, %f\n',parameters(50),parameters(51));
  fprintf('Rho:\t %f\n',rho1);
  fprintf(file,'Rho:\t %f\n',rho1);
  fprintf('Span:\t %f, %f, %f\n', gamma2, mu_b1,sigma_b1);
  fprintf(file,'Span:\t %f, %f, %f\n', gamma2, mu_b1,sigma_b1);
  fprintf('Distance\t %f, %f, %f\n', gamma1, mu_d, sigma_d);
  fprintf(file,'Distance\t %f, %f, %f\n', gamma1, mu_d, sigma_d);
  fprintf('Urban\t %f %f\n', parameters(end-1),parameters(end));

  system('cp output_cashout.mat output_cashout_save.mat');
  system('rm output_cashout.mat');

  system('./cashout_probit data_cashout.mat parameters_cashout.mat output_cashout.mat');


  load output_cashout

  %momentsData(1:66)=momentsData(1:66)*100;
  %moments(1:66)=moments(1:66)*100;
  
  for i=1:33
    fprintf('Choice %d: %f\t(%f)\t%f\t(%f)\n',i,moments(i),momentsData(i),moments(i+33),momentsData(i+33));
    fprintf(file,'Choice %d: %f\t(%f)\t%f\t(%f)\n',i,moments(i),momentsData(i),moments(i+33),momentsData(i+33));
  end
  for i=1:14
    fprintf('Choice %d: %f\t(%f)\n',i,moments(66+i),momentsData(66+i));
    fprintf(file,'Choice %d: %f\t(%f)\n',i,moments(66+i),momentsData(66+i));
  end
  for i=1:4
    fprintf('Distance %d: %f\t(%f)\n',i,moments(80+i),momentsData(80+i));
    fprintf(file,'Distance %d: %f\t(%f)\n',i,moments(80+i),momentsData(80+i));
  end
  for i=1:3
    fprintf('Joint %d: ',i-1);
    fprintf(file,'Joint %d: ',i-1);
    for j=1:3
      fprintf('%f\t(%f)\t',moments(84+(i-1)*3+j),momentsData(84+(i-1)*3+j));
      fprintf(file,'%f\t(%f)\t',moments(84+(i-1)*3+j),momentsData(84+(i-1)*3+j));
    end
    fprintf('\n');
    fprintf(file,'\n');
  end
  for i=1:4
    fprintf('Span %d: %f\t(%f)\n',i,moments(94+i),momentsData(94+i));
    fprintf(file,'Span %d: %f\t(%f)\n',i,moments(94+i),momentsData(94+i));
  end
  for i=1:2
    fprintf('Distance/Span Cov %d: %f\t(%f)\n',i,moments(102+i),momentsData(102+i));
    fprintf(file,'SDistance/Span Cov %d: %f\t(%f)\n',i,moments(102+i),momentsData(102+i));
  end

  fprintf('Same transfer: %f (%f)\n',moments(93),momentsData(93));
  fprintf(file,'Same transfer: %f (%f)\n',moments(93),momentsData(93));

  for i=1:4
    fprintf('Interactions %d: %f\t(%f)\n',i,moments(98+i),momentsData(98+i));
    fprintf(file,'Interactions %d: %f\t(%f)\n',i,moments(98+i),momentsData(98+i));
  end

  for i=1:2
    fprintf('Urban %d: %f\t(%f)\n',i,moments(104+i),momentsData(104+i));
    fprintf(file,'Urban %d: %f\t(%f)\n',i,moments(104+i),momentsData(104+i));
  end


  deleteMoments=[1 34 67 74 93];
  deleteParam=[1];

  moments(deleteMoments)=[];momentsData(deleteMoments)=[];

  load Omega_cashout

  f=moments-momentsData;
  y=f'*Omega*f;

  fprintf(file,'Objective = %f\n\n\n\n',y);
  fclose(file);
end
