%{
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % This package contains code for the paper "Mobile Money in Tanzania" by  %
 %                                                                         %
 % Nicholas Economides                                                     %
 % Stern School of Business, NYU; NET Institute; economides@stern.nyu.edu  %
 %                                                                         %
 % and                                                                     %
 %                                                                         %
 % Przemyslaw Jeziorski                                                    %
 % Haas School of Business, UC Berkeley; przemekj@haas.berkeley.edu        %
 %                                                                         %
 % Copyright by Przemyslaw Jeziorski, 2016                                 %
 %                                                                         %
 % This program is free software: you can redistribute it and/or modify    %
 % it under the terms of the GNU General Public License as published by    %
 % the Free Software Foundation, either version 3 of the License, or       %
 % (at your option) any later version.                                     %
 %                                                                         %
 % This program is distributed in the hope that it will be useful,         %
 % but WITHOUT ANY WARRANTY; without even the implied warranty of          %
 % MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           %
 % GNU General Public License for more details.                            %
 %                                                                         %
 % You should have received a copy of the GNU General Public License       %
 % along with this program.  If not, see <http://www.gnu.org/licenses/>.   %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%}


load amounts

load parametersFinal_cashout

file = fopen('output_cashout','a');
price_before=[0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.8 0.8 1 1 1 1 1 1 1.4 1.4 1.4 1.4 1.4 ...
          1.8 3 4 5 5 5 5 5 5 5];
price_after=[0.5 0.5 0.5 0.5 0.5 0.6 0.6 0.6 0.6 0.6 1 1 1 1.25 1.25 1.25 1.25 1.25 1.5 1.5 1.5 1.5 1.5,...
          2 3 4 5 5 5 5 5 5 5];

transactions = [0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 15000, 20000,...
  25000, 30000, 35000, 40000, 45000, 50000, 60000, 70000, 80000, 90000, 100000, 200000,...
  300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000];

paramSave=parameters;

jac=0;
startd=0.5;
starts=0.5;
for r=1:3
  if(r==1)
    % Overall
    paramSave=parameters;
  elseif(r==2)
    % Rural
    parameters=paramSave;
    parameters(61)=0;
    parameters(62)=0;
  elseif(r==3)
    % Urban
    parameters=paramSave;
    parameters(1:33)=parameters(1:33)+parameters(61);
    parameters(47)=parameters(47)+parameters(62);
    parameters(61)=0;
    parameters(62)=0;
  end

  i=1;
  d1_nom=wtp_evaluate(0.01,1,0,parameters)

  for d=[0.5:0.5:10]
    break_evend{r}(i)=fminbnd(@(x) (d1_nom-wtp_evaluate(d,1,x,parameters))^2,0.1,3*d)
%     break_evend{r}(i)=fminsearch(@(x) (d1_nom-wtp_evaluate(d,1,x,parameters))^2,startd+0.5)
     startd=break_evend{r}(i);
     i=i+1;
  end


  d1_nom=wtp_evaluate(1,0.01,0,parameters)
  i=1;
  for s=[0.5:0.5:10]
     break_evens{r}(i)=fminbnd(@(x) (d1_nom-wtp_evaluate(1,s,x,parameters))^2,0.1,3*s)
%     break_evens{r}(i)=fminsearch(@(x) (d1_nom-wtp_evaluate(1,s,x,parameters))^2,1)
    i=i+1;
  end
end
