%{
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % This package contains code for the paper "Mobile Money in Tanzania" by  %
 %                                                                         %
 % Nicholas Economides                                                     %
 % Stern School of Business, NYU; NET Institute; economides@stern.nyu.edu  %
 %                                                                         %
 % and                                                                     %
 %                                                                         %
 % Przemyslaw Jeziorski                                                    %
 % Haas School of Business, UC Berkeley; przemekj@haas.berkeley.edu        %
 %                                                                         %
 % Copyright by Przemyslaw Jeziorski, 2016                                 %
 %                                                                         %
 % This program is free software: you can redistribute it and/or modify    %
 % it under the terms of the GNU General Public License as published by    %
 % the Free Software Foundation, either version 3 of the License, or       %
 % (at your option) any later version.                                     %
 %                                                                         %
 % This program is distributed in the hope that it will be useful,         %
 % but WITHOUT ANY WARRANTY; without even the implied warranty of          %
 % MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           %
 % GNU General Public License for more details.                            %
 %                                                                         %
 % You should have received a copy of the GNU General Public License       %
 % along with this program.  If not, see <http://www.gnu.org/licenses/>.   %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%}


function d1_nom=wtp_evaluate(d,s,x,parameters)
  load amounts

  price_before=[0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.8 0.8 1 1 1 1 1 1 1.4 1.4 1.4 1.4 1.4 ...
          1.8 3 4 5 5 5 5 5 5 5]+x;
  price_after=[0.5 0.5 0.5 0.5 0.5 0.6 0.6 0.6 0.6 0.6 1 1 1 1.25 1.25 1.25 1.25 1.25 1.5 1.5 1.5 1.5 1.5,...
          2 3 4 5 5 5 5 5 5 5];

  transactions = [0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 15000, 20000,...
          25000, 30000, 35000, 40000, 45000, 50000, 60000, 70000, 80000, 90000, 100000, 200000,...
          300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000];


  jac=0;

  parameters(53:55)=0;
  parameters(52)=log(s);
  parameters(49)=log(d);

  save parametersWtp_cashout parameters price_before price_after jac amounts

  system('rm outputWtp_cashout.mat');
  system('./cashout_probit data_cashout.mat parametersWtp_cashout.mat outputWtp_cashout.mat');

  load outputWtp_cashout

  d1=sum(moments(1:33));
  d1_nom=sum(transactions*moments(1:33));
  [d s x d1 d1_nom]
end
