clear all;

convtol = zeros(17,1);
prof_fun = zeros(10,1);
prof_fun_ipopt = zeros(2,1);
transition = zeros(13,1);
init = zeros(5,1);
constants = zeros(4,1);
control = zeros(3,1);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Tolerance parameters        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Tolerance for value iteration (valueIt) %
  convtol(1) = 1e-6;

  % Tolerance for transition matrix and probability of exiting %
  convtol(2) = 1e-6;

  % Maximum number of fpstrat iteration %
  convtol(3) = 500000.0;

  % Tolerance on the probability of jumping up from the highest state %
  % If probability exceeds the value xmax is increased by convtol(4)   %
  convtol(4) = 1;

  % How much to increase xmax if it too small %
  convtol(5) = 5.0;

  % Tolerance on zero profit condition -- not used when set low %
  convtol(6) = 1e-4;

  % How much should we increase (relative measure) search interval of lambda %
  % when switching from approximate to exact profit function %
  convtol(7) = 0.1;

  % How much should we extend search interval if the equilibrium is outside of the % 
  % of the current search interval %
  convtol(8) = 0.5;

  % Tolerance value on the condition number of the matrix when calculating %
  % stationary distribution. If condition number is smaller that the       %
  % given value infinite sum is calculated instead of the inverse           %
  convtol(9) = 1e10;

  % Parameter regulating size of infinite sum in case condition number is small %
  convtol(10) = 100.0;

  % Parameter regulating smooth update of strategies %
  convtol(11) = 0.25;

  % Maximum xmax, can't go above this at all %
  convtol(12) = 140.0;

  % Hard minimum entry rate (otherwise code fails out) %
  convtol(13) = 1e-5;

  % Hard maximum entry rate (otherwise code fails out) % 
  convtol(14) = 1e6;

  % Unused %
  convtol(15) = 0.0;
  convtol(16) = 0.0;

  % Tolerance on entry rate in outer iterations (note: requires one or other tol to be hit) %
  convtol(17) = 0.01;  

  % 1 - if compute approximate profits first in the stationary model %
  % 2 - if compute only actual profits                               %
  control(1) = 2;

  % Entry process                            %
  % 1 - Poisson Entry                        %
  % 2 - Constant Entry                       %
  control(2) = 1;

  % Entry process                            %
  % 0 - Random number of firms               %
  % >0 - Set the fixed number of firms       %
  control(3) = 10;

  % Coputing method                          %
  % 0 - Bisection                            %
  % 1 - Gauss-Seidel                         %
  control(4) = 1;

  % Subtract a firm from stilde              %
  control(5) = 0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ACW profit function params %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Fixed cost
  prof_fun(1)=-237; % S
  prof_fun(2)=-261; % M
  prof_fun(3)=-287; % L
  prof_fun(4)=0;    % O
  % Log construction employment
  prof_fun(5)=12; % S
  prof_fun(6)=44; % M
  prof_fun(7)=83; % L
  prof_fun(8)=0;  % O
  % 1st competitor
  prof_fun(9)=-96;  % S
  prof_fun(10)=-101; % M
  prof_fun(11)=-76;  % L
  prof_fun(12)=0;    % O
  % Log competitors (above 1)
  prof_fun(13)=-73;  % S
  prof_fun(14)=-67;  % M
  prof_fun(15)=-40;  % L
  prof_fun(16)=0;    % O

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ipopt parameters            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Lower bound on prices
  prof_fun_ipopt(1) = 0;

  % Upper bound on prices
  prof_fun_ipopt(2) = prof_fun(2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Transition maxix parameters        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % State: 1-S, 2-SM, 3-SL, 4-M, 5-ML, 6-L, 7-Out
  transition(1)=0;      % S->S
  transition(2)=-528;   % S->M
  transition(3)=-1973;  % S->L
  transition(4)=0;      % S->O

  transition(5)=0;      % SM->S
  transition(6)=-824;   % SM->M
  transition(7)=-460;   % SM->L
  transition(8)=0;      % SM->O

  transition(9)=-0;     % SL->S
  transition(10)=-299;   % SL->M
  transition(11)=-277;   % SL->L
  transition(12)=-0;     % SL->O

  transition(13)=-7;     % M->S
  transition(14)=0;      % M->M
  transition(15)=105;    % M->L
  transition(16)=0;      % M->O

  transition(17)=-289;   % ML->S
  transition(18)=0;      % ML->M
  transition(19)=30;     % ML->L
  transition(20)=0;      % ML->O

  transition(21)=-111;   % L->S
  transition(22)=-427;   % L->M
  transition(23)=0;      % L->L
  transition(24)=0;      % L->O

  transition(25)=-918;   % O->S
  transition(26)=-2000;  % O->M
  transition(27)=-2721;  % O->L
  transition(28)=0;      % O->O

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Other constants of the model %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Entry cost %
  constants(1) = 35.0;

  % Fixed cost of investment %
  constants(2) = 0.5;

  % Parameter on variable cost of investment %
  % Set up big to switch-off variable cost  %
  constants(5) = 10000.0;

  % Discount factor (beta) %
  constants(3) = 0.95;

  % Entry state %
  constants(4) = 10.0;

  % ACW
  % actions
  constants(7) = 4;
  
  % variance of sigma
  constants(8) = 120;
  
  % demand shocks 
  constants(9) = log(1400);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialization parameters   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % starting xmax %
  init(1) = 7.0;

  % starting investment %
  init(2) = 1.0;

  % Starting exit rule %
  init(3) = constants(1);

  % bisection lower bound for lambda %
  init(4) = 8.0;

  % bisection upper bound for lambda %
  init(5) = 9.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CONTROL PARAMETERS FOR COMPUTING BOUNDS %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % not used %
  bounds(1)=0.0;

  % tolerance relative precision when simulating bounds %
  bounds(2)=0.1;

  % tolerance relative precision when simulating expected value function %
  bounds(3)=0.001;

  % maximum number of iterations to compute bounds %
  bounds(4)=1000000.0;

  % minimum number of iterations to compute bounds %
  bounds(5)=2.0;

  % maximum number of periods to consider when sampling state %
  % in case constant number of entrants                       %
  bounds(6)=1000.0;

  % tolerance prob. being in industry when sampling state %
  % in case constant number of entrants                   %
  bounds(7)=1e-3;

  % how much more states off equilibrium path should be considered %
  bounds(8)=1.0;

  % number of maximum state jumps per period %
  bounds(9)=1.0;

  % tolerance of checking if Delta_y is increasing
  bounds(10)=1e-3;

  filename='oe.log';

  save('oeIn.mat','filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds');

  infile='oeIn.mat';
  outfile='oeOut.mat';
  tic;
  eval(['!../compoe_matlab ',infile,' ',outfile]);
  compTime=toc;
  load(outfile);

%{
%%%%%% bounds

  [bound1,bound2,bound3,bound4,bound5]=bounds_matlab('output_bounds',...
     control,prof_fun,prof_fun_ipopt,transition,constants,init,convtol,bounds,...
     xmax,lambda,iota,rho,V,prices_end,tildes);

% Starting state is OE from original industry
  s0 = round(tildes);
  prof_fun(1)=prof_fun(1)/2;

  [xmax_new,V_new,iota_new,rho_new,lambda_new,tildes_new,prcont,prices,ms,profit,prices_end_new,c,success]...
    =compoe_matlab('output',control,prof_fun,prof_fun_ipopt,transition,constants,init,convtol);
       save oedata_new tildes_new iota_new rho_new V_new xmax_new prices_end_new lambda_new;


  load oedata_new;

  nonstatparams = zeros(14,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameters for non-stationary    %
% equilibrium solver               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  %%% Convergence parameters %%%

    % Tolerance parameter for continuation    %
    % probabilities                           %
    nonstatparams(1)=1;

    % Tolerance parameter for iota  %
    nonstatparams(2)=1;

    % Tolerance parameter for zero profit condition %
    nonstatparams(3)=5;

  %%% Smooth updating of the parameters %%%

    % Exponential parameter on mu %
    nonstatparams(4)=0.5;

    % Exponential parameter on lambda %
    nonstatparams(5)=0.5;

    % Addition parameter on mu %
    nonstatparams(6)=1.0;

    % Addition parameter on lambda %
    nonstatparams(7)=1.0;

  %%% Other parameters %%%
    % How much to increase xmax when computing Tbar %
    % Unused at the moment                          %
    nonstatparams(8)=50.0;

    % If xmax_nonstat is bigger than S0_NONSTAT then fill with this number %
    nonstatparams(9)=0.0;

    % number of maximum state jumps per period %
    nonstatparams(10) = 1.0;

    % Number of periods in the non-stationary equilibrium %
    nonstatparams(11)=50.0;

    % Tolerance for computing Tbar                        %
    % unused at the moment                                %
    nonstatparams(12)=1e-5;

    % Number of states in the non-stationary equilibrium               %
    nonstatparams(13)=xmax;

    % T_LOWERBAR %
    nonstatparams(14)=0.0;

    % 1 - if compute approximate profits first in the non-stationary model %
    % 2 - if compute only actual profits                                   %
    nonstatparams(15)=2;

    % If lambda is smaller than this we treat it as zero %
    nonstatparams(16)=1e-5;
    
    %%% Industry statictics simulation parameters

    % How many periods ahead in the average CS, PS and INV
    % 0 - if discounted
    nonstatparams(17)=0;

    % Where should extra firm start when fixed number of firms
    nonstatparams(18)=0;

[VMatrix,iotaMatrix,rhoMatrix,lambdaVector,sMatrix,profitMatrix,priceMatrix]...
   =compoe_nonstat_matlab('output2',control,prof_fun,prof_fun_ipopt,transition,constants,init,convtol,nonstatparams,...
       lambda_new,iota_new,rho_new,V_new,prices_end_new,s0,tildes_new);

% remember to transpose the resulting matrices because matlab stores them columnwise and C row-wise
VMatrix=VMatrix';
iotaMatrix=iotaMatrix';
rhoMatrix=rhoMatrix';
profitMatrix=profitMatrix';
priceMatrix=priceMatrix';
sMatrix=sMatrix';

save nonstatdata VMatrix iotaMatrix rhoMatrix profitMatrix lambdaVector sMatrix s0 priceMatrix;

load nonstatdata;

[bound1nonstat,bound2nonstat,bound3nonstat, indstat]=bounds_nonstat_matlab('output_nonstat_bounds',...
  control,prof_fun,prof_fun_ipopt,transition,constants,init,convtol,bounds,nonstatparams,...
    lambdaVector,iotaMatrix,rhoMatrix,priceMatrix,sMatrix);

save boundnonstat bound1nonstat bound2nonstat bound3nonstat indstat
%}
