clear all

load oeAggrIn10
load oeAggrOut10
%load domOE-init10_0
%load domOE-out10_0
sMatrix=sMatrix';
VMatrix=VMatrix';

An=size(A,1);
xmax=size(sMatrix,2);

tran_rule(1,1)=1; tran_rule(2,1)=4; tran_rule(3,1)=6; tran_rule(4,1)=7;
tran_rule(1,2)=2; tran_rule(2,2)=4; tran_rule(3,2)=6; tran_rule(4,2)=7;
tran_rule(1,3)=3; tran_rule(2,3)=5; tran_rule(3,3)=6; tran_rule(4,3)=7;
tran_rule(1,4)=2; tran_rule(2,4)=4; tran_rule(3,4)=6; tran_rule(4,4)=7;
tran_rule(1,5)=3; tran_rule(2,5)=5; tran_rule(3,5)=6; tran_rule(4,5)=7;
tran_rule(1,6)=3; tran_rule(2,6)=5; tran_rule(3,6)=6; tran_rule(4,6)=7;
tran_rule(1,7)=1; tran_rule(2,7)=4; tran_rule(3,7)=6; tran_rule(4,7)=7;
A=full(A)';

% verify value function
Vnew=zeros(size(VMatrix));
for i=1:1e3
    for a=1:An
        tran=zeros(xmax,xmax);
        for x=1:xmax
            RHS=zeros(4,1);
            for futurea=1:An
                for action=1:4
                    % fixed cost
                    cont_value=prof_fun(action);
                    % transition cost
                    cont_value=cont_value+transition((x-1)*4+action);
                    % future competitor fringe state (subtract a firm)
                    sf=sMatrix(futurea,:)/sum(sMatrix(futurea,:))*9;
                    % future your state
                    xf=tran_rule(action,x);
                    % number of active competitors
                    comp=sum(sf(1:end-1));
                    % profits
                    % aggregate shock
                    cont_value=cont_value+prof_fun(4+action)*constants(8+futurea);
                    % competition
                    if(comp>0)
                        cont_value=cont_value+prof_fun(8+action)*min(comp,1);
                    end
                    if(comp>1)
                        cont_value=cont_value+prof_fun(12+action)*log(comp);
                    end
                    % value function
                    cont_value=cont_value+0.95*Vnew(futurea,xf);
                
                    RHS(action)=RHS(action)+A(a,futurea)*cont_value;
                end
            end
            RHS=exp(RHS);
            if(x<xmax)
                Vnew(a,x)=log(sum(RHS))+0.577215665;
            else
                Vnew(a,x)=0;
            end
        end
    end
end
Vnew-VMatrix

% verify policy
for a=1:An
    tran=zeros(xmax,xmax);
    for x=1:xmax
        RHS=zeros(4,1);
        for futurea=1:An
            for action=1:4
                % fixed cost
                cont_value=prof_fun(action);
                % transition cost
                cont_value=cont_value+transition((x-1)*4+action);
                % future competitor fringe state (subtract a firm)
                sf=sMatrix(futurea,:)/sum(sMatrix(futurea,:))*9;
                % future your state
                xf=tran_rule(action,x);
                % number of active competitors
                comp=sum(sf(1:end-1));
                % profits
                % aggregate shock
                cont_value=cont_value+prof_fun(4+action)*constants(8+futurea);
                % competition
                if(comp>0)
                    cont_value=cont_value+prof_fun(8+action)*min(comp,1);
                end
                if(comp>1)
                    cont_value=cont_value+prof_fun(12+action)*log(comp);
                end
                % value function
                cont_value=cont_value+0.95*Vnew(futurea,xf);

                RHS(action)=RHS(action)+A(a,futurea)*cont_value;
            end
        end
        RHS=exp(RHS);
        tran(x,tran_rule(:,x))=RHS/sum(RHS);
    end
    tran
    tranFringe{a}
    pause
end
