function [outputfringe outputdom] = domaggr_acw_function(n)
  addpath ..
  convtol = zeros(17,1);
  prof_fun = zeros(10,1);
  prof_fun_ipopt = zeros(2,1);
  transition = zeros(13,1);
  init = zeros(5,1);
  constants = zeros(4,1);
  control = zeros(3,1);

  cat=2;

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Tolerance parameters        %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Tolerance for value iteration (valueIt) %
  convtol(1) = 1e-6;

  % Tolerance for transition matrix and probability of exiting %
  convtol(2) = 1e-6;

  % Maximum number of fpstrat iteration %
  convtol(3) = 500000.0;

  % Tolerance on the probability of jumping up from the highest state %
  % If probability exceeds the value xmax is increased by convtol(4)   %
  convtol(4) = 1;

  % How much to increase xmax if it too small %
  convtol(5) = 5.0;

  % Tolerance on zero profit condition -- not used when set low %
  convtol(6) = 1e-4;

  % How much should we increase (relative measure) search interval of lambda %
  % when switching from approximate to exact profit function %
  convtol(7) = 0.1;

  % How much should we extend search interval if the equilibrium is outside of the % 
  % of the current search interval %
  convtol(8) = 0.5;

  % Tolerance value on the condition number of the matrix when calculating %
  % stationary distribution. If condition number is smaller that the       %
  % given value infinite sum is calculated instead of the inverse           %
  convtol(9) = 1e10;

  % Parameter regulating size of infinite sum in case condition number is small %
  convtol(10) = 100.0;

  % Parameter regulating smooth update of strategies %
  convtol(11) = 0.6;

  % Maximum xmax, can't go above this at all %
  convtol(12) = 140.0;

  % Hard minimum entry rate (otherwise code fails out) %
  convtol(13) = 1e-5;

  % Hard maximum entry rate (otherwise code fails out) % 
  convtol(14) = 1e6;

  % Unused %
  convtol(15) = 0.0;
  convtol(16) = 0.0;

  % Tolerance on entry rate in outer iterations (note: requires one or other tol to be hit) %
  convtol(17) = 0.01;  

  % 1 - if compute approximate profits first in the stationary model %
  % 2 - if compute only actual profits                               %
  control(1) = 2;

  % Entry process                            %
  % 1 - Poisson Entry                        %
  % 2 - Constant Entry                       %
  control(2) = 1;

  % Entry process                            %
  % 0 - Random number of firms               %
  % >0 - Set the fixed number of firms       %
  control(3) = n;

  % Coputing method                          %
  % 0 - Bisection                            %
  % 1 - Gauss-Seidel                         %
  control(4) = 1;

  % Subtract a firm from stilde              %
  control(5) = 1;

fulltheta=[-1.100791,  -2.031995,  -2.160912,    .151633,   .3133813,   .3525054,  -7.864533,  -15.37257, ...
-13.74874,  -2.550811,   -6.08106,  -2.393959,  -14.33732, -4.762511,   -2.57616, -.7880156,   -2.34086, ...
.6625794,  -.2864138,   -1.88825,  -3.021657];

transcost=fulltheta(7:length(fulltheta));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ACW profit function params %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Fixed cost
  prof_fun(1)=fulltheta(1); % S
  prof_fun(2)=fulltheta(2); % M
  prof_fun(3)=fulltheta(3); % L

  prof_fun(4)=0;    % O
  % Log construction employment
  prof_fun(5)=fulltheta(4); % S
  prof_fun(6)=fulltheta(5); % M
  prof_fun(7)=fulltheta(6); % L
  prof_fun(8)=0;  % O
  % 1st competitor
  prof_fun(9)=-0.363;  % S
  prof_fun(10)=-0.433; % M
  prof_fun(11)=-0.477;  % L
  prof_fun(12)=0;    % O
  
% Log competitors (above 1)
  prof_fun(13)=-0.127;  % S
  prof_fun(14)=-0.333;  % M
  prof_fun(15)=-0.359;  % L
  prof_fun(16)=0;    % O

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ipopt parameters            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Lower bound on prices
  prof_fun_ipopt(1) = 0;

  % Upper bound on prices
  prof_fun_ipopt(2) = prof_fun(2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Transition maxix parameters        %
  % State: 1-S, 2-SM, 3-SL, 4-M, 5-ML, 6-L, 7-Out
  transition(1)=0;       % S->S
  transition(2)=transcost(4);    % S->M
  transition(3)=transcost(5);    % S->L
  transition(4)=0;       % S->O

  transition(5)=0;       % SM->S
  transition(6)=transcost(6);    % SM->M
  transition(7)=transcost(7);    % SM->L
  transition(8)=0;       % SM->O

  transition(9)=0;       % SL->S
  transition(10)=transcost(8);   % SL->M
  transition(11)=transcost(9);   % SL->L
  transition(12)=0;      % SL->O

  transition(13)=transcost(10);     % M->S
  transition(14)=0;      % M->M
  transition(15)=transcost(11);     % M->L
  transition(16)=0;      % M->O

  transition(17)=transcost(12);   % ML->S
  transition(18)=0;      % ML->M
  transition(19)=transcost(13);   % ML->L
  transition(20)=0;      % ML->O

  transition(21)=transcost(14);   % L->S
  transition(22)=transcost(15);   % L->M
  transition(23)=0;      % L->L
  transition(24)=0;      % L->O

  transition(25)=transcost(1);   % O->S
  transition(26)=transcost(2);   % O->M
  transition(27)=transcost(3);   % O->L
  transition(28)=0;      % O->O

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Other constants of the model %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Entry cost %
  constants(1) = 35.0;

  % Fixed cost of investment %
  constants(2) = 0.5;

  % Parameter on variable cost of investment %
  % Set up big to switch-off variable cost  %
  constants(5) = 10000.0;

  % Discount factor (beta) %
  constants(3) = 0.95;

  % Entry state %
  constants(4) = 10.0;

  % ACW
  % actions
  constants(7) = 4;
  
  % variance of sigma
  constants(8) = 1;
  
  % demand shocks 
  load L
%  constants(9:18) = [1:8/9:9];
  constants(9:108) = repmat(L((cat-1)*10+1:cat*10),10,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialization parameters   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % starting xmax %
  init(1) = 7.0;

  % starting investment %
  init(2) = 1.0;

  % Starting exit rule %
  init(3) = constants(1);

  % bisection lower bound for lambda %
  init(4) = 8.0;

  % bisection upper bound for lambda %
  init(5) = 9.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CONTROL PARAMETERS FOR COMPUTING BOUNDS %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % not used %
  bounds(1)=0.0;

  % tolerance relative precision when simulating bounds %
  bounds(2)=0.1;

  % tolerance relative precision when simulating expected value function %
  bounds(3)=0.001;

  % maximum number of iterations to compute bounds %
  bounds(4)=1000000.0;

  % minimum number of iterations to compute bounds %
  bounds(5)=2.0;

  % maximum number of periods to consider when sampling state %
  % in case constant number of entrants                       %
  bounds(6)=1000.0;

  % tolerance prob. being in industry when sampling state %
  % in case constant number of entrants                   %
  bounds(7)=1e-3;

  % how much more states off equilibrium path should be considered %
  bounds(8)=1.0;

  % number of maximum state jumps per period %
  bounds(9)=1.0;

  % tolerance of checking if Delta_y is increasing
  bounds(10)=1e-3;

  filename='oe.log';

  save('oeIn.mat','filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds');

  infile='oeIn.mat';
  outfile='oeOut.mat';
  tic;
  eval(['!../compoe_matlab ',infile,' ',outfile]);
  compTime=toc;
  load(outfile);

  fprintf('OE done\n');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameters for aggregate equilibrium %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Tolerance parameter for rho             %
  aggr(1)=10;

  % Tolerance parameter for iota  %
  aggr(2)=1e-6;

  % Tolerance parameter for zero profit condition %
  aggr(3)=1e-7;

  % If lambda is smaller than this we treat it as zero %
  aggr(4)=1e-2;

  % 1 - if compute approximate profits first %
  %      in the aggregate shocks model       %
  % 2 - if compute only actual profits       %
  aggr(5)=2;

  %%%%% Shocks parameters
  %% Sample implementation has three aggregate shocks: low, medium and high
  %%
  %% To change this one have to use the source code distribution
  %% Details are in the documentation
  %%
  %% The value of the shock affects the market size. 
  %% Market size given by prof_fun(1) is the base value for medium shock

  % market size in low shock = (1-aggr(6))*prof_fun(1)
  aggr(6)=0.5;

  % market size in high shock = (1+aggr(7))*prof_fun(1)
  aggr(7)=0.5;

  %%%%% Smooth update parameters

  % Exponential parameter on mu %
  aggr(8)=0.8;

  % Addition parameter on mu %
  aggr(9)=1.0;

  %%%%% Other parameters

  % Number of states                                                 %
  aggr(10)=xmax;

  %%%%% Aggregate shocks bounds specific parameters 

  % Warm up period length 
  aggr(11)=500.0;

  % Length of repetitions to get one sample point 
  aggr(12)=20.0;

  % Number of steps between repetitions to get one sample point 
  aggr(13)=100.0;

   load A;
  A2=A((cat-1)*10+1:cat*10,:);
 
  A2(A2==0)=1e-10;
  for i=1:10
    A2(i,:)=A2(i,:)/sum(A2(i,:));
  end

  A=build_history(2,A2);
  A

  A = sparse(A');
%  A = sparse([0.80 0.1 0.1;0.1 0.80 0.1;0.1 0.1 0.80]');

  filename='oe.log';

  infile=['oeAggrIn' num2str(n) '.mat'];
  outfile=['oeAggrOut' num2str(n) '.mat'];

  save(infile,'filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds','aggr','lambda','iota','rho','V','prices','A');

  tic;
  eval(['!../compoe_aggregate_matlab ',infile,' ',outfile]);
  compTime=toc;
  load(outfile);

  sMatrix=sMatrix';
  VMatrix=VMatrix';

  mean_fringe_state=sum(repmat(Q',1,xmax).*sMatrix,1);
  outputfringe=mean_fringe_state;
  outputdom=zeros(1,xmax);
end
