%
% Graphs

set(0,'defaultTextFontName', 'Arial')
set(0,'defaultAxesFontName', 'Arial')

statmpe=zeros(3,5);
statoe=zeros(3,5,4);
z=1;
for n=[5 7 10];
  load(['simD4N' num2str(n)]);
  statmpe(z,1)=exit_rate;
  statmpe(z,2)=grow(1);
  statmpe(z,3)=grow(2);
  statmpe(z,4)=-sunk_entry;
  statmpe(z,5)=-sunk_change;

  for domn=[0 1 2 3];
    load(['simul' num2str(n) '_' num2str(domn) '.mat']);
    statoe(z,1,domn+1)=exit_rate;
    statoe(z,2,domn+1)=grow(1);
    statoe(z,3,domn+1)=grow(2);
    statoe(z,4,domn+1)=-sunk_entry;
    statoe(z,5,domn+1)=-sunk_change;
  end
  z=z+1;
end
statmpe=statmpe/100908;
    
titles{1}='Avg. number of exiting firms';
titles{2}='Avg. growth rate: small to medium or large';
titles{3}='Avg. growth rate: small or medium to large';
titles{4}='Avg. sunk entry cost';
titles{5}='Avg. sunk cost of changing size';

for s=1:5
  z=1;
  for n=[5 7 10]
    h=figure(1);
    set(gca,'FontSize',17);
    set(gcf,'Position',[0 0 750 300]);
    set(gcf,'PaperPositionMode','auto');
    x=squeeze(statoe(z,s,:))-statmpe(z,s);
    bar(x)
%    xlim([-0.3 cost(end)+0.3])
%    set(gca,'XTick',cost)
    set(gca,'XTickLabel',{'OE','POE-1','POE-2','POE-3'});
    colormap([0 0 0;0.3 0.3 0.3;0.7 0.7 0.7;1 1 1]);
%    legend('OE','POE1','POE2','POE3','Location','NorthWest');
    title({titles{s},['Difference with MPE, ' num2str(n) ' potential entrants']}); 
%    xlabel('Investment cost');
    saveas(h,['statN' num2str(n) 'Stat' num2str(s) '.eps']);
    z=z+1;
  end
end
