function simulate(nfirms,domn)
  infile=['domOE-init' num2str(nfirms) '_' num2str(domn) '.mat'];
  outfile=['domOE-out' num2str(nfirms) '_' num2str(domn) '.mat'];

  load(infile);load(outfile);

  fringen=nfirms-domn;

  % Copute starting state
  % Stationary average state
  mean_fringe_state=sum(repmat(Q,1,size(sMatrix,2)).*sMatrix);
  % Round the state
  fringe0=round(mean_fringe_state);
  % Assume that the missing firms are inactive
  fringe0(end)=fringen-sum(fringe0(1:end-1));

  xmax=size(sMatrix,2);
  run expected_dom
  dom0=round(mean_dom_state);
  dom0(end)=domn-sum(dom0(1:end-1));
  

  cat=2;
  load A
  A2=A((cat-1)*10+1:cat*10,:);
  
  run top_history
  %A=build_history(2,A2);
  
  % convert to firm-by-firm notation
  f0=zeros(1,fringen);
  z=1;
  for s=1:xmax
    for n=1:fringe0(s)
      f0(z)=s-1;
      z=z+1;
  end
  end
  d0=zeros(1,domn);
  z=1;
  for s=1:xmax
    for n=1:dom0(s)
      d0(z)=s-1;
      z=z+1;
    end
  end
  
  a0=0;
  fnew=zeros(size(f0));
  dnew=zeros(size(d0));
  encsize=size(enc,1);
  encOthersize=size(encOther,1);
  
  meanf=zeros(1,xmax);
  meand=zeros(1,xmax);
  %d0=[2 2];
  sunk_change=0;
  exit_rate=0;
  sunk_entry=0;
  grow=zeros(1,2);
  skip=1;
  d=d0;
  f=f0;
  a=a0;
  draws=0;
  
  
  for r=1:2*1e6
    % draw fringe firms
    offset=a*encsize;
    x=matchRow(enc,sort(d));
    P=tranFringe{offset+x};
    for n=1:fringen
      fnew(n)=discretesample(P(f(n)+1,:),1)-1;
    end
    % draw dominant firms
    offset=a*encOthersize;
    for n=1:domn
      otherstate=d;
      otherstate(n)=[];
      if(domn>1)
        x=matchRow(encOther,sort(otherstate));
      else
        x=1;
      end
      P=tranDom{offset+x};
      dnew(n)=discretesample(P(d(n)+1,:),1)-1;
    end
    % draw demand shock
    anew=discretesample(A(a+1,:),1)-1;
    
    % warm-up
    if(r<1e4)
      f=fnew;
      d=dnew;
      a=anew;
      continue;
    end
    if(skip==2)
      draws
      skip=1;
      for n=1:fringen
        meanf(fnew(n)+1)=meanf(fnew(n)+1)+1;
        if(fnew(n)<3)
          action=1;
        elseif(fnew(n)<5)
          action=2;
        elseif(fnew(n)<6)
          action=3;
        else
          action=4;
        end
        if(fnew(n)<6)
          if(f(n)==6) % entry
            sunk_entry=sunk_entry+transition(6*4+action);
          else
            sunk_change=sunk_change+transition(f(n)*4+action);
          end
          if((fnew(n)>=3) && (f(n)<3))
            grow(1)=grow(1)+1;
          end
          if((fnew(n)==5) && (f(n)<5))
            grow(2)=grow(2)+1;
          end
        else
          if(f(n)<6) % exit
            exit_rate=exit_rate+1;
          end
        end
      end
      for n=1:domn
        meand(dnew(n)+1)=meand(dnew(n)+1)+1;
        if(dnew(n)<3)
          action=1;
        elseif(dnew(n)<5)
          action=2;
        elseif(dnew(n)<6)
          action=3;
        else
          action=4;
        end
        if(dnew(n)<6)
          if(d(n)==6) % entry
            sunk_entry=sunk_entry+transition(6*4+action);
          else
            sunk_change=sunk_change+transition(d(n)*4+action);
          end
          if((dnew(n)>=3) && (d(n)<3))
            grow(1)=grow(1)+1;
          end
          if((dnew(n)==5) && (d(n)<5))
            grow(2)=grow(2)+1;
          end
        else
          if(d(n)<6) % exit
            exit_rate=exit_rate+1;
          end
        end
      end
      draws=draws+1;
      [meanf/draws; mean_fringe_state]
      [meand/draws; mean_dom_state]
      exit_rate/draws
      grow/draws
      [sunk_entry sunk_change]/draws
    end
    skip=skip+1;

    f=fnew;
    d=dnew;
    a=anew;
  end
  meanf=meanf/draws;
  meand=meand/draws;
  exit_rate=exit_rate/draws;
  grow=grow/draws;
  sunk_entry=sunk_entry/draws;
  sunk_change=sunk_change/draws;
  
  save(['simul' num2str(nfirms) '_' num2str(domn) '.mat'],'meanf','mean_fringe_state','meand','mean_dom_state','exit_rate','grow','sunk_entry','sunk_change');
end
