clear all;
addpath ..
convtol = zeros(17,1);
prof_fun = zeros(10,1);
prof_fun_ipopt = zeros(2,1);
transition = zeros(13,1);
init = zeros(5,1);
constants = zeros(4,1);
control = zeros(3,1);

cat=4;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Tolerance parameters        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Tolerance for value iteration (valueIt) %
  convtol(1) = 1e-6;

  % Tolerance for transition matrix and probability of exiting %
  convtol(2) = 1e-6;

  % Maximum number of fpstrat iteration %
  convtol(3) = 500000.0;

  % Tolerance on the probability of jumping up from the highest state %
  % If probability exceeds the value xmax is increased by convtol(4)   %
  convtol(4) = 1;

  % How much to increase xmax if it too small %
  convtol(5) = 5.0;

  % Tolerance on zero profit condition -- not used when set low %
  convtol(6) = 1e-4;

  % How much should we increase (relative measure) search interval of lambda %
  % when switching from approximate to exact profit function %
  convtol(7) = 0.1;

  % How much should we extend search interval if the equilibrium is outside of the % 
  % of the current search interval %
  convtol(8) = 0.5;

  % Tolerance value on the condition number of the matrix when calculating %
  % stationary distribution. If condition number is smaller that the       %
  % given value infinite sum is calculated instead of the inverse           %
  convtol(9) = 1e10;

  % Parameter regulating size of infinite sum in case condition number is small %
  convtol(10) = 100.0;

  % Parameter regulating smooth update of strategies %
  convtol(11) = 0.6;

  % Maximum xmax, can't go above this at all %
  convtol(12) = 140.0;

  % Hard minimum entry rate (otherwise code fails out) %
  convtol(13) = 1e-5;

  % Hard maximum entry rate (otherwise code fails out) % 
  convtol(14) = 1e6;

  % Unused %
  convtol(15) = 0.0;
  convtol(16) = 0.0;

  % Tolerance on entry rate in outer iterations (note: requires one or other tol to be hit) %
  convtol(17) = 0.01;  

  % 1 - if compute approximate profits first in the stationary model %
  % 2 - if compute only actual profits                               %
  control(1) = 2;

  % Entry process                            %
  % 1 - Poisson Entry                        %
  % 2 - Constant Entry                       %
  control(2) = 1;

  % Entry process                            %
  % 0 - Random number of firms               %
  % >0 - Set the fixed number of firms       %
  control(3) = 2;

  % Coputing method                          %
  % 0 - Bisection                            %
  % 1 - Gauss-Seidel                         %
  control(4) = 1;

  % Subtract a firm from stilde              %
  control(5) = 0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ACW profit function params %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Fixed cost

  prof_fun(1)=-420; % S
  prof_fun(2)=-560; % M
  prof_fun(3)=-640; % L

  prof_fun(4)=0;    % O
  % Log construction employment
  prof_fun(5)=110/2.3; % S
  prof_fun(6)=120/2.3; % M
  prof_fun(7)=150/2.3; % L
  prof_fun(8)=0;  % O
  % 1st competitor
%  prof_fun(9:16)=0;

  prof_fun(9)=-96;  % S
  prof_fun(10)=-101; % M
  prof_fun(11)=-76;  % L
  prof_fun(12)=0;    % O

% Log competitors (above 1)
  prof_fun(13)=-120;  % S
  prof_fun(14)=-120;  % M
  prof_fun(15)=-80;  % L
  prof_fun(16)=0;    % O

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ipopt parameters            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Lower bound on prices
  prof_fun_ipopt(1) = 0;

  % Upper bound on prices
  prof_fun_ipopt(2) = prof_fun(2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Transition maxix parameters        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % State: 1-S, 2-SM, 3-SL, 4-M, 5-ML, 6-L, 7-Out
  transition(1)=0;       % S->S
  transition(2)=-528;    % S->M
  transition(3)=-1973;   % S->L
  transition(4)=0;       % S->O

  transition(5)=0;       % SM->S
  transition(6)=-824;    % SM->M
  transition(7)=-460;    % SM->L
  transition(8)=0;       % SM->O

  transition(9)=0;       % SL->S
  transition(10)=-299;   % SL->M
  transition(11)=-277;   % SL->L
  transition(12)=0;      % SL->O

  transition(13)=-7;     % M->S
  transition(14)=0;      % M->M
  transition(15)=105;    % M->L
  transition(16)=0;      % M->O

  transition(17)=-289;   % ML->S
  transition(18)=0;      % ML->M
  transition(19)=30;     % ML->L
  transition(20)=0;      % ML->O

  transition(21)=-111;   % L->S
  transition(22)=-427;   % L->M
  transition(23)=0;      % L->L
  transition(24)=0;      % L->O

  transition(25)=-418;   % O->S
  transition(26)=-2000;  % O->M
  transition(27)=-2721;  % O->L
  transition(28)=0;      % O->O

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Other constants of the model %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Entry cost %
  constants(1) = 35.0;

  % Fixed cost of investment %
  constants(2) = 0.5;

  % Parameter on variable cost of investment %
  % Set up big to switch-off variable cost  %
  constants(5) = 10000.0;

  % Discount factor (beta) %
  constants(3) = 0.95;

  % Entry state %
  constants(4) = 10.0;

  % ACW
  % actions
  constants(7) = 4;
  
  % variance of sigma
  constants(8) = 150;
  
  % demand shocks 
  load L
%  constants(9:18) = [1:8/9:9];
  constants(9:18) = L((cat-1)*10+1:cat*10);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialization parameters   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % starting xmax %
  init(1) = 7.0;

  % starting investment %
  init(2) = 1.0;

  % Starting exit rule %
  init(3) = constants(1);

  % bisection lower bound for lambda %
  init(4) = 8.0;

  % bisection upper bound for lambda %
  init(5) = 9.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CONTROL PARAMETERS FOR COMPUTING BOUNDS %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % not used %
  bounds(1)=0.0;

  % tolerance relative precision when simulating bounds %
  bounds(2)=0.1;

  % tolerance relative precision when simulating expected value function %
  bounds(3)=0.001;

  % maximum number of iterations to compute bounds %
  bounds(4)=1000000.0;

  % minimum number of iterations to compute bounds %
  bounds(5)=2.0;

  % maximum number of periods to consider when sampling state %
  % in case constant number of entrants                       %
  bounds(6)=1000.0;

  % tolerance prob. being in industry when sampling state %
  % in case constant number of entrants                   %
  bounds(7)=1e-3;

  % how much more states off equilibrium path should be considered %
  bounds(8)=1.0;

  % number of maximum state jumps per period %
  bounds(9)=1.0;

  % tolerance of checking if Delta_y is increasing
  bounds(10)=1e-3;

  filename='oe.log';

  save('oeIn.mat','filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds');

  infile='oeIn.mat';
  outfile='oeOut.mat';
  tic;
  eval(['!../compoe_matlab ',infile,' ',outfile]);
  compTime=toc;
  load(outfile);

  fprintf('OE done\n');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Parameters for aggregate equilibrium %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % Tolerance parameter for rho           
  dom(1)=1e-3;

  % Tolerance parameter for iota
  dom(2)=1e-4;

  % Tolerance parameter for zero profit condition 
  dom(3)=1e-7;

  % If lambda is smaller than this we treat it as zero
  dom(4)=1e-2;

  % 1 - if compute approximate profits first
  % 2 - if compute only actual profits
  dom(5)=2;

  % MPE with weighted profits?
  dom(6)=1;

  % entry cost for dom firms
  % put 0 for no entry exit
  % INACTIVE NOW
  dom(7)=0.0;

  %%%%% Smooth update parameters

  % Exponential parameter on mu
  dom(8)=0.1;

  % Addition parameter on mu
  dom(9)=1;

  %%%%% Other parameters

  % Number of states
  dom(10)=xmax;

  % Number of dominant firms
  dom(11)=3;

  % Number of warmup periods for stats
  dom(12)=1000;

  % minimum number of simulation periods for stats
  dom(13)=1000;

  % Number of warmup periods for bounds
  dom(14)=100;

  % number of simulations in one observation for bounds
  dom(15)=10;

  % tolerance parameters for norm of lambda
  dom(16)=1e-4;

  % Do small iters?
  dom(17)=0;

  % Don't do small iters for first couple big iters
  dom(18)=100;

  % Lambda convergence accelerator
  dom(19)=1;

  % Minimal number of simulations for stats and bounds
  dom(20)=2000;

  fprintf('Computing dominant firms OE...');

  % Invocation of the solver
  lambdaInit=lambda*ones(xmax,1);

  filename=['output_dom.log'];

  lambdaInit=lambda*ones(xmax,1);
  iotaInit=iota;
  rhoInit=rho;

  load A;
  A=A((cat-1)*10+1:cat*10,:);
  %{
  A(A==0)=1e-10;
  for i=1:10
    A(i,:)=A(i,:)/sum(A(i,:));
  end
  %}

  A = sparse(A');

  filename='oe.log';

  % Shock levels already in the constant
  shocklevels=[];
  mean_fringe_state=zeros(size(tildes)); 
  save('domOE-init','filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds','dom',...
    'lambdaInit','iotaInit','rhoInit','pricesInit','A','shocklevels','mean_fringe_state');

  infile=['domOE-init.mat'];
  outfile=['domOE-out.mat'];
  tic
  eval(['!../compoe_dom_matlab ',infile,' ',outfile]);
  compTime=toc;
  load(outfile);

  %Qm = dom_marginal(Q,enc,xmax);

  mean_fringe_state=sum(repmat(Q,1,xmax).*sMatrix,1);
  mean_dom_state=zeros(size(Q,1),1);

  run simulate_dom
  mean_fringe_state/sum(mean_fringe_state)
  state
  mean_fringe_state+state
  %nf=simul_num_firms(Q,enc,xmax);

