function y=optimize(x);
  save optx2
global control prof_fun transition constants init bounds convtol dom prof_fun_ipopt
  n=1;
  prof_fun(4)=x(1);
  prof_fun(7)=x(2);

  constants(1)=x(3);
  constants(2)=x(4);

  transition(2)=x(5);
  transition(3)=x(6);
  filename=['output_oe' num2str(n)];

  save(['domOE-0-init'],'filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds');

  infile=['domOE-0-init.mat'];
  outfile=['domOE-0-cout.mat'];
  eval(['!../compoe_matlab ',infile,' ',outfile]);

  load(outfile);
  save(['domOE-0-final.mat']);


  lambdaInit=lambda*ones(xmax,1);
  iotaInit=iota;
  rhoInit=rho;

  dom(6)=0;

  save(['domOE-' num2str(n) '-init'],'filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds','dom',...
    'lambdaInit','iotaInit','rhoInit','pricesInit');

  filename=['output_dom' num2str(n)];
  infile=['domOE-' num2str(n) '-init.mat'];
  outfile=['domOE-' num2str(n) '-cout.mat'];
  eval(['!../compoe_dom_matlab ',infile,' ',outfile]);

  load(outfile);
  if(success==0)
    y=1e10;
    return;
  end

  Qm = dom_marginal(Q,enc,xmax);
  mean_fringe_state=sum(repmat(Q,1,xmax).*sMatrix,1);
%  nf=simul_num_firms(Q,enc,xmax);

  save(['domOE-' num2str(n) '-final.mat']);

  %%% Compute fixed fringe
  dom(6)=1;
  save(['domOE-' num2str(n) '-FF-init'],'filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds','dom',...
    'lambdaInit','iotaInit','rhoInit','pricesInit','mean_fringe_state');

  infile=['domOE-' num2str(n) '-FF-init.mat'];
  outfile=['domOE-' num2str(n) '-FF-cout.mat'];
  eval(['!../compoe_dom_matlab ',infile,' ',outfile]);

  load(outfile)
  if(success==0)
      y=1e10;
      return;
  end
  Qm_fixed=dom_marginal(Q,enc,xmax);
%  nf=simul_num_firms(Q,enc,xmax);

  save(['domOE-' num2str(n) '-FF-final.mat']);
  [tildes;mean_fringe_state;Qm_fixed';Qm';(Qm_fixed-Qm)']
  y = -norm(min(Qm_fixed(13:20)-Qm(13:20),0))
end
