%% first produce state distribtion for all numbers of dom firms

load domOE-0-final
h=figure(1);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=tildes';
z(1,1)=.8;
breakplot2(1:8,z, 0.35, 0.4, 'RPatch',100);
set(gca,'ytick',[0 0.35 0.75]);
set(gca,'yticklabel',{'0', '0.35', num2str(tildes(1),'%.2f')});
%bar([1:8],z(1:8),'stacked');
title({'No dominant firms';'Cournot Profit, Entry/Exit'});
legend('Fringe','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);
saveas(h,'state0.eps');


load domOE-1-final
h=figure(2);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
z
z(1,1)=.8;
%z(1,2)=.35;
breakplot2(1:8,z, 0.35, 0.4, 'RPatch',100);
set(gca,'ytick',[0 .35 0.75]);
set(gca,'yticklabel',{'0', '0.35', num2str(mean_fringe_state(1),'%.2f')});
title({'1 dominant firm';'Cournot Profit, Entry/Exit'});
legend('Fringe','Dominant','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);
saveas(h,'state1.eps');



load domOE-2-final
h=figure(3);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
z
z(1,1)=.8;
z(1,2)=.5;
breakplot2(1:8,z, 0.35, 0.4, 'RPatch',100);
set(gca,'ytick',[0 0.35 0.5 0.75]);
set(gca,'yticklabel',{'0', '0.35', num2str(nf(1),'%.2f'), [num2str(mean_fringe_state(1),'%.2f')]});
title({'2 dominant firms';'Cournot Profit, Entry/Exit'});
legend('Fringe','Dominant','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);
saveas(h,'state2.eps');

load domOE-3-final
h=figure(4);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
z(1,1)=.8;
z(1,2)=.6;
breakplot2(1:8,z, 0.35, 0.4, 'RPatch',100);
set(gca,'ytick',[0 0.35 0.6 0.75]);
set(gca,'yticklabel',{'0', '0.35', num2str(nf(1),'%.2f'), num2str(mean_fringe_state(1),'%.2f')});
%bar([1:8],z(1:8,:),'stacked');
title({'3 dominant firms';'Cournot Profit, Entry/Exit'});
legend('Fringe','Dominant','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);

saveas(h,'state3.eps');
%{

%%% Expected investment for duopoly
load domOE-2-final
% expected investment for the fringe
expInv=sum(iotaMatrix.*repmat(Q,1,xmax),1);
%% Expand distribution
Qexp=[];
Eexp=[];
N=size(Q,1);
for x=1:N
	E=enc(x,:);
	per=unique(perms(E),'rows');
	for p=1:size(per,1)
		Eexp=[Eexp;per(p,:)];
		Qexp=[Qexp;Q(x)/size(per,1)];
        end
end

%% integrate investment
for x=0:size(domIotaMatrix,1)-1
  I=find(Eexp(:,1)==x);
  p=Qexp(I)/sum(Qexp(I));
  expInvDom(1,x+1)=sum(domIotaMatrix(:,x+1).*p);
end

h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv' expInvDom'];
bar([1:8],z(1:8,:),'grouped');
title({'2 dominant firms';'Cournot Profit, Entry/Exit'});
legend('Fringe','Dominant','Location','NorthEast');
xlabel('State');
ylabel('Expected investment');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);
saveas(h,'investmentComparison.eps');

%%%%%%%%%%% Part 2 - Entry & investment deterence
I=find(enc(:,1)==enc(:,2));
fDist=sMatrix(I,:);

%% investment if the fringe
expInv=sum(iotaMatrix(I,:).*fDist,2);
h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv];
bar([1:8],z);
title({'2 dominant firms';'Cournot Profit, Entry/Exit'});
legend('Fringe','Location','NorthEast');
xlabel('State of both dominant firms');
ylabel('Fringe investment');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);
saveas(h,'investmentDeterrence.eps');

%% 
h=figure(6);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv];
bar([1:8],lambdaVector(I,:));
title({'2 dominant firms';'Cournot Profit, Entry/Exit'});
legend('Fringe','Location','North');
xlabel('State of both dominant firms');
ylabel('Entry Rate');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);
saveas(h,'entryDeterrence.eps');

%% 
h=figure(7);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv];
bar([1:8],sum(sMatrix(I,:),2));
title({'2 dominant firms';'Cournot Profit, Entry/Exit'});
legend('Fringe','Location','North');
xlabel('State of both dominant firms');
ylabel('Number of active firms');
colormap([0 0 0;0.7 0.7 0.7]);
xlim([0 9]);
saveas(h,'activeFirms.eps');
%}
