%%
% Graphs

%%% fat tail
load logitdom0.mat
h=figure(1);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=tildes;
bar([2:8],z(2:8),'stacked');
title({'OE - no dominant firms';'heavy tail industry'});
legend('Fringe','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'graph0.png');

load logitdom1.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(2);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
bar([2:8],z(2:8,:),'stacked');
title({'OE - 1 dominant firm';'heavy tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'graph1.png');


load logitdom2.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(3);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
bar([2:8],z(2:8,:),'stacked');
title({'OE - 2 dominant firms';'heavy tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'graph2.png');

load logitdom3.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(4);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
bar([2:8],z(2:8,:),'stacked');
title({'OE - 3 dominant firms';'heavy tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'graph3.png');

h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
MPE=[0.1536    0.1507    0.1992    0.2360    0.2281    0.1727    0.0881];
bar([2:8],MPE,'stacked');
title({'MPE - max 8 firms';'heavy tail industry'});
legend('Leaders','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'mpe8.png');
