%%
% Graphs

%%% fat tail
load fat_tail-lowerbound/logitdom0.mat
h=figure(1);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],tildes);
title({'OE - no dominant firms';'heavy tail industry'});
legend('Fringe','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'fat_tail-lowerbound/graph0.png');

load fat_tail-lowerbound/logitdom1.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(2);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],[mean_fringe_state' nf],'stacked');
title({'OE - 1 dominant firm';'heavy tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'fat_tail-lowerbound/graph1.png');


load fat_tail-lowerbound/logitdom2.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(3);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],[mean_fringe_state' nf],'stacked');
title({'OE - 2 dominant firms';'heavy tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'fat_tail-lowerbound/graph2.png');

load fat_tail-lowerbound/logitdom3.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(4);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],[mean_fringe_state' nf],'stacked');
title({'OE - 3 dominant firms';'heavy tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'fat_tail-lowerbound/graph3.png');

h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
MPE=[1.0508    0.1830    0.4020    0.4500    0.6122    0.8541    1.0718    0.8064];
bar([1:8],MPE,'stacked');
title({'MPE - max 8 firms';'heavy tail industry'});
legend('Leaders','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'fat_tail-lowerbound/mpe8.png');



h=figure(6);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
MPE=[1.0720    0.1892    0.4220    0.4621    0.6211    0.8604    1.0734    0.8053];
bar([1:8],MPE,'stacked');
title({'MPE - max 10 firms';'heavy tail industry'});
legend('Leaders','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'fat_tail-lowerbound/mpe10.png');


