%%
% Graphs

%%% Light tail
load light_tail/logitdom0.mat
h=figure(1);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],tildes);
title({'OE - no dominant firms';'Light tail industry'});
legend('Fringe','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'light_tail/graph0.png');

load light_tail/logitdom1.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(2);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],[mean_fringe_state' nf],'stacked');
title({'OE - 1 dominant firm';'Light tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'light_tail/graph1.png');



h=figure(3);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
MPE=[1.7434    1.0603    2.0206    0.5667    0.1770    0.0566    0.0177    0.0050];
bar([1:8],MPE,'stacked');
title({'MPE - max 8 firms';'Light tail industry'});
legend('Leaders','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'light_tail/mpe8.png');




h=figure(4);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
MPE=[2.0459    1.2427    2.2603    0.5145    0.1369    0.0370    0.0102    0.0024];
bar([1:8],MPE,'stacked');
title({'MPE - max 10 firms';'Light tail industry'});
legend('Leaders','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'light_tail/mpe10.png');
