%%
% Graphs

%%% Medium tail
load medium_tail/logitdom0.mat
h=figure(1);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],tildes);
title({'OE - no dominant firms';'Medium tail industry'});
legend('Fringe','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'medium_tail/graph0.png');

load medium_tail/logitdom1.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(2);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],[mean_fringe_state' nf],'stacked');
title({'OE - 1 dominant firm';'Medium tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'medium_tail/graph1.png');


load medium_tail/logitdom2.mat
nf=simul_num_firms(Q,enc,xmax);
h=figure(3);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
bar([1:8],[mean_fringe_state' nf],'stacked');
title({'OE - 2 dominant firms';'Medium tail industry'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'medium_tail/graph2.png');


h=figure(4);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
MPE=[0.0812    0.3206    1.3334    1.0029    0.7991    0.7304    0.8228    0.6952];
bar([1:8],MPE,'stacked');
title({'MPE - max 8 firms';'Medium tail industry'});
legend('Leaders','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'medium_tail/mpe8.png');




h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
MPE=[0.1180    0.4356    1.7082    1.2209    0.9072    0.7583    0.7637    0.6045];
bar([1:8],MPE,'stacked');
title({'MPE - max 10 firms';'Medium tail industry'});
legend('Leaders','Location','North');
xlabel('State');
ylabel('Expected number of firms');
saveas(h,'medium_tail/mpe10.png');
