function y = profit(xInit,prof_fun)
  xmax = size(xInit,2);
  nstar = xInit(xmax);
  sumterm = mc(xmax-1,prof_fun)*xInit(xmax);

  pstar = (prof_fun(1)+sumterm)/(nstar+1);
  prodsur = 0;

  nfirms=0.0;
  for j=xmax:-1:1
     nfirms=nfirms+xInit(j);
  end

  i=xmax;
  if(pstar-mc(i-1,prof_fun)<0)
    pstar=prof_fun(1);
    qstar=0.0;
    profit=prof_fun(7)/nfirms;
    ms=0.0;
    conssur=0.0;
  else
    pstar2=pstar;
    nstar2=nstar;
    % We know xmax-1 is producing
    % Check how many of them are producing
    for i=xmax-1:-1:1
      nstar2=nstar2+xInit(i);
      sumterm=sumterm+xInit(i)*mc(i-1,prof_fun);
      pstar2=(prof_fun(1)+sumterm)/(nstar2+1);
      if(pstar2-mc(i-1,prof_fun)>0)
        % Include i
        pstar=pstar2;
        nstar=nstar2;
      else
        % Do not include i, nor any lower guys
        i=i+1;
        break;
      end
    end
    if(i==0) 
      i=1; % The loop ended with all of them positive
    end
    qstar_sum = 0;
    for j=xmax:-1:i
      qstar(j)=(pstar-mc(double(j-1),prof_fun))/prof_fun(2);
      profit(j)=prof_fun(7)/nfirms + qstar(j)*(pstar-mc(j-1,prof_fun)) - prof_fun(5);
      qstar_sum=qstar_sum+qstar(j)*xInit(j);
    end
    for j=i-1:-1:1
      profit(j)=prof_fun(7)/nfirms-prof_fun(5);
      qstar(j)=0.0;
    end
    if(qstar_sum>0)
      ms=qstar/qstar_sum;
    else
      ms=0;
    end
    for j=1:xmax
      prodsur=prodsur+xInit(j)*profit(j);
    end
    fprintf('q = %.2f, p = %.2f\n',qstar_sum,pstar); 
    prodsur=prodsur-prof_fun(7);
    conssur=0.5*qstar_sum*(prof_fun(1)-pstar);
    fprintf('ps = %.2f, cs = %.2f\n',prodsur,conssur);
  end
end
