%
% Graphs

addpath export_fig

set(0,'defaultTextFontName', 'Arial')
set(0,'defaultAxesFontName', 'Arial')

cs_gradual=zeros(3,8);
ps_gradual=zeros(3,8);
hhi_gradual=zeros(3,8);
c1_gradual=zeros(3,8);
c2_gradual=zeros(3,8);
inv_gradual=zeros(3,8);
firms_gradual=zeros(3,8);
bounds_gradual=zeros(3,8);

c1=zeros(3,8);
c2=zeros(3,8);

step=30;
startc=80;
stopc=290;

for ssn=1:6

for ii=1:3
    for jj=1:8
        xx=startc+(jj-1)*step;
        % load stats
        if(ii==1) % OE
          nn=0;
          ['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']
          load(['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']);
          load(['domOE-' num2str(nn) '-c' num2str(xx) '-stats-pointwise' num2str(ssn) '.mat']);
          stats=statsPOE;
        elseif(ii==2) % POE 3-firms
          nn=3;
          ['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']
          load(['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']);
          load(['domOE-' num2str(nn) '-c' num2str(xx) '-stats-pointwise' num2str(ssn) '.mat']);
          stats=statsPOE;
        else % NOE with resolving, domOEnonstat-0-c10-cout.mat
          ['domOEnonstat-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']
          load(['domOEnonstat-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']);
          stats=statsNOEresolv; 
        end
        
        load(['eq8-stats' num2str(xx) '-pointwise' num2str(ssn) '.mat']);
        cs_gradual(ii,jj)=abs(stats.cs.avr-cs_avg)/cs_avg;
        ps_gradual(ii,jj)=abs(stats.ps.avr-ps_avg)/ps_avg;        
        hhi_gradual(ii,jj)=abs(stats.hhi.avr-hhi_avg);        
        c1_gradual(ii,jj)=abs(stats.c1.avr-conc_one_avg);        
        c2_gradual(ii,jj)=abs(stats.c2.avr-conc_two_avg);
        inv_gradual(ii,jj)=abs(stats.investment.avr-inv_avg*8)/(inv_avg*8)      

        c1(ii,jj)=abs(stats.c1.avr);
        c1(6,jj)=conc_one_avg;

        c2(ii,jj)=abs(stats.c2.avr);
        c2(6,jj)=conc_two_avg;
%{
        if((ii==1) || (ii==5))
            z=sum(tildes(5:8));
            f=tildes/sum(tildes)
            v=V
        else
            z=nf'+mean_fringe_state;z=sum(z(5:8));
            tildes=sum(sMatrix.*repmat(Q,1,xmax),1);
            f=tildes/sum(tildes);
            v=sum(VMatrix.*repmat(Q,1,xmax),1);
        end
        
        z1=sum(firm_per_state_avg(5:8));
        firms_gradual(6,jj)=z1;
        firms_gradual(ii,jj)=z;
        
        bounds_gradual(ii,jj)=sum(f.*boundsPOE.bound3.avr'./v)
%}
    end
end
%{
cs_gradual=cs_gradual([1 5 2 3 4],:);
ps_gradual=ps_gradual([1 5 2 3 4],:);
hhi_gradual=hhi_gradual([1 5 2 3 4],:);
c1_gradual=c1_gradual([1 5 2 3 4],:);
c2_gradual=c2_gradual([1 5 2 3 4],:);
inv_gradual=inv_gradual([1 5 2 3 4],:);
firms_gradual=firms_gradual([1 5 2 3 4 6],:);
bounds_gradual=bounds_gradual([1 5 2 3 4],:);
c1=c1([1 5 2 3 4 6],:);
c2=c2([1 5 2 3 4 6],:);
%}

cost=startc:step:stopc;

panning1=startc-3/5*step;
panning2=stopc+3/5*step;

h=figure(1);
set(gca,'FontSize',15);
set(gcf,'Position',[0 0 750 300]);
set(gcf,'PaperPositionMode','auto');

bar(cost,cs_gradual'*100);
colormap([0 0 0;0.2 0.2 0.2;0.5 0.5 0.5;0.7 0.7 0.7;1 1 1]);
legend('OE','POE3','NOE','Location','NorthEastOutside');
title('Percentage difference in discounted consumer surplus compared to MPE (Cournot)');
xlabel('Investment cost');
xlim([panning1 panning2])
export_fig(['cournot_cs_gradual-pointwise' num2str(ssn) '.pdf'],'-transparent')

bar(cost,ps_gradual'*100)
legend('OE','POE3','NOE','Location','NorthEastOutside');
title('Percentage difference in discounted producer surplus compared to MPE (Cournot)');
xlabel('Investment cost');
xlim([panning1 panning2])
export_fig(['cournot_ps_gradual-pointwise' num2str(ssn) '.pdf'],'-transparent')

bar(cost,inv_gradual'*100)
legend('OE','POE3','NOE','Location','NorthEastOutside');
title('Percentage difference in discounted investment compared to MPE (Cournot)'); 
xlabel('Investment cost');
xlim([panning1 panning2])
export_fig(['cournot_inv_gradual-pointwise' num2str(ssn) '.pdf'],'-transparent')
end
%{
bar(cost,firms_gradual')
legend('OE','OE-SIM','POE1','POE2','POE3','MPE','Location','NorthEastOutside');
colormap([0 0 0;0.2 0.2 0.2;0.4 0.4 0.4;0.6 0.6 0.6;0.8 0.8 0.8;1 1 1]);
title('Average number of firms in the upper half of the state space (Cournot)'); 
xlabel('Investment cost');
saveas(h,'cournot_firms_gradual.png');

bar(cost,bounds_gradual'*100)
legend('OE','OE-SIM','POE1','POE2','POE3','Location','NorthEastOutside');
colormap([0 0 0;0.3 0.3 0.3;0.7 0.7 0.7;1 1 1]);
title('Percentage bounds (Cournot)'); 
xlabel('Investment cost');
saveas(h,'cournot_bounds_gradual.png');

bar(cost,c1_gradual'*100)
legend('OE','OE-SIM','POE1','POE2','POE3','Location','NorthEastOutside');
colormap([0 0 0;0.3 0.3 0.3;0.7 0.7 0.7;1 1 1]);
title('Percentage difference in C1 compared to MPE (Cournot)');
xlabel('Investment cost');
saveas(h,'cournot_c1_gradual.png');

bar(cost,c2_gradual'*100)
legend('OE','OE-SIM','POE1','POE2','POE3','Location','NorthEastOutside');
colormap([0 0 0;0.3 0.3 0.3;0.7 0.7 0.7;1 1 1]);
title('Percentage difference in C2 compared to MPE (Cournot)');
xlabel('Investment cost');
saveas(h,'cournot_c2_gradual.png');

bar(cost,c1(6,:)')
legend('MPE','Location','NorthWest');
colormap([0 0 0;0.2 0.2 0.2;0.6 0.6 0.6;0.8 0.8 0.8;1 1 1]);
title('C1 (Cournot)');
xlabel('Investment cost');
saveas(h,'cournot_c1.png');

bar(cost,c2(6,:)')
legend('MPE','Location','NorthWest');
colormap([0 0 0;0.2 0.2 0.2;0.6 0.6 0.6;0.8 0.8 0.8;1 1 1]);
title('C2 (Cournot)');
xlabel('Investment cost');
saveas(h,'cournot_c2.png');

bar(cost,[c1(6,:)' c2(6,:)'-c1(6,:)'],'stacked')
%xlim([-0.3 cost(end)+0.3])
%set(gca,'XTick',cost)
ylim([0 1.1])
legend('C1','C2','Location','NorthWest');
colormap([0 0 0;0.2 0.2 0.2;0.6 0.6 0.6;0.8 0.8 0.8;1 1 1]);
title('Concentration indexes - MPE (Cournot)');
xlabel('Investment cost');
saveas(h,'cournot_c1c2.png');
%}
