function y=ss(cost,delta,n)
  convtol = zeros(17,1);
  prof_fun = zeros(10,1);
  prof_fun_ipopt = zeros(2,1);
  transition = zeros(13,1);
  init = zeros(5,1);
  constants = zeros(4,1);
  control = zeros(3,1);

  NN=8;
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Tolerance parameters        %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Tolerance for value iteration (valueIt) %
  convtol(1) = 1e-9;

  % Tolerance for transition matrix and probability of exiting %
  convtol(2) = 1e-7;

  % Maximum number of fpstrat iteration %
  if(n==0)
    convtol(3) = 1e10;
  else
    convtol(3) = 1e5;
  end


  % Tolerance on the probability of jumping up from the highest state %
  % If probability exceeds the value xmax is increased by convtol(4)   %
  convtol(4) = 10000;

  % How much to increase xmax if it too small %
  convtol(5) = 5.0;

  % Tolerance on zero profit condition -- not used when set low %
  convtol(6) = 1e-4;

  % How much should we increase (relative measure) search interval of lambda %
  % when switching from approximate to exact profit function %
  convtol(7) = 0.1;

  % How much should we extend search interval if the equilibrium is outside of the % 
  % of the current search interval %
  convtol(8) = 0.5;

  % Tolerance value on the condition number of the matrix when calculating %
  % stationary distribution. If condition number is smaller that the       %
  % given value infinite sum is calculated instead of the inverse           %
  convtol(9) = 1e10;

  % Parameter regulating size of infinite sum in case condition number is small %
  convtol(10) = 100.0;

  % Parameter regulating smooth update of strategies %
  convtol(11) = 0.8;

  % Maximum xmax, can't go above this at all %
  convtol(12) = 140.0;

  % Hard minimum entry rate (otherwise code fails out) %
  convtol(13) = 1e-5;

  % Hard maximum entry rate (otherwise code fails out) % 
  convtol(14) = 1e6;

  % Unused %
  convtol(15) = 0.0;
  convtol(16) = 0.0;

  % Tolerance on entry rate in outer iterations (note: requires one or other tol to be hit) %
  convtol(17) = 0.01;  

  % 1 - if compute approximate profits first in the stationary model %
  % 2 - if compute only actual profits                               %
  control(1) = 2;

  % Entry process                            %
  % 1 - Poisson Entry                        %
  % 2 - Constant Entry                       %
  control(2) = 1;

  % Entry process                            %
  % 0 - Random number of firms               %
  % >0 - Set the fixed number of firms       %
  control(3) = NN;

  % Coputing method                          %
  % 0 - Bisection                            %
  % 1 - Gauss-Seidel                         %
  control(4) = 1;

  % Subtract
  control(5) = 1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Logit profit function params %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Demand size (D)
  prof_fun(1)=200;

  % Demand slope (sigma)
  prof_fun(2)=10;

  % Cost parameter (gamma)
  prof_fun(3)=1;

  % Cost parameter (offset starting value)
  prof_fun(4)=5;

  % Fixed cost parameter f
  prof_fun(5)=0.0;

  % Cost parameter (movement per state)
  prof_fun(6)=0.5;

  % Demand of second market (D2)
  prof_fun(7)=5.0;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ipopt parameters            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Lower bound on prices
  prof_fun_ipopt(1) = 0;

  % Upper bound on prices
  prof_fun_ipopt(2) = prof_fun(2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Transition maxix parameters        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Sell-off value, inactive if fixed number of firms %
  transition(1) = 40.0;

  % Probability of deprecation (delta) %
  transition(2) = delta;

  % Parameter on successful investment (a) %
  transition(3) = 1;

  % The below parameters are special to dense transition matrix
  % It does not apply to tridiagonal transition matrix
  % It adds exogenous shock to the transition probabilities
  % See src/compoe/setup.h
  %
  % Transition equation is given by
  %   x_{t+1}=x_t+w(i_t,\zeta_{t+1})+\epsilon_{t+1}
  % where
  %   w(i_t,\zeta_{t+1}) is {-1,0,+1}-valued transition explained in
  %     Weintraub, Benkard, and Van Roy (2008)
  %   \epsilon_{t+1} is independent {-N,-N+1,...,+N} valued random variable
  %     with distribution function given by the appropriate parameters
  % Note that the biggest jump for random variable x_{t+1} is -N-1 or N+1
  % For the implementation look in src/compoe/compoe-tranprob_dense.cpp

  % put N here
  transition(4) = 2.0;

  % Next two parameters HAVE TO be zeros, do not modify it
  transition(5) = 0.0;
  transition(6) = 0.0;

  % Now come the transition probabilities
  %  Example for N=1
  %    transition(7) = P(\epsilon_t=-1);
  %    transition(8) = P(\epsilon_t=0);
  %    transition(9) = P(\epsilon_t=+1);
  %  Example for N=2
  %    transition(7) = P(\epsilon_t=-2);
  %    transition(8) = P(\epsilon_t=-1);
  %    transition(9) = P(\epsilon_t=0);
  %    transition(10) = P(\epsilon_t=+1);
  %    transition(11) = P(\epsilon_t=+2);
  %  Example for N=3
  %    transition(7) = P(\epsilon_t=-3);
  %    transition(8) = P(\epsilon_t=-2);
  %    transition(9) = P(\epsilon_t=-1);
  %    transition(10) = P(\epsilon_t=0);
  %    transition(11) = P(\epsilon_t=+1);
  %    transition(12) = P(\epsilon_t=+2);
  %    transition(13) = P(\epsilon_t=+3);
  transition(7) = 0.05;
  transition(8) = 0.05;
  transition(9) = 0.8;
  transition(10) = 0.05;
  transition(11) = 0.05;

  % The array has to be terminated by two zeros
  transition(12) = 0.0;
  transition(13) = 0.0;

  transition(14) = 12.0;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Other constants of the model %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Entry cost %
  constants(1) = 20;

  % Fixed cost of investment %
  constants(2) = cost;

  % Parameter on variable cost of investment %
  % Set up big to switch-off variable cost  %
  constants(5) = 10000.0;

  % Discount factor (beta) %
  constants(3) = 0.90;

  % Entry state %
  constants(4) = 3.0;


  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Initialization parameters   %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % starting xmax %
  init(1) = 8.0;

  % starting investment %
  init(2) = 1.0;

  % Starting exit rule %
  init(3) = constants(1);

  % bisection lower bound for lambda %
  init(4) = 8.0;

  % bisection upper bound for lambda %
  init(5) = 9.0;

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % CONTROL PARAMETERS FOR COMPUTING BOUNDS %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % not used %
  bounds(1)=0.0;

  % tolerance relative precision when simulating bounds %
  bounds(2)=0.1;

  % tolerance relative precision when simulating expected value function %
  bounds(3)=0.001;

  % maximum number of iterations to compute bounds %
  bounds(4)=1000000.0;

  % minimum number of iterations to compute bounds %
  bounds(5)=2000.0;

  % maximum number of periods to consider when sampling state %
  % in case constant number of entrants                       %
  bounds(6)=1000.0;

  % tolerance prob. being in industry when sampling state %
  % in case constant number of entrants                   %
  bounds(7)=1e-3;

  % how much more states off equilibrium path should be considered %
  bounds(8)=1.0;

  % number of maximum state jumps per period %
  bounds(9)=1.0;

  % tolerance of checking if Delta_y is increasing
  bounds(10)=1e-3;

  dom(11)=0;

  filename=['output_oe' num2str(n)];

  A = sparse([1]);
  shocklevels=[];
  mean_fringe_state=zeros(size(8,1));

  % Tolerance parameter for rho           
  dom(1)=1e-6;
  
  % Tolerance parameter for iota
  dom(2)=1e-6;

  % Tolerance parameter for zero profit condition 
  dom(3)=1e-4*transition(1);

  % If lambda is smaller than this we treat it as zero
  dom(4)=1e-3;

  % 1 - if compute approximate profits first
  % 2 - if compute only actual profits
  dom(5)=2;

  % MPE with weighted profits?
  dom(6)=0;

  % entry cost for dom firms
  % put 0 for no entry exit
  % INACTIVE NOW
  dom(7)=0.0;

  %%%%% Smooth update parameters

  % Exponential parameter on mu
  dom(8)=0.5;

  % Addition parameter on mu
  dom(9)=1;

  %%%%% Other parameters

  % Number of states
  dom(10)=8.0;

  % Number of dominant firms
  dom(11)=n;

  % Number of warmup periods for stats
  dom(12)=0;

  % minimum number of simulation periods for stats
  dom(13)=100;

  % Number of warmup periods for bounds
  dom(14)=100;

  % number of simulations in one observation for bounds
  dom(15)=10;

  % tolerance parameters for norm of lambda
  dom(16)=1e-4;

  % Do small iters?
  dom(17)=0;

  % Don't do small iters for first couple big iters
  dom(18)=100;

  % Lambda convergence accelerator
  dom(19)=1;

  % Minimal number of simulations for stats
  dom(20)=10000;

  % Minimal number of simulations for bounds
  dom(21)=2000;

  % Pointwise
  dom(22)=1;

  if(n==0)
    save(['domOE-0-c' num2str(cost) '-init.mat'],'filename','control','prof_fun','prof_fun_ipopt',...
      'transition','constants','init','convtol','bounds','A','shocklevels','mean_fringe_state');

    infile=['domOE-0-c' num2str(cost) '-init.mat'];
    outfile=['domOE-0-c' num2str(cost) '-cout.mat'];

    tic;
    eval(['!../../../compoe_matlab ',infile,' ',outfile]);
    compTime=toc;

    load(outfile);
  else
    load(['domOE-0-c' num2str(cost) '-cout.mat']);
    fprintf('Computing dominant firms OE...');	  
 
    % Invocation of the solver
    lambdaInit=lambda*ones(xmax,1);
  
    filename=['output_dom-' num2str(n) '-c' num2str(cost) '.log'];

    control(3)=NN-n;
    lambdaInit=lambda*ones(xmax,1);
    iotaInit=iota;
    rhoInit=rho;

    A = sparse([1]);
    shocklevels=[];
    mean_fringe_state=zeros(size(tildes));

    save(['domOE-' num2str(n) '-c' num2str(cost) '-init'],'filename','control','prof_fun','prof_fun_ipopt',...
      'transition','constants','init','convtol','bounds','dom',...
      'lambdaInit','iotaInit','rhoInit','pricesInit','A','shocklevels','mean_fringe_state');

    infile=['domOE-' num2str(n) '-c' num2str(cost) '-init.mat'];
    outfile=['domOE-' num2str(n) '-c' num2str(cost) '-cout.mat'];
  
    eval(['!../../../compoe_dom_matlab ',infile,' ',outfile]);
    compTime=toc;
  
    load(outfile);

    Qm = dom_marginal(Q,enc,xmax);

    mean_fringe_state=sum(repmat(Q,1,xmax).*sMatrix,1);
    nf=simul_num_firms(Q,enc,xmax);
  end
  start_states=[...
            8 7 7 6 7 6;...
            0 1 0 0 0 0;...
            0 0 0 0 0 0;...
            0 0 0 0 1 2;...
            0 0 0 0 0 0;...
            0 0 0 0 0 0;...
            0 0 0 0 0 0;...
            0 0 1 2 0 0];
    
  for ssn=1:6
    % Choose n largest firms
    s0=start_states(:,ssn);
    if(n>0)
      doms=zeros(1,n);
      for i=1:n
        for x=xmax:-1:1
          if(s0(x)>0) 
            s0(x)=s0(x)-1;
            doms(i)=x;
            break;
          end
        end
      end
      
      w0=-1;
      % encode
      doms=sort(doms)-1;
      for i=1:size(enc,1)
        if(norm(enc(i,:)-doms)==0)
          w0=i-1;
          break;
        end
      end
      if(w0==-1)
        fprintf('Could not find %d', doms)
      end
    else
      w0=0;
    end
      

    save(['domOE-' num2str(n) '-c' num2str(cost) '-final-pointwise' num2str(ssn) '.mat']);

    infile=['domOE-' num2str(n) '-c' num2str(cost) '-final-pointwise' num2str(ssn) '.mat'];
    outfile=['domOE-' num2str(n) '-c' num2str(cost) '-stats-pointwise' num2str(ssn) '.mat'];
    eval(['!../../../stats_dom_matlab ',infile,' ',outfile]);
  end % ssn
end % end function
