clear all


system('../../../compoe_nonstat_matlab domOEnonstat-0-c5-init.mat domOEnonstat-0-c5-cout.mat')
load domOEnonstat-0-c5-init.mat
load domOEnonstat-0-c5-cout.mat
sMatrix=sMatrix';
iotaMatrix=iotaMatrix';

addpath test/

p0=s0/sum(s0);
R=1e5;
xmax=max(size(s0));

output=zeros(size(sMatrix));
denom=output;

P1=tranmat(iotaMatrix(1,:),transition);
P2=tranmat(iotaMatrix(2,:),transition);
P3=tranmat(iotaMatrix(3,:),transition);

for r=1:R
  x=discretesample(p0,1);
  s0sub=s0;
  s0sub(x)=s0sub(x)-1;
  for t=1:4
    P=tranmat(iotaMatrix(t,:),transition);

    % your state
    xnext=discretesample(P(x,:),1);

    % comptetitor state
    snext=zeros(size(s0sub));
    for xc=1:xmax
      comp=discretesample(P(xc,:),s0sub(xc));
      for m=1:s0sub(xc)
        snext(comp(m))=snext(comp(m))+1;
      end
    end
    
    output((xnext-1)*12+t+1,:)=output((xnext-1)*12+t+1,:)+snext;
    denom((xnext-1)*12+t+1,:)=denom((xnext-1)*12+t+1,:)+1;
    
    x=xnext;
    s0sub=snext;
  end
end

ss=output./denom;