function y=ss(x,n)
  addpath ../..
  addpath ..

  convtol = zeros(17,1);
  prof_fun = zeros(10,1);
  prof_fun_ipopt = zeros(2,1);
  transition = zeros(13,1);
  init = zeros(5,1);
  constants = zeros(4,1);
  control = zeros(3,1);

  NN=8;
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Tolerance parameters        %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Tolerance for value iteration (valueIt) %
  convtol(1) = 1e-6;

  % Tolerance for transition matrix and probability of exiting %
  convtol(2) = 1e-6;

  % Maximum number of fpstrat iteration %
  convtol(3) = 1000000.0;

  % Tolerance on the probability of jumping up from the highest state %
  % If probability exceeds the value xmax is increased by convtol(4)   %
  convtol(4) = 10000;

  % How much to increase xmax if it too small %
  convtol(5) = 5.0;

  % Tolerance on zero profit condition -- not used when set low %
  convtol(6) = 1e-4;

  % How much should we increase (relative measure) search interval of lambda %
  % when switching from approximate to exact profit function %
  convtol(7) = 0.1;

  % How much should we extend search interval if the equilibrium is outside of the % 
  % of the csubtracting1urrent search interval %
  convtol(8) = 0.5;

  % Tolerance value on the condition number of the matrix when calculating %
  % stationary distribution. If condition number is smaller that the       %
  % given value infinite sum is calculated instead of the inverse           %
  convtol(9) = 1e10;

  % Parameter regulating size of infinite sum in case condition number is small %
  convtol(10) = 100.0;

  % Parameter regulating smooth update of strategies %
  convtol(11) = 0.6666;

  % Maximum xmax, can't go above this at all %
  convtol(12) = 140.0;

  % Hard minimum entry rate (otherwise code fails out) %
  convtol(13) = 1e-5;

  % Hard maximum entry rate (otherwise code fails out) % 
  convtol(14) = 1e6;

  % Unused %
  convtol(15) = 0.0;
  convtol(16) = 0.0;

  % Tolerance on entry rate in outer iterations (note: requires one or other tol to be hit) %
  convtol(17) = 0.01;  

  % 1 - if compute approximate profits first in the stationary model %
  % 2 - if compute only actual profits                               %
  control(1) = 2;

  % Entry process                            %
  % 1 - Poisson Entry                        %
  % 2 - Constant Entry                       %
  control(2) = 1;

  % Entry process                            %
  % 0 - Random number of firms               %
  % >0 - Set the fixed number of firms       %
  control(3) = NN;

  % Coputing method                          %
  % 0 - Bisection                            %
  % 1 - Gauss-Seidel                         %
  control(4) = 1;

  % Subtract
  control(5) = 1;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Logit profit function params %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Demand size (D)
  prof_fun(1)=x(1);

  % Demand slope (sigma)
  prof_fun(2)=x(2);

  % Cost parameter (gamma)
  prof_fun(3)=x(3);

  % Cost parameter (offset starting value)
  prof_fun(4)=x(8);

  % Fixed cost parameter f
  prof_fun(5)=0.0;

  % Cost parameter (movement per state)
  prof_fun(6)=x(4);

  % Demand of second market (D2)
  prof_fun(7)=5.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ipopt parameters            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Lower bound on prices
  prof_fun_ipopt(1) = 0;

  % Upper bound on prices
  prof_fun_ipopt(2) = prof_fun(2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Transition maxix parameters        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Sell-off value, inactive if fixed number of firms %
  transition(1) = 40.0;

  % Probability of deprecation (delta) %
  transition(2) = x(5);

  % Parameter on successful investment (a) %
  transition(3) = x(6);

  % The below parameters are special to dense transition matrix
  % It does not apply to tridiagonal transition matrix
  % It adds exogenous shock to the transition probabilities
  % See src/compoe/setup.h
  %
  % Transition equation is given by
  %   x_{t+1}=x_t+w(i_t,\zeta_{t+1})+\epsilon_{t+1}
  % where
  %   w(i_t,\zeta_{t+1}) is {-1,0,+1}-valued transition explained in
  %     Weintraub, Benkard, and Van Roy (2008)
  %   \epsilon_{t+1} is independent {-N,-N+1,...,+N} valued random variable
  %     with distribution function given by the appropriate parameters
  % Note that the biggest jump for random variable x_{t+1} is -N-1 or N+1
  % For the implementation look in src/compoe/compoe-tranprob_dense.cpp

  % put N here
  transition(4) = 2.0;

  % Next two parameters HAVE TO be zeros, do not modify it
  transition(5) = 0.0;
  transition(6) = 0.0;

  % Now come the transition probabilities
  %  Example for N=1
  %    transition(7) = P(\epsilon_t=-1);
  %    transition(8) = P(\epsilon_t=0);
  %    transition(9) = P(\epsilon_t=+1);
  %  Example for N=2
  %    transition(7) = P(\epsilon_t=-2);
  %    transition(8) = P(\epsilon_t=-1);
  %    transition(9) = P(\epsilon_t=0);
  %    transition(10) = P(\epsilon_t=+1);
  %    transition(11) = P(\epsilon_t=+2);
  %  Example for N=3
  %    transition(7) = P(\epsilon_t=-3);
  %    transition(8) = P(\epsilon_t=-2);
  %    transition(9) = P(\epsilon_t=-1);
  %    transition(10) = P(\epsilon_t=0);
  %    transition(11) = P(\epsilon_t=+1);
  %    transition(12) = P(\epsilon_t=+2);
  %    transition(13) = P(\epsilon_t=+3);
  transition(7) = 0.05;
  transition(8) = 0.05;
  transition(9) = 0.8;
  transition(10) = 0.05;
  transition(11) = 0.05;

  % The array has to be terminated by two zeros
  transition(12) = 0.0;
  transition(13) = 0.0;

  transition(14) = 12.0;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Other constants of the model %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Entry cost %
  constants(1) = 20;

  % Fixed cost of investment %
  constants(2) = x(7);

  % Parameter on variable cost of investment %
  % Set up big to switch-off variable cost  %
  constants(5) = 10000.0;

  % Discount factor (beta) %
  constants(3) = 0.90;

  % Entry state %
  constants(4) = 3.0;


  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Initialization parameters   %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % starting xmax %
  init(1) = 8.0;

  % starting investment %
  init(2) = 1.0;

  % Starting exit rule %
  init(3) = constants(1);

  % bisection lower bound for lambda %
  init(4) = 8.0;

  % bisection upper bound for lambda %
  init(5) = 9.0;

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % CONTROL PARAMETERS FOR COMPUTING BOUNDS %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % not used %
  bounds(1)=0.0;

  % tolerance relative precision when simulating bounds %
  bounds(2)=0.1;

  % tolerance relative precision when simulating expected value function %
  bounds(3)=0.001;

  % maximum number of iterations to compute bounds %
  bounds(4)=1000000.0;

  % minimum number of iterations to compute bounds %
  bounds(5)=10000.0;

  % maximum number of periods to consider when sampling state %
  % in case constant number of entrants                       %
  bounds(6)=1000.0;

  % tolerance prob. being in industry when sampling state %
  % in case constant number of entrants                   %
  bounds(7)=1e-3;

  % how much more states off equilibrium path should be considered %
  bounds(8)=1.0;

  % number of maximum state jumps per period %
  bounds(9)=1.0;

  % tolerance of checking if Delta_y is increasing
  bounds(10)=1e-3;
  
  % Warm up periods
  bounds(11)=1000;

  dom(11)=0;

  filename=['output_oe' num2str(n)];

  save(['domOE-0-c' num2str(x(7)) '-init.mat'],'filename','control','prof_fun','prof_fun_ipopt',...
    'transition','constants','init','convtol','bounds');

  infile=['domOE-0-c' num2str(x(7)) '-init.mat'];
  outfile=['domOE-0-c' num2str(x(7)) '-cout.mat'];
  tic;
  eval(['!../../../compoe_matlab ',infile,' ',outfile]);
  compTime=toc;
  load(outfile);

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Parameters for non-stationary    %
  % equilibrium solver               %
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % NOTE:
  % In the NOE there is no need to subtract yourself and stilde_t gives
  % the state of the competitors
  % stilde output from regular OE gives full state, thus the code subtract
  % a firm for a final state
  
  s0=zeros(1,8);
  s0=[7 0 0 0 0 0 0 1];
  %s0(2)=8;
  %%% Convergence parameters %%%

    % Tolerance parameter for continuation    %
    % probabilities                           %
    nonstatparams(1)=1;

    % Tolerance parameter for iota  %
    nonstatparams(2)=1;

    % Tolerance parameter for zero profit condition %
    nonstatparams(3)=5;

  %%% Smooth updating of the parameters %%%

    % Exponential parameter on mu %
    nonstatparams(4)=0.5;

    % Exponential parameter on lambda %
    nonstatparams(5)=0.5;

    % Addition parameter on mu %
    nonstatparams(6)=1.0;

    % Addition parameter on lambda %
    nonstatparams(7)=1.0;

  %%% Other parameters %%%

    % How much to increase xmax when computing Tbar %
    % Unused at the moment                          %
    nonstatparams(8)=50.0;

    % If xmax_nonstat is bigger than S0_NONSTAT then fill with this number %
    nonstatparams(9)=0.0;

    % number of maximum state jumps per period %
    nonstatparams(10) = 1.0;

    % Number of periods in the non-stationary equilibrium %
    nonstatparams(11)=1000.0;

    % Tolerance for computing Tbar                        %
    % unused at the moment                                %
    nonstatparams(12)=1e-5;

    % Number of states in the non-stationary equilibrium               %
    nonstatparams(13)=xmax;

    % T_LOWERBAR %
    nonstatparams(14)=0.0;

    % 1 - if compute approximate profits first in the non-stationary model %
    % 2 - if compute only actual profits                                   %
    nonstatparams(15)=2;

    % If lambda is smaller than this we treat it as zero %
    nonstatparams(16)=1e-5;


    %%% Industry statictics simulation parameters

    % How many periods ahead in the average CS, PS and INV
    % 0 - if discounted
    nonstatparams(17)=0;

    % Where should extra firm start when fixed number of firms
    nonstatparams(18)=0;
    
    % Do expensive subtracting
    % 0 - no subtracting, s0 is the state of competitors
    % 1 - approximate subtracting, s0 is the industry state
    % 2 - expensive subtracting, s0 is the industry state
    nonstatparams(19)=3;
  
    save(['domOEnonstat-0-c' num2str(x(7)) '-init.mat'],'filename','control','prof_fun','prof_fun_ipopt',...
      'transition','constants','init','convtol','bounds','nonstatparams',...
      'lambda','iota','rho','V','prices','s0','tildes');

    infile=['domOEnonstat-0-c' num2str(x(7)) '-init.mat'];
    outfile=['domOEnonstat-0-c' num2str(x(7)) '-cout.mat'];
    tic;
    %eval(['!../../../compoe_nonstat_matlab ',infile,' ',outfile]);
    eval(['!../../../compoe_nonstat_resolving ',infile,' ',outfile]);
    compTime=toc;
    load(outfile);
%{
  [VMatrix,iotaMatrix,rhoMatrix,lambdaVector,sMatrix,profitMatrix,priceMatrix]...
     =compoe_nonstat_matlab('output2',control,prof_fun,prof_fun_ipopt,transition,constants,init,convtol,nonstatparams,...
       lambda,iota,rho,V,prices,s0,tildes);

  % remember to transpose the resulting matrices because matlab stores them columnwise and C row-wise
  VMatrix=VMatrix';
  iotaMatrix=iotaMatrix';
  rhoMatrix=rhoMatrix';
  profitMatrix=profitMatrix';
  priceMatrix=priceMatrix';
  sMatrix=sMatrix';

  
  
  
save nonstatdata VMatrix iotaMatrix rhoMatrix profitMatrix lambdaVector sMatrix s0 priceMatrix;
%}
  
end % end function

