%
% Graphs

addpath export_fig

set(0,'defaultTextFontName', 'Arial')
set(0,'defaultAxesFontName', 'Arial')

T=500;

T2=[500 500 500 500 500 500 500 500];

cs_gradual=zeros(7,8,T);
ps_gradual=zeros(7,8,T);
hhi_gradual=zeros(7,8,T);
c1_gradual=zeros(7,8,T);
c2_gradual=zeros(7,8,T);
inv_gradual=zeros(7,8,T);
firms_gradual=zeros(7,8,T);
bounds_gradual=zeros(7,8,T);

markers = {'d','^','v','o','s','+','*','x','.','>','<','p','h'};

step=1;
startc=8;
stopc=15;

for ssn=1:1
  for ii=[0 1 4 5 6]
    for jj=[1 2 3 4 5 6 7 8]
        xx=startc+(jj-1)*step;
        % load stats
        if(ii==0) % MPE
          load(['eq8-stats' num2str(xx) '-pointwise' num2str(ssn) '.mat']);
          
          cs_gradual(ii+1,jj,:)=cs_avg_path;
          ps_gradual(ii+1,jj,:)=ps_avg_path;
          hhi_gradual(ii+1,jj,:)=hhi_avg_path;
          c1_gradual(ii+1,jj,:)=conc_one_avg_path;
          c2_gradual(ii+1,jj,:)=conc_two_avg_path;
          inv_gradual(ii+1,jj,:)=inv_avg_path*8;
        else 
          if(ii==1) % OE
            nn=0;
            ['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']);
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-stats-pointwise' num2str(ssn) '.mat']);
            stats=statsPOE_path;
          elseif((ii>=2) && (ii<=4)) % POE 3-firms
            nn=ii-1;
            ['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']);
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-stats-pointwise' num2str(ssn) '.mat']);
            stats=statsPOE_path;
          elseif(ii==5) % NOE without resolving
            ['domOEnonstat_noresolv-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']
            load(['domOEnonstat_noresolv-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']);
            stats=statsNOEresolv_path;
          elseif(ii==6) % NOE with resolving, domOEnonstat-0-c10-cout.mat
            ['domOEnonstat-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']
            load(['domOEnonstat-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']);
            stats=statsNOEresolv_path; 
          end
          cs_gradual(ii+1,jj,:)=stats.cs.avr;
          ps_gradual(ii+1,jj,:)=stats.ps.avr;        
          hhi_gradual(ii+1,jj,:)=stats.hhi.avr;        
          c1_gradual(ii+1,jj,:)=stats.c1.avr;        
          c2_gradual(ii+1,jj,:)=stats.c2.avr;
          inv_gradual(ii+1,jj,:)=stats.investment.avr;
        end
    end
  end

 
  for jj=1:8
    bw=[0.1:0.05:T2(jj)/100 ones(1,500)*T2(jj)/100];
    xx=startc+(jj-1)*step;
    
    y=cell(1,7);
    x=[1:T2(jj)];
    for i=1:7
      if(max(squeeze(cs_gradual(i,jj,x)))>1.0001*min(squeeze(cs_gradual(i,jj,x))))
        y{i}=ksr(x,squeeze(cs_gradual(i,jj,x)),bw,T2(jj));
      else
        y{i}.f=squeeze(cs_gradual(i,jj,x));
      end
    end
    h1=figure(1);
    set(h1, 'Position', [0 0 2000 600])
    %h=plot(x,y{1}.f,x,y{2}.f,x,y{3}.f,x,y{4}.f,x,y{5}.f,x,y{6}.f,x,y{7}.f,'LineWidth',2);
    h=plot(x,y{1}.f,x,y{2}.f,x,y{5}.f,x,y{6}.f,x,y{7}.f,'LineWidth',2);
    ho=addmarkers(h,5,markers);
    %h=legend(ho,'MPE','OE','POE-1','POE-2','POE-3','NOE','RNOE','Location','SouthEast');
    h=legend(ho,'MPE','OE','POE-3','NOE','RNOE','Location','Best');
    
    set(gcf,'PaperPositionMode','auto');
    set(findall(gcf,'type','text'),'fontSize',18);
    set(gca,'FontSize',18);

    xlabel('Period');
    ylabel('Consumer surplus');
    export_fig(['capacity_cs_path_cost' num2str(xx) '-pointwise' num2str(ssn) '.pdf'],'-transparent');
   
    y=cell(1,7);
    x=[1:T2(jj)];
    for i=1:7
      if(max(squeeze(ps_gradual(i,jj,x)))>1.0001*min(squeeze(ps_gradual(i,jj,x))))
        y{i}=ksr(x,squeeze(ps_gradual(i,jj,x)),bw,T2(jj));
      else
        y{i}.f=squeeze(ps_gradual(i,jj,x));
      end
    end
    h1=figure(1);
    set(h1, 'Position', [0 0 2000 600])
    %h=plot(x,y{1}.f,x,y{2}.f,x,y{3}.f,x,y{4}.f,x,y{5}.f,x,y{6}.f,x,y{7}.f,'LineWidth',2);
    h=plot(x,y{1}.f,x,y{2}.f,x,y{5}.f,x,y{6}.f,x,y{7}.f,'LineWidth',2);
    ho=addmarkers(h,5,markers);
    %h=legend(ho,'MPE','OE','POE-1','POE-2','POE-3','NOE','RNOE','Location','SouthEast');
    h=legend(ho,'MPE','OE','POE-3','NOE','RNOE','Location','Best');
        
    set(gcf,'PaperPositionMode','auto');
    set(findall(gcf,'type','text'),'fontSize',18);
    set(gca,'FontSize',18);
    
    xlabel('Period');
    ylabel('Producer surplus');
    export_fig(['capacity_ps_path_cost' num2str(xx) '-pointwise' num2str(ssn) '.pdf'],'-transparent');
  
    y=cell(1,7);
    x=[1:T2(jj)];
    for i=1:7
      if(max(squeeze(inv_gradual(i,jj,x)))>1.0001*min(squeeze(inv_gradual(i,jj,x))))
        y{i}=ksr(x,squeeze(inv_gradual(i,jj,x)),bw,T2(jj));
      else
        y{i}.f=squeeze(inv_gradual(i,jj,x));
      end
    end
    h1=figure(1);
    set(h1, 'Position', [0 0 2000 600])
    %h=plot(x,y{1}.f,x,y{2}.f,x,y{3}.f,x,y{4}.f,x,y{5}.f,x,y{6}.f,x,y{7}.f,'LineWidth',2);
    h=plot(x,y{1}.f,x,y{2}.f,x,y{5}.f,x,y{6}.f,x,y{7}.f,'LineWidth',2);
    ho=addmarkers(h,5,markers);
    %h=legend(ho,'MPE','OE','POE-1','POE-2','POE-3','NOE','RNOE','Location','SouthEast');
    h=legend(ho,'MPE','OE','POE-3','NOE','RNOE','Location','Best');
 
    set(gcf,'PaperPositionMode','auto');
    set(findall(gcf,'type','text'),'fontSize',18);
    set(gca,'FontSize',18);
    
    xlabel('Period');
    ylabel('Investement');
    export_fig(['capacity_inv_path_cost' num2str(xx) '-pointwise' num2str(ssn) '.pdf'],'-transparent');
    pause
  end
end
