%% first produce state distribtion for all numbers of dom firms

load domOE-0-c4-final
h=figure(1);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=tildes;
bar([1:8],z(1:8),'stacked');
title({'No dominant firms';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7]);
saveas(h,'state0.png');

load domOE-1-c4-final
h=figure(2);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
bar([1:8],z(1:8,:),'stacked');
title({'1 dominant firm';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7]);
saveas(h,'state1.png');

load domOE-2-c4-final
h=figure(3);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
bar([1:8],z(1:8,:),'stacked');
title({'2 dominant firms';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7])
saveas(h,'state2.png');

load domOE-3-c4-final
h=figure(3);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[mean_fringe_state' nf];
bar([1:8],z(1:8,:),'stacked');
title({'3 dominant firms';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected number of firms');
colormap([0 0 0;0.7 0.7 0.7]);
saveas(h,'state3.png');

load domOE-2-c4-final
% expected investment for the fringe
expInv=sum(iotaMatrix.*repmat(Q,1,xmax),1);
%% Expand distribution
Qexp=[];
Eexp=[];
N=size(Q,1);
for x=1:N
	E=enc(x,:);
	per=unique(perms(E),'rows');
	for p=1:size(per,1)
		Eexp=[Eexp;per(p,:)];
		Qexp=[Qexp;Q(x)/size(per,1)];
        end
end

%% integrate investment
for x=0:size(domIotaMatrix,1)-1
  I=find(Eexp(:,1)==x);
  p=Qexp(I)/sum(Qexp(I));
  expInvDom(1,x+1)=sum(domIotaMatrix(:,x+1).*p);
end

h=figure(4);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv' expInvDom'];
bar([1:8],z(1:8,:),'grouped');
title({'2 dominant firms';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Leader','Location','North');
xlabel('State');
ylabel('Expected investment');
colormap([0 0 0;0.7 0.7 0.7]);
saveas(h,'investmentComparison.png');

%%%%%%%%%%% Part 2 - Entry & investment deterence
I=find(enc(:,1)==enc(:,2));
fDist=sMatrix(I,:);

%% investment if the fringe
expInv=sum(iotaMatrix(I,:).*fDist,2);
h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv];
bar([1:8],z);
title({'2 dominant firms';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Location','North');
xlabel('State of both dominant firms');
ylabel('Fringe investment');
colormap([0 0 0;0.7 0.7 0.7])
saveas(h,'investmentDeterrence.png');
%{
%% 
h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv];
bar([1:8],lambdaVector(I,:));
title({'2 dominant firms';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Location','North');
xlabel('State of both dominant firms');
ylabel('Entry Rate');
colormap([0 0 0;0.7 0.7 0.7]);
saveas(h,'entryDeterrence.png');

%% 
h=figure(5);
set(gca,'FontSize',20);
set(gcf,'Position',[0 0 750 400]);
set(gcf,'PaperPositionMode','auto');
z=[expInv];
bar([1:8],sum(sMatrix(I,:),2));
title({'2 dominant firms';'Light Tail, Logit Profit, Entry/Exit'});
legend('Fringe','Location','North');
xlabel('State of both dominant firms');
ylabel('Number of active firms');
colormap([0 0 0;0.7 0.7 0.7])
saveas(h,'activeFirms.png');
%}
