%
% Graphs

addpath export_fig

set(0,'defaultTextFontName', 'Arial')
set(0,'defaultAxesFontName', 'Arial')

T=300;
T2=100;

cs_gradual=zeros(7,8,T);
ps_gradual=zeros(7,8,T);
hhi_gradual=zeros(7,8,T);
c1_gradual=zeros(7,8,T);
c2_gradual=zeros(7,8,T);
inv_gradual=zeros(7,8,T);
firms_gradual=zeros(7,8,T);
bounds_gradual=zeros(7,8,T);

step=1;
startc=8;
stopc=15;

for ssn=1:6
  for ii=0:6
    for jj=1:8
        xx=startc+(jj-1)*step;
        % load stats
        if(ii==0) % MPE
          load(['eq8-stats' num2str(xx) '-pointwise' num2str(ssn) '.mat']);
          
          cs_gradual(ii+1,jj,:)=cs_avg_path;
          ps_gradual(ii+1,jj,:)=ps_avg_path;
          hhi_gradual(ii+1,jj,:)=hhi_avg_path;
          c1_gradual(ii+1,jj,:)=conc_one_avg_path;
          c2_gradual(ii+1,jj,:)=conc_two_avg_path;
          inv_gradual(ii+1,jj,:)=inv_avg_path*8;
        else 
          if(ii==1) % OE
            nn=0;
            ['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']);
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-stats-pointwise' num2str(ssn) '.mat']);
            stats=statsPOE_path;
          elseif((ii>=2) && (ii<=4)) % POE 3-firms
            nn=ii-1;
            ['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-final-pointwise' num2str(ssn) '.mat']);
            load(['domOE-' num2str(nn) '-c' num2str(xx) '-stats-pointwise' num2str(ssn) '.mat']);
            stats=statsPOE_path;
          elseif(ii==5) % NOE without resolving
            ['domOEnonstat_noresolv-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']
            load(['domOEnonstat_noresolv-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']);
            stats=statsNOEresolv_path;
          elseif(ii==6) % NOE with resolving, domOEnonstat-0-c10-cout.mat
            ['domOEnonstat-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']
            load(['domOEnonstat-0-c' num2str(xx) '-pointwise' num2str(ssn) '-cout.mat']);
            stats=statsNOEresolv_path; 
          end
          cs_gradual(ii+1,jj,:)=stats.cs.avr;
          ps_gradual(ii+1,jj,:)=stats.ps.avr;        
          hhi_gradual(ii+1,jj,:)=stats.hhi.avr;        
          c1_gradual(ii+1,jj,:)=stats.c1.avr;        
          c2_gradual(ii+1,jj,:)=stats.c2.avr;
          inv_gradual(ii+1,jj,:)=stats.investment.avr;
        end
    end
  end


  for jj=1:8
    xx=startc+(jj-1)*step;
    plot([1:T2],squeeze(cs_gradual(1,1,1:T2)),[1:T2],squeeze(cs_gradual(2,1,1:T2)),[1:T2],squeeze(cs_gradual(3,1,1:T2)),...
      [1:T2],squeeze(cs_gradual(4,1,1:T2)),[1:T2],squeeze(cs_gradual(5,1,1:T2)),[1:T2],squeeze(cs_gradual(6,1,1:T2)),...
      [1:T2],squeeze(cs_gradual(7,1,1:T2)))

    legend('MPE','OE','POE-1','POE-2','POE-3','NOE','RNOE','Location','SouthEast');
    xlabel('Period');
    ylabel('Consumer surplus');
    export_fig(['logit_cs_path_cost' num2str(xx) '-pointwise' num2str(ssn) '.pdf'],'-transparent');

    plot([1:T2],squeeze(ps_gradual(1,1,1:T2)),[1:T2],squeeze(ps_gradual(2,1,1:T2)),[1:T2],squeeze(ps_gradual(3,1,1:T2)),...
      [1:T2],squeeze(ps_gradual(4,1,1:T2)),[1:T2],squeeze(ps_gradual(5,1,1:T2)),[1:T2],squeeze(ps_gradual(6,1,1:T2)),...
      [1:T2],squeeze(ps_gradual(7,1,1:T2)))

    legend('MPE','OE','POE-1','POE-2','POE-3','NOE','RNOE','Location','SouthEast');
    xlabel('Period');
    ylabel('Producer surplus');
    export_fig(['logit_ps_path_cost' num2str(xx) '-pointwise' num2str(ssn) '.pdf'],'-transparent');

    plot([1:T2],squeeze(inv_gradual(1,1,1:T2)),[1:T2],squeeze(inv_gradual(2,1,1:T2)),[1:T2],squeeze(inv_gradual(3,1,1:T2)),...
      [1:T2],squeeze(inv_gradual(4,1,1:T2)),[1:T2],squeeze(inv_gradual(5,1,1:T2)),[1:T2],squeeze(inv_gradual(6,1,1:T2)),...
      [1:T2],squeeze(inv_gradual(7,1,1:T2)))

    legend('MPE','OE','POE-1','POE-2','POE-3','NOE','RNOE','Location','SouthEast');
    xlabel('Period');
    ylabel('Investement');
    export_fig(['logit_inv_path_cost' num2str(xx) '-pointwise' num2str(ssn) '.pdf'],'-transparent');

  end

end
