%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Logit profit function params %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Market size (M) %
  prof_fun(1) = 100.0;

  % Income size (Y) %
  prof_fun(2) = 1.0;

  % Consumer theta 1 (theta1) %
  prof_fun(3) = 0.8; 

  % Consumer theta 2 (theta2) %
  prof_fun(4) = 0.5;

  % Psi %
  prof_fun(5) = 1;

  % Utility of outside option %
  prof_fun(6) = 0.0;

  % Marginal cost parameter 1 %
  prof_fun(7) = 0.5;

  % Marginal cost parameter 2 %
  prof_fun(8) = 0.0;

  % Fixed cost %
  prof_fun(9) = 0.0;

  % Initial prices %
  prof_fun(10) = (prof_fun(2)+prof_fun(4)*prof_fun(7))/(1+prof_fun(4));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Ipopt parameters            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  % Lower bound on prices
  prof_fun_ipopt(1) = 0;

  % Upper bound on prices
  prof_fun_ipopt(2) = prof_fun(2);

