/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MTLMATRIX3D_H
#define MTLMATRIX3D_H

#include<matrixMTL.h>
#include<vectorMTL.h>

namespace MTL {

/**
	@author Jeziorski, Weintraub, Benkard and Van Roy <przemekj@stanford.edu>
*/
template <class T>
class MatrixMTL3D{
private: 
    int height, length, deep;
    MatrixMTL<T> **data;
public:
    inline MatrixMTL3D(const int heightInput, const int lengthInput, const int deepInput) {
      height = heightInput;
      length = lengthInput;
      deep = deepInput;

      data = new MatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new MatrixMTL<T>(height,length);
      }
    }

    MatrixMTL3D(const MatrixMTL3D<T> &input) {
      height = input.height;
      length = input.length;
      deep = input.deep;

      data = new MatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new MatrixMTL<T>(height,length);
        *(data[i]) = *(input[i]); 
      }
    }

   MatrixMTL3D(const int heightInput, const int lengthInput, const int deepInput, const MatrixMTL<T> &input) {
      height = heightInput;
      length = lengthInput;
      deep = deepInput;

      data = new MatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new MatrixMTL<T>(height,length);
        *(data[i]) = input;
      }
   }

   inline MatrixMTL<T> &operator[](const int input) {
     return *(data[input]);
   }

   ~MatrixMTL3D() {
     for(int i=0;i<deep;i++) {
       delete data[i];
     }
     delete[] data;
   }

   int getDeep() {
     return deep;
   }
};

}

#endif
