/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rangenlib.h"

RanGenLib::RanGenLib() {
  struct timeval t1;
  
  gettimeofday(&t1, 0);

  srand48(t1.tv_sec);
}

int RanGenLib::genPoisson(double lambda) {
  if(lambda<25) {
    double U = genUniform();
    double p=exp(-lambda);
    int j=0;
    double F=p;
    while (U>F) {
      p*=lambda/(j+1);
      F+=p;
      j++;
    }
    return j;
  } else {
    int temp;
    return (temp=(int(lambda+sqrt(-2*lambda*log(genUniform()))*cos(6.28318531*genUniform()))))>0 ? temp : 0;
  }
}

double RanGenLib::genNormal(double mean, double variance) {
  return mean+sqrt(-2*variance*log(genUniform()))*cos(6.28318531*genUniform());
}

RanGenLib::~RanGenLib() {
}
