/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SPARSEMATRIXMTL3D__H
#define SPARSEMATRIXMTL3D__H

#include<sparsematrixMTL.h>

namespace MTL {

/**
	@author Jeziorski, Weintraub, Benkard and Van Roy <przemekj@stanford.edu>
*/

template<class T>
class SparseMatrix3D{
public:
private: 
    int deep;
    SparseMatrixMTL<T> **data;
public:
    inline SparseMatrix3D(const int deepInput) {
      deep = deepInput;

      data = new SparseMatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new SparseMatrixMTL<T>;
      }
    }

    SparseMatrix3D(const SparseMatrix3D<T> &input) {
      deep = input.deep;

      data = new SparseMatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new SparseMatrixMTL<T>;
        *(data[i]) = *(input.data[i]); 
      }
    }

   SparseMatrix3D(const int deepInput, const int x, const int y, const int z) {
     deep = deepInput;
     data = new SparseMatrixMTL<T>*[deep];
     for(int i=0;i<deep;i++) {
       data[i] = new SparseMatrixMTL<T>(x,y,z);
     }
   }

   SparseMatrix3D(const int deepInput, const SparseMatrixMTL<T> &input) {
      deep = deepInput;

      data = new SparseMatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new SparseMatrixMTL<T>(input);
      }
   }

   inline SparseMatrixMTL<T> &operator[](const int input) {
     return *(data[input]);
   }

   ~SparseMatrix3D() {
     for(int i=0;i<deep;i++) {
       delete data[i];
     }
     delete[] data;
   }

   int getDeep() {
     return deep;
   }
};

}

#endif
