/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MTLTRIDIAGMATRIX3D_H
#define MTLTRIDIAGMATRIX3D_H
#include<tridiagmatrix.h>
namespace MTL {

/**
	@author Jeziorski, Weintraub, Benkard and Van Roy <przemekj@stanford.edu>
*/
template<class T>
class TriDiagMatrix3D{
public:
private: 
    int size, deep;
    TriDiagMatrixMTL<T> **data;
public:
    inline TriDiagMatrix3D(const int sizeInput, const int deepInput) {
      size = sizeInput;
      deep = deepInput;

      data = new TriDiagMatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new TriDiagMatrixMTL<T>(size);
      }
    }

    TriDiagMatrix3D(const TriDiagMatrix3D<T> &input) {
      size = input.size;
      deep = input.deep;

      data = new MatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new MatrixMTL<T>(size);
        *(data[i]) = *(input[i]); 
      }
    }

   TriDiagMatrix3D(const int sizeInput, const int deepInput, const TriDiagMatrixMTL<T> &input) {
      size = sizeInput;
      deep = deepInput;

      data = new TriDiagMatrixMTL<T>*[deep];
      for(int i=0;i<deep;i++) {
        data[i] = new TriDiagMatrixMTL<T>(size);
        *(data[i]) = input;
      }
   }

   inline TriDiagMatrixMTL<T> &operator[](const int input) {
     return *(data[input]);
   }

   ~TriDiagMatrix3D() {
     for(int i=0;i<deep;i++) {
       delete data[i];
     }
     delete[] data;
   }
};

}

#endif
