/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include<compoe.h>

#if TRANSITION_MATRIX == 1


/** \file src/compoe/optimalInvestment.cpp 
  Chooses optimal investment for given parametes and
  transition process

  \param Vold Value function
  \param d Precomputed vector of of investment costs for each state
*/ 

VectorMTL<double> CompOE::optInv(VectorMTL<double> &Vold, VectorMTL<double> &d) {
  VectorMTL<double> output(xmax);
  VectorMTL<double> difV(xmax);
  double temp;

//  cout << Vold;
//  getchar(); 

  difV[0]=(Vold[1]-Vold[0])*(1-transition[1]);
  if(difV[0]<0) { 
       difV[0]=0;
  }

  for (int i=1;i<xmax-1;i++) {
    difV[i]=Vold[i+1]*(1-transition[1])+Vold[i]*(2*transition[1]-1)-Vold[i-1]*transition[1];
    if(difV[i]<0) { 
       difV[i]=0;
    }
  }
  difV[xmax-1]=(Vold[xmax-1]-Vold[xmax-2])*transition[1];
  if(difV[xmax-1]<0) { 
       difV[xmax-1]=0;
  }

  for (int i=0;i<xmax; i++) {
    if (difV[i]>0) {
      temp=(sqrt(transition[2]*constants[2]*difV[i]/d[i])-1)/transition[2];
      output[i] = (temp>0) ? temp : 0;
    } else {
      output[i]=0;
    }
  } 
  return output;
}

#endif
