/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/** \file src/compoe/transitionMatrixTridiagonal.cpp 
  Implementation of the transition matrix and
  transition matrix conditional on not exiting.
  Implement this file of you are using tri-diagonal matrix 
  solver i.e. you have #define TRANSITION_MATRIX 1 in setup.h
  Solver uses tridiagonal version of LU decomposition to invert this matrix

  \param iota Investment function
  \param tranMatrix Output transition matrix
  \param contTranMatrix Output conditional transition matrix
  \param contProbVector Probabilities of not exiting
*/ 

#include<compoe.h>

void CompOE::tranProb(VectorMTL<double> &iota, TriDiagMatrixMTL<double> &tranMatrixMTL, TriDiagMatrixMTL<double> &contTranMatrix, VectorMTL<double> &contProbVector) {

  VectorMTL<double> prup(xmax);
  VectorMTL<double> prsame(xmax);
  VectorMTL<double> prdown(xmax);
  VectorMTL<double> aiota(xmax);

  aiota=iota*transition[2];

  for (int i=0;i<xmax;i++) {
    prup[i]=(aiota[i]*(1-transition[1]))/(aiota[i]+1);           		// prob. going up one state
    prsame[i]=(aiota[i]*transition[1]+(1-transition[1]))/(aiota[i]+1);  	// prob. stay in same state 
    prdown[i]=transition[1]/(aiota[i]+1);					// prob. go down one state

//    prup[i]=MIN(prup[i]+0.1,0.9);
//    prdown[i]=MIN(MIN(prdown[i]+0.1,1-prup[i]),0.9);
//    prsame[i]=1-prup[i]-prdown[i];
  }
  prsame[xmax-1]=1-prdown[xmax-1];        // At state xmax can't go up
  prsame[0]=1-prup[0];                    // At state 1 can't go down

/* Using probs. to build matrix of transition probs. */
/* In the same time build matrix for contiunuing in the industry */

/* Create first row */
  tranMatrixMTL[0][0]=prsame[0];
  tranMatrixMTL[-1][0]=prup[0];

  contTranMatrix[0][0]=prsame[0]*contProbVector[0];
  contTranMatrix[-1][0]=prup[0]*contProbVector[0];

/* Create middle rows */
  for (int i=1; i<xmax-1; i++) {
    tranMatrixMTL[1][i-1]=prdown[i];
    tranMatrixMTL[0][i]=prsame[i];
    tranMatrixMTL[-1][i]=prup[i];

    contTranMatrix[1][i-1]=prdown[i]*contProbVector[i];
    contTranMatrix[0][i]=prsame[i]*contProbVector[i];
    contTranMatrix[-1][i]=prup[i]*contProbVector[i];
  }

/* Create last row */
  if (xmax>1) {
    tranMatrixMTL[1][xmax-2]=prdown[xmax-1];
    tranMatrixMTL[0][xmax-1]=prsame[xmax-1];

    contTranMatrix[1][xmax-2]=prdown[xmax-1]*contProbVector[xmax-1];
    contTranMatrix[0][xmax-1]=prsame[xmax-1]*contProbVector[xmax-1];
  }
}
