/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "compoe.h"
void *thread_function(void *);

CompOE::CompOE() {
  xmax = 0;
  method = 0;
  ignore=2;
  V_global = NULL;
  iota_global = NULL;
  rho_global = NULL;
  tildes_global = NULL;
  prices_global = NULL; 
  prof_global = NULL;
  prcont1=NULL;

  bound1por = NULL;

  bound2avg = NULL;
  bound2pre = NULL;
  bound2var = NULL;
  bound2por = NULL;

  bound3avg = NULL;
  bound3pre = NULL;
  bound3var = NULL;
  bound3por = NULL;

  bound4avg = NULL;
  bound4pre = NULL;
  bound4var = NULL;
  bound4por = NULL;

  bound5avg = NULL;
  bound5pre = NULL;
  bound5var = NULL;
  bound5por = NULL;

  firmsnumberavg=NULL;
  firmsnumbervar=NULL;
  firmsnumberpre=NULL;
  firmsnumberpor=NULL;

  prodsuravg_path = NULL; prodsurpre_path = NULL; prodsurvar_path = NULL; 
  conssuravg_path = NULL; conssurpre_path = NULL; conssurvar_path = NULL; 
  totalsuravg_path = NULL; totalsurpre_path = NULL; totalsurvar_path = NULL; 
  c1avg_path = NULL; c1pre_path = NULL; c1var_path = NULL; 
  c4avg_path = NULL; c4pre_path = NULL; c4var_path = NULL; 
  c2avg_path = NULL; c2pre_path = NULL; c2var_path = NULL; 
  c10avg_path = NULL; c10pre_path = NULL; c10var_path = NULL; 
  c20avg_path = NULL; c20pre_path = NULL; c20var_path = NULL; 
  hhi50avg_path = NULL, hhi50pre_path = NULL, hhi50var_path = NULL; 
  entrateavg_path = NULL; entratepre_path = NULL; entratevar_path = NULL; 
  exirateavg_path = NULL; exiratepre_path = NULL; exiratevar_path = NULL; 
  msexitavg_path = NULL; msexitpre_path = NULL; msexitvar_path = NULL; 
  invavg_path = NULL; invpre_path = NULL; invvar_path = NULL; 

  firmsnumberavg_path = NULL; firmsnumberpre_path = NULL; firmsnumbervar_path = NULL; firmsnumberpor_path = NULL;

  #ifdef ACW
    action_profit = NULL;
    acwTran = NULL;
    RHSFringe = NULL;
  #endif
}

int CompOE::sample_constentr(RanGenLib &rnd, double lambda_local, MatrixMTL<double> &Prob, 
  double p,VectorMTL<double> &state) {

  VectorMTL<double> temp(state.getSize());
  int height=Prob.getHeight();
  int num_entr=0;
  state=0;
  for(int k=0;k<height;k++) {
    if(rnd.genUniform()<=p) {
      num_entr=int(floor(lambda_local));
    } else {
      num_entr=int(ceil(lambda_local));
    }
    temp = Prob.getRow(k);
    temp.genFixed(rnd, temp, num_entr);
    state+=temp;
  }
  return num_entr;
}

void CompOE::condToNoncondTranProb(TriDiagMatrixMTL<double> &tranMatrixMTL,TriDiagMatrixMTL<double> &contTranMartix,
    VectorMTL<double> &contProbVector) {

    /* Create first row */
    contTranMartix[0][0]=tranMatrixMTL[0][0]*contProbVector[0];
    contTranMartix[-1][0]=tranMatrixMTL[-1][0]*contProbVector[0];

//     /* Create middle rows */
    for (int i=1; i<xmax-1; i++) {
      contTranMartix[1][i-1]=tranMatrixMTL[1][i-1]*contProbVector[i];
      contTranMartix[0][i]=tranMatrixMTL[0][i]*contProbVector[i];
      contTranMartix[-1][i]=tranMatrixMTL[-1][i]*contProbVector[i];
    }

    /* Create last row */
    if (xmax>1) {
      contTranMartix[1][xmax-2]=tranMatrixMTL[1][xmax-2]*contProbVector[xmax-1];
      contTranMartix[0][xmax-1]=tranMatrixMTL[0][xmax-1]*contProbVector[xmax-1];
    }
}

void CompOE::condToNoncondTranProb(MatrixMTL<double> &tranMatrixMTL, MatrixMTL<double> &contTranMartix,
    VectorMTL<double> &contProbVector) {

    for(int i=0;i<xmax;i++) {
      for(int j=0;j<xmax;j++) {
        contTranMartix[i][j]=tranMatrixMTL[i][j]*contProbVector[i];
      }
    }
}

void CompOE::condToNoncondTranProb(SparseMatrixMTL<double> &tranMatrixMTL, SparseMatrixMTL<double> &contTranMartix,
    VectorMTL<double> &contProbVector) {
    int size=tranMatrixMTL.getSize();

    for(int i=0;i<size;i++) {
      contTranMartix[i]=tranMatrixMTL[i]*contProbVector[tranMatrixMTL.rows[i]];
    }
}

#if TRANSITION_MATRIX == 0 
void CompOE::expState(MatrixMTL<double> &contTranMatrixMTL, VectorMTL<double> &tildes, 
  VectorMTL<double> &expfreq, VectorMTL<double> &d) {
#elif TRANSITION_MATRIX == 1 
void CompOE::expState(TriDiagMatrixMTL<double> contTranMatrixMTL, VectorMTL<double> &tildes, 
  VectorMTL<double> &expfreq, VectorMTL<double> &d) {
#elif TRANSITION_MATRIX == 2 
void CompOE::expState(SparseMatrixMTL<double> contTranMatrixMTL, VectorMTL<double> &tildes, 
  VectorMTL<double> &expfreq, VectorMTL<double> &d) {
#else 
    #error Invalid value for TRANSITION_MATRIX
#endif
  MatrixMTL<double> inv(xmax,xmax);

  // Variable number of firms
  if(control[2]==0) {
    MatrixMTL<double> temp(contTranMatrixMTL);
    contTranMatrixMTL.addDiag(-1.0);
    /* Compute the the inverse matrix */
    if(contTranMatrixMTL.inverse(inv)) {
      condNumber = norm(inv)*norm(contTranMatrixMTL);
    } else {
      condNumber = 0; // if LU fails set condition number to zero
      #ifdef DEBUG
        *myfile << "Tridiag LU failed when inverting for invariant distribution" <<endl;
      #endif

      #ifdef COUT_DEBUG
        cout << "Tridiag LU failed when inverting for invariant distribution" <<endl;
      #endif
    }
    if(condNumber>convtol[8]) {
/*      #ifdef DEBUG
        *myfile << "Ill-conditioned (" << condNumber << ") matrix for entry rate "<< lambda<< endl;
      #endif 

      #ifdef COUT_DEBUG
        cout << "Ill-conditioned (" << condNumber << ") matrix for entry rate "<< lambda<< endl;
      #endif
*/
      /*** if matrix is ill-conditioned, compute infinite sum ***/

      double r=(1/constants[2]-1)*100;       // interest rate
      double num_pers=5*convtol[9]/r;  // number of periods to sum: proportional to interest rate
      MatrixMTL<double> cumB(temp); // initialize the cumulative matrix
      inv=-cumB;
      inv.addDiag(-1.0); // First sum inv=-I-B
      for(int i=1;i<num_pers;i++) {
        cumB=cumB.dot(temp);
        inv-=cumB;
      }
    }

    /* extract columns */
    for(int i=0;i<xmax;i++) {
      expfreq[i]=-inv[int(constants[3])-1][i];
    }
  } else {  // no entry/no exit: compute invariant distr.
    /*condNumber = norm(inv)*norm(contTranMatrixMTL);*/
    contTranMatrixMTL.statDistr(expfreq);
    condNumber = 10;
  }
  tildes = expfreq * (double) lambda;
}

int CompOE::compProf(VectorMTL<double> &state, VectorMTL<double> &p0, 
  VectorMTL<double> &output) {
#ifndef ACW
  int xmax_prof=state.getSize();
  success = 1;
  if(ignore!=1) { 
    VectorMTL<double> temp(xmax_prof);
    VectorMTL<double> prices(xmax_prof);
    double tilden=sum(state);

    #ifndef USE_THREADS
    for (int i=0; i<xmax_prof; i++) {
      FunctionProfit profit(xmax_prof,xmax_prof);
      profit.initStructures(prof_fun, prof_fun_ipopt);
      temp.base(i);

      // Subtract extra firm only if needed

/*
      if(subtract==1) {
        if(tilden>1) {
          temp+=state-state/tilden;
        }
      } else {
        temp+=state;
      }
*/
      temp+=state;
      
      VectorMTL<double> profit_tmp(xmax_prof);
      VectorMTL<double> ms(xmax_prof);
      double cs,ps;
      success=MIN(profit.eval(temp,p0,profit_tmp,0,ms,cs,ps),success);

      output[i] = profit_tmp[i];
    }
    #else
      #if USE_THREADS != 0
        pthread_t thread_id[USE_THREADS];
        int p0_updated=0;
        for (int i=0; i<xmax_prof; i+=USE_THREADS) {
          int number_of_threads = (xmax_prof - i<USE_THREADS) ? xmax_prof - i : USE_THREADS; 
      #else
        pthread_t thread_id[xmax_prof];
        int number_of_threads = xmax_prof;
      #endif
           pthread_attr_t attr;

           pthread_attr_init(&attr);
           size_t stacksize;
//           pthread_attr_getstacksize (&attr, &stacksize);
//           pthread_attr_setstacksize(&attr, 10*stacksize);
           pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_JOINABLE);

           ThreadStructure *input = new ThreadStructure[number_of_threads];
           for(int j=0; j<number_of_threads; j++) {
             VectorMTL<double> *price = new VectorMTL<double>(xmax_prof);
             (*price) = p0;
             VectorMTL<double> *state1 = new VectorMTL<double>(xmax_prof);
             #if USE_THREADS == 0
             state1->base(j);
             #else
             state1->base(i+j);
             #endif

/*
             if(subtract==1) {
               if(tilden>1) {
                 (*state1)+=state-state/tilden;
               }
             } else {
               (*state1)+=state;
             }
*/
             *state1+=state;

             input[j].state = state1;
             #if USE_THREADS == 0
               input[j].number = j;
             #else
               input[j].number = i+j;
             #endif
             input[j].prof_fun = prof_fun;
             input[j].prof_fun_ipopt = prof_fun_ipopt;
             input[j].p0 = price;
             pthread_create(&thread_id[j], &attr, thread_function, (void *) &input[j] );
           }
           pthread_attr_destroy(&attr);


           for(int k=0; k<number_of_threads; k++) {
             pthread_join(thread_id[k], NULL); 
           }

           /*** Update startup prices to be prices at the mid-state ***/

           #if USE_THREADS == 0
             p0 = *(input[int(xmax_prof/2)].p0);
           #else
             if((i>=double(xmax_prof/2)) && (p0_updated==0)) {
               p0 = *(input[0].p0);
               p0_updated=1;
             }
           #endif
           for(int k=0; k<number_of_threads; k++) {
//             cout << input[k].success;
             success = MIN(input[k].success,success);
             delete input[k].p0;
             delete input[k].state;
             output[input[k].number]=input[k].output;
           }

           delete[] input;
      #if USE_THREADS != 0
        }
      #endif
    #endif
  } else {
    FunctionProfit profit(xmax_prof,xmax_prof);
    profit.initStructures(prof_fun,prof_fun_ipopt);
    VectorMTL<double> ms(xmax_prof);
    double cs,ps;
    success=profit.eval(state,p0,output,0,ms,cs,ps);
  }
#else // Collard-Wexler world
    VectorMTL<double> temp(xmax);
    int actions=constants[6];
    for(int a=0;a<actions;++a) {
      for(int x=0;x<xmax;++x) { // xmax includes exit state
//        temp=state;
        double ncomp;
        double ncomp2;
        // Subtract extra firm only if needed
        double tilden=sum(state);
//        temp.base(x);
        temp=0;
/* 
        if(subtract==1) {
          if(tilden>1) {
            temp+=state-state/tilden;
          }
        } else {
          temp+=state;
        }
*/

        // State does not include you
        ncomp=(sum(temp)-temp[xmax-1]);
        // If it's fringe and you are active, subtract a competitor        
//        if((x<xmax-1) && (subtract==1)) {
//          ncomp--;
//        }
        //ncomp2=(sum(temp)-temp[xmax-1])/3+8*temp[xmax-2];
        ncomp2=ncomp;

        (*action_profit)[a][x]=prof_fun[a]+                           // Fixed cost
                        prof_fun[actions+a]*constants[8]+             // Demand shifter
                        prof_fun[2*actions+a]*MIN(ncomp,1)*(ncomp>0)+ // First competitor
                        transition[x*actions+a];                      // Transition cost/entry
        if(ncomp>1)
          (*action_profit)[a][x]+=prof_fun[3*actions+a]*log(ncomp2); // Log competitors above 1
      }
    }
    success=1;
  #endif

  return success;
}

int CompOE::compProfAndStats(VectorMTL<double> &state, VectorMTL<double> &prices, VectorMTL<double> 
  &pricesOutput, VectorMTL<double> &output, VectorMTL<double> &msOutput, 
  double &prodsurOutput, double &conssurOutput) {

  int xmax_prof=state.getSize();

  FunctionProfit profit(xmax_prof,xmax_prof);

  profit.initStructures(prof_fun, prof_fun_ipopt);

  pricesOutput=prices;
  success=profit.eval(state,pricesOutput,output,1,msOutput,prodsurOutput,conssurOutput);
  double cs,ps;
  VectorMTL<double> ms(xmax_prof);
  VectorMTL<double> temp(xmax_prof);

  for (int i=0; i<xmax_prof; i++) {
    temp.base(i);
    temp+=state;
    VectorMTL<double> profit_tmp(xmax_prof);
    if(profit.eval(temp,prices,profit_tmp,0,ms,cs,ps)==0) {
      success=0;
    }
    output[i]=profit_tmp[i];
  }

  return success;
}

int CompOE::compProfAndStats_extra(VectorMTL<double> &state, VectorMTL<double> &prices, VectorMTL<double>
  &pricesOutput, VectorMTL<double> &output, VectorMTL<double> &msOutput,
  double &prodsurOutput, double &conssurOutput) {
  
  #ifndef ACW
  int xmax_prof=state.getSize();

  FunctionProfit profit(xmax_prof,xmax_prof);

  profit.initStructures(prof_fun, prof_fun_ipopt);

  pricesOutput=prices;
  success=profit.eval(state,pricesOutput,output,1,msOutput,prodsurOutput,conssurOutput);
  /*cout << sum(msOutput) << endl;
  cout << msOutput;
  cout << state;getchar();*/
  #else
  msOutput=0;
  prodsurOutput=0;
  conssurOutput=0;
  output=0;
  pricesOutput=0;
  #endif
  return success;
}

int CompOE::compProfAndStats_vector(VectorMTL<double> &state, VectorMTL<double> &prices, VectorMTL<double>
  &pricesOutput, VectorMTL<double> &output, MatrixMTL<double> &msOutput,
  VectorMTL<double> &prodsurOutput, VectorMTL<double> &conssurOutput) {

  int xmax_prof=state.getSize();

  FunctionProfit profit(xmax_prof,xmax_prof);

  profit.initStructures(prof_fun, prof_fun_ipopt);

  double cs,ps;
  VectorMTL<double> ms(xmax_prof);
  VectorMTL<double> temp(xmax_prof);
  double tilden=sum(state);

  for (int i=0; i<xmax_prof; i++) {
    temp.base(i);
    temp+=state-state/tilden;
    VectorMTL<double> profit_tmp(xmax_prof);
    if(profit.eval(temp,prices,profit_tmp,0,ms,conssurOutput[i],prodsurOutput[i])==0) {
      success=0;
    }
    output[i]=profit_tmp[i];
    pricesOutput[i]=prices[i];
    for(int j=0; j<xmax_prof; j++) {
      msOutput[i][j]=ms[j];
    }
  }

  return success;
}

#if TRANSITION_MATRIX == 0
void CompOE::valueIt(VectorMTL<double> &profit, VectorMTL<double> &iota, 
  VectorMTL<double> &rho, VectorMTL<double> &Vnew, MatrixMTL<double> &tranmat, 
  VectorMTL<double> &prcont, VectorMTL<double> &d, VectorMTL<double> &condexp) {

  MatrixMTL<double> conttranmat(xmax,xmax);
#elif TRANSITION_MATRIX == 1
void CompOE::valueIt(VectorMTL<double> &profit, VectorMTL<double> &iota, 
  VectorMTL<double> &rho, VectorMTL<double> &Vnew, TriDiagMatrixMTL<double> &tranmat, 
  VectorMTL<double> &prcont, VectorMTL<double> &d, VectorMTL<double> &condexp) {

  TriDiagMatrixMTL<double> conttranmat(xmax);
#elif TRANSITION_MATRIX == 2
void CompOE::valueIt(VectorMTL<double> &profit, VectorMTL<double> &iota, 
  VectorMTL<double> &rho, VectorMTL<double> &Vnew, SparseMatrixMTL<double> &tranmat, 
  VectorMTL<double> &prcont, VectorMTL<double> &d, VectorMTL<double> &condexp) {

  SparseMatrixMTL<double> conttranmat;
#else 
  #error Invalid value for TRANSITION_MATRIX
#endif
  VectorMTL<double> Vold(xmax);
  double Norm=1;
  int i=0;
  #ifndef ACW
  Vnew=profit/(1-constants[2])+transition[0];
  #else
  Vnew=0;
  #endif
  prcont = 0;
  while (Norm > convtol[0]) {

    i++; 
    if(i>1000) {
      cout << "Value iteration hit maximum" << endl;
      break;
    }
    Vold=Vnew;
    #ifndef ACW
      /*** Compute optimal investment ***/
      iota = optInv(Vold,d);

//      for(int x=0;x<xmax;++x) {
//        iota[x] = MAX(iota[x],1e-8);
//      }

      /*** Compute transition probabilities ***/
      tranProb(iota,tranmat,conttranmat,prcont);

//    cout << tranmat << endl;
//    getchar();
      /*** Compute continuation values if not exiting ***/
      rho = (-iota*d) + ((tranmat.dot(Vold))*constants[2]);

      /*** Compute continuation probs. and conditional expectation sell-off ***
      /*** value, conditional on exiting                                    ***/
      continuationProb(rho,prcont,condexp);
      /*** Update value function ***/
      Vnew = profit + (-prcont+1.0)*condexp+prcont*rho;
    #else
      (*RHSFringe)[0]=0;
      for(int x=0;x<xmax;++x) {
        for(int a=0;a<constants[6]-1;++a) {
          (*RHSFringe)[0][x][a]=((*action_profit)[a][x]+constants[2]*Vold[(*acwTran)[a][x]]);
        }
        Vnew[x] = 0;
        for(int a=0;a<constants[6];++a) {
          Vnew[x] += exp((*RHSFringe)[0][x][a]/constants[7]);
        }
        Vnew[x] = constants[7]*(log(Vnew[x])+0.577215665);
      }
      Vnew[xmax-1]=0;
    #endif
    Norm = norm(Vnew-Vold);
  }
  // Compute transition martix for ACW
  #ifdef ACW
    iota = 0;
    rho = 0;
    tranProbACW((*RHSFringe)[0],tranmat);
    conttranmat=tranmat;
    prcont = 1;
  #endif
}

int CompOE::fpstrat(VectorMTL<double> &iota1, VectorMTL<double> &rho1, VectorMTL<double> &V1,
  VectorMTL<double> &prof, VectorMTL<double> &expfreq, VectorMTL<double> &tildes, 
  VectorMTL<double> &d, VectorMTL<double> &p0) {

  int n=1;
  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> tranmat0(xmax,xmax);
    MatrixMTL<double> tranmat1(xmax,xmax);
    MatrixMTL<double> conttranmat(xmax,xmax);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranmat0(xmax);
    TriDiagMatrixMTL<double> tranmat1(xmax);
    TriDiagMatrixMTL<double> conttranmat(xmax);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> tranmat0;
    SparseMatrixMTL<double> tranmat1;
    SparseMatrixMTL<double> conttranmat;
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif
  VectorMTL<double> iota0(xmax);
  VectorMTL<double> rho0(xmax);
  VectorMTL<double> prcont0(xmax);
  VectorMTL<double> condexp(xmax);

  continuationProb(rho1,*prcont1,condexp);
  tranProb(iota1,tranmat1,conttranmat,*prcont1);

  iota0=0;
  rho0=0;
  V1=0;

  #ifdef ACW
  *action_profit=0;
  tranProbACW((*RHSFringe)[0],tranmat1);
  #endif
  while(1) {
    /* smooth update of strategies */
    #ifndef ACW
    iota0=iota1/(pow(n,convtol[10]))+iota0*(1-1/(pow(n,convtol[10])));
    rho0=rho1/(pow(n,convtol[10]))+rho0*(1-1/(pow(n,convtol[10])));

    continuationProb(rho0,prcont0,condexp);
    tranProb(iota0,tranmat0,conttranmat,prcont0);
    #else
    prcont0=1;
    tranmat0=tranmat1/(pow(n,convtol[10]))+tranmat0*(1-1/(pow(n,convtol[10])));
//    cout << tranmat0;
//    cout << "------------\n";
//    cout << tranmat1;
    conttranmat=tranmat0;
    
    #endif
    expState(conttranmat, tildes, expfreq, d);
    /*conttranmat.statDistr(prcont0);
    cout << prcont0;
    cout << tildes;*/

    VectorMTL<double> tildessub(xmax);
    tildessub=tildes;
    if(subtract==1) {
      if((control[2]==0) && (control[1]==1)) { // Poisson
        for(int x=0;x<xmax;++x) {
          tildessub[x]=tildessub[x]/(1-exp(-tildessub[x]))-1;
        }
      } else {
        double tildesn=sum(tildessub);
        if(tildesn>1) {
          tildessub-=(tildessub/tildesn);
        }
      }
    }
    if(ignore<3) {
      if(!compProf(tildessub,p0,prof)) {
        return 0;
      }
    } else {
      RanGenLib P;
      srand48(634856435);

      prof=0;
      VectorMTL<double> prof_draw(xmax);
      VectorMTL<double> state(xmax);
      VectorMTL<double> sta_distr(xmax);

      sta_distr=tildes/control[2];
      cout << sta_distr;
#ifdef ACW
      // In the ACW model simulate all firms and subtract only if active
      MatrixMTL<double> action_profit_temp(constants[6],xmax);
      action_profit_temp=0;
#endif
      for(int r=0;r<1e4;++r) {
#ifdef ACW
        state.genFixed(P,sta_distr,int(control[2])-1);
        subtract=0;
#else
        state.genFixed(P,sta_distr,int(control[2])-1);
        subtract=0;
#endif
        if(!compProf(state,p0,prof_draw)) {
          return 0;
        }
#ifdef ACW
        action_profit_temp+=(*action_profit);
#endif 
        subtract=control[4];
        prof+=prof_draw;
      }
      prof/=1e4;
#ifdef ACW
      (*action_profit)=action_profit_temp/1e4;
#endif
    }
//    cout << tildes;getchar();


    valueIt(prof, iota1, rho1, V1, tranmat1, *prcont1, d, condexp);
//    cout << V1;
//    getchar();


//    if((((n-100)/100)<(n/100)) || (n==1)) {
      if(1) {
      #ifdef DEBUG
        *myfile << "    fpstrat iteration: " << n << " (" << diffNorm(*prcont1,prcont0) << ")" << 
          "(" << diffNorm(tranmat1,tranmat0)<< ")" << endl;
      #endif
      #ifdef COUT_DEBUG
        cout << "    fpstrat iteration: " << n << " (" << diffNorm(*prcont1,prcont0) << "," << 
          diffNorm(tranmat1,tranmat0)<< ")" << endl;
      #endif
    }

    n++;

    if ( (diffNorm(*prcont1,prcont0)<convtol[1]) && (diffNorm(tranmat1,tranmat0)<convtol[1]) ) {
        break;
    } else if(n>=convtol[2]) {
	      success=0;
        break;
    }
  }

//  cout << tranmat0;
//  cout << *action_profit;
//  cout << "------------------------\n";
  return 1;
}

void CompOE::fpstratxmax(VectorMTL<double> *&iota, VectorMTL<double> *&rho, VectorMTL<double> *&V, VectorMTL<double> *&prof, VectorMTL<double> *&tildes, VectorMTL<double> *&d, VectorMTL<double> *&prices) {

  VectorMTL<double> *expfreq = new VectorMTL<double>(xmax);
  while(1) {
    if(method==0) {
      fpstrat(*iota, *rho, *V, *prof, *expfreq, *tildes, *d, *prices);
    } else {
      fpstrat_gauss_seidel(*iota, *rho, *V, *prof, *expfreq, *tildes, *d, *prices);
    }

    if(lambda==-1) break;

    if((*expfreq)[xmax-1]>convtol[3] && xmax<convtol[11]) {
        xmax+=int(convtol[4]);
        iota->newSize(xmax,(*iota)[xmax-1-int(convtol[4])]);
        rho->newSize(xmax,(*rho)[xmax-1-int(convtol[4])]);
        delete V;
        V = new VectorMTL<double>(xmax);
        delete prof;
        prof = new VectorMTL<double>(xmax);
        prices->newSize(xmax,(*prices)[xmax-1-int(convtol[4])]);
        delete expfreq;
        expfreq = new VectorMTL<double>(xmax);
        delete tildes;
        tildes = new VectorMTL<double>(xmax);
        delete prcont1;
        prcont1 = new VectorMTL<double>(xmax);

        #ifdef DEBUG
	  (*myfile) << "   update xmax: " << xmax << endl;
        #endif

        #ifdef COUT_DEBUG
	  cout << "   update xmax: " << xmax << endl;
        #endif

        VectorMTL<double> *oldd;
        oldd = d;
        d = new VectorMTL<double>(xmax);
        for(int i=0;i<xmax-int(convtol[4]);i++) {
          (*d)[i]=(*oldd)[i];
        }
        for(int i=xmax-int(convtol[4]);i<xmax;i++) {
          (*d)[i]=MACRO__MINVCOST(i);
        }
        delete oldd;
    } else { 
        break;
    }
  }
  delete expfreq;
}
 
int CompOE::compute(int &xmaxInit, VectorMTL<double> &rhoInit, VectorMTL<double> &iotaInit) {
  xmax = xmaxInit;

  if (iota_global!=NULL) delete iota_global;
  if (rho_global!=NULL) delete rho_global;
  if (V_global!=NULL) delete V_global;
  if (prices_global!=NULL) delete prices_global;
  if (tildes_global!=NULL) delete tildes_global;
  if (prof_global!=NULL) delete prof_global;
  if (prcont1!=NULL) delete prcont1;

  #ifdef COUT_DEBUG
    cout << setprecision(4);
  #endif

  #ifdef DEBUG
    *myfile << setprecision(4);
  #endif

  VectorMTL<double> *V = new VectorMTL<double>(xmax);
  VectorMTL<double> *iota = new VectorMTL<double>(xmax);
  VectorMTL<double> *rho = new VectorMTL<double>(xmax);
  VectorMTL<double> *prof = new VectorMTL<double>(xmax);
  VectorMTL<double> *prices = new VectorMTL<double>(xmax);
  VectorMTL<double> *tildes = new VectorMTL<double>(xmax);
  prcont1 = new VectorMTL<double>(xmax);
  *prcont1 = 0;

  subtract=control[4];
  
  // action specific profit function in the Collard-Wexler model
  #ifdef ACW
    if (action_profit!=NULL) delete action_profit;
    action_profit = new MatrixMTL<double>(constants[6],xmax);

    if (acwTran!=NULL) delete acwTran;
    acwTran = new MatrixMTL<int>(constants[6],xmax);
    // State: 0 - S, 1-SM, 2-SL, 3-M, 4-ML, 5-L, 6-Out
    // Actions: 0 - S, 1 - M, 2 - L, 3-Out
    (*acwTran)[0][0]=0; (*acwTran)[1][0]=3; (*acwTran)[2][0]=5; (*acwTran)[3][0]=6;
    (*acwTran)[0][1]=1; (*acwTran)[1][1]=3; (*acwTran)[2][1]=5; (*acwTran)[3][1]=6;
    (*acwTran)[0][2]=2; (*acwTran)[1][2]=4; (*acwTran)[2][2]=5; (*acwTran)[3][2]=6;
    (*acwTran)[0][3]=1; (*acwTran)[1][3]=3; (*acwTran)[2][3]=5; (*acwTran)[3][3]=6;
    (*acwTran)[0][4]=2; (*acwTran)[1][4]=4; (*acwTran)[2][4]=5; (*acwTran)[3][4]=6;
    (*acwTran)[0][5]=2; (*acwTran)[1][5]=4; (*acwTran)[2][5]=5; (*acwTran)[3][5]=6;
    (*acwTran)[0][6]=0; (*acwTran)[1][6]=3; (*acwTran)[2][6]=5; (*acwTran)[3][6]=6;

    if (RHSFringe!=NULL) delete RHSFringe;
    RHSFringe = new MatrixMTL3D<double>(xmax,constants[6],1);
    (*RHSFringe)[0]=0;
  #endif

  for(int i=0;i<xmax;i++) {
      (*prices)[i]=MACRO__MARGINAL_COST(i)+1e-2;
//      cout << MACRO__MARGINAL_COST(i) << endl;
  }
  *iota = iotaInit;
  *rho = rhoInit;

  cout <<  iotaInit;

  lambda = init[3];

  /* Precompute marginal cost */
  VectorMTL<double> *d = new VectorMTL<double>(xmax);
  for(int i=0;i<xmax;i++) {
    (*d)[i]=MACRO__MINVCOST(i);
  }
/*
  ignore=1;
  /////////////// TEST
  VectorMTL<double> xx(xmax);
  xx=0;
  xx[0]=7.1433;
  xx[1]=0.0518;
  xx[2]=0.0781;
  xx[3]=0.1236;
  xx[4]=0.1694;
  xx[5]=0.1926;
  xx[6]=0.1600;
  xx[7]=0.0812;
  double prodsur_xx, conssur_xx;
  VectorMTL<double> prices_xx(xmax), profit_xx(xmax), ms_xx(xmax);
  prices_xx=1;
  compProfAndStats_extra(xx,prices_xx,prices_xx,profit_xx,ms_xx,prodsur_xx,conssur_xx);
  cout << endl << profit_xx;
  cout << prodsur_xx << endl;
  cout << conssur_xx << endl;
  getchar();
  xx=0;
  xx[0]=7.663;
  xx[1]=0.0238;
  xx[2]=0.0332;
  xx[3]=0.0504;
  xx[4]=0.0674;
  xx[5]=0.0729;
  xx[6]=0.0589;
  xx[7]=0.0296;
  prices_xx=1;
  compProfAndStats_extra(xx,prices_xx,prices_xx,profit_xx,ms_xx,prodsur_xx,conssur_xx);
  cout << profit_xx;
  cout << prodsur_xx << endl;
  cout << conssur_xx << endl;
  getchar();
  return 0;
*/

  int uignore;
  if(control[0]>10) {
    control[0]-=10;
    uignore=3;
  } else {
    uignore=2;
  }
  
  // Variable number of firms
  if(control[2]==0) {
    if(method==0) {
      double lambda1 = init[3];
      double lambda2 = init[4];

      /**************************************************************
       * Bisection method to find OE (satisfy zero profit function) *
       **************************************************************/
      for (ignore = int(control[0]); ignore<=uignore; ignore++) {
        #ifdef DEBUG
          if (ignore==3) {
            (*myfile) << "\n  Recompute with simulated profit function" << endl;
          } else if (ignore==2) {
            (*myfile) << "\n  Recompute with actual profit function" << endl;
          } else {
            (*myfile) << "  Compute with approximated profit function" <<endl;
          }
        #endif

        #ifdef COUT_DEBUG
          if (ignore==3) {
            cout << "\n  Recompute with simulated profit function" << endl;
          } else if (ignore==2) {
            cout << "\n  Recompute with actual profit function" << endl;
          } else {
            cout << "  Compute with approximated profit function" <<endl;
          }
        #endif

        /*** Check the endpoints ***/
        #ifdef DEBUG
          *myfile << endl<< "Check the left endpoint"<< endl<<endl;
        #endif

        #ifdef COUT_DEBUG
          cout << endl<< "Check the left endpoint"<< endl<<endl;
        #endif


        int check_right = 1;
        while(1) {
          lambda=lambda1;
          #ifdef DEBUG
            (*myfile) << "  OE calculations for entry rate "<< lambda 
               <<", range ("<< lambda1<<","<<lambda2<<"), "<<xmax << endl;
          #endif

          #ifdef COUT_DEBUG
            cout << "  OE calculations for entry rate "<< lambda 
               <<", range ("<< lambda1<<","<<lambda2<<"), "<<xmax << endl;
          #endif
          fpstratxmax(iota, rho, V, prof, tildes, d, prices);

          #ifdef DEBUG
            (*myfile) << "  Zero profit condition: " << constants[2]*(*V)[int(constants[3])-1]-constants[0] << endl << endl;
          #endif

          #ifdef COUT_DEBUG
            cout << "  Zero profit condition: " << constants[2]*(*V)[int(constants[3])-1]-constants[0] << endl << endl;
          #endif

          #ifdef OE_TEST
            break;
          #endif

          if(constants[2]*(*V)[int(constants[3])-1]-constants[0]<0 && lambda1>convtol[12] ) {
            #ifdef DEBUG
              *myfile << "  Extending left endpoint of interval entry rate at " << lambda1 << endl;
            #endif
            #ifdef COUT_DEBUG
              cout << "  Extending left endpoint of interval entry rate at " << lambda1 << endl;
            #endif
            lambda2=lambda1;
            lambda1=lambda2*(1-convtol[7]);
            check_right = 0;
	    if (lambda1<convtol[12]) {
	      lambda=-1;
	      success=0;
              #ifdef DEBUG
                *myfile <<endl<< "Lower bound for lambda hit. Stopping..."<< endl<<endl;
              #endif
              #ifdef COUT_DEBUG
                cout <<endl<< "Lower bound for lambda hit. Stopping..."<< endl<<endl;
              #endif
	      break;
	    }
          } else {
            break;
          }
        }

	if(lambda==-1) break;
          #ifdef OE_TEST
            break;
          #endif

        if(check_right) {
          #ifdef DEBUG
            *myfile <<endl<< "Check the right endpoint"<< endl<<endl;
          #endif
          #ifdef COUT_DEBUG
            cout <<endl<< "Check the right endpoint"<< endl<<endl;
          #endif
        }
        while(check_right) {
          lambda=lambda2;
          #ifdef DEBUG
            (*myfile) << "  OE calculations for entry rate "<< lambda 
               <<", range ("<< lambda1<<","<<lambda2<<"), "<<xmax << endl;
          #endif
  
          #ifdef COUT_DEBUG
            (*myfile) << "  OE calculations for entry rate "<< lambda 
               <<", range ("<< lambda1<<","<<lambda2<<"), "<<xmax << endl;
          #endif

          fpstratxmax(iota, rho, V, prof, tildes, d, prices);
          #ifdef DEBUG
            *myfile << "  Zero profit condition: " << constants[2]*(*V)[int(constants[3])-1]-constants[0] << endl;
          #endif
          #ifdef COUT_DEBUG
            cout << "  Zero profit condition: " << constants[2]*(*V)[int(constants[3])-1]-constants[0] << endl;
          #endif
          if(constants[2]*(*V)[int(constants[3])-1]-constants[0]>0 && lambda2<convtol[13]) {
            #ifdef DEBUG
              *myfile << "  Extending right endpoint of interval entry rate at " << lambda2 << endl << endl;
            #endif
            #ifdef COUT_DEBUG
              cout << "  Extending right endpoint of interval entry rate at " << lambda2 << endl << endl;
            #endif
            lambda1=lambda2;
            lambda2=lambda1*(1+convtol[7]);
            if (lambda2>convtol[13]) {
	      lambda=-1;
	      success=0;
              #ifdef DEBUG
                *myfile <<endl<< "Upper bound for lambda hit. Stopping..."<< endl<<endl;
              #endif
              #ifdef COUT_DEBUG
                cout <<endl<< "Upper bound for lambda hit. Stopping..."<< endl<<endl;
              #endif
	      break;
	    }
          } else {
            break;
          }
        }

        if(lambda==-1) break;

        /*** Bisection ***/

        #ifdef DEBUG
          (*myfile) << endl << "Starting Bisection" << endl << endl;
        #endif

        #ifdef COUT_DEBUG
          cout << endl << "Starting Bisection" << endl << endl;
        #endif

        double zero_profit=convtol[5]+1;
        while(fabs(zero_profit)>convtol[5] && (fabs(lambda2-lambda1)/lambda2)>convtol[16]) {
          lambda=(lambda1+lambda2)/2;
          if(ignore==1)
            if(fabs(lambda1-lambda)<0.1)
              break;
          #ifdef DEBUG
            (*myfile) << "  OE calculations for entry rate "<< lambda 
               <<", range ("<< lambda1<<","<<lambda2<<"), "<<xmax << endl;
          #endif

          #ifdef COUT_DEBUG
            cout << "  OE calculations for entry rate "<< lambda 
               <<", range ("<< lambda1<<","<<lambda2<<"), "<<xmax << endl;
          #endif

          fpstratxmax(iota, rho, V, prof, tildes, d, prices);
          zero_profit = constants[2]*(*V)[int(constants[3])-1]-constants[0];
          #ifdef DEBUG
            (*myfile) << "  Zero profit condition: " << zero_profit << endl << endl;
          #endif

          #ifdef COUT_DEBUG
            cout << "  Zero profit condition: " << zero_profit << endl << endl;
          #endif

          if(zero_profit>=0) {
            lambda1=lambda;
          } else {
            lambda2=lambda;
          }
        }
        lambda1=lambda*(1-convtol[6]);
        lambda2=lambda*(1+convtol[6]);
      }
    } else { // Gauss-Seidel
      for(ignore=int(control[0]);ignore<=uignore;ignore++) {
        #ifdef DEBUG
          if (ignore==3) {
            (*myfile) << "\n  Recompute with simulated profit function" << endl;
          } else if (ignore==2) {
            (*myfile) << "\n  Recompute with actual profit function" << endl;
          } else {
            (*myfile) << "  Compute with approximated profit function" <<endl;
          }
        #endif

        #ifdef COUT_DEBUG
          if (ignore==3) {
            cout << "\n  Recompute with simulated profit function" << endl;
          } else if (ignore==2) {
            cout << "\n  Recompute with actual profit function" << endl;
          } else {
            cout << "  Compute with approximated profit function" <<endl;
          }
        #endif
 
        fpstratxmax(iota, rho, V, prof, tildes, d, prices);
	if(lambda==-1) {
	  break;
	}
      }
    }
  } else {
    lambda = control[2];
    method = 0;
    for(ignore=int(control[0]);ignore<=uignore;ignore++) {
      #ifdef DEBUG
        if (ignore==3) {
          (*myfile) << "\n  Recompute with simulated profit function" << endl;
        } else if (ignore==2) {
          (*myfile) << "\n  Recompute with actual profit function" << endl;
        } else {
          (*myfile) << "  Compute with approximated profit function" <<endl;
        }
      #endif

      #ifdef COUT_DEBUG
        if (ignore==3) {
          cout << "\n  Recompute with simulated profit function" << endl;
        } else if (ignore==2) {
          cout << "\n  Recompute with actual profit function" << endl;
        } else {
          cout << "  Compute with approximated profit function" <<endl;
        }
      #endif

      fpstratxmax(iota, rho, V, prof, tildes, d, prices);
    }
  }
  #ifdef DEBUG
    if (success==1) {
      (*myfile) << "Equilibrium computed" << endl;
      (*myfile) << "Condition number: " << condNumber << endl;
    } else {
      (*myfile) << "Equilibrium computation FAILED" <<endl;
    }
  #endif
  #ifdef COUT_DEBUG
    if (success==1) {
      cout << "Equilibrium computed" << endl;
      cout << "Condition number: " << condNumber << endl;
    } else {
      cout << "Equilibrium computation FAILED" <<endl;
    }
  #endif

/*  TriDiagMatrixMTL<double> tranmat(xmax);
  TriDiagMatrixMTL<double> conttranmat(xmax);
  VectorMTL<double> prcont0(xmax);
  VectorMTL<double> condexp(xmax);

  continuationProb(*rho,prcont0,condexp);
  tranProb(*iota,tranmat,conttranmat,prcont0);
  ofstream myfile2;
  myfile2.open ("output_conttran");
  myfile2 << conttranmat;
  myfile2.close();


  VectorMTL<double> temp(xmax);
  temp= conttranmat.primedot(*tildes);
  temp[9]+=lambda;
  cout << *tildes-temp;
  getchar();*/

  //cout << *action_profit;

  delete d;
  V_global = new VectorMTL<double>(xmax);
  *V_global = (*V);
  delete V;
  iota_global = new VectorMTL<double>(xmax);
  *iota_global = (*iota);
  delete iota;
  rho_global = new VectorMTL<double>(xmax);
  *rho_global = (*rho);
  delete rho;
  prof_global = new VectorMTL<double>(xmax);
  *prof_global = (*prof);
  delete prof;
  prices_global = new VectorMTL<double>(xmax);
  *prices_global = (*prices);
  delete prices;
  tildes_global = new VectorMTL<double>(xmax);
  *tildes_global = (*tildes);
  delete tildes;

  return success;
}

void CompOE::computeBounds(double *bounds_init, VectorMTL<double> &iota, VectorMTL<double> &rho, VectorMTL<double> &V, 
  VectorMTL<double> &tildes, double lambda, VectorMTL<double> &prices) {

  int kmaxsum;
  xmax = iota.getSize();
  bounds = bounds_init; 

  int xmax_ext = xmax * int(bounds[7]);

  VectorMTL<double> Vsum(xmax),Vsqr(xmax),Vpre(xmax),Vvar(xmax),Vavg(xmax);
  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> temp(xmax);
    MatrixMTL<double> tranMatrixMTL(xmax,xmax);
    MatrixMTL<double> contTranMatrixMTL(xmax,xmax);
    MatrixMTL<double> tranMatrix_infty(xmax_ext,xmax_ext);
    MatrixMTL<double> contTranMat_infty(xmax_ext,xmax_ext);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranMatrixMTL(xmax);
    TriDiagMatrixMTL<double> temp(xmax);
    TriDiagMatrixMTL<double> contTranMatrixMTL(xmax);
    TriDiagMatrixMTL<double> tranMatrix_infty(xmax_ext);
    TriDiagMatrixMTL<double> contTranMat_infty(xmax_ext);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> temp;
    SparseMatrixMTL<double> tranMatrixMTL;
    SparseMatrixMTL<double> contTranMatrixMTL;
    SparseMatrixMTL<double> tranMatrix_infty;
    SparseMatrixMTL<double> contTranMat_infty;
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif

  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);
  VectorMTL<double> state(xmax);
  VectorMTL<double> profstate(xmax);
  VectorMTL<double> proftildes(xmax);
  double bound1sum=0, bound1sqr=0;
  VectorMTL<double> bound2sum(xmax), bound2sqr(xmax);
  VectorMTL<double> bound3sum(xmax), bound3sqr(xmax);
  VectorMTL<double> bound4sum(xmax), bound4sqr(xmax);
  VectorMTL<double> bound5sum(xmax), bound5sqr(xmax);

  MatrixMTL<double> disc_Freq(xmax,xmax);
  VectorMTL<double> disc_Vdet(xmax);
  double boundspre;
  VectorMTL<double> bound2det(xmax);
  MatrixMTL<double> *g=NULL;


  /*** Extended vectors ***/
  VectorMTL<double> tildes_ext(xmax_ext);
  VectorMTL<double> proftildes_ext(xmax_ext);
  VectorMTL<double> profstate_ext(xmax_ext);
  VectorMTL<double> state_ext(xmax_ext);
  VectorMTL<double> prices_ext(xmax_ext);
  VectorMTL<double> pricesOut_ext(xmax_ext);
  VectorMTL<double> ms_ext(xmax_ext);
  VectorMTL<double> discprof(xmax);
  VectorMTL<double> difprof(xmax_ext);
  VectorMTL<double> difprofpos(xmax_ext);

  VectorMTL<double> iota_infty(xmax_ext);
  VectorMTL<double> prcont_infty(xmax_ext);

  /*** Market shares ***/
  VectorMTL<double> ms(xmax);

  /*** Industry statistics ***/
  double prodsursum=0,prodsursqr=0,conssursum=0,conssursqr=0,totalsursum=0,totalsursqr=0;

  /*** Entry/Exit stats ***/
  double entratesum=0, entratesqr=0, exiratesum=0, exiratesqr=0, msexitsum=0, msexitsqr=0;

  /*** Concetrations ratios ***/
  double c1sum=0, c1sqr=0, c4sum=0, c4sqr=0, c10sum=0, c10sqr=0, c20sum=0, c20sqr=0, hhi50sum=0, hhi50sqr=0;

  /****************************************************************************/

  /* initialiaze the extedended state */
  state_ext = 0;

  Vsum = 0;
  Vsqr = 0;

  bound2sum = 0;
  bound2sqr = 0;

  bound3sum = 0;
  bound3sqr = 0;

  bound4sum = 0;
  bound4sqr = 0;

  bound5sum = 0;
  bound5sqr = 0;

  if (bound1por!=NULL) delete bound1por;
  bound1por = new VectorMTL<double>(xmax);

  if (bound2avg!=NULL) delete bound2avg;
  if (bound2var!=NULL) delete bound2var;
  if (bound2pre!=NULL) delete bound2pre;
  if (bound2por!=NULL) delete bound2por;

  bound2avg = new VectorMTL<double>(xmax);
  bound2var = new VectorMTL<double>(xmax);
  bound2pre = new VectorMTL<double>(xmax);
  bound2por = new VectorMTL<double>(xmax);

  if (bound3avg!=NULL) delete bound3avg;
  if (bound3var!=NULL) delete bound3var;
  if (bound3pre!=NULL) delete bound3pre;
  if (bound3por!=NULL) delete bound3por;
  bound3avg = new VectorMTL<double>(xmax-1);
  bound3var = new VectorMTL<double>(xmax-1);
  bound3pre = new VectorMTL<double>(xmax-1);
  bound3por = new VectorMTL<double>(xmax-1);

  if (bound4avg!=NULL) delete bound4avg;
  if (bound4var!=NULL) delete bound4var;
  if (bound4pre!=NULL) delete bound4pre;
  if (bound4por!=NULL) delete bound4por;
  bound4avg = new VectorMTL<double>(xmax);
  bound4var = new VectorMTL<double>(xmax);
  bound4pre = new VectorMTL<double>(xmax);
  bound4por = new VectorMTL<double>(xmax);

  if (bound5avg!=NULL) delete bound5avg;
  if (bound5var!=NULL) delete bound5var;
  if (bound5pre!=NULL) delete bound5pre;
  if (bound5por!=NULL) delete bound5por;
  bound5avg = new VectorMTL<double>(xmax);
  bound5var = new VectorMTL<double>(xmax);
  bound5pre = new VectorMTL<double>(xmax);
  bound5por = new VectorMTL<double>(xmax);

  // Adjust the precisions
  double tol1=bounds[1]/(1+bounds[1]);
  double tol2=bounds[2]/(1+bounds[2]);

  // Prepare tildes and prices

  for(int i=0;i<xmax;i++) {
    tildes_ext[i]=tildes[i];
  }
  for(int i=xmax;i<xmax_ext;i++) {
    tildes_ext[i]=0;
  }

  for(int i=0;i<xmax;i++) {
    prices_ext[i]=prices[i];
  }
  for(int i=xmax;i<xmax_ext;i++) {
    prices_ext[i]=prices[xmax-1];
  }

  /* Precompute marginal cost */
  VectorMTL<double> d(xmax);
  for(int i=0;i<xmax;i++) {
    d[i]=MACRO__MINVCOST(i);
  }

  int save_xmax = xmax;
  xmax = xmax_ext;
  compProf(tildes_ext, prices_ext, proftildes_ext);
  xmax = save_xmax;

  proftildes = proftildes_ext.subVector(0,xmax-1);


  /* To compute expV, we compute "deterministic part" of value function */
  /* which is independent of the competitors' state under OE strats.    */
  continuationProb(rho, prcont, condexp);
  tranProb(iota, tranMatrixMTL, contTranMatrixMTL, prcont);

  temp = contTranMatrixMTL;
  temp*=-constants[2];
  temp.addDiag(1);
  if(!temp.inverse(disc_Freq)) {
    cout << "Bound calculation routine error: Cannot invert the discount MatrixMTL" << endl;
    exit(0);
  }
  disc_Vdet = disc_Freq.dot((-prcont+1.0)*condexp + prcont*(-iota*d));
  bound2det = disc_Freq.dot(proftildes);

  int n=1;

  RanGenLib P;

  boundspre = bounds[1]+1;

  MatrixMTL<double> Prob(1,xmax);
  double p=0;

  VectorMTL<double> sta_distr(xmax);

  if(control[2]>0) {
    sta_distr = tildes/(control[2]-1);
  } else {
    if(control[1]==2) {
      int time=1;
      MatrixMTL<double> A(xmax,xmax);
      A.eye();

      for(int i=0;i<xmax;i++) {
        Prob[0][i]=A[int(constants[3])-1][i];
      }
      A=A.dot(contTranMatrixMTL);

      if (bounds[6]<=sum(Prob.getRow(0))) {
        while(time<bounds[5]) {
          Prob.extraRow(1);
          for(int i=0;i<xmax;i++) {		// row time of matrix Prob is a vector with probs of being
            Prob[time][i]=A[int(constants[3])-1][i];	// in each state after time periods in the industry
          }
          A=A.dot(contTranMatrixMTL);

          if (bounds[6]>sum(Prob.getRow(time))) {
            break;
          }
          // Compute prob. to randomize number of entrants if lambda non-integer
          if(ceil(lambda)!=floor(lambda)) {
            p=(ceil(lambda)-lambda)/(ceil(lambda)-floor(lambda));
          } else {
            p=0;
          }
          if(time==bounds[5]) {
            cout << "Time limit reached when computing distribution to sample states with fixed number of entrants\n";
          }
          time++;
        }
      }
    }
  }

  iota_infty=1e20;
  prcont_infty=1.0;
  save_xmax = xmax;
  xmax = xmax_ext;
  tranProb(iota_infty, tranMatrix_infty, contTranMat_infty, prcont_infty);
  xmax=save_xmax;

  while((boundspre>tol1) || 
    (min(Vpre)>tol2) ||
    (n<=bounds[4])) {
    if (n>bounds[3]) break; 

    double entrants;

    if(control[2]>0) {
      state.genFixed(P,sta_distr,int(control[2])-1);
      entrants = 0;
    } else {
      if(control[1]==2) {
        entrants=sample_constentr(P,lambda,Prob,p,state);
     } else {
        state.genPoisson(P,tildes);
        entrants = P.genPoisson(lambda);
      }
    }


    for(int i=0; i<xmax;i++) {
      state_ext[i]=state[i];
    }

  
    // cout << tildes<< state;
    // getchar();

    /***** Evaluate the profit with statitics ******/
    double prodsur;
    double conssur;

    int save_xmax = xmax;
    xmax = xmax_ext;
    compProfAndStats(state_ext,prices_ext,pricesOut_ext,profstate_ext,ms_ext,prodsur,conssur);
    xmax=save_xmax;

    profstate = profstate_ext.subVector(0,xmax-1);
    ms = ms_ext.subVector(0,xmax-1);

    /***** Bound 1 ******/
    double max_absd=norm(profstate-proftildes)*(2/(1-constants[2]));
    bound1sum+=max_absd;
    bound1sqr+=max_absd*max_absd;

    discprof=disc_Freq.dot(profstate);

    difprof=profstate_ext-proftildes_ext;

    for(int i=0;i<difprof.getSize();i++) {
      difprofpos[i] = MAX(difprof[i],0);
    }

    double max_d=max(difprof)/(1-constants[2]);
    if(control[2]==0) {
      if (max_d<0) max_d=0;
    }


    bound2sum += (bound2det - discprof + max_d);
    bound2sqr += (bound2det - discprof + max_d)*(bound2det - discprof+max_d);

    for(int start_x=0;start_x<xmax;start_x++) {
      int k;
      double term1=0;
      if(2*(start_x+1) <= xmax_ext) {
        double beta = 1;
        for (k=0;k<start_x+1;k+=int(bounds[8])) {
          if(control[2]>0) {
            term1+=beta*max(difprof.subVector(start_x-k,start_x+k));
          } else {
            term1+=beta*MACRO__POSITIVE(max(difprof.subVector(start_x-k,start_x+k)));
          }
          beta*=constants[2];
        }
        for (int k2=k;k2<xmax_ext-start_x;k2+=int(bounds[8])) {
          if(control[2]>0) {
            term1+=beta*max(difprof.subVector(0,start_x+k2));
          } else {
            term1+=beta*MACRO__POSITIVE(max(difprof.subVector(0,start_x+k2)));
          }
          beta*=constants[2];
        }
        if(control[2]>0) {
          term1+=beta/(1-constants[2])*max(difprof.subVector(0,xmax_ext-1));
        } else {
          term1+=beta/(1-constants[2])*MACRO__POSITIVE(max(difprof.subVector(0,xmax_ext-1)));
        }
      } else {
        double beta = 1;
        for(k=0;k<xmax_ext-start_x;k+=int(bounds[8])) {
          if(control[2]>0) {
            term1+=beta*max(difprof.subVector(start_x-k,start_x+k));
          } else {
            term1+=beta*MACRO__POSITIVE(max(difprof.subVector(start_x-k,start_x+k)));
          }
          beta*=constants[2];
        }
        for(int k2=k;k2<start_x+1;k2+=int(bounds[8])) {
          if(control[2]>0) {
            term1+=beta*max(difprof.subVector(start_x-k2,xmax_ext-1));
          } else {
            term1+=beta*MACRO__POSITIVE(max(difprof.subVector(start_x-k2,xmax_ext-1)));
          }
          beta*=constants[2];
        }
        if(control[2]>0) {
          term1+=beta/(1-constants[2])*max(difprof.subVector(0,xmax_ext-1));
        } else {
          term1+=beta/(1-constants[2])*MACRO__POSITIVE(max(difprof.subVector(0,xmax_ext-1)));
        }
      }
      bound3sum[start_x] += (term1 + bound2det[start_x] - discprof[start_x]);
      bound3sqr[start_x] += (term1 + bound2det[start_x] - discprof[start_x])*
        (term1 + bound2det[start_x] - discprof[start_x]);
    }

    // Tighter bound for model with depreciation
    // First, using estimate of bound calculate number of terms
    // and terms in binomial sum and store them.
    // Alternatively, if memory requirements become too high,
    // could compute the binomial terms each iteration.

    if((n==1) || (n==10) || (n==int(bounds[4]/2)) || (n==bounds[4])) {
      kmaxsum=int(round((log(bounds[1]*(max(bound2sum)/n)*(1-constants[2])/(2*max(proftildes)))/log(constants[2]))));

      if(g!=NULL) delete g;
      g = new MatrixMTL<double>(kmaxsum+1,MIN(kmaxsum+1,xmax_ext));

      for (int i=0; i<=kmaxsum; i++) {
        for (int m=0;m<=MIN(i,xmax_ext-1);m++) {
          (*g)[i][m]= binopdf(m,i,1-transition[1]);
        }
      }
    }

    // Bound calculations for tighter bound for model with depreciation
    // First, check whether \Delta_y is increasing in y

    for(int i=0;i<xmax_ext-1;i++) {
      if(difprofpos[i]-difprofpos[i+1]>bounds[9]*proftildes[i]) {
      #ifdef DEBUG_COUT
        cout << "Delta_y not increasing in y" << endl;
      #endif
      #ifdef DEBUG
        *myfile << "Delta_y not increasing in y" << endl;
      #endif
      }
    }

    for(int start_x=0;start_x<xmax;start_x++) { 
      double term1=0;
      double term1_sim=0;
      int xdraw = start_x;

      double beta = 1;
      if(max(difprofpos)!=0) {

        for (int k=0;k<=kmaxsum;k++) {
          VectorMTL<double> temp1(MIN(k,xmax_ext-1-start_x)+1);
          for(int i=0;i<=MIN(k,xmax_ext-1-start_x);i++) {
            temp1[i]=(*g)[k][i];
          }

          term1_sim+=(beta*difprofpos[xdraw]);

          double binsum=temp1.dot(difprofpos.subVector(start_x,start_x+MIN(k,xmax_ext-1-start_x)));

          if(k>xmax_ext-start_x-1) { // Need to sum extra terms associated to  being at xmax_ext
            binsum+=(1-binocdf(xmax_ext-start_x-1,k,1-transition[1]))* difprofpos[xmax_ext-1]; 
          }

          term1+=beta*binsum;

          beta*=constants[2];

          xdraw=genDistr(P,contTranMat_infty.getRow(xdraw));
        }
      }
      bound4sum[start_x]+=(term1 + bound2det[start_x] - discprof[start_x]);
      bound4sqr[start_x]+=(term1 + bound2det[start_x] - discprof[start_x])*
        (term1 + bound2det[start_x] - discprof[start_x]);

      bound5sum[start_x]+=(term1_sim + bound2det[start_x] - discprof[start_x]);
      bound5sqr[start_x]+=(term1_sim + bound2det[start_x] - discprof[start_x])*
        (term1_sim + bound2det[start_x] - discprof[start_x]);
    }


    Vsum+=(disc_Vdet+discprof);
    Vsqr+=((disc_Vdet+discprof)*(disc_Vdet+discprof));

    if(n>=bounds[4]) {
        compAvgPre(bound1sum,bound1sqr,n,bound1avg,bound1pre,bound1var);
        compAvgPre(bound2sum,bound2sqr,n,*bound2avg,*bound2pre,*bound2var);
        compAvgPre(bound3sum,bound3sqr,n,*bound3avg,*bound3pre,*bound3var);
        compAvgPre(bound4sum,bound4sqr,n,*bound4avg,*bound4pre,*bound4var);
        compAvgPre(bound5sum,bound5sqr,n,*bound5avg,*bound5pre,*bound5var);
        compAvgPre(Vsum,Vsqr,n,Vavg,Vpre,Vvar);
        boundspre=bound1pre;
        double temp;
        if((temp=max(*bound2pre))>boundspre) boundspre=temp;
        if((temp=max(*bound3pre))>boundspre) boundspre=temp;
        if((temp=max(*bound4pre))>boundspre) boundspre=temp;
        if((temp=max(*bound5pre))>boundspre) boundspre=temp;
        if(((n-1)/100)<(n/100)) {
          #ifdef DEBUG
            *myfile << "    bounds iteration: " << n << ", precision = " << boundspre << endl;
          #endif
          #ifdef COUT_DEBUG
            cout << "    bounds iteration: " << n << ", precision = " << boundspre << endl;
          #endif
        }
    } else {
      if((((n-1)/100)<(n/100)) || (n==1)) {
          #ifdef DEBUG
            *myfile << "    bounds iteration: " << n << endl;
          #endif
          #ifdef COUT_DEBUG
            cout << "    bounds iteration: " << n<< endl;
          #endif
      }
    }

    n++;


    /**** Industry statitics ****/
    compProfAndStats_extra(state_ext,prices_ext,pricesOut_ext,profstate_ext,ms_ext,prodsur,conssur);

    prodsursum+=prodsur;
    prodsursqr+=prodsur*prodsur;
    conssursum+=conssur;
    conssursqr+=conssur*conssur;
    totalsursum+=prodsur+conssur;
    totalsursqr+=(prodsur+conssur)*(prodsur+conssur);

    /**** Concetration ratios ****/
    VectorMTL<double> cumfirms(xmax);
    cumfirms=flip(cumSum(flip(state_ext)));
    VectorMTL<double> conc(xmax);
    conc=state_ext*ms_ext;
    VectorMTL<double> cumconc(xmax);
    cumconc=flip(cumSum(flip(conc)));
    double c1=0, c4=0, c10=0, c20=0;
    if (cumfirms[xmax-1]>=1) 
        c1=ms_ext[xmax-1];
    if (cumfirms[xmax-1]>=4) 
        c4=ms_ext[xmax-1]*4;
    if (cumfirms[xmax-1]>=10) 
        c10=ms_ext[xmax-1]*10;
    if (cumfirms[xmax-1]>=20) 
        c20=ms_ext[xmax-1]*20;
    for (int i=xmax-2;i>=0;i--) {
      if ((cumfirms[i]>=1) && (cumfirms[i+1]<1))
         c1=cumconc[i+1]+ms_ext[i]*(1-cumfirms[i+1]);
      if ((cumfirms[i]>=4) && (cumfirms[i+1]<4))
         c4=cumconc[i+1]+ms_ext[i]*(4-cumfirms[i+1]);
      if ((cumfirms[i]>=10) && (cumfirms[i+1]<10))
         c10=cumconc[i+1]+ms_ext[i]*(10-cumfirms[i+1]);
      if ((cumfirms[i]>=20) && (cumfirms[i+1]<20))
         c20=cumconc[i+1]+ms_ext[i]*(20-cumfirms[i+1]);
    }
    if((cumfirms[0]>=1) && (cumfirms[0]<20)) { 
        c20=1;
        if(cumfirms[0]<10) {
            c10=1;
            if(cumfirms[0]<4) {
                c4=1;
            }
        }
    }

    c1sum+=c1;
    c1sqr+=c1*c1;
    c4sum+=c4;
    c4sqr+=c4*c4;
    c10sum+=c10;
    c10sqr+=c10*c10;
    c20sum+=c20;
    c20sqr+=c20*c20;

    // Calculate HHI50 //
    VectorMTL<double> temp2(xmax);
    temp2=state_ext;
    double hhi50=0;
    double sj,fracdone;
    fracdone=0.0;
    sj=0.0;
    int i=xmax-1;
    int j=50;
    while (i>0 && j>0) {
      if (fracdone+temp2[i]>1.0) {
        sj=(1-fracdone)*ms_ext[i]+sj;
        hhi50+=10000.0*sj*sj;
        temp2[i]-=(1.0-fracdone);
        j--;
        fracdone=0.0;
        sj=0.0;
      } else {
        fracdone+=temp2[i];
        sj+=temp2[i]*ms_ext[i];
        i--;
      }
    }

    hhi50sum+=hhi50;
    hhi50sqr+=(hhi50*hhi50);

    /**** entry exit statistics ****/
    // Variable number of firms
    if(control[2]==0) {
      double numfirms=sum(state);
      double entrate=entrants/numfirms;
      entratesum+=entrate;
      entratesqr+=entrate*entrate;
      double numexit=0;
      double msexit=0;
      for(int i=0;i<xmax;i++) {
        for(int j=0;j<state[i];j++) {
          if(P.genUniform()<=1-prcont[i]) {
            numexit+=1; 
            msexit+=ms[i];
          }
        }
      }
      double exirate=numexit/numfirms;
      exiratesum+=exirate;
      exiratesqr+=exirate*exirate;
      msexitsum+=msexitsum;
      msexitsqr+=msexit*msexit;
    }
  }


  #ifdef DEBUG
    (*myfile) << "Number of iterations in bounds simulation: " << n << endl;
  #endif

  #ifdef COUT_DEBUG
    cout << "Number of iterations in bounds simulation: " << n << endl;
  #endif

  // Variable number of firms
  if(control[2]==0) {
    compAvgPre(entratesum,entratesqr,n,entrateavg,entratepre,entratevar);
    compAvgPre(exiratesum,exiratesqr,n,exirateavg,exiratepre,exiratevar);
    compAvgPre(msexitsum,msexitsqr,n,msexitavg,msexitpre,msexitvar);
  } else {
    entrateavg=0;
    entratevar=0;
    exirateavg=0;
    exiratevar=0;
    msexitavg=0;
    msexitvar=0;
  }

  compAvgPre(prodsursum,prodsursqr,n,prodsuravg,prodsurpre,prodsurvar);
  compAvgPre(conssursum,conssursqr,n,conssuravg,conssurpre,conssurvar);
  compAvgPre(totalsursum,totalsursqr,n,totalsuravg,totalsurpre,totalsurvar);
  compAvgPre(c1sum,c1sqr,n,c1avg,c1pre,c1var);
  compAvgPre(c4sum,c4sqr,n,c4avg,c4pre,c4var);
  compAvgPre(c10sum,c10sqr,n,c10avg,c10pre,c10var);
  compAvgPre(c20sum,c20sqr,n,c20avg,c20pre,c20var);
  compAvgPre(hhi50sum,hhi50sqr,n,hhi50avg,hhi50pre,hhi50var);

  if(g!=NULL) delete g;

  *bound1por=(bound1avg)/Vavg*100.0;
  *bound2por=(*bound2avg)/Vavg*100.0;
  *bound3por=(*bound3avg)/Vavg*100.0;
  *bound4por=(*bound4avg)/Vavg*100.0;
  *bound5por=(*bound5avg)/Vavg*100.0;
}

void CompOE::computeStats(double tol, int n_min, int n_max, VectorMTL<double> &iota, VectorMTL<double> &rho, 
  VectorMTL<double> &tildes, VectorMTL<double> &pricesStart, double lambda,  VectorMTL<double> &pricesOut,
  VectorMTL<double> &msOut, double &prodsurOut, double &conssurOut, double &totalsurOut, VectorMTL<double> &cOut,
  double &entrateOut, double &exirateOut, double &msexitOut) {

  xmax = iota.getSize();

  VectorMTL<double> state(xmax);
  VectorMTL<double> profstate(xmax);

  /*** Market shares ***/
  VectorMTL<double> ms(xmax);
  VectorMTL<double> mssqr(xmax);
  mssqr=0;
  VectorMTL<double> mssum(xmax);
  mssum=0;
  VectorMTL<double> mspre(xmax);
  VectorMTL<double> msvar(xmax);

  /*** Prices ***/
  VectorMTL<double> prices(xmax);
  VectorMTL<double> pricessqr(xmax);
  pricessqr=0;
  VectorMTL<double> pricessum(xmax);
  pricessum=0;
  VectorMTL<double> pricespre(xmax);
  VectorMTL<double> pricesvar(xmax);


  /*** Industry statistics ***/
  double prodsursum=0,prodsursqr=0;
  double conssursum=0,conssursqr=0;
  double totalsursum=0,totalsursqr=0;

  /*** Entry/Exit stats ***/
  double entratesum=0, entratesqr=0;
  double exiratesum=0, exiratesqr=0;
  double msexitsum=0, msexitsqr=0;

  /*** Concetrations ratios ***/
  double c1sum=0, c1sqr=0; 
  double c4sum=0, c4sqr=0;
  double c10sum=0, c10sqr=0;
  double c20sum=0, c20sqr=0;
  double hhi50sum=0, hhi50sqr=0;

  // Adjust the precisions
  tol=tol/(1+tol);

  // Calculate transition probabilities
  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> tranMatrixMTL(xmax,xmax);
    MatrixMTL<double> contTranMatrixMTL(xmax,xmax);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranMatrixMTL(xmax);
    TriDiagMatrixMTL<double> contTranMatrixMTL(xmax);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> tranMatrixMTL;
    SparseMatrixMTL<double> contTranMatrixMTL;
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif

  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);

  continuationProb(rho, prcont, condexp);
  tranProb(iota, tranMatrixMTL, contTranMatrixMTL, prcont);


  int n=1;

  RanGenLib P;

  MatrixMTL<double> Prob(1,xmax);
  double p=0;

  VectorMTL<double> sta_distr(xmax);

  if(control[2]>0) {
    sta_distr = tildes/(control[2]-1);
  } else {
    if(control[1]==2) {
      int time=1;
      MatrixMTL<double> A(xmax,xmax);
      A.eye();

      for(int i=0;i<xmax;i++) {
        Prob[0][i]=A[int(constants[3])][i];
      }
      A=A.dot(contTranMatrixMTL);

      if (bounds[6]<=sum(Prob.getRow(0))) {
        while(time<bounds[5]) {
          Prob.extraRow(1);
          for(int i=0;i<xmax;i++) {		// row time of matrix Prob is a vector with probs of being
            Prob[time][i]=A[int(constants[3])-1][i];	// in each state after time periods in the industry
          }
          A=A.dot(contTranMatrixMTL);

          if (bounds[6]>sum(Prob.getRow(time))) {
            break;
          }
          // Compute prob. to randomize number of entrants if lambda non-integer
          if(ceil(lambda)!=floor(lambda)) {
            p=(ceil(lambda)-lambda)/(ceil(lambda)-floor(lambda));
          } else {
            p=0;
          }
          if(time==bounds[5]) {
            cout << "Time limit reached when computing distribution to sample states with fixed number of entrants\n";
          }
          time++;
        }
      }
    }
  }

  double pre;

  while((pre>tol) || (n<=n_min)) {
    if (n>n_max) break; 

    double entrants;

    if(control[2]>0) {
      state.genFixed(P,sta_distr,int(control[2])-1);
      entrants = 0;
    } else {
      if(control[1]==2) {
        entrants=sample_constentr(P,lambda,Prob,p,state);
      } else {
        state.genPoisson(P,tildes);
        entrants = P.genPoisson(lambda);
      }
    }

    // cout << tildes<< state;
    // getchar();

    /***** Evaluate the profit with statitics ******/
    double prodsur;
    double conssur;

    compProfAndStats_extra(state,pricesStart,prices,profstate,ms,prodsur,conssur);

    /**** Industry statitics ****/
    mssum+=ms;
    mssqr+=ms*ms;
    pricessum+=prices;
    pricessqr+=prices*prices;
    prodsursum+=prodsur;
    prodsursqr+=prodsur*prodsur;
    conssursum+=conssur;
    conssursqr+=conssur*conssur;
    totalsursum+=prodsur+conssur;
    totalsursqr+=(prodsur+conssur)*(prodsur+conssur);

    /**** Concetration ratios ****/
    double c1, c4, c10, c20;
    concentrationRatios(ms, state, c1, c4, c10, c20);

    c1sum+=c1;
    c1sqr+=c1*c1;
    c4sum+=c4;
    c4sqr+=c4*c4;
    c10sum+=c10;
    c10sqr+=c10*c10;
    c20sum+=c20;
    c20sqr+=c20*c20;

    /**** entry exit statistics ****/
    // Variable number of firms
    if(control[2]==0) {
      double numfirms=sum(state);
      double entrate=entrants/numfirms;
      entratesum+=entrate;
      entratesqr+=entrate*entrate;
      double numexit=0;
      double msexit=0;
      for(int i=0;i<xmax;i++) {
        for(int j=0;j<state[i];j++) {
          if(P.genUniform()<=1-prcont[i]) {
            numexit+=1; 
            msexit+=ms[i];
          }
        }
      }
      double exirate=numexit/numfirms;
      exiratesum+=exirate;
      exiratesqr+=exirate*exirate;
      msexitsum+=msexitsum;
      msexitsqr+=msexit*msexit;
    }
  }


  // Calculate HHI50 //
  VectorMTL<double> temp2(xmax);
  temp2=state;
  double hhi50=0;
  double sj,fracdone;
  fracdone=0.0;
  sj=0.0;
  int i=xmax-1;
  int j=50;
  while (i>0 && j>0) {
    if (fracdone+temp2[i]>1.0) {
      sj=(1-fracdone)*ms[i]+sj;
      hhi50+=10000.0*sj*sj;
      temp2[i]-=(1.0-fracdone);
      j--;
      fracdone=0.0;
      sj=0.0;
    } else {
      fracdone+=temp2[i];
      sj+=temp2[i]*ms[i];
      i--;
    }
  }
  hhi50sum+=hhi50;
  hhi50sqr+=(hhi50*hhi50);

  // Variable number of firms
  if(control[2]==0) {
    compAvgPre(entratesum,entratesqr,n,entrateOut,entratepre,entratevar);
    compAvgPre(exiratesum,exiratesqr,n,exirateOut,exiratepre,exiratevar);
    compAvgPre(msexitsum,msexitsqr,n,msexitOut,msexitpre,msexitvar);
  } else {
    entrateOut=0;
    exirateOut=0;
    msexitOut=0;
  }

  compAvgPre(mssum,mssqr,n,msOut,mspre,msvar);
  compAvgPre(prodsursum,prodsursqr,n,prodsurOut,prodsurpre,prodsurvar);
  compAvgPre(conssursum,conssursqr,n,conssurOut,conssurpre,conssurvar);
  compAvgPre(totalsursum,totalsursqr,n,totalsurOut,totalsurpre,totalsurvar);
  compAvgPre(c1sum,c1sqr,n,cOut[0],c1pre,c1var);
  compAvgPre(c4sum,c4sqr,n,cOut[1],c4pre,c4var);
  compAvgPre(c10sum,c10sqr,n,cOut[3],c10pre,c10var);
  compAvgPre(c20sum,c20sqr,n,cOut[4],c20pre,c20var);

  // Determine stopping norm
  double temp;
  pre = 0;
  if((temp=max(ms))>pre) pre=temp;
  if((temp=entratepre)>pre) pre=temp;
  if((temp=exiratepre)>pre) pre=temp;
  if((temp=msexitpre)>pre) pre=temp;
  if((temp=prodsurpre)>pre) pre=temp;
  if((temp=conssurpre)>pre) pre=temp;
  if((temp=totalsurpre)>pre) pre=temp;
  if((temp=c1pre)>pre) pre=temp;
  if((temp=c4pre)>pre) pre=temp;
  if((temp=c10pre)>pre) pre=temp;
  if((temp=c20pre)>pre) pre=temp;

  n++;
}


CompOE::~CompOE() {
  if (bound1por!=NULL) delete bound1por;

  if (bound2avg!=NULL) delete bound2avg;
  if (bound2var!=NULL) delete bound2var;
  if (bound2pre!=NULL) delete bound2pre;
  if (bound2por!=NULL) delete bound2por;

  if (bound3avg!=NULL) delete bound3avg;
  if (bound3var!=NULL) delete bound3var;
  if (bound3pre!=NULL) delete bound3pre;
  if (bound3por!=NULL) delete bound3por;

  if (bound4avg!=NULL) delete bound4avg;
  if (bound4var!=NULL) delete bound4var;
  if (bound4pre!=NULL) delete bound4pre;
  if (bound4por!=NULL) delete bound4por;

  if (bound5avg!=NULL) delete bound5avg;
  if (bound5var!=NULL) delete bound5var;
  if (bound5pre!=NULL) delete bound5pre;
  if (bound5por!=NULL) delete bound5por;

  if (iota_global!=NULL) delete iota_global;
  if (rho_global!=NULL) delete rho_global;
  if (V_global!=NULL) delete V_global;
  if (prices_global!=NULL) delete prices_global;
  if (tildes_global!=NULL) delete tildes_global;
  if (prof_global!=NULL) delete prof_global;
  if (prcont1!=NULL) delete prcont1;

  if (firmsnumberavg!=NULL) delete firmsnumberavg;
  if (firmsnumbervar!=NULL) delete firmsnumbervar;
  if (firmsnumberpre!=NULL) delete firmsnumberpre;
  if (firmsnumberpor!=NULL) delete firmsnumberpor;

  #ifdef ACW
    if (action_profit!=NULL) delete action_profit;
    if (acwTran!=NULL) delete acwTran;
    if (RHSFringe!=NULL) delete RHSFringe;
  #endif

  if (prodsuravg_path!=NULL) delete prodsuravg_path;
  if (prodsurvar_path!=NULL) delete prodsurvar_path;
  if (prodsurpre_path!=NULL) delete prodsurpre_path;

  if (conssuravg_path!=NULL) delete conssuravg_path;
  if (conssurvar_path!=NULL) delete conssurvar_path;
  if (conssurpre_path!=NULL) delete conssurpre_path;

  if (totalsuravg_path!=NULL) delete totalsuravg_path;
  if (totalsurvar_path!=NULL) delete totalsurvar_path;
  if (totalsurpre_path!=NULL) delete totalsurpre_path;

  if (c1avg_path!=NULL) delete c1avg_path;
  if (c1var_path!=NULL) delete c1var_path;
  if (c1pre_path!=NULL) delete c1pre_path;

  if (c2avg_path!=NULL) delete c2avg_path;
  if (c2var_path!=NULL) delete c2var_path;
  if (c2pre_path!=NULL) delete c2pre_path;

  if (c4avg_path!=NULL) delete c4avg_path;
  if (c4var_path!=NULL) delete c4var_path;
  if (c4pre_path!=NULL) delete c4pre_path;

  if (c10avg_path!=NULL) delete c10avg_path;
  if (c10var_path!=NULL) delete c10var_path;
  if (c10pre_path!=NULL) delete c10pre_path;

  if (c20avg_path!=NULL) delete c20avg_path;
  if (c20var_path!=NULL) delete c20var_path;
  if (c20pre_path!=NULL) delete c20pre_path;

  if (hhi50avg_path!=NULL) delete hhi50avg_path;
  if (hhi50var_path!=NULL) delete hhi50var_path;
  if (hhi50pre_path!=NULL) delete hhi50pre_path;

  if (invavg_path!=NULL) delete invavg_path;
  if (invvar_path!=NULL) delete invvar_path;
  if (invpre_path!=NULL) delete invpre_path;

  if (firmsnumberavg_path!=NULL) delete firmsnumberavg_path;
  if (firmsnumbervar_path!=NULL) delete firmsnumbervar_path;
  if (firmsnumberpre_path!=NULL) delete firmsnumberpre_path;
}

void *thread_function(void *input)
{
   ThreadStructure *str = (ThreadStructure *) input; 
   VectorMTL<double> *state = str->state;
   VectorMTL<double> *p0 = str->p0;

   int i  = str->number;
   int xmax = state->getSize();

   FunctionProfit profit(xmax,xmax);

   profit.initStructures(str->prof_fun, str->prof_fun_ipopt);

   VectorMTL<double> profit_tmp(xmax);
   VectorMTL<double> ms(xmax);

   double cs,ps;
   (str->success)=profit.eval(*state,*p0,profit_tmp,0,ms,cs,ps);


/*   cout << str->success << endl;
   if((str->success)==0) {
      cout << "ups "<< (str->success);getchar();
   }*/

   str->output = profit_tmp[i];

   pthread_exit(NULL);
}

void CompOE::concentrationRatios(VectorMTL<double> &ms, VectorMTL<double> &tildes, 
  double &c1, double &c4, double &c10, double &c20) {
    VectorMTL<double> cumfirms(xmax);
    cumfirms=flip(cumSum(flip(tildes)));
    VectorMTL<double> conc(xmax);
    conc=tildes*ms;
    VectorMTL<double> cumconc(xmax);
    cumconc=flip(cumSum(flip(conc)));
    c1=0;
    c4=0; 
    c10=0; 
    c20=0;
    if (cumfirms[xmax-1]>=1) 
        c1=ms[xmax-1];
    if (cumfirms[xmax-1]>=4) 
        c4=ms[xmax-1]*4;
    if (cumfirms[xmax-1]>=10) 
        c10=ms[xmax-1]*10;
    if (cumfirms[xmax-1]>=20) 
        c20=ms[xmax-1]*20;
    for (int i=xmax-2;i>=0;i--) {
      if ((cumfirms[i]>=1) && (cumfirms[i+1]<1))
         c1=cumconc[i+1]+ms[i]*(1-cumfirms[i+1]);
      if ((cumfirms[i]>=4) && (cumfirms[i+1]<4))
         c4=cumconc[i+1]+ms[i]*(4-cumfirms[i+1]);
      if ((cumfirms[i]>=10) && (cumfirms[i+1]<10))
         c10=cumconc[i+1]+ms[i]*(10-cumfirms[i+1]);
      if ((cumfirms[i]>=20) && (cumfirms[i+1]<20))
         c20=cumconc[i+1]+ms[i]*(20-cumfirms[i+1]);
    }
    if((cumfirms[0]>=1) && (cumfirms[0]<20)) { 
        c20=1;
        if(cumfirms[0]<10) {
            c10=1;
            if(cumfirms[0]<4) {
                c4=1;
            }
        }
    }
}

double binocdf(int x, int n, double b) {
  int bin;
  double cdf;
  double pr;

  if (x<0) {
    cdf = 0.0;
  } else if ( n <= x ) {
    cdf = 1.0;
  } else if ( b == 0.0 ) {
    cdf = 1.0;
  } else if ( b == 1.0 ) {
    cdf = 0.0;
  } else {
    cdf = 0.0;
    for (int j = 0; j <= x; j++ ) {
      cdf = cdf + binopdf(j,n,b);
    }
  }
  return cdf;
}

double binopdf(int x, int n, double b) {
  double sum = log(double(bico(n,x)))+x*log(b)+(n-x)*log(1.0-b);
  return exp(sum);
}

unsigned int binomial_coef(int n, int m) {
  unsigned int b[n+1];
  b[0] = 1;
  for(unsigned int i=1;i<=n;++i) {
    b[i] = 1;
    for(unsigned int j=i-1;j>0;--j) { 
      b[j] += b[j-1];
    }
  }
  return b[m];
}

double gammln(double xx) {
  double x,y,tmp,ser;
  static double cof[6] = {76.18009172947146,-86.50532032941677,
    24.01409824083091, -1.231739572450155,
    0.1208650973866179e-2,-0.5395239384953e-5};
  int j;

  y=x=xx;
  tmp=x+5.5;
  tmp -= (x+0.5)*log(tmp);
  ser=1.000000000190015;
  for(j=0;j<=5;j++) ser+= cof[j]/++y;
  return -tmp+log(2.5066282746310005*ser/x);
}

double factln(int n) {
  static double a[101];

  if (n<=1) return 0.0;
  if (n<=100) return a[n] ? a[n] :(a[n]=gammln(n+1.0));
  else return gammln(n+1.0);
}

double bico(int n, int k) {
  return floor(0.5+exp(factln(n)-factln(k)-factln(n-k)));
}


void CompOE::fpstrat_gauss_seidel(VectorMTL<double> &iota1, VectorMTL<double> &rho1, VectorMTL<double> &V1,
  VectorMTL<double> &prof, VectorMTL<double> &expfreq, VectorMTL<double> &tildes,
  VectorMTL<double> &d, VectorMTL<double> &p0) {

  int n=1;
  #if TRANSITION_MATRIX == 0
    MatrixMTL<double> tranmat0(xmax,xmax);
    MatrixMTL<double> tranmat1(xmax,xmax);
    MatrixMTL<double> conttranmat(xmax,xmax);
  #elif TRANSITION_MATRIX == 1
    TriDiagMatrixMTL<double> tranmat0(xmax);
    TriDiagMatrixMTL<double> tranmat1(xmax);
    TriDiagMatrixMTL<double> conttranmat(xmax);
  #elif TRANSITION_MATRIX == 2
    SparseMatrixMTL<double> tranmat0;
    SparseMatrixMTL<double> tranmat1;
    SparseMatrixMTL<double> conttranmat;
  #else
    #error Invalid value for TRANSITION_MATRIX
  #endif
  VectorMTL<double> iota0(xmax);
  VectorMTL<double> rho0(xmax);
  VectorMTL<double> prcont0(xmax);
  VectorMTL<double> condexp(xmax);

  continuationProb(rho1,*prcont1,condexp);
  tranProb(iota1,tranmat1,conttranmat,*prcont1);

  iota0=0;
  rho0=0;

  double lambda_old=lambda;

  while(1) {
    /* smooth update of strategies */
    iota0=iota1/(pow(n,convtol[10]))+iota0*(1-1/(pow(n,convtol[10])));

    rho0=rho1/(pow(n,convtol[10]))+rho0*(1-1/(pow(n,convtol[10])));

    continuationProb(rho0,prcont0,condexp);
    tranProb(iota0,tranmat0,conttranmat,prcont0);
    expState(conttranmat, tildes, expfreq, d);

    VectorMTL<double> tildessub(xmax);
    tildessub=tildes;
    if(subtract==1) {
      if((control[2]==0) && (control[1]==1)) { // Poisson
        for(int x=0;x<xmax;++x) {
          tildessub[x]=tildessub[x]/(1-exp(-tildessub[x]))-1;
        }
      } else {
        double tildesn=sum(tildessub);
        if(tildesn>1) {
          tildessub-=(tildessub/tildesn);
        }
      }
    }

    if(!compProf(tildessub,p0,prof)) {
      success=0;
      return;
    }

//    cout << tildes << endl;
//    cout << prof << endl;
//    getchar();

    valueIt(prof, iota1, rho1, V1, tranmat1, *prcont1, d, condexp);
    double mutiplier = V1[int(constants[3])-1]*constants[2]/constants[0];
    if((convtol[15]>0) && (mutiplier>convtol[15])) {
      mutiplier=convtol[15];
    } else if((convtol[14]>0) && (mutiplier<convtol[14])) {
      mutiplier=convtol[14];
    }

    lambda=lambda_old*mutiplier;
    
    double zero_profit = V1[int(constants[3])-1]*constants[2]-constants[0];
    
//    cout << lambda << ", " << lambda_old << ", " <<  V1[int(constants[3])-1]*constants[2]/constants[0] << ", " << zero_profit << endl;
//    getchar();

    if((((n-1)/100)<(n/100)) || (n==1)) {
      #ifdef DEBUG
        *myfile << "    fpstrat iteration: " << n << " (" << diffNorm(*prcont1,prcont0) << ")" <<
          "(" << diffNorm(tranmat1,tranmat0)<< ") Lambda = " << lambda << ", ZP = " << zero_profit  << endl;
      #endif
      #ifdef COUT_DEBUG
        cout << "    fpstrat iteration: " << n << " (" << diffNorm(*prcont1,prcont0) << "," <<
          diffNorm(tranmat1,tranmat0)<< ") Lambda = " << lambda << ", ZP = " << zero_profit <<  endl;
      #endif
    }

    n++;

    if (lambda<convtol[12] || lambda>convtol[13]) {   /* Checks for entry rate outside accepted range */
       success=0;
       #ifdef DEBUG
         *myfile <<endl<< "Bound for lambda = " << lambda << " was hit. Stopping..."<< endl<<endl;
       #endif
       #ifdef COUT_DEBUG
         cout <<endl<< "Bound for lambda = " << lambda << " was hit. Stopping..."<< endl<<endl;
       #endif
       lambda = -1;
       success=0;
       return;
    }
					

    if ( (diffNorm(*prcont1,prcont0)<convtol[1]) && (diffNorm(tranmat1,tranmat0)<convtol[1]) &&
       ( (fabs(zero_profit)<convtol[5]) || (fabs(lambda-lambda_old)/lambda)<convtol[16] ) ) {
        #ifdef DEBUG
          *myfile << "  Tolerance reached: " << n << " (" << diffNorm(*prcont1,prcont0) << ")" <<
            "(" << diffNorm(tranmat1,tranmat0)<< ") Lambda = " << lambda << ", ZP = " << zero_profit  << endl;
        #endif
        #ifdef COUT_DEBUG
          cout << "  Tolerance reached: " << n << " (" << diffNorm(*prcont1,prcont0) << "," <<
            diffNorm(tranmat1,tranmat0)<< ") Lambda = " << lambda << ", ZP = " << zero_profit <<  endl;
        #endif
	return;
    } else if(n>=convtol[2]) {
        #ifdef DEBUG
          *myfile << "  Max. # of iterations hit: " << n << " (" << diffNorm(*prcont1,prcont0) << ")" <<
            "(" << diffNorm(tranmat1,tranmat0)<< ") Lambda = " << lambda << ", ZP = " << zero_profit  << endl;
        #endif
        #ifdef COUT_DEBUG
          cout << "  Max. # of iterations hit: " << n << " (" << diffNorm(*prcont1,prcont0) << "," <<
            diffNorm(tranmat1,tranmat0)<< ") Lambda = " << lambda << ", ZP = " << zero_profit <<  endl;
        #endif
        success=0;
	return;
    }

    lambda_old=lambda;
  }
}

