/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "compoe_aggr.h"

CompOE_aggr::CompOE_aggr() : CompOE() {
  q=NULL;
  iotaMatrix0_global=NULL;
  rhoMatrix0_global=NULL;
  V_global=NULL;
  V_expected_global=NULL;
  tildesMatrix_global=NULL;
  profitMatrix_global=NULL;
  pricesMatrix_global=NULL;
  lambdaVector0_global=NULL;
  bound1avg_aggr=NULL;
  bound1var_aggr=NULL;
  bound1pre_aggr=NULL;
  bound1por_aggr=NULL;
  bound2avg_aggr=NULL;
  bound2var_aggr=NULL;
  bound2pre_aggr=NULL;
  bound2por_aggr=NULL;
  bound3avg_aggr=NULL;
  bound3var_aggr=NULL;
  bound3pre_aggr=NULL;
  bound3por_aggr=NULL;
  #ifdef ACW
    action_profit = NULL;
    acwTran = NULL;
    tranmat3D = NULL;
    action_profitMatrix_global = NULL;
  #endif
}

void CompOE_aggr::valueIt(MatrixMTL<double> &profitMatrix, MatrixMTL<double> &iota, 
  MatrixMTL<double> &rho, MatrixMTL<double> &V, MatrixMTL<double> &V_expected, MatrixMTL<double> &dMatrix,
  SparseMatrixMTL<double> &shockTran) {

  #if TRANSITION_MATRIX == 0
    MatrixMTL<double> tranmat_w(xmax);
    MatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 1
    TriDiagMatrixMTL<double> tranmat_w(xmax);
    TriDiagMatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 2
    SparseMatrixMTL<double> tranmat_w(xmax);
    SparseMatrixMTL<double> conttranmat_w(xmax);
  #else 
  #error Invalid value for TRANSITION_MATRIX
  #endif

  VectorMTL<double> V_w(xmax), Vnew_w(xmax) ,condexp_w(xmax),prcont_w(xmax),d(xmax);
  VectorMTL<double> iota_w(xmax),rho_w(xmax), profit_w(xmax);
  VectorMTL<double> distr_w(shock_states);

  double Norm=1;
  int i=0;

  #ifndef ACW
  for(int i=0;i<shock_states;i++) {
    for(int j=0;j<xmax;j++) {
      V[i][j]=profitMatrix[i][j]/(1-constants[2])+transition[0];
    }
  }
  #else
  V=0;
  #endif

//  cout << "V initialized" << endl;
//  getchar();

  // Set prcont to something so that tranProb will work
  prcont_w = 0;

//  ofstream myfile2;
//  myfile2.open ("output_conttran");

  while (1) {
    i++; 
    if(i>1000) {
      cout << "Value iteration hit maximum" << endl;
      break;
    }

    Norm = 0;

    int expectation_w_iterator=0;

    for(int w=0;w<shock_states;w++) {
      if((*q)[w]>0) {
        setShock(w);
//      cout << "State: " << w << endl;

        #ifndef ACW

        /*** Compute expected value function given w ***/
        int j;
        for(int x=0;x<xmax;x++) {
          V_w[x]=0;
          j=expectation_w_iterator;
          while(1) {
            // End of matrix or end of row
            if( (j==shockTran.getSize()) || (shockTran.rows[j]>w) ) {
              break;
            }
//            cout << w << " " << j << " " << shockTran.columns[j] <<  " " << shockTran[j] << endl; getchar(); 
            // This is Gauss-Sidel in V !!!
            V_w[x]+=shockTran[j]*V[shockTran.columns[j]][x];
            j++;
          }
        }
        expectation_w_iterator=j;

//      cout << "Expected V:"<< endl << V_w << endl;
//      getchar();

        V_expected.setRow(w,V_w);

//      myfile2 << "State " << w << endl;
//      myfile2 << V << endl;
//      myfile2 << V_w << endl;
        
        /*** Compute optimal investment ***/
        d=dMatrix.getRow(w);
        iota_w = optInv(V_w,d);
        iota.setRow(w,iota_w);
//        cout  << w << " " <<  iota_w << endl;

        /*** Compute transition probabilities ***/
        tranProb(iota_w,tranmat_w,conttranmat_w,prcont_w);

        /*** Compute continuation values if not exiting ***/
        rho_w = (-iota_w*d) + ((tranmat_w.dot(V_w))*constants[2]);
        rho.setRow(w,rho_w);

        /*** Compute continuation probs. and conditional expectation sell-off ***
         *** value, conditional on exiting                                    ***/

        continuationProb(rho_w,prcont_w,condexp_w);

        /*** Compute new function for w ***/
        profit_w = profitMatrix.getRow(w);
//        cout << V_w << endl;
//        cout << profit_w << endl;
//	cout << rho_w << endl; getchar();
	
        Vnew_w = profit_w + (-prcont_w+1.0)*condexp_w+prcont_w*rho_w;
        #else
        int j;
        for(int x=0;x<xmax;x++) {
          for(int a=0;a<constants[6];++a) {
            (*RHSFringe)[w][x][a]=0;
          }
          j=expectation_w_iterator;
          while(1) {
            if( (j==shockTran.getSize()) || (shockTran.rows[j]>w) ) {
              break;
            }
            for(int a=0;a<constants[6]-1;++a) {
              (*RHSFringe)[w][x][a]+=shockTran[j]*((*action_profitMatrix_global)[shockTran.columns[j]][a][x]+constants[2]*V[shockTran.columns[j]][(*acwTran)[a][x]]);
            }
            j++;
          }

          Vnew_w[x] = 0;
          for(int a=0;a<constants[6];++a) {
            Vnew_w[x] += exp((*RHSFringe)[w][x][a]/constants[7]);
          }
          Vnew_w[x] = constants[7]*(log(Vnew_w[x])+0.577215665);
        }

        expectation_w_iterator=j; 

        Vnew_w[xmax-1] = 0;
        #endif

        /*** Check the difference ***/
        Norm = MAX(Norm,norm(Vnew_w-V.getRow(w)));

        /*** Update value funtion ***/
        V.setRow(w, Vnew_w);
        restore();
      } else {
        V_w = -1;
        V_expected.setRow(w,V_w);
        V.setRow(w, V_w);
        rho.setRow(w, V_w);
        iota.setRow(w, V_w);
        // Iterate those shocks that we are skipping to have the right value of the iterator
        while(1) {
            // End of matrix or end of row
            if( (expectation_w_iterator==shockTran.getSize()) || (shockTran.rows[expectation_w_iterator]>w) ) {
              break;
            }
            expectation_w_iterator++;
        }
      }
    }

//    myfile2.close();
//    exit(1);

//    cout << Norm << endl; getchar();

    if(Norm<convtol[0]) {
      break;
    }
  }
}


int CompOE_aggr::compute_aggr(int &xmaxInit, VectorMTL<double> &iotaInit, VectorMTL<double> &rhoInit, 
  double lambdaInit, SparseMatrixMTL<double> &shockTran) {
  xmax = xmaxInit;
  shock_states = shockTran.getNRows();

  struct tms t,u;
  long r1,r2;

  VectorMTL<double> lambdaVector1(shock_states);
  lambdaVector1=lambdaInit;

  subtract=control[4];

  // Create global variables
  if(lambdaVector0_global!=NULL) delete lambdaVector0_global;
  lambdaVector0_global = new VectorMTL<double>(shock_states);

  if(iotaMatrix0_global!=NULL) delete iotaMatrix0_global;
  iotaMatrix0_global = new MatrixMTL<double>(shock_states,xmax);

  if(rhoMatrix0_global!=NULL) delete rhoMatrix0_global;
  rhoMatrix0_global = new MatrixMTL<double>(shock_states,xmax);

  if(V_global!=NULL) delete V_global;
  V_global = new MatrixMTL<double>(shock_states,xmax);

  if(V_expected_global!=NULL) delete V_expected_global;
  V_expected_global = new MatrixMTL<double>(shock_states,xmax);

  if(tildesMatrix_global!=NULL) delete tildesMatrix_global;
  tildesMatrix_global = new MatrixMTL<double>(shock_states,xmax);

  if(profitMatrix_global!=NULL) delete profitMatrix_global;
  profitMatrix_global = new MatrixMTL<double>(shock_states,xmax);

  if(pricesMatrix_global!=NULL) delete pricesMatrix_global;
  pricesMatrix_global = new MatrixMTL<double>(shock_states,xmax);

  MatrixMTL<double> *iotaMatrix1 = new MatrixMTL<double>(shock_states,xmax);
  MatrixMTL<double> *rhoMatrix1 = new MatrixMTL<double>(shock_states,xmax);

  (*pricesMatrix_global) = prof_fun[9];

  // Precompute investment cost
  MatrixMTL<double> *dMatrix = new MatrixMTL<double>(shock_states,xmax);
  for(int w=0;w<shock_states;w++) {
    setShock(w);
    for(int i=0;i<xmax;i++) {
      (*dMatrix)[w][i]=MACRO__MINVCOST(i);
    }
    restore();
  }

  // Initialize Iota and rho

  for(int i=0;i<shock_states;i++) {
    for(int j=0;j<xmax;j++) {
//      cout << "(" << i << "," << j << ")" << endl;
      (*iotaMatrix0_global)[i][j]=iotaInit[j];
      (*rhoMatrix0_global)[i][j]=rhoInit[j];
    }
  }

  // Precompute stationary distribution of shocks
  if(q!=NULL) {
    delete q;
  }
  q = new VectorMTL<double>(shock_states);

  if(shockTran.statDistr(*q)!=1) {
    cout << "Cannot compute stationary distribution of shocks" << endl;
    exit(1);
  }

  *V_expected_global=0;

  // action specific profit function in the Collard-Wexler model
  #ifdef ACW
    if (action_profit!=NULL) delete action_profit;
    action_profit = new MatrixMTL<double>(constants[6],xmax);

    if (acwTran!=NULL) delete acwTran;
    acwTran = new MatrixMTL<int>(constants[6],xmax);
    // State: 0 - S, 1-SM, 2-SL, 3-M, 4-ML, 5-L, 6-Out
    // Actions: 0 - S, 1 - M, 2 - L, 3-Out
    (*acwTran)[0][0]=0; (*acwTran)[1][0]=3; (*acwTran)[2][0]=5; (*acwTran)[3][0]=6;
    (*acwTran)[0][1]=1; (*acwTran)[1][1]=3; (*acwTran)[2][1]=5; (*acwTran)[3][1]=6;
    (*acwTran)[0][2]=2; (*acwTran)[1][2]=4; (*acwTran)[2][2]=5; (*acwTran)[3][2]=6;
    (*acwTran)[0][3]=1; (*acwTran)[1][3]=3; (*acwTran)[2][3]=5; (*acwTran)[3][3]=6;
    (*acwTran)[0][4]=2; (*acwTran)[1][4]=4; (*acwTran)[2][4]=5; (*acwTran)[3][4]=6;
    (*acwTran)[0][5]=2; (*acwTran)[1][5]=4; (*acwTran)[2][5]=5; (*acwTran)[3][5]=6;
    (*acwTran)[0][6]=0; (*acwTran)[1][6]=3; (*acwTran)[2][6]=5; (*acwTran)[3][6]=6;

    if (tranmat3D!=NULL) delete tranmat3D;
    tranmat3D = new MatrixMTL3D<double>(xmax,xmax,shock_states);
    if (action_profitMatrix_global!=NULL) delete action_profitMatrix_global;
    action_profitMatrix_global = new MatrixMTL3D<double>(constants[6],xmax,shock_states);
    *action_profit=0;
    
    if (RHSFringe!=NULL) delete RHSFringe;
    RHSFringe = new MatrixMTL3D<double>(xmax,constants[6],shock_states);
    
    for(int w=0;w<shock_states;w++) {
      MatrixMTL<double> tranmat_w(xmax);  
      (*RHSFringe)[w]=0;
      tranProbACW((*RHSFringe)[w],tranmat_w);
      (*tranmat3D)[w]=tranmat_w;
    }
  #endif 

  int uignore;
  if(aggrparams[4]>10) {
    aggrparams[4]-=10;
    uignore=3;
  } else {
    uignore=2;
  }

  for(ignore=int(aggrparams[4]);ignore<=uignore;ignore++) {
    int n=1;
    if(ignore==3) {
      #ifdef COUT_DEBUG
        cout << "Aggregate shocks: Compute with simulated profit function"<< endl;  
      #endif
      #ifdef DEBUG
        *myfile << "Aggregate shocks: Compute with simulated profit function"<< endl;
      #endif
    } else if(ignore==1) { 
      #ifdef COUT_DEBUG
        cout << "Aggregate shocks: Compute with approximated profit function"<< endl;
      #endif
      #ifdef DEBUG
        *myfile << "Aggregate shocks: Compute with approximated profit function"<< endl;
      #endif
    } else {
      #ifdef COUT_DEBUG
        cout << "Aggregate shocks: Compute with full profit function"<< endl;
      #endif
      #ifdef DEBUG
        *myfile << "Aggregate shocks: Compute with full profit function"<< endl;
      #endif
    }

    while(1) {
      double Delta0=0;
      double Delta1=0;
      r1 = times(&t);
      (*lambdaVector0_global)=lambdaVector1;

      // Compute s_tildes
      computeTildes(*iotaMatrix0_global, *rhoMatrix0_global, 
        (*lambdaVector0_global), shockTran, *tildesMatrix_global);

      //cout << *tildesMatrix_global << endl;
      //getchar();

      // Precompute profits
      if(ignore<3) {
        for(int w=0;w<shock_states;w++) {
          if((*q)[w]>0) {
            setShock(w);
            VectorMTL<double> profit_w(xmax);
            VectorMTL<double> prices_w(xmax);
            VectorMTL<double> tildes_w(xmax);
            tildes_w = tildesMatrix_global->getRow(w);
            prices_w = pricesMatrix_global->getRow(w);
            compProf(tildes_w,prices_w,profit_w);
            #ifdef ACW
            (*action_profitMatrix_global)[w]=(*action_profit);
            #endif
            pricesMatrix_global->setRow(w, prices_w);
            profitMatrix_global->setRow(w, profit_w);
            restore();
          } else {
            VectorMTL<double> profit_w(xmax);
            profit_w = -1;
            pricesMatrix_global->setRow(w, profit_w);
            profitMatrix_global->setRow(w, profit_w);
          }
        }
      } else { // Simulate
#ifndef ACW
          cout << "Not implemented\n";
          // Not implemented because the transition matrices are empty!!!
          // tranmat3D
          exit(1);
#else
        subtract=0;
#ifdef ACW
        subtract=1;
#endif
        VectorMTL<double> profit_w(xmax);
        VectorMTL<double> prices_w(xmax);

        for(int w=0;w<shock_states;w++) {
          if((*q)[w]>0) {
#ifdef ACW
            (*action_profitMatrix_global)[w]=0;
#endif
            profit_w=0;
            profitMatrix_global->setRow(w, profit_w);
          } else {
            profit_w = -1;
            pricesMatrix_global->setRow(w, profit_w);
            profitMatrix_global->setRow(w, profit_w);
          }
        }

        RanGenLib P;
        srand48(634856435);

        // Simulate L times
        int w = 0;
        VectorMTL<double> state(xmax); 
        VectorMTL<double> state_new(xmax);
        state = 0; state[6]=control[2]-1;
#ifdef ACW
        state[6]=control[2];
#endif
        int L=1e5;
        int M=1e6;

        for(int i=0;i<L;i++) {
          state_new.genMarkov(P,(*tranmat3D)[w],state);
          w = genDistr(P,shockTran.getRow(w));

          int entrants;
          // Simulate entry
          if(control[2]>0) {
            entrants = 0;
          } else {
            if(control[1]==2) {
              cout << "Not implemented\n";
              exit(1);
            } else {
              entrants = P.genPoisson((*lambdaVector0_global)[w]);
            }
          }

          // Add entry
          state_new[int(constants[3])-1]+=entrants;
          state=state_new;
        } // End of L loop

        int mindraw=0;
        VectorMTL<int> drawvector(shock_states);
        drawvector=0;
        while(mindraw<M) {
          state_new.genMarkov(P,(*tranmat3D)[w],state);
          w = genDistr(P,shockTran.getRow(w));
          drawvector[w]++;
          mindraw=M+1;
          for(int w1=0;w1<shock_states;w1++) {
            if((*q)[w1]>0) {
              mindraw=MIN(mindraw,drawvector[w1]);
            }
          }

          int entrants;
          // Simulate entry
          if(control[2]>0) {
            entrants = 0;
          } else { 
            if(control[1]==2) {
              cout << "Not implemented\n";
              exit(1);
            } else {
              entrants = P.genPoisson((*lambdaVector0_global)[w]);
            }
          }

          // Add entry
          state_new[int(constants[3])-1]+=entrants;
          state=state_new;

          // Compute profit
          setShock(w);
          VectorMTL<double> profit2_w(xmax);
          prices_w = pricesMatrix_global->getRow(w);
          profit2_w = profitMatrix_global->getRow(w);
          compProf(state,prices_w,profit_w);
          #ifdef ACW
          (*action_profitMatrix_global)[w]+=(*action_profit);
          #endif
          pricesMatrix_global->setRow(w, prices_w);
          profitMatrix_global->setRow(w, profit2_w+profit_w);
          restore();
        } // End of L loop

        // Divide
        for(w=0;w<shock_states;w++) {
          if((*q)[w]>0) {
            for(int x=0;x<xmax;++x) {
              (*profitMatrix_global)[w][x]/=drawvector[w];
            }
            #ifdef ACW
            (*action_profitMatrix_global)[w]/=drawvector[w];
            #endif
          }
        }

        subtract=control[4];
#endif
      }
        
      // Compute iota and rho
      valueIt(*profitMatrix_global, *iotaMatrix1, *rhoMatrix1, *V_global, *V_expected_global, *dMatrix, shockTran);

      #ifdef ACW
      // Precompute transition strategies
      Delta0=0;
      for(int w=0;w<shock_states;w++) {
        setShock(w);
        MatrixMTL<double> tranmat_w(xmax);
        VectorMTL<double> V_w(xmax);

        // Compute transitions
        tranProbACW((*RHSFringe)[w],tranmat_w);
        //cout << tranmat_w;
        //cout << "--" << endl;

        // Update transitions
        Delta0=MAX(Delta0,norm((tranmat_w)-(*tranmat3D)[w]));
        //(*tranmat3D)[w]=tranmat_w;
        (*tranmat3D)[w]+=((tranmat_w)-(*tranmat3D)[w])/(pow(n,aggrparams[7])+aggrparams[8]);
        restore();
      }
      r2 = times(&u);
      if((((n-1)/1)<(n/1)) || (n==1)) {
        cout << "Iteration: " << n << endl;
        cout << "Stop: " << Delta0 << endl;
        cout << "Time of the iteration: " << r2-r1 <<endl;
      }
      if(Delta0<aggrparams[1]) break;

      //getchar();
      #else
      // Update lambda
      for(int w=0;w<shock_states;w++) {
        if((*q)[w]>0) {
          VectorMTL<double> V_expected_w(xmax);
          V_expected_w=V_expected_global->getRow(w);
          lambdaVector1[w]=(*lambdaVector0_global)[w]*V_expected_w[int(constants[3])-1]*constants[2]/constants[0];
          double temp = V_expected_w[int(constants[3])-1]*constants[2]-constants[0];
          Delta0=MAX(temp,Delta0);
          if(lambdaVector1[w]>aggrparams[3]) {
            Delta1=MAX(Delta1,-temp);
          }
        } else {
          lambdaVector1[w]=-1;
        }
      }

      // Update iota and rho
      (*rhoMatrix0_global)+=((*rhoMatrix1)-(*rhoMatrix0_global))/(pow(n,aggrparams[7])+aggrparams[8]);
      (*iotaMatrix0_global)+=((*iotaMatrix1)-(*iotaMatrix0_global))/(pow(n,aggrparams[7])+aggrparams[8]);

//      cout << V_expected_global->getRow(0);
//      cout << rhoMatrix1->getRow(0);
//      cout << rhoMatrix0_global->getRow(0);
//      cout << iotaMatrix0_global->getRow(0);
//      getchar();

//      cout << ambdaVector0_global[0] << endl;
//      getchar();
     

      r2 = times(&u);
      if((((n-1)/100)<(n/100)) || (n==1)) {
        #ifdef COUT_DEBUG
          cout << "Iteration: " << n << endl;
          cout << "Iota stop: " << norm((*iotaMatrix0_global)-(*iotaMatrix1)) << "\t\t Rho stop = "
            << norm((*rhoMatrix0_global)-(*rhoMatrix1)) << endl;
          cout << "Lambda stop: Delta0 = " << Delta0 << ", Delta1 = " 
            << Delta1 << ", norm: " << norm(lambdaVector1-(*lambdaVector0_global))<< endl;
          cout << "Time of the iteration: " << r2-r1 <<endl;
        #endif

        #ifdef DEBUG
          *myfile << "Iteration: " << n << endl;
          *myfile << "Iota stop: " << norm((*iotaMatrix0_global)-(*iotaMatrix1)) << "\t\t Rho stop = "
            << norm((*rhoMatrix0_global)-(*rhoMatrix1)) << endl;
          *myfile << "Lambda stop: Delta0 = " << Delta0 << ", Delta1 = " 
            << Delta1 << ", norm: " << norm(lambdaVector1-(*lambdaVector0_global))<< endl;
          *myfile << "Time of the iteration: " << r2-r1 <<endl;
        #endif
      }

      /*** Stopping criterion ***/
      if ((norm((*iotaMatrix0_global)-(*iotaMatrix1)) < aggrparams[1]) && 
        (norm((*rhoMatrix0_global)-(*rhoMatrix1)) < aggrparams[0]) &&
        (Delta0<aggrparams[2]) && (Delta1<aggrparams[2])) { 
          break;
      }
      #endif

      n++;
    }
  }

  for(int w=0;w<shock_states;w++) {
    if(lambdaVector1[w]>aggrparams[3]) {
      (*lambdaVector0_global)[w]=lambdaVector1[w];
    } else {
      (*lambdaVector0_global)[w]=0;
    } 
  }

  //cout << setprecision(4);
  //cout << (*tranmat3D)[0];
  //cout << (*tranmat3D)[9];
//  cout << (*action_profitMatrix_global)[5];

  #ifdef ACW
  /*cout << V_expected_global->getRow(5);
  cout << (*action_profitMatrix_global)[5];
  cout << "--------" << endl;
  cout << (*tranmat3D)[0];
  cout << "--------" << endl;
  cout << (*tranmat3D)[5];
  
  for(int w=0;w<shock_states;++w) {
     cout << (*tranmat3D)[w].getRow(6);// << "--------" << endl;
  } 
  cout << "--------" << endl;
  for(int w=0;w<shock_states;++w) {
     cout << (*tranmat3D)[w].getRow(5);// << "--------" << endl;
  }
  cout << "--------" << endl;
  for(int w=0;w<shock_states;++w) {
     cout << (*tranmat3D)[w].getRow(3);// << "--------" << endl;
  }
  cout << "--------" << endl;
  for(int w=0;w<shock_states;++w) {
     cout << (*tranmat3D)[w].getRow(0);// << "--------" << endl;
  }
  */
  #endif
}

void CompOE_aggr::computeTildes(MatrixMTL<double> &iotaMatrix, 
  MatrixMTL<double> &rhoMatrix, VectorMTL<double> &lambdaVector, 
  SparseMatrixMTL<double> &shockTran, MatrixMTL<double> &tildesMatrix) {

  // Compute p(x',w'|x,w)
  // Rows (columns) have shock_states number of blocks of size xmax
  // Size of the matrix is shock_states*xmax
  // Each submatrix corresponds to one (w,w') pair and its
  // elements are given by P(x'|x,w)P(w'|w)
  // Number of zeros in each submatrix equals to number of zeros in P(x'|x,w)

  #if TRANSITION_MATRIX == 0
  MatrixMTL<double> tranmat_w(xmax);
  MatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 1
  TriDiagMatrixMTL<double> tranmat_w(xmax);
  TriDiagMatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 2
  SparseMatrixMTL<double> tranmat_w(xmax);
  SparseMatrixMTL<double> conttranmat_w(xmax);
  #error Invalid value for TRANSITION_MATRIX
  #endif
  VectorMTL<double> prcont_w(xmax);
  VectorMTL<double> iota_w(xmax);
  VectorMTL<double> rho_w(xmax);
  VectorMTL<double> condexp_w(xmax);

  // STEP I: Calculate number of nonzero elements
  int p_size = shockTran.getSize()*getTransitionSize();
//  cout << "Size of p: " << p_size <<endl;
  // Allocate the matrix
  int p_dim = shock_states*xmax;
  SparseMatrixMTL<double> p(p_dim, p_dim, p_size);

  // Compute p_matrix
  // Loop over rows
  int p_iterator = 0;
  int first_element_of_row = 0;
  int offset_w = 0;

  for(int w=0;w<shockTran.nrows;w++) {
    if((*q)[w]>0) {
      #ifndef ACW
      iota_w = iotaMatrix.getRow(w);
//    iota_w+=w;
      rho_w = rhoMatrix.getRow(w);
      setShock(w);
      continuationProb(rho_w,prcont_w,condexp_w);
      tranProb(iota_w, tranmat_w, conttranmat_w, prcont_w);
      restore();
      #else
      conttranmat_w=(*tranmat3D)[w];
      #endif
    } else {
      conttranmat_w = 0;
    }
    #if TRANSITION_MATRIX == 0
    // Row loop
    int i=first_element_of_row;
    for(int j=0;j<xmax;j++) {
      i=first_element_of_row;
      int offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
      // Wprime loop
      while(1) {
        if((i==shockTran.getSize()) ||(shockTran.rows[i]>w)) {
          break;
        }

        double p_w_wprime = shockTran[i];

        // Columns of the transition
        for(int j1=0;j1<xmax;j1++) {
          p.rows[p_iterator]=offset_w;
          p.columns[p_iterator]=offset_w_prime+j1;
          p[p_iterator]=conttranmat_w[j][j1]*p_w_wprime;
          p_iterator++;
        }
        i++;
        offset_w_prime=shockTran.columns[i]*xmax;
      }
      offset_w++;
    }
    first_element_of_row=i;

    #elif TRANSITION_MATRIX == 1
    // Loop over conttranmax

    // First row //
    int offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
    // Loop over columns of w
    int i=first_element_of_row;
    while(1) {
      if((i==shockTran.getSize())  || (shockTran.rows[i]>w)) {
        break;
      }

      double p_w_wprime = shockTran[i];

      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime;
      p[p_iterator]=conttranmat_w[0][0]*p_w_wprime;
      p_iterator++;

      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime+1;
      p[p_iterator]=conttranmat_w[-1][0]*p_w_wprime;
      p_iterator++;

      i++;
      offset_w_prime=shockTran.columns[i]*xmax;
    }
    offset_w++;

    // Middle rows
    for(int j=1;j<xmax-1;j++) {
      offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
      i=first_element_of_row;
      while(1) {
        if((i==shockTran.getSize()) ||(shockTran.rows[i]>w)) {
          break;
        }

        double p_w_wprime = shockTran[i];

        p.rows[p_iterator]=offset_w;
        p.columns[p_iterator]=offset_w_prime+j-1;
        p[p_iterator]=conttranmat_w[1][j-1]*p_w_wprime;
        p_iterator++;

        p.rows[p_iterator]=offset_w;
        p.columns[p_iterator]=offset_w_prime+j;
        p[p_iterator]=conttranmat_w[0][j]*p_w_wprime;
        p_iterator++;

        p.rows[p_iterator]=offset_w;
        p.columns[p_iterator]=offset_w_prime+j+1;
        p[p_iterator]=conttranmat_w[-1][j]*p_w_wprime;
        p_iterator++;

        i++;
        offset_w_prime=shockTran.columns[i]*xmax;
      }
      offset_w++;
    }

    i=first_element_of_row;
    offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
    while(1) {
      if((i==shockTran.getSize()) ||(shockTran.rows[i]>w)) {
        break;
      }

      double p_w_wprime = shockTran[i];

      // Last row
      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime+xmax-2;
      p[p_iterator]=conttranmat_w[1][xmax-2]*p_w_wprime;
      p_iterator++;

      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime+xmax-1;
      p[p_iterator]=conttranmat_w[0][xmax-1]*p_w_wprime;
      p_iterator++;

      i++;
      offset_w_prime=shockTran.columns[i]*xmax;
    }
    offset_w++;

    first_element_of_row = i;
    #elif TRANSITION_MATRIX == 2
    #else 
    #error Invalid value for TRANSITION_MATRIX
    #endif
  }

  if(control[2]==0) {
    // Compute b vector
    VectorMTL<double> b(p_dim);
    // First zero out the vector b
    b=0;
    // Loop for (w,w')
    for(int i=0;i<shockTran.getSize();i++) {
      b[shockTran.columns[i]*xmax+int(constants[3])-1]
        -=lambdaVector[shockTran.rows[i]]*(*q)[shockTran.rows[i]]*shockTran[i];
    }

    // Solve for pi
    VectorMTL<double> pi(p_dim);
    p.addDiag(-1);
    p.primesolve(b,pi);

    offset_w = 0;
    for(int w=0;w<shock_states;w++) {
      double temp_q = (*q)[w];
      if(temp_q==0) {
        for(int x=0;x<xmax;x++) {
          tildesMatrix[w][x]=-1;
        }
      } else {
        for(int x=0;x<xmax;x++) {
          tildesMatrix[w][x]=pi[offset_w+x]/temp_q;
        }
      }
      offset_w+=xmax;
    }
  } else {
    VectorMTL<double> pi(p_dim);
    p.statDistr(pi);

//    ofstream myfile2;
//    myfile2.open ("example.txt");
//    myfile << p;
//    myfile.close();
//    cout << p;
//    cout << pi;
//    getchar();
    
    int z=0;
    for(int w=0;w<shock_states;w++) {
      for(int x=0;x<xmax;x++) {
        tildesMatrix[w][x]=control[2]*pi[z]/((*q)[w]);
        z++;
      }
    }
  }
}

void CompOE_aggr::computeBounds_aggr(double *bounds_init, MatrixMTL<double> &iota, 
  MatrixMTL<double> &rho, MatrixMTL<double> &tildes, 
  VectorMTL<double> &lambdaVector, MatrixMTL<double> &prices,
  SparseMatrixMTL<double> &shockTran) {

//  cout << "prices: " <<endl<< prices << endl;
//  getchar();
//  cout << "tildes: " << endl<<tildes << endl;
//  getchar();
//  return;
//  cout<< rho;
//  getchar();
//  cout<<iota;
//  getchar();
//  cout<<lambdaVector;
//  getchar();
  ignore=2;
  int kmaxsum;
  xmax = iota.getLength();
  shock_states = iota.getHeight();
  bounds = bounds_init; 

  VectorMTL<double> Vsum(xmax),Vsqr(xmax),Vpre(xmax),Vvar(xmax),Vavg(xmax);
  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> tranMatrix_w(xmax,xmax);
    MatrixMTL<double> contTranMatrix_w(xmax,xmax);
    MatrixMTL3D<double> contTranMatrix_infty(xmax,xmax,shock_states);
    MatrixMTL3D<double> contTranMatrix(xmax,xmax,shock_states);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranMatrix_w(xmax);
    TriDiagMatrixMTL<double> contTranMatrix_w(xmax);
    TriDiagMatrix3D<double> contTranMatrix_infty(xmax,shock_states);
    TriDiagMatrix3D<double> contTranMatrix(xmax,shock_states);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> tranMatrix_w;
    SparseMatrixMTL<double> contTranMatrix_w;
    SparseMatrix3D<double> contTranMatrix(shock_states);
    SparseMatrix3D<double> contTranMatrix_infty(shock_states);
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif

  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);
  VectorMTL<double> rho_w(xmax);
  VectorMTL<double> iota_w(xmax);


  VectorMTL<double> p(shock_states);

  VectorMTL<double> bound1sum(xmax), bound1sum_sim(xmax), bound1sqr(xmax);
  VectorMTL<double> bound2sum(xmax), bound2sum_sim(xmax), bound2sqr(xmax);
  VectorMTL<double> bound3sum(xmax), bound3sum_sim(xmax), bound3sqr(xmax);

  double boundspre;
  MatrixMTL<double> *g=NULL;

  int xmax_ext = xmax * int(bounds[7]);

  /*** Extended vectors ***/
  MatrixMTL<double> tildes_ext(shock_states,xmax_ext);
  MatrixMTL<double> proftildes_ext(shock_states,xmax_ext);
  MatrixMTL<double> prices_ext(shock_states,xmax_ext);
  VectorMTL<double> s0_ext(xmax_ext);
  VectorMTL<double> state(xmax_ext);
  VectorMTL<double> state_new(xmax_ext);
  VectorMTL<double> state_sim(xmax_ext);
  VectorMTL<double> profsim(xmax_ext);
  VectorMTL<double> profsim_xmax(xmax);
  VectorMTL<double> difprofit(xmax_ext);
  VectorMTL<double> difprofitpos(xmax_ext);

  /*** Market shares ***/
  MatrixMTL<double> ms(shock_states,xmax);

  /*** Industry statistics ***/
  VectorMTL<double> prodsursum(shock_states);
  prodsursum = 0;
  VectorMTL<double> prodsursqr(shock_states);
  prodsursqr = 0;
  VectorMTL<double> conssursum(shock_states);
  conssursum = 0;
  VectorMTL<double> conssursqr(shock_states);
  conssursqr = 0;
  VectorMTL<double> totalsursum(shock_states);
  totalsursum = 0;
  VectorMTL<double> totalsursqr(shock_states);
  totalsursqr = 0;

  /*** Entry/Exit stats ***/
  VectorMTL<double> entratesum(shock_states);
  entratesum=0;
  VectorMTL<double> entratesqr(shock_states);
  entratesqr=0;
  VectorMTL<double> exiratesum(shock_states);
  exiratesum=0;
  VectorMTL<double> exiratesqr(shock_states);
  exiratesqr=0;
  VectorMTL<double> msexitsum(shock_states);
  msexitsum=0; 
  VectorMTL<double> msexitsqr(shock_states);
  msexitsqr=0;

  /*** Concetrations ratios ***/
  VectorMTL<double> c1sum(shock_states);
  c1sum=0;
  VectorMTL<double> c1sqr(shock_states);
  c1sqr=0;
  VectorMTL<double> c4sum(shock_states);
  c4sum=0;
  VectorMTL<double> c4sqr(shock_states);
  c4sqr=0;
  VectorMTL<double> c10sum(shock_states);
  c10sum=0;
  VectorMTL<double> c10sqr(shock_states); 
  c10sqr=0;
  VectorMTL<double> c20sum(shock_states); 
  c20sum=0;
  VectorMTL<double> c20sqr(shock_states);
  c20sqr=0;

  /****************************************************************************/

  /* initialiaze the extedended state */
  bound1sum = 0;
  bound1sqr = 0;

  bound2sum = 0;
  bound2sqr = 0;

  bound3sum = 0;
  bound3sqr = 0;

  int computebound2 = 1;


  if (bound1avg_aggr!=NULL) delete bound1avg_aggr;
  if (bound1var_aggr!=NULL) delete bound1var_aggr;
  if (bound1pre_aggr!=NULL) delete bound1pre_aggr;
  if (bound1por_aggr!=NULL) delete bound1por_aggr;
  bound1avg_aggr = new VectorMTL<double>(xmax);
  bound1var_aggr = new VectorMTL<double>(xmax);
  bound1pre_aggr = new VectorMTL<double>(xmax);
  bound1por_aggr = new VectorMTL<double>(xmax);

  if (bound2avg_aggr!=NULL) delete bound2avg_aggr;
  if (bound2var_aggr!=NULL) delete bound2var_aggr;
  if (bound2pre_aggr!=NULL) delete bound2pre_aggr;
  if (bound2por_aggr!=NULL) delete bound2por_aggr;

  bound2avg_aggr = new VectorMTL<double>(xmax);
  bound2var_aggr = new VectorMTL<double>(xmax);
  bound2pre_aggr = new VectorMTL<double>(xmax);
  bound2por_aggr = new VectorMTL<double>(xmax);

  if (bound3avg_aggr!=NULL) delete bound3avg_aggr;
  if (bound3var_aggr!=NULL) delete bound3var_aggr;
  if (bound3pre_aggr!=NULL) delete bound3pre_aggr;
  if (bound3por_aggr!=NULL) delete bound3por_aggr;

  bound3avg_aggr = new VectorMTL<double>(xmax);
  bound3var_aggr = new VectorMTL<double>(xmax);
  bound3pre_aggr = new VectorMTL<double>(xmax);
  bound3por_aggr = new VectorMTL<double>(xmax);

  // Adjust the precisions
  double tol=bounds[1]/(1+bounds[1]);

  // Compute the stationary distribution of shock process
  VectorMTL<double> q(shock_states);
  if(shockTran.statDistr(q)!=1) {
    cout << "Cannot compute stationary distribution of shocks" << endl;
    exit(1);
  }

  // Prepare tildes, prices and precompute profits
  VectorMTL<double> profit_w(xmax_ext);
  VectorMTL<double> tildes_w(xmax_ext);
  VectorMTL<double> prices_w(xmax_ext);

  VectorMTL<double> s0(xmax);
  s0=0;

  int w0=0;

  int kmax = 0;
  int kmax_temp;

  for(int w=0;w<shock_states;w++) {
    if(q[w]>0) { // Check if the state is not transient
      // Begin shocks
      setShock(w);

      // Compute s0 and w0
      s0+=tildes.getRow(w)*q[w];

      // Precompute transition matrices
      rho_w = rho.getRow(w);
      iota_w = iota.getRow(w);
      continuationProb(rho_w, prcont, condexp);
      tranProb(iota_w, tranMatrix_w, contTranMatrix[w], prcont);

      // Precompute probability for fixed entry
      if(control[1]==2) {
        if(ceil(lambdaVector[w])!=floor(lambdaVector[w])) {
          p[w]=(ceil(lambdaVector[w])-lambdaVector[w])/(ceil(lambdaVector[w])-floor(lambdaVector[w]));
        } else {
          p[w]=0;
        }
      }

      // Prepare extended vectors
      for(int i=0;i<xmax;i++) {
        tildes_ext[w][i]=tildes[w][i];
        prices_ext[w][i]=prices[w][i];
        s0_ext[i]=round(s0[i]);
      }

      for(int i=xmax;i<xmax_ext;i++) {
        tildes_ext[w][i]=0;
        prices_ext[w][i]=prices[w][xmax-1];
        s0_ext[i]=0;
      }

      ///// Precompute profits at tildes

      // Compute profits
      tildes_w = tildes_ext.getRow(w);
      prices_w = prices_ext.getRow(w);
      compProf(tildes_w, prices_w, profit_w);

      // Precompute infinite investment matrices
      iota_w = 1e20;
      prcont = 1.0;
      tranProb(iota_w, tranMatrix_w, contTranMatrix_infty[w], prcont);

      // Remember profits
      proftildes_ext.setRow(w,profit_w);

      // Compute kmax
      if((kmax_temp=int(MAX(xmax+1,log(0.01*(1.0-constants[2])/profit_w[xmax-1])/log(constants[2]))))>kmax)
        kmax=kmax_temp;

      restore();
      // End shocks
    }
  }


  boundspre = bounds[1]+1;

  int L = int(aggrparams[10]);
  int M = int(aggrparams[11]);

  // Precompute binomial pdfs 
  g = new MatrixMTL<double>(kmax+1,kmax+1);
  for (int i=0; i<=kmax;i++) {
    for (int m=0;m<=kmax;m++) {
      (*g)[i][m]= binopdf(m,i,1-transition[1]);
    }
  }

  MatrixMTL<double> disc_Freq(xmax,xmax);

  VectorMTL<int> bound3_x(xmax);
  VectorMTL<double> term2(xmax);

  cout << "Preparation over.. Start simulations" << endl;
  int n=1;

  RanGenLib P;
/*  cout << prices_w;
  state = 0;
  state[0]= 15;
  setShock(0);
  compProf(state, prices_w, profsim);
  restore();
  cout << profsim;
  getchar();*/

  while(boundspre>tol) {
    // Get new w0
    w0 = genDistr(P,q);

    if (n>bounds[3]) break; 

    double entrants;

    // Simulate L times
    int w = w0;
    state = s0_ext;
    for(int i=0;i<L;i++) {
      state_new.genMarkov(P,contTranMatrix[w],state);
      w = genDistr(P,shockTran.getRow(w));

      int entrants;
      // Simulate entry
      if(control[2]>0) {
        entrants = 0;
      } else {
        if(control[1]==2) {
          if(P.genUniform()>p[w]) {
             entrants=int(ceil(lambdaVector[w]));
          } else {
             entrants=int(floor(lambdaVector[w]));
          }
        } else {
          entrants = P.genPoisson(lambdaVector[w]);
        }
      }

      // Add entry
      state_new[int(constants[3])-1]+=entrants;
      state=state_new;
    } // End of L loop

    // Reset the bounds within M simulation
    bound1sum_sim = 0;
    bound2sum_sim = 0;
    bound3sum_sim = 0;

    // Simulate M times more
    for(int s=0;s<M;s++) {
      // Reset starting point
      int w_sim=w;
      state = state_new;

      // Additional simulations
      for(int a=0;a<int(aggrparams[12]);a++) {
        state_sim.genMarkov(P,contTranMatrix[w_sim],state);
        w_sim = genDistr(P,shockTran.getRow(w_sim));

        int entrants;
        // Simulate entry
        if(control[2]>0) {
          entrants = 0;
        } else {
          if(control[1]==2) {
            if(P.genUniform()>p[w_sim]) {
               entrants=int(ceil(lambdaVector[w_sim]));
            } else {
               entrants=int(floor(lambdaVector[w_sim]));
            }
          } else {
            entrants = P.genPoisson(lambdaVector[w_sim]);
          }
        }

        // Add entry
        state_sim[int(constants[3])-1]+=entrants;
        state=state_sim;

      } // End of additional simulations between each of m

      ///// Initialize term2 for t=0 /////

      // Compute profits at simulated state
      prices_w=prices_ext.getRow(w_sim);
      setShock(w_sim);
      compProf(state, prices_w, profsim);
      restore();

      profsim-=proftildes_ext.getRow(w_sim);
      profsim_xmax=profsim.subVector(0,xmax-1);

      term2 = -profsim_xmax;
      disc_Freq.eye();

      double beta = constants[2];

      // Initialize x for bound3
      for(int x=0;x<xmax;x++) {
        bound3_x[x]=x;
        bound1sum_sim[x]+= MACRO__POSITIVE(profsim[x]);
        bound2sum_sim[x]+= MACRO__POSITIVE(profsim[x]);
        bound3sum_sim[x]+= MACRO__POSITIVE(profsim[x]);
      }

      //// End of init, start the loop /////

      // Simulate kmax states forward
      for(int t=1;t<kmax;t++) {
        // Simulate current x for bound3 using previous shock
        for(int x=0;x<xmax;x++) {
            bound3_x[x]=genDistr(P,contTranMatrix_infty[w_sim].getRow(bound3_x[x]));
        }

        // Draw new state
        state_sim.genMarkov(P,contTranMatrix[w_sim],state);

        // Draw new shock
        w_sim = genDistr(P,shockTran.getRow(w_sim));

        int entrants;
        // Simulate entry
        if(control[2]>0) {
          entrants = 0;
        } else {
          if(control[1]==2) {
            if(P.genUniform()>p[w_sim]) {
               entrants=int(ceil(lambdaVector[w_sim]));
            } else {
               entrants=int(floor(lambdaVector[w_sim]));
            }
          } else {
            entrants = P.genPoisson(lambdaVector[w_sim]);
          }
        }

        // Add entry
        state_sim[int(constants[3])-1]+=entrants;

        // Compute profits at simulated state
        prices_w=prices_ext.getRow(w_sim);

        setShock(w_sim);
        if(compProf(state_sim, prices_w, profsim)==0) {
          #ifdef COUT_DEBUG
            cout << "Profit computation failed:" << endl;
            cout << "Shock:" << endl << w_sim << endl;
            cout << "State:" << endl << state_sim << endl;
            cout << "Starting prices:" << endl << prices_ext.getRow(w_sim) << endl;
            cout << "Final prices:" << endl << prices_w << endl;
            cout << "Profit:" << endl << profsim << endl << endl;
          #endif
          #ifdef DEBUG
            *myfile << "Profit computation failed:" << endl;
            *myfile <<  "Shock:" << endl << w_sim << endl;
            *myfile << "State:" << endl << state_sim << endl;
            *myfile << "Starting prices:" << endl << prices_ext.getRow(w_sim) << endl;
            *myfile << "Final prices:" << endl << prices_w << endl;
            *myfile << "Profit:" << endl << profsim << endl << endl; 
          #endif
        }
        restore();

        // Create difprofit for this industry path
        profsim-=proftildes_ext.getRow(w_sim);

        // Compute the distribution of x and take the expectation with respect to x
        disc_Freq=disc_Freq.dot(contTranMatrix[w_sim]);
        profsim_xmax = profsim.subVector(0,xmax-1);
        term2-=beta*disc_Freq.dot(profsim_xmax);

        for(int x=0;x<xmax;x++) {

          // Compute bound1
          int lowx = MAX(x-int(bounds[8])*t,0);
          int highx = MIN(x+int(bounds[8])*t,xmax_ext-1);

          bound1sum_sim[x]+=beta*MACRO__POSITIVE(max(profsim.subVector(lowx,highx)));

          if(computebound2==1) {
            for(int i=0;i<xmax_ext-2;i++) {
              if(MAX(profsim[i],0)-MAX(profsim[i+1],0)>bounds[9]*proftildes_ext[w_sim][i+1]) {
                #ifdef COUT_DEBUG
                cout << "Delta_y not increasing (" << MAX(profsim[i],0)-MAX(profsim[i+1],0) <<
                  ") for t=" << t << " and y=" << i << endl;
                #endif
                #ifdef DEBUG
                *myfile << "Delta_y not increasing (" << MAX(profsim[i],0)-MAX(profsim[i+1],0) <<
                  ") for t=" << t << " and y=" << i << endl;
                #endif
//                computebound2 = 0;
              }
            }
          }

          if(computebound2==1) {
            // Compute bound2
            if(int(bounds[8])==1) {
              for(int y=x;y<=x+t;y++) {
                bound2sum_sim[x]+=beta*(*g)[t][y-x]*MAX(profsim[MIN(y,xmax_ext-1)],0);
              }
            } else {
              bound2sum_sim[x]=0;
            }

            // Compute bound3
            bound3sum_sim[x]+=beta*MAX(profsim[bound3_x[x]],0);
          }
        }

        // Prepare for next iteration
        state=state_sim;
        beta*=constants[2];
      } // End of t-simulation loop

      bound1sum_sim+=term2;
      if(computebound2==1) {
        if(int(bounds[8])==1) {
          bound2sum_sim+=term2;
        }
        bound3sum_sim+=term2;
      }
    } // End of M loop



  // Take sample averages of all simuations
//   average = entratesum_sim/M;
//   entratesum+=average;
//   entratesqr+=average*average;
// 
//   average = exiratesum_sim/M;
//   exiratesum+=average;
//   exiratesqr+=average*average;
// 
//   average = msexitsum_sim/M;
//   msexitsum+=average;
//   msexitsqr+=average*average;
// 
//   average = prodsursum_sim/M;
//   prodsursum+=average;
//   prodsursqr+=average*average;
// 
//   average = conssursum_sim/M;
//   conssursum+=average;
//   conssursqr+=average*average;
// 
//   average = totalsursum_sim/M;
//   totalsursum+=average;
//   totalsursqr+=average*average;
// 
//   average = c1sum_sim/M;
//   c1sum+=average;
//   c1sqr+=average*average;
// 
//   average = c4sum_sim/M;
//   c4sum+=average;
//   c4sqr+=average*average;
// 
//   average = c10sum_sim/M;
//   c10sum+=average;
//   c10sqr+=average*average;
// 
//   average = c20sum_sim/M;
//   c20sum+=average;
//   c20sqr+=average*average;

    VectorMTL<double> average(xmax);
    double Md=double(M);
    average = bound1sum_sim/Md;
    bound1sum+=average;
    bound1sqr+=average*average;

    average = bound2sum_sim/Md;
    bound2sum+=average;
    bound2sqr+=average*average;

    average = bound3sum_sim/Md;
    bound3sum+=average;
    bound3sqr+=average*average;

    // Compute precisions
//     if(control[2]==0) {
//       compAvgPre(entratesum,entratesqr,n,entrateavg,entratepre,entratevar);
//       compAvgPre(exiratesum,exiratesqr,n,exirateavg,exiratepre,exiratevar);
//       compAvgPre(msexitsum,msexitsqr,n,msexitavg,msexitpre,msexitvar);
//     } else {
//       entrateavg=0;
//       entratevar=0;
//       exirateavg=0;
//       exiratevar=0;
//       msexitavg=0;
//       msexitvar=0;
//     }

//     compAvgPre(prodsursum,prodsursqr,n,prodsuravg,prodsurpre,prodsurvar);
//     compAvgPre(conssursum,conssursqr,n,conssuravg,conssurpre,conssurvar);
//     compAvgPre(totalsursum,totalsursqr,n,totalsuravg,totalsurpre,totalsurvar);
//     compAvgPre(c1sum,c1sqr,n,c1avg,c1pre,c1var);
//     compAvgPre(c4sum,c4sqr,n,c4avg,c4pre,c4var);
//     compAvgPre(c10sum,c10sqr,n,c10avg,c10pre,c10var);
//     compAvgPre(c20sum,c20sqr,n,c20avg,c20pre,c20var);

//    if(n>=bounds[4]) {
      compAvgPre(bound1sum,bound1sqr,n,*bound1avg_aggr,*bound1pre_aggr,*bound1var_aggr);
      if(computebound2==1) { 
        if(int(bounds[8])==1) {
          compAvgPre(bound2sum,bound2sqr,n,*bound2avg_aggr,*bound2pre_aggr,*bound2var_aggr);
        } else {
          *bound2avg_aggr=0;
          *bound2pre_aggr=0;
          *bound2var_aggr=0;
        }
        compAvgPre(bound3sum,bound3sqr,n,*bound3avg_aggr,*bound3pre_aggr,*bound3var_aggr);
      } else {
        *bound2avg_aggr = 0;
        *bound2pre_aggr = 0;
        *bound2var_aggr = 0;
        *bound3avg_aggr = 0;
        *bound3pre_aggr = 0;
        *bound3var_aggr = 0;
      }
    if(n>=bounds[4]) {
      boundspre=max(*bound1pre_aggr);
      double temp;
      if((temp=max(*bound2pre_aggr))>boundspre) boundspre=temp;
      if((temp=max(*bound3pre_aggr))>boundspre) boundspre=temp;
    }
    n++;

    cout << *bound2avg_aggr << endl;
    cout << *bound3avg_aggr;
    cout << "End of simulation: " << n-1 << ", tol: " << boundspre << endl;
  } // End of simulation loop
  if(g!=NULL) delete g;
}

int CompOE_aggr::compProfAndStats_aggr(VectorMTL<double> &state, VectorMTL<double> &prices, VectorMTL<double> 
  &pricesOutput, VectorMTL<double> &output, VectorMTL<double> &msOutput, 
  double &prodsurOutput, double &conssurOutput, int w) {

  setShock(w);

  int success = compProfAndStats(state, prices, pricesOutput, output, msOutput, 
    prodsurOutput, conssurOutput);

  restore();

  return success;
}


CompOE_aggr::~CompOE_aggr() {
  if(iotaMatrix0_global!=NULL) delete iotaMatrix0_global;
  if(rhoMatrix0_global!=NULL) delete rhoMatrix0_global;
  if(V_global!=NULL) delete V_global;
  if(V_expected_global!=NULL) delete V_expected_global;
  if(tildesMatrix_global!=NULL) delete tildesMatrix_global;
  if(profitMatrix_global!=NULL) delete profitMatrix_global;
  if(pricesMatrix_global!=NULL) delete pricesMatrix_global;
  if(lambdaVector0_global!=NULL) delete lambdaVector0_global;

  if (bound1avg_aggr!=NULL) delete bound1avg_aggr;
  if (bound1var_aggr!=NULL) delete bound1var_aggr;
  if (bound1pre_aggr!=NULL) delete bound1pre_aggr;
  if (bound1por_aggr!=NULL) delete bound1por_aggr;

  if (bound2avg_aggr!=NULL) delete bound2avg_aggr;
  if (bound2var_aggr!=NULL) delete bound2var_aggr;
  if (bound2pre_aggr!=NULL) delete bound2pre_aggr;
  if (bound2por_aggr!=NULL) delete bound2por_aggr;

  if (bound3avg_aggr!=NULL) delete bound3avg_aggr;
  if (bound3var_aggr!=NULL) delete bound3var_aggr;
  if (bound3pre_aggr!=NULL) delete bound3pre_aggr;
  if (bound3por_aggr!=NULL) delete bound3por_aggr;

  if (q!=NULL) delete q;

  #ifdef ACW
//  if (action_profit!=NULL) delete action_profit;
//  if (acwTran!=NULL) delete acwTran;
  if (tranmat3D!=NULL) delete tranmat3D;
  if (action_profitMatrix_global!=NULL) delete action_profitMatrix_global;
  #endif
}
