/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MTLCOMPOE_AGGR_H
#define MTLCOMPOE_AGGR_H

#include <compoe.h>
#include <tridiagmatrix3d.h>
#include <matrix3d.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>

/**
	@author Jeziorski, Weintraub, Benkard and Van Roy <przemekj@stanford.edu>
*/
class CompOE_aggr : public CompOE {
private:
  VectorMTL<double> *q;
  double *aggrparams;
  int shock_states;
  MatrixMTL<double> *iotaMatrix0_global;
  MatrixMTL<double> *rhoMatrix0_global;
  MatrixMTL<double> *V_global;
  MatrixMTL<double> *V_expected_global;
  MatrixMTL<double> *tildesMatrix_global;
  MatrixMTL<double> *profitMatrix_global;
  MatrixMTL<double> *pricesMatrix_global;
  VectorMTL<double> *lambdaVector0_global;

  VectorMTL<double> *bound1avg_aggr, *bound1pre_aggr, *bound1var_aggr, *bound1por_aggr;
  VectorMTL<double> *bound2avg_aggr, *bound2pre_aggr, *bound2var_aggr, *bound2por_aggr;
  VectorMTL<double> *bound3avg_aggr, *bound3pre_aggr, *bound3var_aggr, *bound3por_aggr;

  VectorMTL<double> *backup;

  #ifdef ACW
  MatrixMTL3D<double> *tranmat3D;
  MatrixMTL3D<double> *action_profitMatrix_global;
  #endif
public:
  CompOE_aggr();

  inline void initialize(double *control_init, double *prof_fun_init, double *prof_fun_ipopt_init,
    double *transition_init, double *constants_init, double *init_init, 
    double *convtol_init, double *aggrparams_init) {

    control = control_init;
    prof_fun = prof_fun_init;
    prof_fun_ipopt = prof_fun_ipopt_init;
    transition = transition_init;
    constants = constants_init;
    init = init_init;
    convtol = convtol_init;
    aggrparams = aggrparams_init;
  }

  //inline void getInvariant(VectorMTL<double> &qInit) {
  //  qInit = *q;
  //}

  #ifdef ACW
  inline MatrixMTL<double> *getActionProfit(int w) {
    return &((*action_profitMatrix_global)[w]);
  }

  inline MatrixMTL3D<double> *getTranFringe() {
    return tranmat3D;
  }
  #endif

  inline VectorMTL<double> *getInvariant() {
    return q;
  }

  inline MatrixMTL<double> *getIotaAggr() {
    return iotaMatrix0_global;
  }

  inline MatrixMTL<double> *getRhoAggr() {
    return rhoMatrix0_global;
  }

  inline MatrixMTL<double> *getVAggr() {
    return V_global;
  }

  inline MatrixMTL<double> *getVExpectedAggr() {
    return V_expected_global;
  }

  inline MatrixMTL<double> *getTildesAggr() {
    return tildesMatrix_global;
  }

  inline MatrixMTL<double> *getProfitAggr() {
    return profitMatrix_global;
  }

  inline MatrixMTL<double> *getPricesInitAggr() {
    return pricesMatrix_global;
  }

  inline VectorMTL<double> *getLambdaAggr() {
    return lambdaVector0_global;
  }

  inline int getShocksSize() {
    return shock_states;
  }

  inline void getBound1_aggr(VectorMTL<double> &bound1avgOut, VectorMTL<double> &bound1preOut, 
    VectorMTL<double> &bound1varOut) {

    bound1avgOut = *bound1avg_aggr;
    bound1varOut = *bound1var_aggr;
    bound1preOut = *bound1pre_aggr;
  }

  inline void getBound2_aggr(VectorMTL<double> &bound2avgOut, VectorMTL<double> &bound2preOut, 
    VectorMTL<double> &bound2varOut) {

    bound2avgOut = *bound2avg_aggr;
    bound2varOut = *bound2var_aggr;
    bound2preOut = *bound2pre_aggr;
  }

  inline void getBound3_aggr(VectorMTL<double> &bound3avgOut, VectorMTL<double> &bound3preOut, 
    VectorMTL<double> &bound3varOut) {

    bound3avgOut = *bound3avg_aggr;
    bound3varOut = *bound3var_aggr;
    bound3preOut = *bound3pre_aggr;
  }


  int compute(int &xmaxInit, VectorMTL<double> &iotaInit, VectorMTL<double> &rhoInit, double lambdaInit, 
    SparseMatrixMTL<double> &shockTran);
  void valueIt(MatrixMTL<double> &profit, MatrixMTL<double> &iota, 
    MatrixMTL<double> &rho, MatrixMTL<double> &V, MatrixMTL<double> &V_expected, MatrixMTL<double> &dMatrix,
    SparseMatrixMTL<double> &stateTran);
  int compute_aggr(int &xmaxInit, VectorMTL<double> &iotaInit, VectorMTL<double> &rhoInit, double lambdaInit,
    SparseMatrixMTL<double> &shockTran); 
  void computeTildes(MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &rhoMatrix, VectorMTL<double> &lambdaVector,
    SparseMatrixMTL<double> &stateTran, MatrixMTL<double> &tildesMatrix);
  void computeBounds_aggr(double *bounds_aggr, MatrixMTL<double> &iota, 
    MatrixMTL<double> &rho, MatrixMTL<double> &tildes, 
    VectorMTL<double> &lambdaVector, MatrixMTL<double> &prices,
    SparseMatrixMTL<double> &shockTran);
  int compProfAndStats_aggr(VectorMTL<double> &state, VectorMTL<double> &prices, VectorMTL<double> 
    &pricesOutput, VectorMTL<double> &output, VectorMTL<double> &msOutput, 
    double &prodsurOutput, double &conssurOutput, int w);

  void setShock(int w);
  void restore();
  ~CompOE_aggr();

};

#endif
