/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "compoe_dom.h"

void CompOE_dom::setShock(int w) {
  #ifndef ACW
  backup = new VectorMTL<double>(1);

  // First back up the parameters that will be altered
  // *backup vector need to be created so that the parameters
  // can be restored to its reference values
  backup = new VectorMTL<double>(1); // Number of parameters to back up
                                     // In the sample case we back up only one parameter
				     // that is size of the market

  (*backup)[0]=prof_fun[0];          // Now back up the parameters

  // Now set the parameters in each of the shock state

  switch(w) {
    // Low shock, decrease the market size
    case 0: 
      prof_fun[0]=(*backup)[0]*(1-shocklevels[0]);
      break;
    // Mid shock, keep the market size unchanged
    case 1:
      prof_fun[0]=(*backup)[0];
      break;
    // High shock, increase the market size
    case 2:
      prof_fun[0]=(*backup)[0]*(1+shocklevels[1]);
      break;
  }

  #else
  backup = new VectorMTL<double>(1);  
  (*backup)[0]=constants[8];
  constants[8]=constants[8+w];
  #endif
}

// Restore function
// Every parameter need to restored to its reference value
// That is kept in the *backup vector
void CompOE_dom::restore() {
  #ifndef ACW
  // restore the parameters to original state
//  prof_fun[0]=(*backup)[0];
  #else
  constants[8]=(*backup)[0];
  #endif
  // Delete the backup vector
  delete backup;
}
