/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "compoe_dom.h"
#define GET_TRANSITION

#ifdef GET_TRANSITION
double ***rememberCompTran;
#endif
int n_global;
int next_comb(int *comb, int k, int n) {
  int i = k - 1;
  ++comb[i];
  while ((i > 0) && (comb[i] >= n - k + 1 + i)) {
    --i;
    ++comb[i];
  }

  if (comb[0] > n - k) /* Combination (n-k, n-k+1, ..., n) reached */
    return false; /* No more combinations can be generated */

  /* comb now looks like (..., x, n, n, n, ..., n).
  Turn it into (..., x, x + 1, x + 2, ...) */
  for (i = i + 1; i < k; ++i) {
    comb[i] = comb[i - 1] + 1;
  }

  return true;
}

void insertionSort(int *a, int n) {
  int k;
  for (k = 1; k < n; ++k) {
    int key = a[k];
    int i = k - 1;
    while ((i >= 0) && (key < a[i])) {
      a[i + 1] = a[i];
      --i;
    }
    a[i + 1] = key;
  }
}

void printArray(int *array, int n) {
        for(int i=0;i<n;i++) {
                cout << array[i] << " ";
        }
}


CompOE_dom::CompOE_dom() : CompOE() {
  q=NULL;
  iotaMatrix0_global=NULL;
  rhoMatrix0_global=NULL;
  V_global=NULL;
  V_expected_global=NULL;
  tildesMatrix_global=NULL;
  profitMatrix_global=NULL;
  pricesMatrix_global=NULL;
  lambdaVector0_global=NULL;
  prcontMatrix_global=NULL;

  VDom_global=NULL;
  profitMatrixDom_global=NULL;
  pricesMatrixDom_global=NULL;
  iotaMatrixDom0_global=NULL;
  bound1avg_dom=NULL;
  bound1var_dom=NULL;
  bound1pre_dom=NULL;
  bound1por_dom=NULL;
  bound2avg_dom=NULL;
  bound2var_dom=NULL;
  bound2pre_dom=NULL;
  bound2por_dom=NULL;
  bound3avg_dom=NULL;
  bound3var_dom=NULL;
  bound3pre_dom=NULL;
  bound3por_dom=NULL;
  
  fringeavg=NULL;
  fringevar=NULL;
  fringepre=NULL;
  fringepor=NULL;

  reverseEnc=NULL;
  reverseEncShocks=NULL;

  EVDom=NULL;

  tranDom_global=NULL;

  #ifdef ACW
    RHS=NULL;
    action_profit = NULL;
    acwTran = NULL;
    tranmat3D = NULL;
    action_profitMatrix_global = NULL;
    action_profitMatrixFringe_global = NULL;
  #endif
}

///////// This is a piece that converts a pair (y,x) into
// list of states if you add x to y, and remove all firms is y
// It's very similar to the combinations piece because we need to go through all y
//
// Output is a matrix compTransition[starting state of competitors][your state*firms+position of your competitor ]
void CompOE_dom::competitorsTransition(int **encoding, int *array, int slotIndex, int n, int k, int shock_states) {
  int minValue,i;

  if (slotIndex == k) {
    // We have a combination y here in array, that is encoded as c
    // Save the array
    int saveArray[k];
    for(int y=0;y<k;y++) {
      saveArray[y]=array[y];
    }

    int z=0;
    // For each your state x
    for(int x=0;x<n;x++) {
      // For each competitor firm y
      for(int y=0;y<k;y++) {
        int save = array[y];
        array[y] = x;

        insertionSort(array,k);
//      cout << "Insert into "; printArray(saveArray,k); cout << " - " << x << " in position " << y;
//      cout << endl << "Result " ;printArray(array,k);cout << endl;
//      getchar();

        // Now identify the proper encoding
        int bigIndex;
        for(bigIndex=0;bigIndex<shock_states;bigIndex++) {
          int j;
          for(j=0;j<k;j++) {
            if(encoding[bigIndex][j]!=array[j])
              break;
          }
          if(j==k)
            break;
        }
        // Save

        (*compTransition)[c][z]=bigIndex;
        z++;

        // Revert the sorted array
        for(int y=0;y<k;y++) {
          array[y]=saveArray[y];
        }
      }
    }
    c++;
  } else {
    minValue = 0;
    if (slotIndex > 0) {
      minValue = array[slotIndex - 1];
    }
    for (i = minValue; i < n; i++) {
      array[slotIndex] = i;
      competitorsTransition(encoding, array, slotIndex + 1, n, k, shock_states);
    }
  }
}

// This is transition probability of competitors from state 'from' to state 'to'
// Conditioning on the fact to you are in state x
double CompOE_dom::compProb(int **encoding, int x, int fromInit, int toInit, int firms, SparseMatrix3D<double> &bigTran, int fromShock) {
  int offset = fromShock*other_dom_firms;
  if(firms>0) {
    double prob=0;
    // We need to thought all the permutation of 'to'
    int *to2 = encoding[toInit];
    // I will permute it so I need to copy it
    int to[firms];
    for(int i=0;i<firms;i++)
      to[i]=to2[i];

    int *from = encoding[fromInit];
//    cout << "Your state: " << x << endl;
//    cout << "From: "; printArray(from,firms); cout << endl;
//    cout << "To:   "; printArray(to,firms); cout << endl;
    do {
      double probPerm=1;
      // For each competitor firm in state from[y]
      for(int y=0;y<firms;y++) {
//       cout << "\tFor firm: " << y;
        // Compute the state of the competitors of firm in slot y
        int state = (*compTransition)[fromInit][x*firms+y]+offset;
//        cout << " opponent state is " << state << endl;
//        cout << "\tFirm goes from " << from[y] << " to " << to[y] << ",revEnc: " << (*reverseEnc)[from[y]][to[y]];
//        cout << ", Prob = " << bigTran[state][(*reverseEnc)[from[y]][to[y]]] << endl;
        // Now we need to use the transition martix for that state
        if((*reverseEnc)[from[y]][to[y]]>-1) {
          // This thing assumes that sparcity pattern does not depend on competitors state
          // In particular it's true when your transition matrix does not depend on competitors state
          probPerm*=bigTran[state][(*reverseEnc)[from[y]][to[y]]];
        } else {
          probPerm=0;
          break;
        }
      }
//      cout << "----" << endl;
      prob+=probPerm;
    } while(next_permutation(to,to+firms));
    return prob;
  } else {
    return 1;
  }
}

// NEEDS TO BE FIXED FOR AGGREAGATE SHOCKS

void CompOE_dom::compProbFullPattern(int **encoding, int dom_firm_number, int shock_states,
  SparseMatrixMTL<double> &tranFull, SparseMatrixMTL<double> &shockTran) {
  // First we need to compute number of non-zeros in this matrix
  int nonzeros=0;

  for(int fromIdx=0;fromIdx<shock_states;fromIdx++) {
    for(int toIdx=0;toIdx<shock_states;toIdx++) {
      int *from=encoding[fromIdx];
      int *toInit=encoding[toIdx];
      int to[dom_firm_number];
      // We will permute so we need to copy it
      for(int i=0;i<dom_firm_number;i++) {
        to[i]=toInit[i];
      }
      // Consider all permutations
      int can=0;
      do {
        int canP=1;
        // Check if this permutation works
        for(int y=0;y<dom_firm_number;y++) {
          if((*reverseEnc)[from[y]][to[y]]==-1) {
            canP=0;
            break;
          }
        }
        // Set the variable saying the there exists a permutation
        if(canP) {
          can=1;
          break;
        }
      } while(next_permutation(to,to+dom_firm_number));

      if(can) {
        nonzeros++;
      }
    }
  }

  dom_nonzeros=nonzeros;

  nonzeros*=shockTran.getSize();

  tranFull.init(shock_states*aggr_shocks,shock_states*aggr_shocks,nonzeros);

  // Now do the sparcity pattern
  nonzeros=0;
  int shockidx=0;
  int shockidx_iterator;
  for(int fromw=0;fromw<aggr_shocks;++fromw) {
    shockidx_iterator=shockidx;
    for(int fromIdx=0;fromIdx<shock_states;fromIdx++) {
      shockidx=shockidx_iterator; // For each fromIdx we need to go though all the targer shocks
      while(1) {
        if((shockidx==shockTran.getSize())  || (shockTran.rows[shockidx]>fromw)) {
          break;
        }
        for(int toIdx=0;toIdx<shock_states;toIdx++) {
          int *from=encoding[fromIdx];
          int *toInit=encoding[toIdx];
          int to[dom_firm_number];
          // We will permute so we need to copy it
          for(int i=0;i<dom_firm_number;i++) {
            to[i]=toInit[i];
          }
          // Consider all permutations
          int can=0;
          do {
            int canP=1;
            // Check if this permutation works
            for(int y=0;y<dom_firm_number;y++) {
              if((*reverseEnc)[from[y]][to[y]]==-1) {
                canP=0;
                break;
              }
            }
            // Set the variable saying the there exists a permutation
            if(canP) {
              can=1;
              break;
            }
          } while(next_permutation(to,to+dom_firm_number));

          if(can) {
            tranFull.rows[nonzeros]=fromIdx+shockTran.rows[shockidx]*shock_states;
            tranFull.columns[nonzeros]=toIdx+shockTran.columns[shockidx]*shock_states;
            nonzeros++;
          }
        }
        shockidx++;
      }
    }
  }
}

void CompOE_dom::compProbFull(int **encoding, int dom_firm_number, int shock_states,
  SparseMatrixMTL<double> &tranFull, SparseMatrix3D<double> &tran, MatrixMTL<int> &removeFirm, 
  SparseMatrixMTL<double> &shockTran) {

  for(int idx=0;idx<tranFull.getSize();idx++) {
    int *from=encoding[tranFull.rows[idx] % shock_states];
    int *toInit=encoding[tranFull.columns[idx] % shock_states];
    int shockFrom = tranFull.rows[idx]/shock_states;
    int shockTo = tranFull.columns[idx]/shock_states;
    int to[dom_firm_number];
    // We will permute so we need to copy it
    for(int i=0;i<dom_firm_number;i++) {
      to[i]=toInit[i];
    }
    // Consider all permutations
    tranFull[idx]=0;
//    cout << "Going from ";printArray(from,dom_firm_number); cout << " to "; printArray(to,dom_firm_number); cout << endl;
    do {
//      cout << "\tConsider permuation ";printArray(to,dom_firm_number); cout << endl;
//      double prob=1;
      double prob=shockTran[(*reverseEncShocks)[shockFrom][shockTo]];
//      cout << "\t\tShock transition " << prob << endl;
      for(int y=0;y<dom_firm_number;y++) {
//        cout << "\t\tFirm " << y << ", competitors (" << removeFirm[y][tranFull.rows[idx]] << ")";
//        printArray(encoding_other[removeFirm[y][tranFull.rows[idx]]],dom_firm_number-1);cout << endl;
        if((*reverseEnc)[from[y]][to[y]]>-1) {
          int removedState = removeFirm[y][tranFull.rows[idx] % shock_states]+shockFrom*other_dom_firms;
//          cout << removedState << endl;
//          cout << tran[removedState];
//          prob/=7;
//          cout << prob << endl;
//          cout << tran[removedState];
//          cout << (*reverseEnc)[from[y]][to[y]] << endl;
//          cout << tran[removedState][(*reverseEnc)[from[y]][to[y]]] << endl;
          prob*=tran[removedState][(*reverseEnc)[from[y]][to[y]]];
//          getchar();
        } else {
          prob=0;
          break;
//          cout << "\t\t Not OK!" << endl;
        }
      }
//      cout << "\t\tTotal prob " << prob << endl;
      tranFull[idx]+=prob;
    } while(next_permutation(to,to+dom_firm_number));
//    cout << tranFull[idx] << endl;
//    getchar();
  }
}

void CompOE_dom::computeRemoveFirm(MatrixMTL<int> &removeFirm, int **encoding_total, int **encoding_other, int dom_firm_number, int shock_states) {
  for(int s=0;s<shock_states;s++) {
    for(int y=0;y<dom_firm_number;y++) {
      if(dom_firm_number>1) {
        int enc = 0;
        while(1) {
          int x;
          int z;
          for(x=0, z=0;x<dom_firm_number;x++,z++) {
            if(x==y) {
              z--;
              continue;
            }
            if(encoding_other[enc][z]!=encoding_total[s][x])
              break;
          }
          if(x==dom_firm_number) {
            removeFirm[y][s]=enc;
//          printArray(encoding_total[s],dom_firm_number); cout << " - " << y << " = "; printArray(encoding_other[enc],dom_firm_number-1);cout << endl;
            break;
          } else {
            enc++;
          }
        }
      } else {
        removeFirm[y][s]=0;
      }
    }
  }
}

void CompOE_dom::tranProbDom(MatrixMTL<double> &iotaDom, SparseMatrix3D<double> &tranDom) {
  VectorMTL<double> prcont_w(xmax_dom);
  VectorMTL<double> iota_w(xmax_dom);
//  SparseMatrixMTL<double> tranmat_w(xmax_dom,xmax_dom,4+(xmax_dom-2)*3);
  SparseMatrixMTL<double> conttranmat_w;
  #ifdef ACW
    VectorMTL<double> EVw(xmax_dom);
  #endif
  prcont_w=1;
  int z=0;
  for(int a=0;a<aggr_shocks;++a) {
    setShock(a);
    for(int w=0;w<other_dom_firms;w++) {
      #ifndef ACW
      iota_w = iotaDom.getRow(z);

      tranProb(iota_w,tranDom[z],conttranmat_w,prcont_w);
      #else
      tranProbACWDom((*RHS)[z],tranDom[z]);
      #endif
      
      z++;
    }
    restore();
  }
}

void CompOE_dom::valueItDom(MatrixMTL<double> &profitMatrix, MatrixMTL<double> &iotaDom,
  MatrixMTL<double> &V, VectorMTL<double> &d, SparseMatrix3D<double> &tranDom, SparseMatrixMTL<double> &shockTran) {

 #if TRANSITION_MATRIX_DOM == 0
    MatrixMTL<double> tranmat_w(xmax_dom);
    MatrixMTL<double> conttranmat_w(xmax_dom);
  #elif TRANSITION_MATRIX_DOM == 1
    TriDiagMatrixMTL<double> tranmat_w(xmax_dom);
    TriDiagMatrixMTL<double> conttranmat_w(xmax_dom);
  #elif TRANSITION_MATRIX_DOM == 2
    SparseMatrixMTL<double> tranmat_w(xmax_dom,xmax_dom,4+(xmax_dom-2)*3);
    SparseMatrixMTL<double> conttranmat_w(xmax_dom,xmax_dom,4+(xmax_dom-2)*3);
  #else
  #error Invalid value for TRANSITION_MATRIX
  #endif
  //cout << "-" << endl;getchar();

  #ifndef ACW
  for(int i=0;i<other_dom_firms*aggr_shocks;i++) {
    for(int j=0;j<xmax_dom;j++) {
      V[i][j]=profitMatrix[i][j]/(1-constants[2]);
    }
  }
  #else
  V=0;
  #endif

  int i=0;
  VectorMTL<double> iota_w(xmax_dom);
  VectorMTL<double> profit_w(xmax_dom);

  VectorMTL<double> prcont(xmax_dom);
  prcont=1;

  while (1) {
    double Norm=0;

    i++;
    if(i>1000) {
      cout << "Value iteration for dominant firms hit maximum" << endl;
      break;
    }
    
    // For all states of the competitors
    int k=0;
    int expectation_w_iterator=0;

    for(int aFrom=0;aFrom<aggr_shocks;++aFrom) {
      setShock(aFrom);
      int j;
      for(int w=0;w<other_dom_firms;++w) {
        VectorMTL<double> EVw(xmax_dom);
        VectorMTL<double> Vnew_w(xmax_dom);
     
        //cout << "0"<< endl;getchar();
        // Integrate competitors
        #ifndef ACW
        for(int x=0;x<xmax_dom;x++) {
          j=expectation_w_iterator;
          EVw[x]=0;
          while(1) {
            if( (j==shockTran.getSize()) || (shockTran.rows[j]>aFrom) ) {
              break;
            }
            if(other_number>0) {
              for(int to=0;to<other_dom_firms;to++) {
                // double compProb(int **encoding, int x, int fromInit, int toInit, int firms, SparseMatrix3D<double> &bigTran)
//              cout << compProb(encoding_other, x, w, to, other_number, tranDom) << " ";
                #ifdef GET_TRANSITION
                double probb=compProb(encoding_other, x, w, to, other_number, tranDom, aFrom);
                EVw[x] += probb*V[to][x];
                rememberCompTran[w][to][x]=probb;
                #else
                EVw[x] += compProb(encoding_other, x, w, to, other_number, tranDom, aFrom)*shockTran[j]*V[to+shockTran.columns[j]*other_dom_firms][x];
                #endif
              }
            } else {
              EVw[x] += shockTran[j]*V[shockTran.columns[j]][x];
            }
            j++;
          }
//        getchar();
        }

        // Optimal invesment
        iota_w=optInv(EVw,d);
        //cout << EVw;
        //cout << iota_w;
        //getchar();

        iotaDom.setRow(k,iota_w);

        // Transition matrix
        tranProb(iota_w,tranmat_w,conttranmat_w,prcont);

        //cout << "2" << endl;getchar();
        // Value iteration
        profit_w = profitMatrix.getRow(k);
      
        Vnew_w = profit_w + (-iota_w*d) + constants[2]*tranmat_w.dot(EVw);

        EVDom->setRow(k,EVw);
        #else
        for(int x=0;x<xmax_dom;x++) {
          for(int a=0;a<constants[6];++a) {
            (*RHS)[k][x][a]=0;
          }

          if(other_number>0) {
            for(int to=0;to<other_dom_firms;to++) {
              /*
              if(n_global==100) {
                cout << x << endl;

                for(int i=0;i<other_number;++i) {
                  cout << encoding_other[w][i] << "\t";
                }
                cout << endl;
                for(int i=0;i<other_number;++i) {
                  cout << encoding_other[to][i] << "\t";
                }
                cout << endl;
                cout << compProb(encoding_other, x, w, to, other_number, tranDom, aFrom) << endl;
              }
              */

              double probb=compProb(encoding_other, x, w, to, other_number, tranDom, aFrom);

              j=expectation_w_iterator;
              while(1) {
                if( (j==shockTran.getSize()) || (shockTran.rows[j]>aFrom) ) {
                  break;
                }
                for(int a=0;a<constants[6]-1;++a) {
                  (*RHS)[k][x][a]+=probb*shockTran[j]*((*action_profitMatrix_global)[to+shockTran.columns[j]*other_dom_firms][a][x]+constants[2]*V[to+shockTran.columns[j]*other_dom_firms][(*acwTran)[a][x]]);
                }
                j++;
              }
            }
          } else {
            j=expectation_w_iterator;
            while(1) {
              if( (j==shockTran.getSize()) || (shockTran.rows[j]>aFrom) ) {
                break;
              }

              for(int a=0;a<constants[6]-1;++a) {
                (*RHS)[k][x][a]+=shockTran[j]*((*action_profitMatrix_global)[shockTran.columns[j]][a][x]+constants[2]*V[shockTran.columns[j]][(*acwTran)[a][x]]);
              }
              j++;
            }
          }


          Vnew_w[x] = 0;
          for(int a=0;a<constants[6];++a) {
            Vnew_w[x] += exp((*RHS)[k][x][a]/constants[7]);
          }
          Vnew_w[x] = constants[7]*(log(Vnew_w[x])+0.577215665);
        }

        Vnew_w[xmax-1] = 0;
        /*
        cout << (*RHS)[k];
        cout << Vnew_w;
        getchar();*/
        #endif

        // Check the difference
        Norm = MAX(Norm,norm(Vnew_w-V.getRow(k)));

        // Update value funtion (Gauss-Seidel in w)
        V.setRow(k, Vnew_w);
        
        //cout << aFrom << " " << w << " " << k << " " << endl;
        //cout << Vnew_w;
        //getchar();
 
        k++;
      }
      expectation_w_iterator=j;
      restore();
    }
    if(Norm<convtol[0]) {
      break;
    }
  }

  #ifdef ACW
  iotaDom = 0;
  #endif
  //cout << profitMatrix;
    //getchar();
}

void CompOE_dom::valueIt(MatrixMTL<double> &profitMatrix, MatrixMTL<double> &iota, 
  MatrixMTL<double> &rho, MatrixMTL<double> &V, MatrixMTL<double> &V_expected, VectorMTL<double> &d,
  SparseMatrixMTL<double> &shockTran) {

  #if TRANSITION_MATRIX == 0
    MatrixMTL<double> tranmat_w(xmax);
    MatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 1
    TriDiagMatrixMTL<double> tranmat_w(xmax);
    TriDiagMatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 2
    SparseMatrixMTL<double> tranmat_w(xmax);
    SparseMatrixMTL<double> conttranmat_w(xmax);
  #else 
  #error Invalid value for TRANSITION_MATRIX
  #endif

  VectorMTL<double> V_w(xmax), Vnew_w(xmax),condexp_w(xmax),prcont_w(xmax);
  VectorMTL<double> iota_w(xmax),rho_w(xmax), profit_w(xmax);
  VectorMTL<double> distr_w(shock_states*aggr_shocks);

  double Norm=1;
  int i=0;

  #ifndef ACW
  for(int i=0;i<shock_states*aggr_shocks;i++) {
    for(int j=0;j<xmax;j++) {
      V[i][j]=profitMatrix[i][j]/(1-constants[2])+transition[0];
    }
  }
  #else
  V=0;
  #endif


  // Set prcont to something so that tranProb will work
  prcont_w = 0;

  while (1) {
    i++; 
    if(i>1000) {
      cout << "Value iteration hit maximum" << endl;
      break;
    }

    Norm = 0;

    int expectation_w_iterator=0;

    for(int w=0;w<shock_states*aggr_shocks;w++) {
        setShock((int) w/shock_states);
        #ifndef ACW
        /*** Compute expected value function given w ***/
        int j;
        for(int x=0;x<xmax;x++) {
          V_w[x]=0;
          j=expectation_w_iterator;
          while(1) {
            // End of matrix or end of row
            if( (j==shockTran.getSize()) || (shockTran.rows[j]>w) ) {
              break;
            }
            // This is Gauss-Sidel in V !!!
            V_w[x]+=shockTran[j]*V[shockTran.columns[j]][x];
            j++;
          }
        }
        expectation_w_iterator=j;

        V_expected.setRow(w,V_w);

        /*** Compute optimal investment ***/
        iota_w = optInv(V_w,d);
        iota.setRow(w,iota_w);

        /*** Compute transition probabilities ***/
        tranProb(iota_w,tranmat_w,conttranmat_w,prcont_w);

        /*** Compute continuation values if not exiting ***/
        rho_w = (-iota_w*d) + ((tranmat_w.dot(V_w))*constants[2]);
        rho.setRow(w,rho_w);

        /*** Compute continuation probs. and conditional expectation sell-off ***
         *** value, conditional on exiting                                    ***/

        continuationProb(rho_w,prcont_w,condexp_w);

        /*** Compute new function for w ***/
        profit_w = profitMatrix.getRow(w);
	
        Vnew_w = profit_w + (-prcont_w+1.0)*condexp_w+prcont_w*rho_w;
        
        #else
        int j;
        for(int x=0;x<xmax_dom;x++) {
          for(int a=0;a<constants[6];++a) {
            (*RHSFringe)[w][x][a]=0;
          }
          j=expectation_w_iterator;
          while(1) {
            if( (j==shockTran.getSize()) || (shockTran.rows[j]>w) ) {
              break;
            }
            for(int a=0;a<constants[6]-1;++a) {
              (*RHSFringe)[w][x][a]+=shockTran[j]*((*action_profitMatrixFringe_global)[shockTran.columns[j]][a][x]+constants[2]*V[shockTran.columns[j]][(*acwTran)[a][x]]);
            }
            j++;
          }

          Vnew_w[x] = 0;
          for(int a=0;a<constants[6];++a) {
            Vnew_w[x] += exp((*RHSFringe)[w][x][a]/constants[7]);
          }
          Vnew_w[x] = constants[7]*(log(Vnew_w[x])+0.577215665);
        }
        expectation_w_iterator=j;
        Vnew_w[xmax-1] = 0;
        
        #endif

        /*** Check the difference ***/
        Norm = MAX(Norm,norm(Vnew_w-V.getRow(w)));

        /*** Update value funtion ***/
        V.setRow(w, Vnew_w);

	      prcontMatrix_global->setRow(w, prcont_w);

        restore();
    }

    if(Norm<convtol[0]) {
      break;
    }
  }
}


int CompOE_dom::newton(int n, int k) {
  int out = n;
  int i;

  n--;
  for(i=1;i<k;i++) {
    out*=n;
    n--;
  }

  return out;
}

int CompOE_dom::factorial(int number) {
        int temp;

        if(number <= 1) return 1;

        temp = number * factorial(number - 1);
        return temp;
}

void CompOE_dom::combinations_with_repetition(int **encoding, int *array, int slotIndex, int n, int k) {
  int minValue,i;

  if (slotIndex == k) {
    encoding[c]=(int *) malloc(k*sizeof(int));

    for (i = 0; i < k; i++) {
      encoding[c][i] = array[i];
    }
    c++;

    } else {
      minValue = 0;
      if (slotIndex > 0) {
        minValue = array[slotIndex - 1];
      }
      for (i = minValue; i < n; i++) {
        array[slotIndex] = i;
        combinations_with_repetition(encoding, array, slotIndex + 1, n, k);
      }
   }
}

void CompOE_dom::reverseEncoding(SparseMatrixMTL<double> &tran) {
  int rows=tran.getNRows();
  int cols=tran.getNColumns();
  int all=tran.getSize();

  for(int i=0;i<rows;i++) {
    for(int j=0;j<cols;j++) {
      (*reverseEnc)[i][j]=-1;
    }
  }

  for(int i=0;i<all;i++) {
    (*reverseEnc)[tran.rows[i]][tran.columns[i]]=i;
  }
}

void CompOE_dom::reverseEncodingShocks(SparseMatrixMTL<double> &tran) {
  int rows=tran.getNRows();
  int cols=tran.getNColumns();
  int all=tran.getSize();

  for(int i=0;i<rows;i++) { 
    for(int j=0;j<cols;j++) {
      (*reverseEncShocks)[i][j]=-1;
    }
  }

  for(int i=0;i<all;i++) {
    (*reverseEncShocks)[tran.rows[i]][tran.columns[i]]=i;
  }
}

void CompOE_dom::endcodeAddFirm(MatrixMTL<int> &addFirm) {
  for(int add=0;add<xmax_dom;add++) {
    for(int smallIndex=0;smallIndex<other_dom_firms;smallIndex++) {
      int *state = encoding_other[smallIndex];
      int added_state[dom_firm_number];

//      cout << add << " + "; printArray(state,other_number);cout<< " = ";

      // Go throught the state
      int search;
      for(search=0;search<other_number;search++) {
        if(state[search]>add) {
          added_state[search]=add;
          break;
        } else {
          added_state[search]=state[search];
        }
      }
      // If finished the search
      if(search==other_number) {
        added_state[other_number]=add;
      } else { // Some left
        for(int i=search;i<other_number;i++) {
          added_state[i+1]=state[i];
        }
      }

      // Identify the encoding
      int bigIndex;
      for(bigIndex=0;bigIndex<shock_states;bigIndex++) {
        int j;
        for(j=0;j<dom_firm_number;j++) {
          if(encoding_total[bigIndex][j]!=added_state[j])
            break;
        }
        if(j==dom_firm_number)
          break;
      }
      // Save
      addFirm[add][smallIndex]=bigIndex;
    }
  }
}

int CompOE_dom::compute_dom(int &xmaxInit, VectorMTL<double> &iotaInit, VectorMTL<double> &rhoInit, 
  VectorMTL<double> &lambdaInit, VectorMTL<double> &mean_fringe_state, SparseMatrixMTL<double> &shockTran) {
  success=1;
  
  xmax = xmaxInit;
  aggr_shocks = shockTran.getNRows();

  struct tms t,u;
  long r1,r2;

  xmax_dom = xmax; // Allow for different number of states of dominant firms
  dom_firm_number = int(domparams[10]);
  other_number = dom_firm_number-1;

  other_dom_firms = (dom_firm_number <= 1) ? 1 : 
    newton(xmax_dom+other_number-1,other_number)/factorial(other_number); // Number of states of competitors of dom firm (symetric)
  shock_states = newton(xmax_dom+dom_firm_number-1,dom_firm_number)/factorial(dom_firm_number); // Number of states of dominant firms (symetric)
  
  // Remember the transition of the competitors for best response computation
  // There is a seperate code computing that
  #ifdef GET_TRANSITION
  rememberCompTran = (double ***) malloc(other_dom_firms*sizeof(double **));
  for(int i=0;i<other_dom_firms;i++) {
    rememberCompTran[i]=(double **) malloc(other_dom_firms*sizeof(double *));
    for(int j=0;j<other_dom_firms;j++) {
      rememberCompTran[i][j]=(double *) malloc(xmax_dom*sizeof(double));
    }
  }
  #endif
  
  // Econding for state space

  int index_enc[dom_firm_number];
  encoding_total = (int **) malloc(shock_states*sizeof(int *));
  c=0; combinations_with_repetition(encoding_total, index_enc, 0, xmax_dom, dom_firm_number);
  if(other_number>0) {
    encoding_other = (int **) malloc(other_dom_firms*sizeof(int *));
    c=0; combinations_with_repetition(encoding_other, index_enc, 0, xmax_dom, other_number);
  } else {
    encoding_other = (int **) malloc(other_dom_firms*sizeof(int *));
    encoding_other[0] = (int *) malloc(other_dom_firms*sizeof(int));
    encoding_other[0][0]=0;
  }

//  cout << "1\n";

  // Add firm encoding

  MatrixMTL<int> addFirm(xmax_dom,other_dom_firms);
  if(other_number>0) {
    endcodeAddFirm(addFirm);
  } else {
    for(int i=0;i<xmax_dom;i++) {
      addFirm[i][0]=i;
    }
  }

//  cout << "2\n";

  // Remove firm 
  MatrixMTL<int> removeFirm(dom_firm_number,shock_states);
  computeRemoveFirm(removeFirm, encoding_total, encoding_other, dom_firm_number, shock_states);

//  cout << "3\n";

  // Create global variables
  if(iotaMatrix0_global!=NULL) delete iotaMatrix0_global;
  iotaMatrix0_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  if(rhoMatrix0_global!=NULL) delete rhoMatrix0_global;
  rhoMatrix0_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  if(V_global!=NULL) delete V_global;
  V_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  if(V_expected_global!=NULL) delete V_expected_global;
  V_expected_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  if(tildesMatrix_global!=NULL) delete tildesMatrix_global;
  tildesMatrix_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  if(profitMatrix_global!=NULL) delete profitMatrix_global;
  profitMatrix_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  if(prcontMatrix_global!=NULL) delete prcontMatrix_global;
  prcontMatrix_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  if(pricesMatrix_global!=NULL) delete pricesMatrix_global;
  pricesMatrix_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  // Dominant firms globals
  if(VDom_global!=NULL) delete VDom_global;
  VDom_global = new MatrixMTL<double>(other_dom_firms*aggr_shocks,xmax_dom);

  if(profitMatrixDom_global!=NULL) delete profitMatrixDom_global;
  profitMatrixDom_global = new MatrixMTL<double>(other_dom_firms*aggr_shocks,xmax_dom);

  if(pricesMatrixDom_global!=NULL) delete pricesMatrixDom_global;
  pricesMatrixDom_global = new MatrixMTL<double>(shock_states*aggr_shocks,xmax_dom);
  // Initialize dominant firm strategies
  // IT NEEDS TO REWRITTEN IN CASE WE WANT TO KEEP TRACK OF HISTORIES
  // AND xmax_dom!=XMAX
  if(iotaMatrixDom0_global!=NULL) delete iotaMatrixDom0_global;
  iotaMatrixDom0_global = new MatrixMTL<double>(other_dom_firms*aggr_shocks, xmax_dom);
  for(int i=0;i<other_dom_firms*aggr_shocks;++i) {
    for(int j=0;j<xmax_dom;++j) {
      (*iotaMatrixDom0_global)[i][j]=MAX(iotaInit[j],0.5);
    }
  }

  if(EVDom!=NULL) delete EVDom;
  EVDom = new MatrixMTL<double>(other_dom_firms*aggr_shocks,xmax_dom);
  (*EVDom)=0;

//  cout << "4\n";

  MatrixMTL<double> *iotaMatrixDom1 = new MatrixMTL<double>(other_dom_firms*aggr_shocks, xmax_dom);

  MatrixMTL<double> *iotaMatrix1 = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);
  MatrixMTL<double> *rhoMatrix1 = new MatrixMTL<double>(shock_states*aggr_shocks,xmax);

  VectorMTL<double> d(xmax);

  for(int w=0;w<shock_states*aggr_shocks;w++) {
    for(int i=0;i<xmax;i++) {
      d[i]=MACRO__MINVCOST(i);
      (*pricesMatrix_global)[w][i]=MACRO__MARGINAL_COST(i)+1e-1;
      (*pricesMatrixDom_global)[w][i]=MACRO__MARGINAL_COST(i)+1e-1;
    }
  }

//  cout << "5\n";

  // Initialize Iota and rho
  for(int i=0;i<shock_states*aggr_shocks;i++) {
    for(int j=0;j<xmax;j++) {
//      cout << "(" << i << "," << j << ")" << endl;
      (*iotaMatrix0_global)[i][j]=iotaInit[j];
      (*rhoMatrix0_global)[i][j]=rhoInit[j];
    }
  }

  // initialize stationary distribution vector for dominant firms
  if(q!=NULL) {
    delete q;
  }
  q = new VectorMTL<double>(shock_states*aggr_shocks);

  ignore=1;


//  cout << "6\n";

  //// Generate sparcity patterns for transition matrices
  // First get the reverse encoding for per-firm transition
  #ifndef ACW
  SparseMatrixMTL<double> tranTemp;
  SparseMatrixMTL<double> contTranTemp;
  VectorMTL<double> prcontTemp(xmax_dom);
  prcontTemp = 1;
  VectorMTL<double> iotaTemp(xmax_dom);
  iotaTemp = iotaMatrixDom0_global->getRow(0);
  tranProb(iotaTemp, tranTemp, contTranTemp, prcontTemp);
  if(reverseEnc!=NULL) delete reverseEnc;
  reverseEnc = new MatrixMTL<int>(xmax_dom,xmax_dom);
  reverseEncoding(tranTemp);
  #else
  // Creare dense reverse encoding for ECW
  reverseEnc = new MatrixMTL<int>(xmax_dom,xmax_dom);
  int ii=0;
  for(int i=0;i<xmax_dom;++i) {
    for(int j=0;j<xmax_dom;++j) {
      (*reverseEnc)[i][j]=ii;
      ii++;
    }
  }
  #endif

  if(reverseEncShocks!=NULL) delete reverseEncShocks;
  reverseEncShocks = new MatrixMTL<int>(aggr_shocks,aggr_shocks);
  reverseEncodingShocks(shockTran);
  // Generate sparcity pattern for full industry
  // void compProbFullPattern(int **encoding, int dom_firm_number, int shock_states,
  //    SparseMatrixMTL<double> &tranFull)
  SparseMatrixMTL<double> p;
  compProbFullPattern(encoding_total, dom_firm_number, shock_states, p, shockTran);

  SparseMatrix3D<double> tranDom(other_dom_firms*aggr_shocks);


  // If ACW model then allocate the sparse martices
  #ifdef ACW
    SparseMatrix3D<double> tranDom2(other_dom_firms*aggr_shocks);
    for(int z=0;z<other_dom_firms*aggr_shocks;++z) {
      tranDom[z].init(xmax_dom,xmax_dom,xmax_dom*xmax_dom);
      tranDom2[z].init(xmax_dom,xmax_dom,xmax_dom*xmax_dom);
      // Generate dense sparcity pattern
      int element=0;
      for(int i=0;i<xmax_dom;++i) {
        for(int j=0;j<xmax_dom;++j) {
          tranDom[z].rows[element]=i;
          tranDom[z].columns[element]=j;
          tranDom2[z].rows[element]=i;
          tranDom2[z].columns[element]=j;
          element++;
        }
      }
    }

    if (action_profit!=NULL) delete action_profit;
    action_profit = new MatrixMTL<double>(constants[6],xmax);

    if (acwTran!=NULL) delete acwTran;
    acwTran = new MatrixMTL<int>(constants[6],xmax);
    // State: 0 - S, 1-SM, 2-SL, 3-M, 4-ML, 5-L, 6-Out
    // Actions: 0 - S, 1 - M, 2 - L, 3-Out
    (*acwTran)[0][0]=0; (*acwTran)[1][0]=3; (*acwTran)[2][0]=5; (*acwTran)[3][0]=6;
    (*acwTran)[0][1]=1; (*acwTran)[1][1]=3; (*acwTran)[2][1]=5; (*acwTran)[3][1]=6;
    (*acwTran)[0][2]=2; (*acwTran)[1][2]=4; (*acwTran)[2][2]=5; (*acwTran)[3][2]=6;
    (*acwTran)[0][3]=1; (*acwTran)[1][3]=3; (*acwTran)[2][3]=5; (*acwTran)[3][3]=6;
    (*acwTran)[0][4]=2; (*acwTran)[1][4]=4; (*acwTran)[2][4]=5; (*acwTran)[3][4]=6;
    (*acwTran)[0][5]=2; (*acwTran)[1][5]=4; (*acwTran)[2][5]=5; (*acwTran)[3][5]=6;
    (*acwTran)[0][6]=0; (*acwTran)[1][6]=3; (*acwTran)[2][6]=5; (*acwTran)[3][6]=6;

    if (tranmat3D!=NULL) delete tranmat3D;
    tranmat3D = new MatrixMTL3D<double>(xmax,xmax,aggr_shocks*shock_states);
    if (RHS!=NULL) delete RHS;
    RHS = new MatrixMTL3D<double>(xmax,constants[6],other_dom_firms*aggr_shocks);
    if (RHSFringe!=NULL) delete RHSFringe;
    RHSFringe = new MatrixMTL3D<double>(xmax,constants[6],aggr_shocks*shock_states);

    if (action_profitMatrix_global!=NULL) delete action_profitMatrix_global;
    action_profitMatrix_global = new MatrixMTL3D<double>(constants[6],xmax,other_dom_firms*aggr_shocks);
    if (action_profitMatrixFringe_global!=NULL) delete action_profitMatrixFringe_global;
    action_profitMatrixFringe_global = new MatrixMTL3D<double>(constants[6],xmax,shock_states*aggr_shocks);

    *action_profit=0;

    for(int w=0;w<shock_states*aggr_shocks;++w) {
      (*action_profitMatrixFringe_global)[w]=0;
    }
    for(int w=0;w<other_dom_firms*aggr_shocks;++w) {
      (*action_profitMatrix_global)[w]=0;
    }

    int k=0;
    for(int a=0;a<aggr_shocks;a++) {
      setShock(a);
      for(int w=0;w<shock_states;w++) {
        MatrixMTL<double> tranmat_w(xmax);

        (*RHSFringe)[k]=0;
        for(int x=0;x<xmax_dom;x++) {
          (*RHSFringe)[k][x][(int) constants[6]-1]=5;
        }
        tranProbACW((*RHSFringe)[k],tranmat_w);
        (*tranmat3D)[k]=tranmat_w;

        k++;
      }
      restore();
    }
    k=0;
    for(int a=0;a<aggr_shocks;a++) {
      for(int w=0;w<other_dom_firms;++w) {
        (*RHS)[k]=0;
        k++;
      }
    }
  #endif

  // Matrix for competitors transition
  // It has patterns for adding your state and subtracting states
  if(other_number>0) {
    compTransition = new MatrixMTL<int>(other_dom_firms, other_number*xmax_dom);
    c=0;competitorsTransition(encoding_other, index_enc, 0, xmax_dom, other_number, other_dom_firms);
  }

  // Initialize transition matrix
  tranProbDom(*iotaMatrixDom0_global,tranDom);
  compProbFull(encoding_total, dom_firm_number, shock_states, p, tranDom, removeFirm, shockTran);
 
  //for(int i=0;i<p.getSize();++i)  
  //cout << p.rows[i] <<  " " << p.columns[i] << " " << p[i] << endl;
  if(!domparams[5])
    p.statDistr(*q);
//  *q=*q*1e6;
  cout << p;
  cout << *q;
  /****** Initialize lambda *********/
  VectorMTL<double> lambdaVector1(shock_states*aggr_shocks);
  int ai=0;
  for(int a=0;a<aggr_shocks;a++) {
    for(int i=0;i<shock_states;i++) {
      lambdaVector1[ai]=0;
      for(int j=0;j<dom_firm_number;j++) {
        lambdaVector1[ai]+=lambdaInit[encoding_total[i][j]];
      }
      lambdaVector1[ai]/=dom_firm_number;
      ai++;
    }
  }
  if(lambdaVector0_global!=NULL) delete lambdaVector0_global;
  lambdaVector0_global = new VectorMTL<double>(shock_states*aggr_shocks);
  *lambdaVector0_global=lambdaVector1;
  /****** end of init lambda ********/

//  cout << "8\n";
  for(ignore=int(domparams[4]);ignore<3;ignore++) {
    int n=1;
    if(domparams[5]) 
      ignore++;
    if(ignore==1) { 
      #ifdef COUT_DEBUG
        cout << "POE with aggregate shocks: Compute with approximated profit function"<< endl;
      #endif
      #ifdef DEBUG
        *myfile << "POE with aggregate shocks: Compute with approximated profit function"<< endl;
      #endif
    } else {
      #ifdef COUT_DEBUG
        cout << "POE with aggregate shocks: Compute with full profit function"<< endl;
      #endif
      #ifdef DEBUG
        *myfile << "POE with aggregate shocks: Compute with full profit function"<< endl;
      #endif
    }

    while(1) {
      double Delta0=0;
      double Delta1=0;
      r1 = times(&t);
      for(int w=0;w<aggr_shocks*shock_states;w++) {
        if(lambdaVector1[w]<domparams[3]) {
          (*lambdaVector0_global)[w]=0;
        } else {
          //(*lambdaVector0_global)[w]+=(lambdaVector1[w]-(*lambdaVector0_global)[w])/(pow(n,domparams[7])+domparams[8]);
          (*lambdaVector0_global)[w]=lambdaVector1[w];
	}
      }
//      (*lambdaVector0_global)=lambdaVector1;
//      *lambdaVector0_global+=((lambdaVector1)-(*lambdaVector0_global))/(pow(n,domparams[7])+domparams[8]);
      int bsiter=1;
      while(1) {
        if(domparams[5]) {
          #ifdef COUT_DEBUG
            if((((bsiter-1)/10)<(bsiter/10)) || (bsiter==1)) {
              cout << "Small iter: " << bsiter << endl;
	          }
          #endif
        } else {
          for(int w=0;w<shock_states*aggr_shocks;w++) {
            if((*q)[w]<1e-24) {
              cout << "ERROR: Transient state " << w << ": " << w/shock_states << " - ";
              for(int i=0;i<dom_firm_number;i++) {
                cout << encoding_total[w % shock_states][i] << " ";
              }
              cout << endl;
              cout << *q;
      	      cout << "Matrix" << endl;
              cout << p;
	            cout << "Investment" << endl;
              cout << *iotaMatrixDom0_global;
	            success=0;
              return 0;
            }
          }
        }

//        cout << "Compute tildes" << endl;

        // Compute s_tildes
	      if(control[2]>0) {
	        (*lambdaVector0_global)=control[2]-1;
          lambdaVector1=control[2]-1;
	      }
        //p=1.0/(aggr_shocks*shock_states);
        //(*q)=1e6/(aggr_shocks*shock_states);
        computeTildes(*iotaMatrix0_global, *rhoMatrix0_global, 
          (*lambdaVector0_global), p, *tildesMatrix_global);
        
        //cout << "Tildes computed" << endl;
        
        // Precompute profits for dominant firms
        subtract=0;
        for(int a=0;a<aggr_shocks;++a) {
          setShock(a);
          for(int w=0;w<other_dom_firms;w++) {
            VectorMTL<double> profit_w(xmax_dom);
            VectorMTL<double> prices_w(xmax_dom);
            VectorMTL<double> tildes_w(xmax_dom);
            for(int x=0;x<xmax_dom;x++) {
              VectorMTL<double> profit_x(xmax_dom);

              // We need to aggregate w and x into fullstate encoding
              int z=addFirm[x][w];
              int bigZ=z+a*shock_states;
              VectorMTL<double> tildes_w(xmax_dom);
              // weighted MPE?
              if(domparams[5]) {
                tildes_w=mean_fringe_state;
//                tildes_w=0;
              } else {
//                tildes_w=0;
                tildes_w = tildesMatrix_global->getRow(bigZ);
              }
/*
              if(subtract==1) {
                double tildesn=sum(tildes_w);
                if(tildesn>1) {
                 tildes_w-=(tildes_w/tildesn);  
                } 
              }
*/
              // Add dominant firms
              for(int i=0;i<other_number;i++) {
                tildes_w[encoding_other[w][i]]++;
              }
              prices_w = pricesMatrixDom_global->getRow(bigZ);

//            cout << tildes_w;
              compProf(tildes_w,prices_w,profit_x);

              profit_w[x]=profit_x[x];
              pricesMatrixDom_global->setRow(bigZ, prices_w);
              #ifdef ACW
              for(int a2=0;a2<constants[6];++a2) {
                (*action_profitMatrix_global)[w+a*other_dom_firms][a2][x]=(*action_profit)[a2][x];
              }
              #endif
            } 
            profitMatrixDom_global->setRow(w+a*other_dom_firms, profit_w);
          }
          restore();
        }
//        cout << *tildesMatrix_global << endl;
//        cout << *profitMatrixDom_global;
//        cout << "Dominant firm profits precomputed" << endl;getchar();

        // Best respond dominant firms
        valueItDom(*profitMatrixDom_global, *iotaMatrixDom1, *VDom_global, d, tranDom, shockTran);
        #ifndef ACW
        if((((n-1)/100)<(n/100)) || (n==1) || (domparams[5])) {
          if((((bsiter-1)/10)<(bsiter/10)) || (bsiter==1)) {
          #ifdef COUT_DEBUG
            cout << "\tIota DOM stop: " << norm((*iotaMatrixDom0_global)-(*iotaMatrixDom1)) << endl;
          #endif
	        }
	      }
        

        if (norm((*iotaMatrixDom0_global)-(*iotaMatrixDom1)) < domparams[1]) {
	        // Recompute the stationary distribution and exit
	        tranProbDom(*iotaMatrixDom0_global,tranDom);
	        compProbFull(encoding_total, dom_firm_number, shock_states, p, tranDom, removeFirm, shockTran);
	        if(!domparams[5]) {
            p.statDistr(*q);
//	          *q=*q*1e6;
          }
          break;
        }
        (*iotaMatrixDom0_global)+=(((*iotaMatrixDom1)-(*iotaMatrixDom0_global))/(pow(bsiter+n,domparams[7])+domparams[8]));
	      tranProbDom(*iotaMatrixDom0_global,tranDom);
	      compProbFull(encoding_total, dom_firm_number, shock_states, p, tranDom, removeFirm, shockTran);
	      if(!domparams[5]) {
          p.statDistr(*q);
//	        *q=*q*1e6;
        }

        // If not weighted MPE
        // If weighted MPE then do only small ones so never break
        if(!domparams[5]) {
          // Do small iters?
          if(domparams[16]==0) {
            break;
          }
          // Don't do small iters for first
          if(n<domparams[17]) {
            break;
          }
        }
        bsiter++;

        #else
        tranProbDom(*iotaMatrixDom0_global,tranDom2);
        // Smooth updating of the transition matrix and norm computation
        // Norm is the maximum norm of a difference of transition matrices by the dominant firms
        int k=0;
        Delta0=0;
        for(int a=0;a<aggr_shocks;a++) {
          for(int w=0;w<other_dom_firms;w++) {
            Delta0=MAX(Delta0,norm(tranDom2[k]-tranDom[k]));
            tranDom[k]+=(tranDom2[k]-tranDom[k])/(pow(n,domparams[7])+domparams[8]);
            k++;
          }
        }
        if(!domparams[5]) {
          compProbFull(encoding_total, dom_firm_number, shock_states, p, tranDom, removeFirm, shockTran);
          p.statDistr(*q);
          break;
        }
        if(Delta0<domparams[1]) {
          break;
        }
        cout << "Small iter: " << bsiter << " (" << Delta0 << ")" << endl;
        bsiter++;
        #endif
      }

      // If weighed iter, then compute stationary distribution and exit
      if(domparams[5]) {
        compProbFull(encoding_total, dom_firm_number, shock_states, p, tranDom, removeFirm, shockTran);
        p.statDistr(*q);
//        *q=*q*1e6;
        break;
      }

      // End of bsiter
      // Precompute profits
      subtract=control[4];
      //subtract=0;
      int k=0;
      for(int a=0;a<aggr_shocks;a++) {
        setShock(a);
        for(int w=0;w<shock_states;w++) {
          VectorMTL<double> profit_w(xmax);
          VectorMTL<double> prices_w(xmax);
          VectorMTL<double> tildes_w(xmax);
          tildes_w = tildesMatrix_global->getRow(k);
          prices_w = pricesMatrix_global->getRow(k);

          if(subtract==1) {
            if((control[2]==0) && (control[1]==1)) { // Poisson
              for(int x=0;x<xmax;++x) {
                tildes_w[x]=tildes_w[x]/(1-exp(-tildes_w[x]))-1;
              }
            } else {
              double tildesn=sum(tildes_w);
              if(tildesn>1) {
                tildes_w-=(tildes_w/tildesn);
              }
            }
          }

          for(int i=0;i<dom_firm_number;i++) {
            tildes_w[encoding_total[w][i]]++;
          }

          compProf(tildes_w,prices_w,profit_w);
          pricesMatrix_global->setRow(k, prices_w);
          profitMatrix_global->setRow(k, profit_w);
          #ifdef ACW
          (*action_profitMatrixFringe_global)[k]=(*action_profit);
          #endif

          k++;
        }
        restore();
      }
//      cout << *tildesMatrix_global << endl;
//      cout << *profitMatrix_global;

//      cout << "Frigne firm profits precomputed" << endl;getchar();
//    cout << "Profit computed" << endl;
//    getchar();

      //// Compute iota and rho for fringe
      valueIt(*profitMatrix_global, *iotaMatrix1, *rhoMatrix1, *V_global, *V_expected_global, d, p);
//      cout << "Fringe firm value function computed" << endl;getchar();

      #ifdef ACW
      k=0;
      for(int a=0;a<aggr_shocks;a++) {
        setShock(a);
        for(int w=0;w<shock_states;w++) {
          MatrixMTL<double> tranmat_w(xmax);
          VectorMTL<double> V_w(xmax);

          // Compute transitions
          tranProbACW((*RHSFringe)[k],tranmat_w);

          // Update transitions
          Delta0=MAX(Delta0,norm((tranmat_w)-(*tranmat3D)[k]));
          //(*tranmat3D)[k]=tranmat_w;
          (*tranmat3D)[k]+=((tranmat_w)-(*tranmat3D)[k])/(pow(n,domparams[7])+domparams[8]);

          k++;
        }
        restore();
      }
      /*
      cout << tranDom[0];
      cout << endl;
      cout << (*RHSFringe)[0];
      cout << endl;
      cout << (*RHSFringe)[6];
      getchar();
      */
      r2 = times(&u);
      if((((n-1)/1)<(n/1)) || (n==1)) {
        #ifdef COUT_DEBUG
        cout << "Iteration: " << n << endl;
        cout << "Stop: " << Delta0 << endl;
        cout << "Time of the iteration: " << r2-r1 <<endl;
        #endif

        #ifdef DEBUG
        *myfile << "Iteration: " << n << endl;
        *myfile << "Stop: " << Delta0 << endl;
        *myfile << "Time of the iteration: " << r2-r1 <<endl;
        #endif
      }
      if(Delta0<domparams[1]) break;
      #else
      // Update lambda
      k=0;
      for(int a=0;a<aggr_shocks;a++) {
        for(int w=0;w<shock_states;w++) {
          VectorMTL<double> V_expected_w(xmax);
          V_expected_w=V_expected_global->getRow(k);
          if(control[2]==0) {
            lambdaVector1[k]=(*lambdaVector0_global)[k]*V_expected_w[int(constants[3])-1]*constants[2]/constants[0];
          }
          double temp = V_expected_w[int(constants[3])-1]*constants[2]-constants[0];
          /*if(a==aggr_shocks-1) {
            cout << "UPDATE: " << lambdaVector1[k];
            cout << " " << V_expected_w[int(constants[3])-1]*constants[2]/constants[0] << " " << V_expected_w[int(constants[3])-1] << endl;
          }*/
          Delta0=MAX(temp,Delta0);
          if(lambdaVector1[k]>domparams[3]) {
            Delta1=MAX(Delta1,-temp);
          } else {
            // If lambda was 0 but there is positive profit now
/*            if(temp>0) {
              lambdaVector1[k]=2*domparams[3];
            }*/
          }
          k++;
        }
      }
      //getchar();
      //cout << "Lambda updated" << endl;getchar();

      // Update iota and rho
      (*rhoMatrix0_global)+=((*rhoMatrix1)-(*rhoMatrix0_global))/(pow(n,domparams[7])+domparams[8]);
      (*iotaMatrix0_global)+=((*iotaMatrix1)-(*iotaMatrix0_global))/(pow(n,domparams[7])+domparams[8]);

//      cout << V_expected_global->getRow(0);
//      cout << rhoMatrix1->getRow(0);
//      cout << rhoMatrix0_global->getRow(0);
//      cout << iotaMatrix0_global->getRow(0);
//      getchar();

//      cout << ambdaVector0_global[0] << endl;
//      getchar();

      r2 = times(&u);
      if((((n-1)/100)<(n/100)) || (n==1)) {

        #ifdef COUT_DEBUG
          cout << "Iteration: " << n << endl;
          cout << "Iota stop: " << norm((*iotaMatrix0_global)-(*iotaMatrix1)) << "\t\t Rho stop = "
            << norm((*rhoMatrix0_global)-(*rhoMatrix1)) << endl;
	        if(control[2]==0) {
            cout << "Lambda stop: Delta0 = " << Delta0 << ", Delta1 = " 
              << Delta1 << ", norm: " << norm(lambdaVector1-(*lambdaVector0_global))<< endl;
	        }
          cout << "Time of the iteration: " << r2-r1 <<endl;
        #endif

        #ifdef DEBUG
          *myfile << "Iteration: " << n << endl;
          *myfile << "Iota stop: " << norm((*iotaMatrix0_global)-(*iotaMatrix1)) << "\t\t Rho stop = "
            << norm((*rhoMatrix0_global)-(*rhoMatrix1)) << endl;
	        if(control[2]==0) {
            *myfile << "Lambda stop: Delta0 = " << Delta0 << ", Delta1 = " 
              << Delta1 << ", norm: " << norm(lambdaVector1-(*lambdaVector0_global))<< endl;
	        }
          *myfile << "Time of the iteration: " << r2-r1 <<endl;
        #endif
      }

      /*** Stopping criterion ***/
      if ((norm((*iotaMatrix0_global)-(*iotaMatrix1)) < domparams[1]) && 
        (norm((*rhoMatrix0_global)-(*rhoMatrix1)) < domparams[0]) &&
        (norm((*iotaMatrixDom0_global)-(*iotaMatrixDom1)) < domparams[1])) {
	      break;
      }
      
      if(control[2]==0) {
        if((Delta0<domparams[2]) && (Delta1<domparams[2])) break;
	      if(norm(lambdaVector1-(*lambdaVector0_global))<domparams[15]) break;
      }
      #endif
      if(n>convtol[2]) {
        success=0;
        break;
      }
      n_global=n;
      n++;
    }
  }
  
  ofstream myfile2;
  myfile2.open ("fullTransition.txt");
  myfile2 << p;
  myfile2.close();

  #ifdef ACW
  //cout << tranDom[0];
  myfile2.open ("domTransition.txt");
  for(int z=0;z<aggr_shocks*other_dom_firms;++z) {
    myfile2 << tranDom[z];
  }
  myfile2.close();

  myfile2.open ("shockTransition.txt");
  myfile2 << shockTran;
  myfile2.close();


/*
  cout << V_expected_global->getRow(0);
  cout << V_expected_global->getRow(5*7);
  cout << (*action_profitMatrixFringe_global)[5*7];
  cout << "--------" << endl;
  cout << (*tranmat3D)[0];
  cout << "--------" << endl;
  cout << (*tranmat3D)[7*5];
  cout << (*tranmat3D)[7*5+4];
  cout << "--------" << endl;
  cout << EVDom->getRow(0);
  cout << EVDom->getRow(5);
  cout << (*action_profitMatrix_global)[5];
  cout << "--------" << endl;
  cout << tranDom[0];

  ofstream myfile2;
  myfile2.open ("example5.txt");
  for(int i=0;i<aggr_shocks;++i) {
    myfile2 << tranDom[i];
  }
  myfile2.close();

  myfile2.open ("example6.txt");
  myfile2 << shockTran;
  myfile2.close();
*/
/*
  for(int w=0;w<aggr_shocks;++w) {
     cout << (*tranmat3D)[w*7].getRow(6);// << "--------" << endl;
  }
  cout << "--------" << endl;
  for(int w=0;w<aggr_shocks;++w) {
     cout << (*tranmat3D)[w*7].getRow(5);// << "--------" << endl;
  }
  cout << "--------" << endl;
  for(int w=0;w<aggr_shocks;++w) {
     cout << (*tranmat3D)[w*7].getRow(3);// << "--------" << endl;
  }
  cout << "--------" << endl;
  for(int w=0;w<aggr_shocks;++w) {
     cout << (*tranmat3D)[w*7].getRow(0);// << "--------" << endl;
  }
*/
  #endif

/*
  for(int w=0;w<shock_states;w++) {
    if(lambdaVector1[w]>domparams[3]) {
      (*lambdaVector0_global)[w]=lambdaVector1[w];
    } else {
      (*lambdaVector0_global)[w]=0;
    } 
  }*/

  //*q=*q/1e6;

  // Save tran dom
  if(tranDom_global!=NULL) delete tranDom_global;
  tranDom_global=new SparseMatrix3D<double>(tranDom);

  #ifdef GET_TRANSITION
  ofstream fout;
  fout.open ("competitorsTransition");
  fout.precision(30);
  for(int i=0;i<other_dom_firms;i++) {
    for(int j=0;j<other_dom_firms;j++) {
      for(int k=0;k<xmax_dom;k++) {
        fout << i << "\t" << j << "\t" << k << "\t" << rememberCompTran[i][j][k] << endl;
      }
    }
  }
  cout << "Write to file\n";
  fout.close();
  #endif

  return success;

  /// IT'S A MEMORY LEAK NOW
/*
  for(int w=0;w<shock_states;w++) {
    free(encoding_total[w]);
  }
  free(encoding_total);

  for(int w=0;w<other_dom_firms;w++) {
    free(encoding_other[w]);
  }
  free(encoding_other);*/
}

void CompOE_dom::computeTildes(MatrixMTL<double> &iotaMatrix, 
  MatrixMTL<double> &rhoMatrix, VectorMTL<double> &lambdaVector, 
  SparseMatrixMTL<double> &shockTran, MatrixMTL<double> &tildesMatrix) {

  // Compute p(x',w'|x,w)
  // Rows (columns) have shock_states number of blocks of size xmax
  // Size of the matrix is shock_states*xmax
  // Each submatrix corresponds to one (w,w') pair and its
  // elements are given by P(x'|x,w)P(w'|w)
  // Number of zeros in each submatrix equals to number of zeros in P(x'|x,w)

  #if TRANSITION_MATRIX == 0
  MatrixMTL<double> tranmat_w(xmax);
  MatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 1
  TriDiagMatrixMTL<double> tranmat_w(xmax);
  TriDiagMatrixMTL<double> conttranmat_w(xmax);
  #elif TRANSITION_MATRIX == 2
  SparseMatrixMTL<double> tranmat_w(xmax);
  SparseMatrixMTL<double> conttranmat_w(xmax);
  #error Invalid value for TRANSITION_MATRIX
  #endif
  VectorMTL<double> prcont_w(xmax);
  VectorMTL<double> iota_w(xmax);
  VectorMTL<double> rho_w(xmax);
  VectorMTL<double> condexp_w(xmax);

  // STEP I: Calculate number of nonzero elements
  int p_size = shockTran.getSize()*getTransitionSize();
//  cout << "Size of p: " << p_size <<endl;
  // Allocate the matrix
  int p_dim = shock_states*aggr_shocks*xmax;
  SparseMatrixMTL<double> p(p_dim, p_dim, p_size);

  // Compute p_matrix
  // Loop over rows
  int p_iterator = 0;
  int first_element_of_row = 0;
  int offset_w = 0;
  for(int w=0;w<shockTran.nrows;w++) {
    #ifndef ACW
    if((*q)[w]>0) {
      iota_w = iotaMatrix.getRow(w);
      rho_w = rhoMatrix.getRow(w);
      continuationProb(rho_w,prcont_w,condexp_w);
      tranProb(iota_w, tranmat_w, conttranmat_w, prcont_w);
//      cout << w;
//      cout << iota_w;
//      cout << conttranmat_w;
//      getchar();
    } else {
      conttranmat_w = 0;
    }
    #else
    conttranmat_w = (*tranmat3D)[w];
    #endif

    #if TRANSITION_MATRIX == 0
    // Row loop
    
    int i=first_element_of_row;
    for(int j=0;j<xmax;j++) {
      i=first_element_of_row;
      int offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
      // Wprime loop
      while(1) {
        if((i==shockTran.getSize()) ||(shockTran.rows[i]>w)) {
          break;
        }

        double p_w_wprime = shockTran[i];

        // Columns of the transition
        for(int j1=0;j1<xmax;j1++) {
          p.rows[p_iterator]=offset_w;
          p.columns[p_iterator]=offset_w_prime+j1;
          p[p_iterator]=conttranmat_w[j][j1]*p_w_wprime;
          p_iterator++;
        }
        i++;
        if(i==shockTran.getSize())
          break;
        offset_w_prime=shockTran.columns[i]*xmax;
      }
      offset_w++;
    }
    first_element_of_row=i;
/*
    for(int j=0;j<xmax;++j) {
      int i=w*70;
      int z=0;
      for(int g=0;g<70;g++) {
        for(int j1=0;j1<xmax;j1++) {
          p.rows[p_iterator]=7*w+j;
          p.columns[p_iterator]=z;
          p[p_iterator]=conttranmat_w[j][j1]*shockTran[i];
          p_iterator++;
          z++;
          if((w==7) && (g==0) && (j==0) && (j1==0))
            printf("%.15f\t%.15f\t%.15f\n",conttranmat_w[j][j1],shockTran[i],p[p_iterator-1]);

        }
        i++;
      }
    }
*/    

    #elif TRANSITION_MATRIX == 1
    // Loop over conttranmax

    // First row //
    int offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
    // Loop over columns of w
    int i=first_element_of_row;
    while(1) {
      if((i==shockTran.getSize())  || (shockTran.rows[i]>w)) {
        break;
      }

      double p_w_wprime = shockTran[i];

      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime;
      p[p_iterator]=conttranmat_w[0][0]*p_w_wprime;
      p_iterator++;

      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime+1;
      p[p_iterator]=conttranmat_w[-1][0]*p_w_wprime;
      p_iterator++;
      
      i++;
      if(i<shockTran.getSize())
        offset_w_prime=shockTran.columns[i]*xmax;
    }
    offset_w++;

    // Middle rows
    for(int j=1;j<xmax-1;j++) {
      offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
      i=first_element_of_row;
      while(1) {
        if((i==shockTran.getSize()) ||(shockTran.rows[i]>w)) {
          break;
        }

        double p_w_wprime = shockTran[i];

        p.rows[p_iterator]=offset_w;
        p.columns[p_iterator]=offset_w_prime+j-1;
        p[p_iterator]=conttranmat_w[1][j-1]*p_w_wprime;
        p_iterator++;

        p.rows[p_iterator]=offset_w;
        p.columns[p_iterator]=offset_w_prime+j;
        p[p_iterator]=conttranmat_w[0][j]*p_w_wprime;
        p_iterator++;

        p.rows[p_iterator]=offset_w;
        p.columns[p_iterator]=offset_w_prime+j+1;
        p[p_iterator]=conttranmat_w[-1][j]*p_w_wprime;
        p_iterator++;

        i++;
	      if(i<shockTran.getSize())
          offset_w_prime=shockTran.columns[i]*xmax;
      }
      offset_w++;
    }

    i=first_element_of_row;
    offset_w_prime=shockTran.columns[first_element_of_row]*xmax;
    while(1) {
      if((i==shockTran.getSize()) ||(shockTran.rows[i]>w)) {
        break;
      }

      double p_w_wprime = shockTran[i];

      // Last row
      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime+xmax-2;
      p[p_iterator]=conttranmat_w[1][xmax-2]*p_w_wprime;
      p_iterator++;

      p.rows[p_iterator]=offset_w;
      p.columns[p_iterator]=offset_w_prime+xmax-1;
      p[p_iterator]=conttranmat_w[0][xmax-1]*p_w_wprime;
      p_iterator++;

      i++;
      if(i<shockTran.getSize())
        offset_w_prime=shockTran.columns[i]*xmax;
    }
    offset_w++;

    first_element_of_row = i;
    #elif TRANSITION_MATRIX == 2
    #else 
    #error Invalid value for TRANSITION_MATRIX
    #endif
  }
  if(control[2]>0) {
    VectorMTL<double> b(p_dim);
/*
    ofstream myfile2;
    myfile2.open ("example.txt");
    myfile2.precision(10);
    myfile2 << p;
    myfile2.close();
    myfile2.open ("example2.txt");
    myfile2.precision(10);
    myfile2 << shockTran;
    myfile2.close();
    myfile2.open ("example3.txt");
    myfile2.precision(10);
    for(int w=0;w<shockTran.nrows;w++) {
    myfile2 << (*tranmat3D)[w];
    }
*/
    p.statDistr(b);
    offset_w = 0;

    /*
    for(int w=0;w<aggr_shocks*shock_states;w++) {
      double temp_q = (*q)[w]*1e-6;
      if(temp_q==0) {
	      for(int x=0;x<xmax;x++) {
          tildesMatrix[w][x]=-1;
	        tildesMatrixFringe[w][x]=-1;
	      }
      } else {
	      for(int x=0;x<xmax;x++) {
          tildesMatrix[w][x]=control[2]*b[offset_w+x]/temp_q;
	        tildesMatrixFringe[w][x]=(control[2]-1)*b[offset_w+x]/temp_q;
	      }
      }
      offset_w+=xmax;
    }
    */
    int z=0;
    for(int w=0;w<aggr_shocks*shock_states;w++) {
      for(int x=0;x<xmax;x++) {
        tildesMatrix[w][x]=control[2]*b[z]/((*q)[w]);
        z++;
      }
    }
  } else {
    // Compute b vector
    VectorMTL<double> b(p_dim);
    // First zero out the vector b
    b=0;
    // Loop for (w,w')
    for(int i=0;i<shockTran.getSize();i++) {
      b[shockTran.columns[i]*xmax+int(constants[3])-1]
        -=lambdaVector[shockTran.rows[i]]*(*q)[shockTran.rows[i]]*shockTran[i];
    }

    // Solve for pi
    VectorMTL<double> pi(p_dim);
    p.addDiag(-1);
    p.primesolve(b,pi);
    offset_w = 0;
    for(int w=0;w<aggr_shocks*shock_states;w++) {
      double temp_q = (*q)[w];
      if(temp_q==0) {
        for(int x=0;x<xmax;x++) {
          tildesMatrix[w][x]=-1;
        }
      } else {
        for(int x=0;x<xmax;x++) {
          tildesMatrix[w][x]=pi[offset_w+x]/temp_q;
        }
      }
      offset_w+=xmax;
    }
  }
}



void CompOE_dom::computeStats_dom(double *bounds_init, MatrixMTL<double> &iota, MatrixMTL<double> &iota_dom,
  MatrixMTL<double> &rho, MatrixMTL<double> &tildes,
  VectorMTL<double> &lambdaVector, MatrixMTL<double> &prices,
  VectorMTL<double> &q, SparseMatrixMTL<double> &shockTran,
  VectorMTL<double> &s0_init, int w0_init) {

  int L = int(domparams[11]);
  int M = int(domparams[12]);

  int discounted=0;
  if(s0_init[0]>-1) {
    if(domparams[21]>0) {
      discounted=1;
    }
  }

  ignore=2;
  xmax = iota.getLength();
  
  shock_states = iota.getHeight();
  bounds = bounds_init;

  xmax_dom = xmax; // Allow for different number of states of dominant firms
  dom_firm_number = int(domparams[10]);
  other_number = dom_firm_number-1;

  other_dom_firms = (dom_firm_number <= 1) ? 1 :
    newton(xmax_dom+other_number-1,other_number)/factorial(other_number);; // Number of states of competitors of dom firm (symetric)
  shock_states = (dom_firm_number == 0) ? 1 :
    newton(xmax_dom+dom_firm_number-1,dom_firm_number)/factorial(dom_firm_number); // Number of states of dominant firms (symetric)

  aggr_shocks = shockTran.getNRows();
  if(reverseEncShocks!=NULL) delete reverseEncShocks;
  reverseEncShocks = new MatrixMTL<int>(aggr_shocks,aggr_shocks);
  reverseEncodingShocks(shockTran);


  #if TRANSITION_MATRIX == 0
    MatrixMTL<double> tranMatrix_w(xmax,xmax);
    MatrixMTL<double> contTranMatrix_w(xmax,xmax);
    MatrixMTL3D<double> contTranMatrix(xmax,xmax,shock_states);
  #elif TRANSITION_MATRIX == 1
    TriDiagMatrixMTL<double> tranMatrix_w(xmax);
    TriDiagMatrixMTL<double> contTranMatrix_w(xmax);
    TriDiagMatrix3D<double> contTranMatrix(xmax,shock_states);
  #elif TRANSITION_MATRIX == 2
    SparseMatrixMTL<double> tranMatrix_w;
    SparseMatrixMTL<double> contTranMatrix_w;
    SparseMatrix3D<double> contTranMatrix(shock_states);
  #else
    #error Invalid value for TRANSITION_MATRIX
  #endif

  SparseMatrixMTL<double> full;
  if(dom_firm_number>0) {
    // Econding for state space
    int index_enc[dom_firm_number];
    encoding_total = (int **) malloc(shock_states*sizeof(int *));
    c=0; combinations_with_repetition(encoding_total, index_enc, 0, xmax_dom, dom_firm_number);
    if(other_number>0) {
      encoding_other = (int **) malloc(other_dom_firms*sizeof(int *));
      c=0; combinations_with_repetition(encoding_other, index_enc, 0, xmax_dom, other_number);
    } else {
      encoding_other = (int **) malloc(other_dom_firms*sizeof(int *));
      encoding_other[0] = (int *) malloc(other_dom_firms*sizeof(int));
      encoding_other[0][0]=0;
    }
  

    // Add firm encoding
    MatrixMTL<int> addFirm(xmax_dom,other_dom_firms);
    if(other_number>0) {
      endcodeAddFirm(addFirm);
    } else {
      for(int i=0;i<xmax_dom;i++) {
        addFirm[i][0]=i;
      }
    }

    // Remove firm 
    MatrixMTL<int> removeFirm(dom_firm_number,shock_states);
    computeRemoveFirm(removeFirm, encoding_total, encoding_other, dom_firm_number, shock_states);
  
    //// Generate sparcity patterns for transition matrices
    // First get the reverse encoding for per-firm transition

    SparseMatrixMTL<double> tranTemp;
    SparseMatrixMTL<double> contTranTemp;
    VectorMTL<double> prcontTemp(xmax_dom);
    prcontTemp = 1;
    VectorMTL<double> iotaTemp(xmax_dom);
    iotaTemp = iota_dom.getRow(0);
    tranProb(iotaTemp, tranTemp, contTranTemp, prcontTemp);
    reverseEnc = new MatrixMTL<int>(xmax_dom,xmax_dom);
    reverseEncoding(tranTemp);

/*
    int z=0;
    for(int i=0;i<xmax_dom;++i) {
      for(int j=0;j<xmax_dom;++j) {
        (*reverseEnc)[i][j]=z;
        z++;
      }
    }
*/    
    compProbFullPattern(encoding_total, dom_firm_number, shock_states, full, shockTran);

    SparseMatrix3D<double> tranDom(other_dom_firms);
    tranProbDom(iota_dom,tranDom);
    compProbFull(encoding_total, dom_firm_number, shock_states, full, tranDom, removeFirm, shockTran);
  } else {
    q[0]=1;
  } // End of dom firm 'if'

  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);
  VectorMTL<double> rho_w(xmax);
  VectorMTL<double> iota_w(xmax);

  double boundspre;

  int xmax_ext = xmax * int(bounds[7]);

  /*** Extended vectors ***/
  MatrixMTL<double> tildes_ext(shock_states,xmax_ext);
  MatrixMTL<double> proftildes_ext(shock_states,xmax_ext);
  MatrixMTL<double> prices_ext(shock_states,xmax_ext);
  VectorMTL<double> s0_ext(xmax_ext);
  VectorMTL<double> state(xmax_ext);
  VectorMTL<double> state_new(xmax_ext);
  VectorMTL<double> profsim(xmax_ext);
  VectorMTL<double> profsim_xmax(xmax);

  /*** Market shares ***/
  VectorMTL<double> ms(xmax_ext);

  /*** Industry statistics ***/
  double prodsursum = 0;
  double prodsursqr = 0;
  double conssursum = 0;
  double conssursqr = 0;
  double totalsursum = 0;
  double totalsursqr = 0;

  /*** Entry/Exit stats ***/
  double entratesum=0;
  double entratesqr=0;
  double exiratesum=0;
  double exiratesqr=0;
  double msexitsum=0;
  double msexitsqr=0;

  double invsum=0;
  double invsqr=0;

  /*** Concetrations ratios ***/
  double c1sum=0;
  double c1sqr=0;
  double c2sum=0;
  double c2sqr=0;
  double c4sum=0;
  double c4sqr=0;
  double c10sum=0;
  double c10sqr=0;
  double c20sum=0;
  double c20sqr=0;

  double hhi50sum=0;
  double hhi50sqr=0;
  
  
  VectorMTL<double> firmsnumbersum(xmax_dom);
  firmsnumbersum=0;
  VectorMTL<double> firmsnumbersqr(xmax_dom);
  firmsnumbersqr=0;
  MatrixMTL<double> fringesum(shock_states,xmax_dom);
  fringesum=0;
  MatrixMTL<double> fringesqr(shock_states,xmax_dom);
  fringesqr=0;

  if (firmsnumberavg!=NULL) delete firmsnumberavg;
  if (firmsnumbervar!=NULL) delete firmsnumbervar;
  if (firmsnumberpre!=NULL) delete firmsnumberpre;
  if (firmsnumberpor!=NULL) delete firmsnumberpor;
  firmsnumberavg = new VectorMTL<double>(xmax_dom);
  firmsnumbervar = new VectorMTL<double>(xmax_dom);
  firmsnumberpre = new VectorMTL<double>(xmax_dom);
  firmsnumberpor = new VectorMTL<double>(xmax_dom);

  if (fringeavg!=NULL) delete fringeavg;
  if (fringevar!=NULL) delete fringevar;
  if (fringepre!=NULL) delete fringepre;
  if (fringepor!=NULL) delete fringepor;
  fringeavg = new MatrixMTL<double>(shock_states,xmax_dom);
  fringevar = new MatrixMTL<double>(shock_states,xmax_dom);
  fringepre = new MatrixMTL<double>(shock_states,xmax_dom);
  fringepor = new MatrixMTL<double>(shock_states,xmax_dom);

  /* Discounted */
  if(discounted==1) {
    if (prodsuravg_path!=NULL) delete prodsuravg_path;
    if (prodsurvar_path!=NULL) delete prodsurvar_path;
    if (prodsurpre_path!=NULL) delete prodsurpre_path;
    prodsuravg_path = new VectorMTL<double>(M);
    prodsurvar_path = new VectorMTL<double>(M);
    prodsurpre_path = new VectorMTL<double>(M);

    if (conssuravg_path!=NULL) delete conssuravg_path;
    if (conssurvar_path!=NULL) delete conssurvar_path;
    if (conssurpre_path!=NULL) delete conssurpre_path;
    conssuravg_path = new VectorMTL<double>(M);
    conssurvar_path = new VectorMTL<double>(M);
    conssurpre_path = new VectorMTL<double>(M);

    if (totalsuravg_path!=NULL) delete totalsuravg_path;
    if (totalsurvar_path!=NULL) delete totalsurvar_path;
    if (totalsurpre_path!=NULL) delete totalsurpre_path;
    totalsuravg_path = new VectorMTL<double>(M);
    totalsurvar_path = new VectorMTL<double>(M);
    totalsurpre_path = new VectorMTL<double>(M);

    if (c1avg_path!=NULL) delete c1avg_path;
    if (c1var_path!=NULL) delete c1var_path;
    if (c1pre_path!=NULL) delete c1pre_path;
    c1avg_path = new VectorMTL<double>(M);
    c1var_path = new VectorMTL<double>(M);
    c1pre_path = new VectorMTL<double>(M);

    if (c2avg_path!=NULL) delete c2avg_path;
    if (c2var_path!=NULL) delete c2var_path;
    if (c2pre_path!=NULL) delete c2pre_path;
    c2avg_path = new VectorMTL<double>(M);
    c2var_path = new VectorMTL<double>(M);
    c2pre_path = new VectorMTL<double>(M);

    if (c4avg_path!=NULL) delete c4avg_path;
    if (c4var_path!=NULL) delete c4var_path;
    if (c4pre_path!=NULL) delete c4pre_path;
    c4avg_path = new VectorMTL<double>(M);
    c4var_path = new VectorMTL<double>(M);
    c4pre_path = new VectorMTL<double>(M);

    if (c10avg_path!=NULL) delete c10avg_path;
    if (c10var_path!=NULL) delete c10var_path;
    if (c10pre_path!=NULL) delete c10pre_path;
    c10avg_path = new VectorMTL<double>(M);
    c10var_path = new VectorMTL<double>(M);
    c10pre_path = new VectorMTL<double>(M);

    if (c20avg_path!=NULL) delete c20avg_path;
    if (c20var_path!=NULL) delete c20var_path;
    if (c20pre_path!=NULL) delete c20pre_path;
    c20avg_path = new VectorMTL<double>(M);
    c20var_path = new VectorMTL<double>(M);
    c20pre_path = new VectorMTL<double>(M);

    if (hhi50avg_path!=NULL) delete hhi50avg_path;
    if (hhi50var_path!=NULL) delete hhi50var_path;
    if (hhi50pre_path!=NULL) delete hhi50pre_path;
    hhi50avg_path = new VectorMTL<double>(M);
    hhi50var_path = new VectorMTL<double>(M);
    hhi50pre_path = new VectorMTL<double>(M);

    if (invavg_path!=NULL) delete invavg_path;
    if (invvar_path!=NULL) delete invvar_path;
    if (invpre_path!=NULL) delete invpre_path;
    invavg_path = new VectorMTL<double>(M);
    invvar_path = new VectorMTL<double>(M);
    invpre_path = new VectorMTL<double>(M);

    if (firmsnumberavg_path!=NULL) delete firmsnumberavg_path;
    if (firmsnumbervar_path!=NULL) delete firmsnumbervar_path;
    if (firmsnumberpre_path!=NULL) delete firmsnumberpre_path;
    firmsnumberavg_path = new MatrixMTL<double>(M,xmax);
    firmsnumbervar_path = new MatrixMTL<double>(M,xmax);
    firmsnumberpre_path = new MatrixMTL<double>(M,xmax);
  }
    
  VectorMTL<double> prodsursum_path(M);
  VectorMTL<double> prodsursqr_path(M);
  VectorMTL<double> conssursum_path(M);
  VectorMTL<double> conssursqr_path(M);
  VectorMTL<double> totalsursum_path(M);
  VectorMTL<double> totalsursqr_path(M);
  VectorMTL<double> invsum_path(M);
  VectorMTL<double> invsqr_path(M);
  
  VectorMTL<double> c1sum_path(M);
  VectorMTL<double> c1sqr_path(M);
  VectorMTL<double> c2sum_path(M);
  VectorMTL<double> c2sqr_path(M);
  VectorMTL<double> c4sum_path(M);
  VectorMTL<double> c4sqr_path(M);
  VectorMTL<double> c10sum_path(M);
  VectorMTL<double> c10sqr_path(M);
  VectorMTL<double> c20sum_path(M);
  VectorMTL<double> c20sqr_path(M);
  
  VectorMTL<double> hhi50sum_path(M);
  VectorMTL<double> hhi50sqr_path(M);

  MatrixMTL<double> firmsnumbersum_path(M,xmax);
  MatrixMTL<double> firmsnumbersqr_path(M,xmax);
  
  if(discounted==1) {
    prodsursum_path=0;
    prodsursqr_path=0;
    conssursum_path=0;
    conssursqr_path=0;
    totalsursum_path=0;
    totalsursqr_path=0;
    invsum_path=0;
    invsqr_path=0;
  
    c1sum_path=0;
    c1sqr_path=0;
    c2sum_path=0;
    c2sqr_path=0;
    c4sum_path=0;
    c4sqr_path=0;
    c10sum_path=0;
    c10sqr_path=0;
    c20sum_path=0;
    c20sqr_path=0;

    hhi50sum_path=0;
    hhi50sqr_path=0;

    firmsnumbersum_path=0;
    firmsnumbersqr_path=0;
  }

  /****************************************************************************/

  // Adjust the precisions
  double tol=bounds[1]/(1+bounds[1]);

  // Prepare tildes, prices and precompute profits
  VectorMTL<double> profit_w(xmax_ext);
  VectorMTL<double> tildes_w(xmax_ext);
  VectorMTL<double> prices_w(xmax_ext);

  VectorMTL<double> s0(xmax);
  s0=0;

  int w0=0;

  int kmax = 200;
  VectorMTL<double> p(shock_states);

  for(int w=0;w<shock_states;w++) {
    if(q[w]>0) { // Check if the state is not transient
      // Compute s0 and w0
      s0+=tildes.getRow(w)*q[w];
      // Precompute transition matrices
      rho_w = rho.getRow(w);
      iota_w = iota.getRow(w);
      if(control[2]==0) {
        continuationProb(rho_w, prcont, condexp);
      } else {
	      prcont=1;
      }
      tranProb(iota_w, tranMatrix_w, contTranMatrix[w], prcont);

      // Precompute probability for fixed entry
      if(control[1]==2) {
        if(ceil(lambdaVector[w])!=floor(lambdaVector[w])) {
          p[w]=(ceil(lambdaVector[w])-lambdaVector[w])/(ceil(lambdaVector[w])-floor(lambdaVector[w]));
        } else {
          p[w]=0;
        }
      }

      // Prepare extended vectors
      for(int i=0;i<xmax;i++) {
        tildes_ext[w][i]=tildes[w][i];
        prices_ext[w][i]=prices[w][i];
      }

      for(int i=xmax;i<xmax_ext;i++) {
        tildes_ext[w][i]=0;
        prices_ext[w][i]=prices[w][xmax-1];
      }
    }
  }
  
  RanGenLib P;

  // Prepare extended starting point
  if(control[2]==0) {
    for(int i=0;i<xmax;i++) {
      s0_ext[i]=round(s0[i]);
    }
  } else {
    s0=s0/sum(s0);
    s0_ext=0;
    // Draw from the invariant distribution
    for(int i=0;i<control[2];i++) {
      s0_ext[genDistr(P,s0)]++;
    }
  }

  if(s0_init[0]>-1) {
    s0_ext=s0_init;
    w0=w0_init;
  } else {
    w0 = genDistr(P,q);
  }


  for(int i=xmax;i<xmax_ext;i++) {
    s0_ext[i]=0;
    w0=w0_init;
  }


  // Remove firm
  MatrixMTL<int> removeFirm(dom_firm_number,shock_states);
  computeRemoveFirm(removeFirm, encoding_total, encoding_other, dom_firm_number, shock_states);

  // initial value for tolerance
  boundspre = bounds[1]+1;

  int n=1;

  int w = w0;
  state = s0_ext;
  state_new=state;

  cout << "Preparation over.. Start simulations" << endl;
  while(boundspre>tol) {
    if (n>bounds[3]) break;

    int w = w0;
    state = s0_ext;

    double prodsurrun=0;
    double conssurrun=0;
    double totalsurrun=0;
    double entraterun=0;
    double invrun=0;
    double c20run=0;
    double c10run=0;
    double c4run=0;
    double c2run=0;
    double c1run=0;
    double hhi50run=0;
    VectorMTL<double> firmsnumberrun(xmax_dom);
    MatrixMTL<double> fringerun(shock_states,xmax_dom);
    firmsnumberrun = 0;
    fringerun = 0;
    VectorMTL<double> domstate(shock_states);
    domstate=0;

    VectorMTL<double> prodsurrun_path(M);
    VectorMTL<double> conssurrun_path(M);
    VectorMTL<double> totalsurrun_path(M);
    VectorMTL<double> invrun_path(M);

    VectorMTL<double> c1run_path(M);
    VectorMTL<double> c2run_path(M);
    VectorMTL<double> c4run_path(M);
    VectorMTL<double> c10run_path(M);
    VectorMTL<double> c20run_path(M);

    VectorMTL<double> hhi50run_path(M);

    MatrixMTL<double> firmsnumberrun_path(M,xmax);
    if(discounted==1) {
      prodsurrun_path=0;
      conssurrun_path=0;
      totalsurrun_path=0;
      invrun_path=0;

      c1run_path=0;
      c2run_path=0;
      c4run_path=0;
      c10run_path=0;
      c20run_path=0;

      hhi50run_path=0;
    
      firmsnumberrun_path=0;
    }

    double beta=1.0;
    
    int smalln=0;
    while(smalln<L+M) {
      if((smalln>=L) && (sum(state_new)>0)) {
        iota_w = iota.getRow(w);	
        //cout << iota_w;

        VectorMTL<double> prices(xmax_ext);
        double prodsur,conssur;


        state_new=state;

	// Record the fringe
	for(int x=0;x<xmax;x++) {
	  fringerun[w][x]+=state_new[x];
	  firmsnumberrun[x]+=state_new[x];
	  invrun+=beta*state_new[x]*iota_w[x];
          if(discounted==1) { 
            firmsnumberrun_path[smalln][x]+=state_new[x];
            invrun_path[smalln]+=state_new[x]*iota_w[x];
          }
	}
	domstate[w]++;
        // Add dominant firms
	if(dom_firm_number>0) {
          for(int i=0;i<dom_firm_number;i++) {
            state_new[encoding_total[w][i]]++;
	    firmsnumberrun[encoding_total[w][i]]++;
	    invrun+=beta*iota_dom[removeFirm[i][w]][encoding_total[w][i]];
            if(discounted==1) {
              firmsnumberrun_path[smalln][encoding_total[w][i]]++;
              invrun_path[smalln]+=iota_dom[removeFirm[i][w]][encoding_total[w][i]];
            }
          }
	}

        

        compProfAndStats_extra(state_new,prices_w,prices,profsim,ms,prodsur,conssur);
        //cout << state_new << endl;
	//cout << ms << endl;
	//cout << conssur << endl;
        //cout << conssurrun/(smalln-L) << endl;
	//cout << conssur << endl;
        //cout << invrun << endl;
	
        prodsurrun+=beta*prodsur;
        conssurrun+=beta*conssur;
        totalsurrun+=beta*(conssur+prodsur);

        if(discounted==1) {
          prodsurrun_path[smalln]=prodsur;
          conssurrun_path[smalln]=conssur;
          totalsurrun_path[smalln]=prodsur+conssur;
        }

        // Calculate concetration ratios
	double totalms=0;
	
	totalms=sum(ms*state_new);
	if(totalms>0) {
	  ms/=totalms;

          double c1=0, c2=0, c4=0, c10=0, c20=0, c50=0;
          double firms = 0;
	  for(int i=xmax-1;i>=0;i--) {
	    // Need more firms?
	    if(firms<1) {
	      // Add ms of all firms at i but up to the needed number 
	      c1+=MIN(state_new[i],1-firms)*ms[i];
	    }
            if(firms<2) {
              // Add ms of all firms at i but up to the needed number 
              c2+=MIN(state_new[i],2-firms)*ms[i];
            }
            if(firms<4) {
              // Add ms of all firms at i but up to the needed number
              c4+=MIN(state_new[i],4-firms)*ms[i];
            }
            if(firms<10) {
              // Add ms of all firms at i but up to the needed number 
              c10+=MIN(state_new[i],10-firms)*ms[i];
            }
            if(firms<20) {
              // Add ms of all firms at i but up to the needed number 
              c20+=MIN(state_new[i],20-firms)*ms[i];
            }
            if(firms<50) {
              // Add ms of all firms at i but up to the needed number 
              c50+=MIN(state_new[i],50-firms)*ms[i];
            }
            firms+=state_new[i];
          }

          double hhi50=0;
          for(int x=0;x<xmax_dom;x++) {
            hhi50+=10000*ms[x]*ms[x]*state_new[x];
          }

          c20run+=c20;
          c10run+=c10;
          c4run+=c4;
	  c2run+=c2;
          c1run+=c1;
          hhi50run+=hhi50;

          if(discounted==1) {
            c20run_path[smalln]=c20;
            c10run_path[smalln]=c10;
            c4run_path[smalln]=c4;
            c2run_path[smalln]=c2;
            c1run_path[smalln]=c1;
            hhi50run_path[smalln]=hhi50;
   
            beta*=constants[2];
          }

//          cout << invrun/(smalln-L);
//          getchar();
	      } // totalms>0
      }

      double entrants;

      state_new.genMarkov(P,contTranMatrix[w],state);
      //cout << contTranMatrix[w];
      state=state_new;

      // Transition of the dominant firm
      if(dom_firm_number>0) {
        w = genDistr(P,full.getRow(w));
      }

      // Simulate entry
      if(control[2]>0) {
        entrants = 0;
      } else {
        if(control[1]==2) {
          if(P.genUniform()>p[w]) {
            entrants=int(ceil(lambdaVector[w]));
          } else {
            entrants=int(floor(lambdaVector[w]));
          }
        } else {
          entrants = P.genPoisson(lambdaVector[w]);
        }
      }

      // Add entry
      state[int(constants[3])-1]+=entrants;

      // Compute profits at simulated state
      prices_w=prices_ext.getRow(w);

      if(smalln>=L) entraterun+=entrants;

      smalln++;
    }


    if(discounted==0) {
      prodsurrun/=M;
      conssurrun/=M;
      totalsurrun/=M;
      invrun/=M;
    }
    if(control[2]==0) entraterun/=M;
    c20run/=M;
    c10run/=M;
    c4run/=M;
    c2run/=M;
    c1run/=M;
    hhi50run/=M;
    firmsnumberrun/=M;
 
//    cout << fringerun << "-----\n";
//    cout << domstate << "-----\n";
    for(int z=0;z<shock_states;z++) {
      if(domstate[z]>0) {
        for(int x=0;x<xmax;x++) {
//          fringerun[z][x]/=(M*q[z]);
          fringerun[z][x]/=domstate[z];
        } 
      } else {
	      for(int x=0;x<xmax;x++) {
	        fringerun[z][x]=0;
	      }
      }
    }

//    cout << fringerun;
//    getchar();
      
    prodsursum+=prodsurrun;
    prodsursqr+=(prodsurrun*prodsurrun);

    conssursum+=conssurrun;
    conssursqr+=(conssurrun*conssurrun);

    totalsursum+=totalsurrun;
    totalsursqr+=(totalsurrun*totalsurrun);

    if(control[2]==0) {
      entratesum+=entraterun;
      entratesqr+=(entraterun*entraterun);
    }

    invsum+=invrun;
    invsqr+=(invrun*invrun);

    c20sum+=c20run;
    c20sqr+=(c20run*c20run);
    c10sum+=c10run;
    c10sqr+=(c10run*c10run);
    c4sum+=c4run;
    c4sqr+=(c4run*c4run);
    c2sum+=c2run;
    c2sqr+=(c2run*c2run);
    c1sum+=c1run;
    c1sqr+=(c1run*c1run);

    hhi50sum+=hhi50run;
    hhi50sqr+=(hhi50run*hhi50run);

    firmsnumbersum+=firmsnumberrun;
    firmsnumbersqr+=(firmsnumberrun*firmsnumberrun);

    fringesum+=fringerun;

    //cout << smalln << " " << L << " " << M << endl;
    //cout << conssurrun << endl;
    //cout << conssursum/n << endl;
    //getchar();
//    cout << fringerun;
//    cout << "----";
//    cout << fringesum/(double) n;
//    getchar();

    if(discounted==1) {
      prodsursum_path+=prodsurrun_path;
      conssursum_path+=conssurrun_path;
      totalsursum_path+=totalsurrun_path;
      invsum_path+=invrun_path;

      prodsursqr_path+=prodsurrun_path*prodsurrun_path;
      conssursqr_path+=conssurrun_path*conssurrun_path;
      totalsursqr_path+=totalsurrun_path*totalsurrun_path;
      invsqr_path+=invrun_path*invrun_path;

      c20sum_path+=c20run_path;
      c10sum_path+=c10run_path;
      c4sum_path+=c4run_path;
      c2sum_path+=c2run_path;
      c1sum_path+=c1run_path;
      hhi50sum_path+=hhi50run_path;
      firmsnumbersum_path+=firmsnumberrun_path;

      c20sqr_path+=c20run_path*c20run_path;
      c10sqr_path+=c10run_path*c10run_path;
      c4sqr_path+=c4run_path*c4run_path;
      c2sqr_path+=c2run_path*c2run_path;
      c1sqr_path+=c1run_path*c1run_path;
      hhi50sqr_path=hhi50run_path*hhi50run_path;
      firmsnumbersqr_path+=firmsnumberrun_path*firmsnumberrun_path;
    }

    if(n>domparams[19]) {
      double temp;
      boundspre=0;
      compAvgPre(prodsursum,prodsursqr,n,prodsuravg,prodsurpre,prodsurvar);
      if((temp=prodsurpre)>boundspre) boundspre=temp;
      compAvgPre(conssursum,conssursqr,n,conssuravg,conssurpre,conssurvar);
      if((temp=conssurpre)>boundspre) boundspre=temp;
      compAvgPre(totalsursum,totalsursqr,n,totalsuravg,totalsurpre,totalsurvar);
      if((temp=totalsurpre)>boundspre) boundspre=temp;

      if(control[2]==0) {
	      compAvgPre(entratesum,entratesqr,n,entrateavg,entratepre,entratevar);
       	if((temp=entratepre)>boundspre) boundspre=temp;
      } else {
	      entrateavg=0;
	      entratepre=0;
	      entratevar=0;
      }

      compAvgPre(invsum,invsqr,n,invavg,invpre,invvar);
      if((temp=invpre)>boundspre) boundspre=temp;

      compAvgPre(c1sum,c1sqr,n,c1avg,c1pre,c1var);
      if((temp=c1pre)>boundspre) boundspre=temp;
      compAvgPre(c2sum,c2sqr,n,c2avg,c2pre,c2var);
      if((temp=c2pre)>boundspre) boundspre=temp;
      compAvgPre(c4sum,c4sqr,n,c4avg,c4pre,c4var);
      if((temp=c4pre)>boundspre) boundspre=temp;
      compAvgPre(c10sum,c10sqr,n,c10avg,c10pre,c10var);
      if((temp=c10pre)>boundspre) boundspre=temp;
      compAvgPre(c20sum,c20sqr,n,c20avg,c20pre,c20var);
      if((temp=c20pre)>boundspre) boundspre=temp;

      compAvgPre(hhi50sum,hhi50sqr,n,hhi50avg,hhi50pre,hhi50var);
      if((temp=hhi50pre)>boundspre) boundspre=temp;
      
      compAvgPre(firmsnumbersum,firmsnumbersqr,n,*firmsnumberavg,*firmsnumberpre,*firmsnumbervar);
      if((temp=max(*firmsnumberpre))>boundspre) boundspre=temp;
      
      (*fringeavg)=fringesum/(double) n;

      if(discounted==1) {
        compAvgPre(prodsursum_path,prodsursqr_path,n,*prodsuravg_path,*prodsurpre_path,*prodsurvar_path);
        compAvgPre(conssursum_path,conssursqr_path,n,*conssuravg_path,*conssurpre_path,*conssurvar_path);
        compAvgPre(totalsursum_path,totalsursqr_path,n,*totalsuravg_path,*totalsurpre_path,*totalsurvar_path);
        compAvgPre(invsum_path,invsqr_path,n,*invavg_path,*invpre_path,*invvar_path);

        compAvgPre(c1sum_path,c1sqr_path,n,*c1avg_path,*c1pre_path,*c1var_path);
        compAvgPre(c2sum_path,c2sqr_path,n,*c2avg_path,*c2pre_path,*c2var_path);
        compAvgPre(c4sum_path,c4sqr_path,n,*c4avg_path,*c4pre_path,*c4var_path);
        compAvgPre(c10sum_path,c10sqr_path,n,*c10avg_path,*c10pre_path,*c10var_path);
        compAvgPre(c20sum_path,c20sqr_path,n,*c20avg_path,*c20pre_path,*c20var_path);

        compAvgPre(hhi50sum_path,hhi50sqr_path,n,*hhi50avg_path,*hhi50pre_path,*hhi50var_path);

        compAvgPre(firmsnumbersum_path,firmsnumbersqr_path,n,*firmsnumberavg_path,*firmsnumberpre_path,*firmsnumbervar_path);
      }
      cout << "Tol: " << boundspre << endl;
    }
    //cout << "Round: " << n << endl;
    n++;
  }
}

void CompOE_dom::computeBounds_dom(double *bounds_init, MatrixMTL<double> &iota, MatrixMTL<double> &iota_dom,
  MatrixMTL<double> &rho, MatrixMTL<double> &tildes,
  VectorMTL<double> &lambdaVector, MatrixMTL<double> &prices,
  VectorMTL<double> &q, SparseMatrixMTL<double> &shockTran) {

  ignore=2;
  xmax = iota.getLength();
  shock_states = iota.getHeight();
  bounds = bounds_init;

  int kmax=200,kmax_temp;

  double boundspre;

  int xmax_ext = xmax * int(bounds[7]);

  /*** Extended vectors ***/
  MatrixMTL<double> tildes_ext(shock_states,xmax_ext);
  MatrixMTL<double> proftildes_ext(shock_states,xmax_ext);
  MatrixMTL<double> prices_ext(shock_states,xmax_ext);
  VectorMTL<double> s0_ext(xmax_ext);
  VectorMTL<double> state(xmax_ext);
  VectorMTL<double> state_new(xmax_ext);
  VectorMTL<double> state_sim(xmax_ext);
  VectorMTL<double> state_dom(xmax_ext);
  VectorMTL<double> profsim(xmax_ext);
  VectorMTL<double> profsim_xmax(xmax);

  /*** Bounds ***/
  VectorMTL<double> bound1sum(xmax), bound1sum_sim(xmax), bound1sqr(xmax);
  VectorMTL<double> bound2sum(xmax), bound2sum_sim(xmax), bound2sqr(xmax);
  VectorMTL<double> bound3sum(xmax), bound3sum_sim(xmax), bound3sqr(xmax);

  MatrixMTL<double> *g=NULL;

  bound1sum = 0;
  bound1sqr = 0;

  bound2sum = 0;
  bound2sqr = 0;

  bound3sum = 0;
  bound3sqr = 0;

  int computebound2 = 1;

  if (bound1avg_dom!=NULL) delete bound1avg_dom;
  if (bound1var_dom!=NULL) delete bound1var_dom;
  if (bound1pre_dom!=NULL) delete bound1pre_dom;
  if (bound1por_dom!=NULL) delete bound1por_dom;
  bound1avg_dom = new VectorMTL<double>(xmax);
  bound1var_dom = new VectorMTL<double>(xmax);
  bound1pre_dom = new VectorMTL<double>(xmax);
  bound1por_dom = new VectorMTL<double>(xmax);

  if (bound2avg_dom!=NULL) delete bound2avg_dom;
  if (bound2var_dom!=NULL) delete bound2var_dom;
  if (bound2pre_dom!=NULL) delete bound2pre_dom;
  if (bound2por_dom!=NULL) delete bound2por_dom;

  bound2avg_dom = new VectorMTL<double>(xmax);
  bound2var_dom = new VectorMTL<double>(xmax);
  bound2pre_dom = new VectorMTL<double>(xmax);
  bound2por_dom = new VectorMTL<double>(xmax);

  if (bound3avg_dom!=NULL) delete bound3avg_dom;
  if (bound3var_dom!=NULL) delete bound3var_dom;
  if (bound3pre_dom!=NULL) delete bound3pre_dom;
  if (bound3por_dom!=NULL) delete bound3por_dom;

  bound3avg_dom = new VectorMTL<double>(xmax);
  bound3var_dom = new VectorMTL<double>(xmax);
  bound3pre_dom = new VectorMTL<double>(xmax);
  bound3por_dom = new VectorMTL<double>(xmax);

  // Precompute binomial pdfs
  g = new MatrixMTL<double>(kmax+1,kmax+1);
  for (int i=0; i<=kmax;i++) {
    for (int m=0;m<=kmax;m++) {
      (*g)[i][m]= binopdf(m,i,1-transition[1]);
    }
  }


  /****************************************************************************/
  shock_states = iota.getHeight();
  bounds = bounds_init;

  xmax_dom = xmax; // Allow for different number of states of dominant firms
  dom_firm_number = int(domparams[10]);
  other_number = dom_firm_number-1;

  other_dom_firms = (dom_firm_number <= 1) ? 1 :
    newton(xmax_dom+other_number-1,other_number)/factorial(other_number);; // Number of states of competitors of dom firm (symetric)
  shock_states = (dom_firm_number == 0) ? 1 :
    newton(xmax_dom+dom_firm_number-1,dom_firm_number)/factorial(dom_firm_number); // Number of states of dominant firms (symetric)

  aggr_shocks = shockTran.getNRows();
  if(reverseEncShocks!=NULL) delete reverseEncShocks;
  reverseEncShocks = new MatrixMTL<int>(aggr_shocks,aggr_shocks);
  reverseEncodingShocks(shockTran);

  #if TRANSITION_MATRIX == 0
    MatrixMTL<double> tranMatrix_w(xmax,xmax);
    MatrixMTL<double> contTranMatrix_w(xmax,xmax);
    MatrixMTL3D<double> contTranMatrix(xmax,xmax,shock_states);
    MatrixMTL<double> contTranMatrix_infty(xmax,xmax);
  #elif TRANSITION_MATRIX == 1
    TriDiagMatrixMTL<double> tranMatrix_w(xmax);
    TriDiagMatrixMTL<double> contTranMatrix_w(xmax);
    TriDiagMatrix3D<double> contTranMatrix(xmax,shock_states);
    TriDiagMatrixMTL<double> contTranMatrix_infty(xmax);
  #elif TRANSITION_MATRIX == 2
    SparseMatrixMTL<double> tranMatrix_w;
    SparseMatrixMTL<double> contTranMatrix_w;
    SparseMatrix3D<double> contTranMatrix(shock_states);
  #else
    #error Invalid value for TRANSITION_MATRIX
  #endif

  SparseMatrixMTL<double> full;
  if(dom_firm_number>0) {
    // Econding for state space
    int index_enc[dom_firm_number];
    encoding_total = (int **) malloc(shock_states*sizeof(int *));
    c=0; combinations_with_repetition(encoding_total, index_enc, 0, xmax_dom, dom_firm_number);
    if(other_number>0) {
      encoding_other = (int **) malloc(other_dom_firms*sizeof(int *));
      c=0; combinations_with_repetition(encoding_other, index_enc, 0, xmax_dom, other_number);
    } else {
      encoding_other = (int **) malloc(other_dom_firms*sizeof(int *));
      encoding_other[0] = (int *) malloc(other_dom_firms*sizeof(int));
      encoding_other[0][0]=0;
    }
    MatrixMTL<int> addFirm(xmax_dom,other_dom_firms);
    if(other_number>0) {
      endcodeAddFirm(addFirm);
    } else {
      for(int i=0;i<xmax_dom;i++) {
        addFirm[i][0]=i;
      }
    }

    // Remove firm
    MatrixMTL<int> removeFirm(dom_firm_number,shock_states);
    computeRemoveFirm(removeFirm, encoding_total, encoding_other, dom_firm_number, shock_states);

    //// Generate sparcity patterns for transition matrices
    // First get the reverse encoding for per-firm transition
    SparseMatrixMTL<double> tranTemp;
    SparseMatrixMTL<double> contTranTemp;
    VectorMTL<double> prcontTemp(xmax_dom);
    prcontTemp = 1;
    VectorMTL<double> iotaTemp(xmax_dom);
    iotaTemp = iota_dom.getRow(0);
    tranProb(iotaTemp, tranTemp, contTranTemp, prcontTemp);
    reverseEnc = new MatrixMTL<int>(xmax_dom,xmax_dom);
    reverseEncoding(tranTemp);

    compProbFullPattern(encoding_total, dom_firm_number, shock_states, full, shockTran);

    SparseMatrix3D<double> tranDom(other_dom_firms);
    tranProbDom(iota_dom,tranDom);
    compProbFull(encoding_total, dom_firm_number, shock_states, full, tranDom, removeFirm, shockTran);
  } else {
    q[0]=1;
  } // End of dom firm 'if'

  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);
  VectorMTL<double> rho_w(xmax);
  VectorMTL<double> iota_w(xmax);

  // Adjust the precisions
  double tol=bounds[1]/(1+bounds[1]);

  // Prepare tildes, prices and precompute profits
  VectorMTL<double> profit_w(xmax_ext);
  VectorMTL<double> tildes_w(xmax_ext);
  VectorMTL<double> prices_w(xmax_ext);

  VectorMTL<double> s0(xmax);
  s0=0;

  int w0=0;

  VectorMTL<double> p(shock_states);

  // Precompute infinite investment matrix
  iota_w = 1e20;
  prcont = 1.0;
  tranProb(iota_w, tranMatrix_w, contTranMatrix_infty, prcont);

  for(int w=0;w<shock_states;w++) {
    if(q[w]>0) { // Check if the state is not transient
      // Compute s0 and w0
      s0+=tildes.getRow(w)*q[w];
      // Precompute transition matrices
      rho_w = rho.getRow(w);
      iota_w = iota.getRow(w);
      if(control[2]==0) {
        continuationProb(rho_w, prcont, condexp);
      } else {
	    prcont=1;
      }
      tranProb(iota_w, tranMatrix_w, contTranMatrix[w], prcont);

      // Precompute probability for fixed entry
      if(control[1]==2) {
        if(ceil(lambdaVector[w])!=floor(lambdaVector[w])) {
          p[w]=(ceil(lambdaVector[w])-lambdaVector[w])/(ceil(lambdaVector[w])-floor(lambdaVector[w]));
        } else {
          p[w]=0;
        }
      }

      // Prepare extended vectors
      for(int i=0;i<xmax;i++) {
        tildes_ext[w][i]=tildes[w][i];
        prices_ext[w][i]=prices[w][i];
      }

      for(int i=xmax;i<xmax_ext;i++) {
        tildes_ext[w][i]=0;
        prices_ext[w][i]=prices[w][xmax-1];
      }
      // precompute profits
      tildes_w=tildes_ext.getRow(w);
      prices_w=prices_ext.getRow(w);
      // Add dominant firms
      if(dom_firm_number>0) {
        for(int i=0;i<dom_firm_number;i++) {
          tildes_w[encoding_total[w][i]]++;
        }
      }
      compProf(tildes_w, prices_w, profit_w);
      proftildes_ext.setRow(w,profit_w);
    }
  }

  RanGenLib P;

  // Prepare extended starting point
  if(control[2]==0) {
    for(int i=0;i<xmax;i++) {
      s0_ext[i]=round(s0[i]);
    }
  } else {
    s0=s0/sum(s0);
    s0_ext=0;
    // Draw from the invariant distribution
    for(int i=0;i<control[2];i++) {
      s0_ext[genDistr(P,s0)]++;
    }
  }


  for(int i=xmax;i<xmax_ext;i++) {
    s0_ext[i]=0;
  }


  boundspre = bounds[1]+1;

  int L = int(domparams[13]);
  int M = int(domparams[14]);

  int n=1;

  w0 = genDistr(P,q);
  int w = w0;
  state = s0_ext;

  MatrixMTL<double> disc_Freq(xmax,xmax);

  VectorMTL<int> bound3_x(xmax);
  VectorMTL<double> term2(xmax);

  cout << "Preparation over.. Start simulations" << endl;

/*  cout << prices_w;
  state = 0;
  state[0]= 15;
  setShock(0);
  compProf(state, prices_w, profsim);
  restore();
  cout << profsim;
  getchar();*/


  while(boundspre>tol) {
//  while(1) {
    // Get new w0
//    w0 = genDistr(P,q);

//    if (n>bounds[3]) break;

    double entrants;

    // Simulate L times
    int w = w0;
    state = s0_ext;
    for(int i=0;i<L;i++) {
      state_new.genMarkov(P,contTranMatrix[w],state);
      
      // Transition of the dominant firm
      if(dom_firm_number>0) {
        w = genDistr(P,full.getRow(w));
      }

      int entrants;
      // Simulate entry
      if(control[2]>0) {
        entrants = 0;
      } else {
        if(control[1]==2) {
          if(P.genUniform()>p[w]) {
             entrants=int(ceil(lambdaVector[w]));
          } else {
             entrants=int(floor(lambdaVector[w]));
          }
        } else {
          entrants = P.genPoisson(lambdaVector[w]);
        }
      }

      // Add entry
      state_new[int(constants[3])-1]+=entrants;
      state=state_new;
    } // End of L loop

    // Reset the bounds within M simulation
    bound1sum_sim = 0;
    bound2sum_sim = 0;
    bound3sum_sim = 0;

    // Simulate M times more
    for(int s=0;s<M;s++) {
      // Additional simulations
      for(int a=0;a<int(domparams[12]);a++) {
        state_new.genMarkov(P,contTranMatrix[w],state);

        // Transition of the dominant firm
        if(dom_firm_number>0) {
          w = genDistr(P,full.getRow(w));
        }

        int entrants;
        // Simulate entry
        if(control[2]>0) {
          entrants = 0;
        } else {
          if(control[1]==2) {
            if(P.genUniform()>p[w]) {
               entrants=int(ceil(lambdaVector[w]));
            } else {
               entrants=int(floor(lambdaVector[w]));  
               entrants=int(floor(lambdaVector[w]));
            }
          } else {
            entrants = P.genPoisson(lambdaVector[w]);
          }
        }

        // Add entry
        state_new[int(constants[3])-1]+=entrants;
        state=state_new;

      } // End of additional simulations between each of m

      //// Now there are kmax forward simulations
      //// I will modify state_sim and w_sim inside those
      // Initialize
      state_sim=state;
      int w_sim=w;

      ///// Initialize term2 for t=0 /////

      state_new=state_sim;
      // Compute profits at simulated state
      prices_w=prices_ext.getRow(w_sim);
      // Add dominant firms
      if(dom_firm_number>0) {
        for(int i=0;i<dom_firm_number;i++) {
          state_new[encoding_total[w][i]]++;
        }
      }
      if(sum(state_new)>0) {
        compProf(state_new, prices_w, profsim);
      } else {
	profsim=0;
      }
//      cout << state_new;
//      cout << profsim;
//      cout << proftildes_ext;

      profsim-=proftildes_ext.getRow(w);
      profsim_xmax=profsim.subVector(0,xmax-1);

      term2=-profsim_xmax;
      disc_Freq.eye();

      double beta = constants[2];

      // Initialize x for bound3
      for(int x=0;x<xmax;x++) {
        bound3_x[x]=x;
        bound1sum_sim[x]+= MACRO__POSITIVE(profsim[x]);
        bound2sum_sim[x]+= MACRO__POSITIVE(profsim[x]);
        bound3sum_sim[x]+= MACRO__POSITIVE(profsim[x]);
      }

      //// End of init, start the loop /////

      // Simulate kmax states forward

//      cout << bound2sum_sim;
//      cout << "simulate " << kmax << " states forward" << endl;
//      getchar();
      for(int t=1;t<kmax;t++) {
        // Simulate current x for bound3 using previous shock
        for(int x=0;x<xmax;x++) {
            bound3_x[x]=genDistr(P,contTranMatrix_infty.getRow(bound3_x[x]));
        }

        // Draw new state
        state_new.genMarkov(P,contTranMatrix[w_sim],state_sim);

        // Transition of the dominant firm
        if(dom_firm_number>0) {
          w_sim = genDistr(P,full.getRow(w_sim));
        }

        int entrants;
        // Simulate entry
        if(control[2]>0) {
          entrants = 0;
        } else {
          if(control[1]==2) {
            if(P.genUniform()>p[w_sim]) {
               entrants=int(ceil(lambdaVector[w_sim]));
            } else {
               entrants=int(floor(lambdaVector[w_sim]));
            }
          } else {
            entrants = P.genPoisson(lambdaVector[w_sim]);
          }
        }

        // Add entry
        state_new[int(constants[3])-1]+=entrants;
        state_sim=state_new;

        // Compute profits at simulated state
        prices_w=prices_ext.getRow(w_sim);
        // Add dominant firms
        if(dom_firm_number>0) {
          for(int i=0;i<dom_firm_number;i++) {
            state_new[encoding_total[w][i]]++;
          }
        }

	if(sum(state_new)>0) {
          if(compProf(state_new, prices_w, profsim)==0) {
            #ifdef COUT_DEBUG
              cout << "Profit computation failed:" << endl;
              cout << "Shock:" << endl << w_sim << endl;
              cout << "State:" << endl << state_sim << endl;
              cout << "Starting prices:" << endl << prices_ext.getRow(w_sim) << endl;
              cout << "Final prices:" << endl << prices_w << endl;
              cout << "Profit:" << endl << profsim << endl << endl;
            #endif
            #ifdef DEBUG
              *myfile << "Profit computation failed:" << endl;
              *myfile <<  "Shock:" << endl << w_sim << endl;
              *myfile << "State:" << endl << state_new << endl;
              *myfile << "Starting prices:" << endl << prices_ext.getRow(w_sim) << endl;
              *myfile << "Final prices:" << endl << prices_w << endl;
              *myfile << "Profit:" << endl << profsim << endl << endl;
            #endif
	  }
        } else {
          profsim=0;
	}
        // Create difprofit for this industry path
        profsim-=proftildes_ext.getRow(w_sim);

        // Compute the distribution of x and take the expectation with respect to x
        disc_Freq=disc_Freq.dot(contTranMatrix[w_sim]);
        profsim_xmax = profsim.subVector(0,xmax-1);
        term2-=beta*disc_Freq.dot(profsim_xmax);

        for(int x=0;x<xmax;x++) {

          // Compute bound1
          int lowx = MAX(x-int(bounds[8])*t,0);
          int highx = MIN(x+int(bounds[8])*t,xmax_ext-1);

          bound1sum_sim[x]+=beta*MACRO__POSITIVE(max(profsim.subVector(lowx,highx)));

          if(computebound2==1) {
            for(int i=0;i<xmax_ext-2;i++) {
              if(MAX(profsim[i],0)-MAX(profsim[i+1],0)>bounds[9]*proftildes_ext[w_sim][i+1]) {
                #ifdef COUT_DEBUG
//                cout << "Delta_y not increasing (" << proftildes_ext[w_sim][i+1] << "," << MAX(profsim[i],0)-MAX(profsim[i+1],0) <<
//                  ") for t=" << t << " and y=" << i << endl;
//		cout << profsim;
//		getchar();
                #endif
                #ifdef DEBUG
//                *myfile << "Delta_y not increasing (" << MAX(profsim[i],0)-MAX(profsim[i+1],0) <<
//                  ") for t=" << t << " and y=" << i << endl;
                #endif
//                computebound2 = 0;
              }
            }
          }

          if(computebound2==1) {
            // Compute bound2
            if(int(bounds[8])==1) {
              for(int y=x;y<=x+t;y++) {
                bound2sum_sim[x]+=beta*(*g)[t][y-x]*MAX(profsim[MIN(y,xmax_ext-1)],0);
              }
            } else {
              bound2sum_sim[x]=0;
            }

            // Compute bound3
            bound3sum_sim[x]+=beta*MAX(profsim[bound3_x[x]],0);
          }
        }

        // Prepare for next iteration
        beta*=constants[2];
      } // End of t-simulation loop

      bound1sum_sim+=term2;
      if(computebound2==1) {
        if(int(bounds[8])==1) {
          bound2sum_sim+=term2;
        }
        bound3sum_sim+=term2;
      }
    } // End of M loop

    VectorMTL<double> average(xmax);
    double Md=double(M);
    average = bound1sum_sim/Md;
    bound1sum+=average;
    bound1sqr+=average*average;

    average = bound2sum_sim/Md;
    bound2sum+=average;
    bound2sqr+=average*average;

    average = bound3sum_sim/Md;
    bound3sum+=average;
    bound3sqr+=average*average;
    if(n>domparams[20]) {
      compAvgPre(bound1sum,bound1sqr,n,*bound1avg_dom,*bound1pre_dom,*bound1var_dom);
      if(computebound2==1) {
        if(int(bounds[8])==1) {
          compAvgPre(bound2sum,bound2sqr,n,*bound2avg_dom,*bound2pre_dom,*bound2var_dom);
        } else {
          *bound2avg_dom=0;
          *bound2pre_dom=0;
          *bound2var_dom=0;
        }
        compAvgPre(bound3sum,bound3sqr,n,*bound3avg_dom,*bound3pre_dom,*bound3var_dom);
      } else {
        *bound2avg_dom = 0;
        *bound2pre_dom = 0;
        *bound2var_dom = 0;
        *bound3avg_dom = 0;
        *bound3pre_dom = 0;
        *bound3var_dom = 0;
      }
      if(n>=bounds[4]) {
        boundspre=max(*bound1pre_dom);
        double temp;
        if((temp=max(*bound2pre_dom))>boundspre) boundspre=temp;
        if((temp=max(*bound3pre_dom))>boundspre) boundspre=temp;
      }
      cout << *bound2avg_dom << endl;
      cout << *bound2var_dom << endl;
      cout << bound2sum << endl;
      cout << bound2sqr << endl;
//    cout << *bound3avg_dom;
      
    }
    cout << "End of simulation: " << n << ", tol: " << boundspre << endl;
    n++;
  } // End of simulation loop
  if(g!=NULL) delete g;
}

CompOE_dom::~CompOE_dom() {
  if(iotaMatrix0_global!=NULL) delete iotaMatrix0_global;
  if(rhoMatrix0_global!=NULL) delete rhoMatrix0_global;
  if(V_global!=NULL) delete V_global;
  if(V_expected_global!=NULL) delete V_expected_global;
  if(tildesMatrix_global!=NULL) delete tildesMatrix_global;
  if(profitMatrix_global!=NULL) delete profitMatrix_global;
  if(pricesMatrix_global!=NULL) delete pricesMatrix_global;
  if(lambdaVector0_global!=NULL) delete lambdaVector0_global;
  if(prcontMatrix_global!=NULL) delete prcontMatrix_global;

  if(VDom_global!=NULL) delete VDom_global;
  if(profitMatrixDom_global!=NULL) delete profitMatrixDom_global;
  if(pricesMatrixDom_global!=NULL) delete pricesMatrixDom_global;

  if (bound1avg_dom!=NULL) delete bound1avg_dom;
  if (bound1var_dom!=NULL) delete bound1var_dom;
  if (bound1pre_dom!=NULL) delete bound1pre_dom;
  if (bound1por_dom!=NULL) delete bound1por_dom;

  if (bound2avg_dom!=NULL) delete bound2avg_dom;
  if (bound2var_dom!=NULL) delete bound2var_dom;
  if (bound2pre_dom!=NULL) delete bound2pre_dom;
  if (bound2por_dom!=NULL) delete bound2por_dom;

  if (bound3avg_dom!=NULL) delete bound3avg_dom;
  if (bound3var_dom!=NULL) delete bound3var_dom;
  if (bound3pre_dom!=NULL) delete bound3pre_dom;
  if (bound3por_dom!=NULL) delete bound3por_dom;
  
  if (fringeavg!=NULL) delete fringeavg;
  if (fringevar!=NULL) delete fringevar;
  if (fringepre!=NULL) delete fringepre;
  if (fringepor!=NULL) delete fringepor;

  if(reverseEnc!=NULL) delete reverseEnc;
  if(reverseEncShocks!=NULL) delete reverseEncShocks;

  if (q!=NULL) delete q;

  if(tranDom_global!=NULL) delete tranDom_global;

  #ifdef ACW
//  if (action_profit!=NULL) delete action_profit;
//  if (acwTran!=NULL) delete acwTran;
  if (tranmat3D!=NULL) delete tranmat3D;
  if (action_profitMatrix_global!=NULL) delete action_profitMatrix_global;
  if (action_profitMatrixFringe_global!=NULL) delete action_profitMatrixFringe_global;

  #endif

  if (EVDom!=NULL) delete EVDom;
}
