/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MTLCompOE_dom_H
#define MTLCompOE_dom_H

#include <compoe.h>
#include <tridiagmatrix3d.h>
#include <sparsematrixMTL.h>
#include <sparsematrixMTL3d.h>
#include <matrix3d.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/time.h>
#include <algorithm>

/**
	@author Jeziorski, Weintraub, Benkard and Van Roy <przemekj@stanford.edu>
*/

class CompOE_dom : public CompOE {
private:
  VectorMTL<double> *q;
  double *domparams;
  double *shocklevels;
  int shock_states;
  int c;

  int **encoding_total;
  int **encoding_other;
  MatrixMTL<int> *reverseEnc;
  MatrixMTL<int> *reverseEncShocks;
  MatrixMTL<int> *compTransition;

  MatrixMTL<double> *iotaMatrix0_global;
  MatrixMTL<double> *rhoMatrix0_global;
  MatrixMTL<double> *V_global;
  MatrixMTL<double> *V_expected_global;
  MatrixMTL<double> *tildesMatrix_global;
  MatrixMTL<double> *profitMatrix_global;
  MatrixMTL<double> *pricesMatrix_global;
  VectorMTL<double> *lambdaVector0_global;
  MatrixMTL<double> *prcontMatrix_global;

  MatrixMTL<double> *VDom_global;
  MatrixMTL<double> *profitMatrixDom_global;
  MatrixMTL<double> *pricesMatrixDom_global;
  MatrixMTL<double> *iotaMatrixDom0_global;
 
  MatrixMTL<double> *EVDom;
 
  VectorMTL<double> *rhoMatrixDom_global;
  double lambdaDom;

  VectorMTL<double> *bound1avg_dom, *bound1pre_dom, *bound1var_dom, *bound1por_dom;
  VectorMTL<double> *bound2avg_dom, *bound2pre_dom, *bound2var_dom, *bound2por_dom;
  VectorMTL<double> *bound3avg_dom, *bound3pre_dom, *bound3var_dom, *bound3por_dom;
  MatrixMTL<double> *fringeavg, *fringepre, *fringevar, *fringepor;

  VectorMTL<double> *backup;

  int xmax_dom;
  int other_dom_firms;
  int other_number;
  int dom_firm_number;
  int dom_nonzeros;

  int aggr_shocks;

  SparseMatrix3D<double> *tranDom_global;

  #ifdef ACW
  MatrixMTL3D<double> *tranmat3D;
  MatrixMTL3D<double> *action_profitMatrix_global;
  MatrixMTL3D<double> *action_profitMatrixFringe_global;
  MatrixMTL3D<double> *RHS;
  #endif
public:
  CompOE_dom();

  inline void initialize(double *control_init, double *prof_fun_init, double *prof_fun_ipopt_init,
    double *transition_init, double *constants_init, double *init_init, 
    double *convtol_init, double *domparams_init, double *shocklevels_init) {

    control = control_init;
    prof_fun = prof_fun_init;
    prof_fun_ipopt = prof_fun_ipopt_init;
    transition = transition_init;
    constants = constants_init;
    init = init_init;
    convtol = convtol_init;
    domparams = domparams_init;
    shocklevels = shocklevels_init;
  }

  inline MatrixMTL<double> *getStatsFringe() {
    return fringeavg;
  }

  inline void getStats(MatrixMTL<double> &stats) {
    stats[0][0]=conssuravg; stats[0][1]=conssurpre; stats[0][2]=conssurvar;
    stats[1][0]=prodsuravg; stats[1][1]=prodsurpre; stats[1][2]=prodsurvar;
    stats[2][0]=totalsuravg; stats[2][1]=totalsurpre; stats[2][2]=totalsurvar;
    
    stats[3][0]=c1avg; stats[3][1]=c1pre; stats[3][2]=c1var;
    stats[4][0]=c2avg; stats[4][1]=c2pre; stats[4][2]=c2var;
    stats[5][0]=c4avg; stats[5][1]=c4pre; stats[5][2]=c4var;
    stats[6][0]=c10avg; stats[6][1]=c10pre; stats[6][2]=c10var;
    stats[7][0]=c20avg; stats[7][1]=c20pre; stats[7][2]=c20var;

    stats[8][0]=hhi50avg; stats[8][1]=hhi50pre; stats[8][2]=hhi50var;

    stats[9][0]=entrateavg; stats[9][1]=entratepre; stats[9][2]=entratevar;
    stats[10][0]=invavg; stats[10][1]=invpre; stats[10][2]=invvar;
  }

  inline SparseMatrix3D<double> *getTranDom() {
    return tranDom_global;
  }
 
#ifdef ACW
  inline MatrixMTL3D<double> *getTranFringe() {
    return tranmat3D;
  }
#endif

  inline MatrixMTL<double> *getIotaDom() {
    return iotaMatrix0_global;
  }

  inline MatrixMTL<double> *getRhoDom() {
    return rhoMatrix0_global;
  }

  inline MatrixMTL<double> *getVDom() {
    return V_global;
  }

  inline MatrixMTL<double> *getVExpectedDom() {
    return V_expected_global;
  }

  inline MatrixMTL<double> *getTildesDom() {
    return tildesMatrix_global;
  }

  inline MatrixMTL<double> *getProfitDom() {
    return profitMatrix_global;
  }

  inline MatrixMTL<double> *getPricesInitDom() {
    return pricesMatrix_global;
  }

  inline MatrixMTL<double> *getPrcontMatrix() {
    return prcontMatrix_global;
  }

  inline VectorMTL<double> *getLambdaDom() {
    return lambdaVector0_global;
  }

  inline MatrixMTL<double> *getV_domDom() {
    return VDom_global;
  }

  inline MatrixMTL<double> *getIota_domDom() {
    return iotaMatrixDom0_global;
  }

  inline VectorMTL<double> *getQ_domDom() {
    return q;
  }

  inline int **getTotalEncodingDom() {
    return encoding_total;
  }
  inline int **getOtherEncodingDom() {
    return encoding_other;
  }

  inline void getBound1_dom(VectorMTL<double> &bound1avgOut, VectorMTL<double> &bound1preOut,
    VectorMTL<double> &bound1varOut) {

    bound1avgOut = *bound1avg_dom;
    bound1varOut = *bound1var_dom;
    bound1preOut = *bound1pre_dom;
  }

  inline void getBound2_dom(VectorMTL<double> &bound2avgOut, VectorMTL<double> &bound2preOut,
    VectorMTL<double> &bound2varOut) {

    bound2avgOut = *bound2avg_dom;
    bound2varOut = *bound2var_dom;
    bound2preOut = *bound2pre_dom;
  }

  inline void getBound3_dom(VectorMTL<double> &bound3avgOut, VectorMTL<double> &bound3preOut,
    VectorMTL<double> &bound3varOut) {

    bound3avgOut = *bound3avg_dom;
    bound3varOut = *bound3var_dom;
    bound3preOut = *bound3pre_dom;
  }
  
  int compute_dom(int &xmaxInit, VectorMTL<double> &iotaInit, VectorMTL<double> &rhoInit, VectorMTL<double> &lambdaInit,
    VectorMTL<double> &mean_fringe_state, SparseMatrixMTL<double> &shockTran);
  void valueIt(MatrixMTL<double> &profit, MatrixMTL<double> &iota, 
    MatrixMTL<double> &rho, MatrixMTL<double> &V, MatrixMTL<double> &V_expected, VectorMTL<double> &d,
    SparseMatrixMTL<double> &stateTran);
  int compute_Dom(int &xmaxInit, VectorMTL<double> &iotaInit, VectorMTL<double> &rhoInit, double lambdaInit,
    SparseMatrixMTL<double> &shockTran); 
  void computeTildes(MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &rhoMatrix, VectorMTL<double> &lambdaVector,
    SparseMatrixMTL<double> &stateTran, MatrixMTL<double> &tildesMatrix);
  void computeBounds_dom(double *bounds_init, MatrixMTL<double> &iota, MatrixMTL<double> &iota_dom,
      MatrixMTL<double> &rho, MatrixMTL<double> &tildes,
      VectorMTL<double> &lambdaVector, MatrixMTL<double> &prices,
      VectorMTL<double> &q, SparseMatrixMTL<double> &shockTran);
  void tranProbDomOther(MatrixMTL<double> &iotaDom,SparseMatrixMTL<double> &tranmat_other, int);

  void valueItDom(MatrixMTL<double> &profitMatrix, MatrixMTL<double> &iotaDom,
    MatrixMTL<double> &V, VectorMTL<double> &d, SparseMatrix3D<double> &tranDom, SparseMatrixMTL<double> &shockTran);

  void addDominant(VectorMTL<double> &tildes_w,int w);

  void computeStats_dom(double *bounds_init, MatrixMTL<double> &iota, MatrixMTL<double> &iota_dom,
    MatrixMTL<double> &rho, MatrixMTL<double> &tildes,
    VectorMTL<double> &lambdaVector, MatrixMTL<double> &prices,
    VectorMTL<double> &q, SparseMatrixMTL<double> &shockTran,
    VectorMTL<double> &s0_init, int w0_init);

  int factorial(int number);
  void combinations_with_repetition(int **encoding, int *array, int slotIndex, int n, int k);
  int newton(int n, int k);

  void compProbFullPattern(int **encoding, int dom_firm_number, int shock_states, SparseMatrixMTL<double> &tranFull, 
        SparseMatrixMTL<double> &shockTran);
  void compProbFull(int **encoding, int dom_firm_number, int shock_states, SparseMatrixMTL<double> &tranFull, 
        SparseMatrix3D<double> &tran, MatrixMTL<int> &removeFirm, SparseMatrixMTL<double> &shockTran);
  void computeRemoveFirm(MatrixMTL<int> &removeFirm, int **encoding_total, int **encoding_other, int dom_firm_number, int shock_states);
  void tranProbDom(MatrixMTL<double> &iotaDom, SparseMatrix3D<double> &tranDom);
  void reverseEncoding(SparseMatrixMTL<double> &tran);
  void reverseEncodingShocks(SparseMatrixMTL<double> &tran);
  void endcodeAddFirm(MatrixMTL<int> &addFirm);
  double compProb(int **encoding, int x, int fromInit, int toInit, int firms, SparseMatrix3D<double> &bigTran, int fromShock);
  void competitorsTransition(int **encoding, int *array, int slotIndex, int n, int k, int shock_states);

  void setShock(int w);
  void restore();
  ~CompOE_dom();

  #ifdef ACW
  void tranProbACWDom(MatrixMTL<double> &V, SparseMatrixMTL<double> &tranMatrix);
  #endif
};

#endif
