/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "compoe_nonstat.h"

void CompOE_nonstat::setShock(int t) {
  backup = new VectorMTL<double>(1);
  (*backup)[0]=prof_fun[0];
  prof_fun[0]*=(*ED)[t][0]*nonstatparams[19]+(*ED)[t][1]+(*ED)[t][2]*nonstatparams[20];
}

/*
void CompOE_nonstat::setShock(int w) {
  // First back up the parameters that will be altered
  // *backup vector need to be created so that the parameters
  // can be restored to its reference values
  backup = new VectorMTL<double>(1); // Number of parameters to back up
                                     // In the sample case we back up only one parameter
				     // that is size of the market

  (*backup)[0]=prof_fun[0];          // Now back up the parameters

  // Now set the parameters in each of the shock state

  switch(w) {
    // Low shock, decrease the market size
    case 0: 
      prof_fun[0]=(*backup)[0]*(1-nonstatparams[19]);
      break;
    // Mid shock, keep the market size unchanged
    case 1:
      prof_fun[0]=(*backup)[0];
      break;
    // High shock, increase the market size
    case 2:
      prof_fun[0]=(*backup)[0]*(1+nonstatparams[20]);
      break;
  }
}
*/
// Restore function
// Every parameter need to restored to its reference value
// That is kept in the *backup vector
void CompOE_nonstat::restore() {
  prof_fun[0]=(*backup)[0];
  // Delete the backup vector
  delete backup;
}
