/***************************************************************************
 *   Copyright (C) 2006 by Jeziorski, Weintraub, Benkard and Van Roy       *
 *   przemekj@stanford.edu                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "compoe_nonstat.h"
CompOE_nonstat::CompOE_nonstat() {
  xmax = 0;
  ignore = 2;
  rhoMatrix_global=NULL;
  iotaMatrix_global=NULL;
  lambdaVector_global=NULL; 
  V_global=NULL; 
  s_global=NULL;
  p_global=NULL;
  profitMatrix_global=NULL;
  bound1avg_nonstat=NULL;
  bound1var_nonstat=NULL;
  bound1pre_nonstat=NULL;
  bound1por_nonstat=NULL;
  bound2avg_nonstat=NULL;
  bound2var_nonstat=NULL;
  bound2pre_nonstat=NULL;
  bound2por_nonstat=NULL;
  bound3avg_nonstat=NULL;
  bound3var_nonstat=NULL;
  bound3pre_nonstat=NULL;
  bound3por_nonstat=NULL;

  stackResolving = new stack<stackItem *>();
  ED=NULL;
}

void CompOE_nonstat::tloop(MatrixMTL<double> &rhoMatrix, MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &pMatrix,
  VectorMTL<double> &lambda1, MatrixMTL<double> &VMatrix, MatrixMTL<double> &s, 
  VectorMTL<double> &d, double &Delta0, double &Delta1) {

  VectorMTL<double> iota(xmax);
  VectorMTL<double> rho(xmax);
  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);
  VectorMTL<double> profit(xmax);
  VectorMTL<double> V(xmax);
  VectorMTL<double> temp(xmax);
  VectorMTL<double> p0(xmax);
  VectorMTL<double> proftemp(xmax);

  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> tranmat(xmax);
    MatrixMTL<double> conttranmat(xmax);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranmat(xmax);
    TriDiagMatrixMTL<double> conttranmat(xmax);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> tranmat;
    SparseMatrixMTL<double> conttranmat;
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif

  prcont = 0;
  
  iotaMatrix=0;
  rhoMatrix=0;

  for(int x=0;x<xmax_subtract;++x) {
    if(nonstatparams[18]==2) {
      if((*s0)[x]==0)
        continue;
    }
    
    V = VMatrix.getRow((Tbar+1)*x+Tbar+1);
    for(int j=Tbar; j>=0; j--) {
      if(shockn>1) setShock(j);

      int i1=x*(Tbar+1)+j;
      int i2=x*(Tbar+2)+j;

//      cout << "Tloop for t = " << i << endl;
      /*** Optimal investment ***/
      iota = optInv(V,d);
      iotaMatrix.setRow(i1,iota);

      /*** Compute transition probabilities ***/
      tranProb(iota,tranmat,conttranmat,prcont);

      /*** Compute continuation values if not exiting ***/
      rho = (-iota*d) + ((tranmat.dot(V))*constants[2]);
      rhoMatrix.setRow(i1,rho);

      /*** Compute continuation probs. and conditional expectation sell-off ***
       *** value, conditional on exiting                                    ***/
      continuationProb(rho,prcont,condexp);
      condToNoncondTranProb(tranmat,conttranmat,prcont);

      if(nonstatparams[18]!=3) {
        temp = s.getRow(i2);
        
        p0 = pMatrix.getRow(i1);
        compProf(temp,p0,profit);
      } else {
        for(int xown=0;xown<xmax;++xown) {
          temp = s.getRow(xown*(Tbar+2)+j);
          temp[xown]++;

          ignore=1;
          p0 = pMatrix.getRow(i1);
          compProf(temp,p0,proftemp);
          ignore=2;

          profit[xown]=proftemp[xown];
        }
      }
      pMatrix.setRow(i1,p0);
      profitMatrix_global->setRow(i1,profit);

      VectorMTL<double> Vold(xmax);
      Vold=V;

      V = profit + (-prcont+1.0)*condexp+prcont*rho;

      VMatrix.setRow(i1,V);

      /*** Fixed number of firms ***/
      if(control[2]>0) {
        Delta0=0;
        Delta1=0;

        lambda1[i1]=control[2]-1;
      } else { // Entry/exit
        /*** Update Delta ***/
        Delta0 = MAX(Delta0,(Vold[int(constants[3])-1]*constants[2]-constants[0]));
        if(lambda1[i1]>nonstatparams[15]) {
          Delta1 = MAX(Delta1,-(Vold[int(constants[3])-1]*constants[2]-constants[0]));
        }

        /*** Set lambda_{Tbar}=lambda_oe ***/
        if(j==Tbar) {
          // Do not update lambda at Tbar, it's simply lambdaoe
        } else {
//        cout << "Update lambda: " << Vold[int(constants[3])-1]*constants[2]/constants[0] << endl;
          lambda1[i1]*=Vold[int(constants[3])-1]*constants[2]/constants[0];
        }
      }
      if(shockn>1) restore();
    }
  }
}

void CompOE_nonstat::computeState(MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &rhoMatrix,
  VectorMTL<double> &lambda1, MatrixMTL<double> &s) {

#if TRANSITION_MATRIX == 0 
  MatrixMTL<double> tranmat(xmax,xmax);
  MatrixMTL<double> conttranmat(xmax,xmax);
#elif TRANSITION_MATRIX == 1 
  TriDiagMatrixMTL<double> tranmat(xmax);
  TriDiagMatrixMTL<double> conttranmat(xmax);
#elif TRANSITION_MATRIX == 2 
  SparseMatrixMTL<double> tranmat;
  SparseMatrixMTL<double> conttranmat;
#else 
  #error Invalid value for TRANSITION_MATRIX
#endif

  VectorMTL<double> temp(xmax);
  VectorMTL<double> contprob(xmax);
  VectorMTL<double> rho(xmax);
  VectorMTL<double> iota(xmax);

  if(nonstatparams[18]==2) {
    VectorMTL<double> s0sub(xmax);
    VectorMTL<double> state(xmax);

    MatrixMTL<double> stemp((Tbar+2)*xmax_subtract,xmax);

    for(int x=0;x<xmax_subtract;++x) {
      // Expected state of the firm started at x
      if((*s0)[x]==0)
        continue;
      
      state=0;state[x]=1;
      for(int j=0;j<Tbar;j++) {
        int i1=x*(Tbar+1)+j;
        int i2=x*(Tbar+2)+j;
        iota = iotaMatrix.getRow(i1);
        rho = rhoMatrix.getRow(i1);

        continuationProb(rho,contprob,temp);
        tranProb(iota,tranmat,conttranmat,contprob);
        state = conttranmat.primedot(state);
        stemp.setRow(i2+1,state);
      }
    }

    for(int xown=0;xown<xmax_subtract+1;++xown) {
      if(xown<xmax_subtract) if((*s0)[xown]==0)
        continue;

      // S0 of the competitors specific to the the firm in this state
      s0sub = s.getRow(xown*(Tbar+2));
      for(int j=0;j<Tbar;j++) {
        int iown=xown*(Tbar+2)+j;
        temp=0;
        for(int xcomp=0;xcomp<xmax_subtract;++xcomp) {
          if((*s0)[xcomp]==0)
            continue;
          int icomp;
     //     if(xown==xmax_subtract)
     //       icomp=xcomp*(Tbar+2)+j;
     //     else
          icomp=xcomp*(Tbar+2)+j;
          temp+=s0sub[xcomp]*stemp.getRow(icomp+1);
        }
//        if(control[2]==0)
//          temp[int(constants[3])-1]+=lambda1[i];
        
        s.setRow(iown+1,temp);
      }
    }
  } else if(nonstatparams[18]==3) {
    MatrixMTL<double> pt(xmax,xmax);
    VectorMTL<double> state(xmax);
    VectorMTL<double> ps0(xmax);
    VectorMTL<double> pxt(xmax);
    MatrixMTL<double> stemp(xmax,xmax);

    ps0=(*s0)/sum(*s0);

    for(int ownx_at_0=0;ownx_at_0<xmax;ownx_at_0++) {
      state=*s0;state[ownx_at_0]--;
      stemp.setRow(ownx_at_0,state);
    }

    pt.eye();
    for(int j=0;j<Tbar;j++) {
      iota = iotaMatrix.getRow(j);
      rho = rhoMatrix.getRow(j);
      continuationProb(rho,contprob,temp);

      tranProb(iota,tranmat,conttranmat,contprob);

      pt=pt.dot(conttranmat);

      pxt=pt.primedot(ps0);

      stemp=stemp.dot(conttranmat);
      /*
      cout << conttranmat;
      getchar();
      cout << pt;
      getchar();
      cout << stemp;
      getchar();
      cout << ps0;
      cout << pxt;
      getchar();
      */
      for(int ownx_at_t=0;ownx_at_t<xmax;ownx_at_t++) {
        state=0;
        // Check if achievable state
        if(pxt[ownx_at_t]==0) continue;
        for(int ownx_at_0=0;ownx_at_0<xmax;ownx_at_0++) {
          double p0_given_xt=pt[ownx_at_0][ownx_at_t]*ps0[ownx_at_0]/pxt[ownx_at_t];
          //cout << "0: " << ownx_at_0 << " t: " << ownx_at_t << " p: " << p0_given_xt << endl;
          state+=stemp.getRow(ownx_at_0)*p0_given_xt;
        }
        int iown=ownx_at_t*(Tbar+2)+j;
        s.setRow(iown+1,state);

        /*
        cout << "xown " << ownx_at_t << endl;
        cout << state;
        getchar();
        */
      }

      // Fill in missing states
      for(int ownx_at_t=0;ownx_at_t<xmax;ownx_at_t++) {
        if(pxt[ownx_at_t]==0) {
          int iown=ownx_at_t*(Tbar+2)+j;

          for(int k=1;k<xmax;++k) {
            int checkx=MAX(ownx_at_t-k,0);
            if(pxt[checkx]>0) {
              s.setRow(iown+1, s.getRow(checkx*(Tbar+2)+j+1));
              break;
            }
            checkx=MIN(ownx_at_t+k,xmax-1);
            if(pxt[checkx]>0) {
              s.setRow(iown+1, s.getRow(checkx*(Tbar+2)+j+1));
              break;
            }
          }
        }
      }

    }
  } else {
    for(int i=0;i<Tbar;i++) {
      iota = iotaMatrix.getRow(i);
      rho = rhoMatrix.getRow(i);
      continuationProb(rho,contprob,temp);
      tranProb(iota,tranmat,conttranmat,contprob);


      temp = conttranmat.primedot(s.getRow(i));
      if(control[2]==0)
        temp[int(constants[3])-1]+=lambda1[i];
      s.setRow(i+1,temp);
    }
  }
}


void CompOE_nonstat::main_loop(int xmax_init, int TbarInit, VectorMTL<double> &VInit, 
  MatrixMTL<double> &iotaInit, MatrixMTL<double> &rhoInit, VectorMTL<double> &s0_init, VectorMTL<double> &tildes,
  MatrixMTL<double> &prices_init, VectorMTL<double> &lambda_oe, VectorMTL<double> &D0_init) {

  // We want Tbar + 1 periods
  Tbar=TbarInit;
  xmax = xmax_init;

  /*** Initialize vector size for subtracting ***/
  if(nonstatparams[18]==2) {
    xmax_subtract=xmax;
  } else {
    xmax_subtract=1;
  }

  MatrixMTL<double> rhoMatrix0((Tbar+1)*xmax_subtract,xmax); 
  MatrixMTL<double> iotaMatrix0((Tbar+1)*xmax_subtract,xmax);
  VectorMTL<double> lambda0((Tbar+1)*xmax_subtract);
  MatrixMTL<double> rhoMatrix1((Tbar+1)*xmax_subtract,xmax); 
  MatrixMTL<double> iotaMatrix1((Tbar+1)*xmax_subtract,xmax);
  VectorMTL<double> lambda1((Tbar+1)*xmax_subtract);

  VectorMTL<double> contprob(xmax);
  VectorMTL<double> iota0(xmax);
  VectorMTL<double> rho0(xmax);

  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> tranmat(xmax,xmax);
    MatrixMTL<double> conttranmat(xmax,xmax);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranmat(xmax);
    TriDiagMatrixMTL<double> conttranmat(xmax);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> tranmat;
    SparseMatrixMTL<double> conttranmat;
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif

  MatrixMTL<double> VMatrix((Tbar+2)*xmax_subtract,xmax);
  VMatrix=0;

  if(nonstatparams[18]==2) {
    xmax_subtract++;
  }
  
  int sdim;
  if(nonstatparams[18]!=3) {
    sdim=(Tbar+2)*xmax_subtract;
  } else {
    sdim=(Tbar+2)*xmax;
  }

  MatrixMTL<double> s(sdim,xmax);


  if(nonstatparams[18]==2) {
    xmax_subtract--;
  }

  VectorMTL<double> V(xmax);
  VectorMTL<double> temp(xmax);
  VectorMTL<double> condexp(xmax);

  s=0;
  // Set last expected state to OE with a subtracted firm
  // Last state of an industry state (only with case '2')
  if(nonstatparams[18]==2) {
    s.setRow((Tbar+2)*xmax_subtract+Tbar+1,tildes);
  }

  // Last state for competitors' state
  temp = tildes;
  if((control[2]==0) && (control[1]==1)) { // Poisson
    for(int x=0;x<xmax;++x) {
     temp[x]=tildes[x]/(1-exp(-tildes[x]))-1;
    }
  } else {
    double tildesn=sum(tildes);
    if(tildesn>1) {
      temp=tildes-(tildes/tildesn);
    }
  }
  if(nonstatparams[18]!=3) {
    for(int x=0;x<xmax_subtract;++x) {
      s.setRow(x*(Tbar+2)+Tbar+1,temp);
    }
  } else {
    for(int x=0;x<xmax;++x) {
      s.setRow(x*(Tbar+2)+Tbar+1,temp);
    }
  }


  MatrixMTL<double> contprobMatrix0(Tbar,xmax),contprobMatrix1(Tbar,xmax);
  contprobMatrix1=0;

  /* Initialize profit matrix */
  if(profitMatrix_global!=NULL) {
    delete profitMatrix_global;
  }
  profitMatrix_global = new MatrixMTL<double>((Tbar+1)*xmax_subtract,xmax);
  *profitMatrix_global = 0;

  /* Precompute investment cost */
  VectorMTL<double> d(xmax);
  for(int i=0;i<xmax;i++) {
    d[i]=MACRO__MINVCOST(i);
  }

  /* Initialize the startup prices */
  MatrixMTL<double> pMatrix((Tbar+1)*xmax_subtract,xmax);

  struct tms t,u;
  long r1,r2;

  /*** Innitialize states ***/
  s0 = &s0_init;
  if(nonstatparams[18]==2) {
    VectorMTL<double> s0_init_sub(xmax);
    for(int x=0;x<xmax_subtract;++x) {
      if(s0_init[x]>0) {
        s0_init_sub=s0_init;
        s0_init_sub[x]--;
      } else {
        s0_init_sub=-1;
      }

      s.setRow(x*(Tbar+2),s0_init_sub);
    }
    s.setRow(xmax_subtract*(Tbar+2),s0_init);
  } if(nonstatparams[18]==3) {
    VectorMTL<double> s0_init_sub(xmax);
    for(int x=0;x<xmax;++x) {
      if(s0_init[x]>0) {
        s0_init_sub=s0_init;
        s0_init_sub[x]--;
      } else {
        s0_init_sub=0;
      }
    
      s.setRow(x*(Tbar+2),s0_init_sub);
    }
  } else {
    //  subtract a firm
    VectorMTL<double> s0_init_sub(xmax);
    s0_init_sub=s0_init;

    if(nonstatparams[18]==1) {
      double s0n=sum(s0_init_sub);
      if(s0n>1) {
        s0_init_sub-=(s0_init/s0n);
      } else {
        s0_init_sub=0;
      }
    }
    s.setRow(0,s0_init_sub);
  }

  /*** Innitialize calulations ***/
//  for(int x=0;x<xmax_subtract;++x) {
//    for(int j=0;j<=Tbar;j++) {
//      int i=x*(Tbar+1)+j;
//      rhoMatrix0.setRow(i,rhoInit);
//      iotaMatrix0.setRow(i,iotaInit);
      //pMatrix.setRow(i,prices_init);
//    }
//  }

  rhoMatrix0=rhoInit;
  iotaMatrix0=iotaInit;
  pMatrix=prices_init;
  lambda0=lambda_oe;

//  lambda0 = lambda_oe;


  // Compute aggregate shock distribution
  shockn=shockTran->getHeight();
  VectorMTL<double> D0(shockn);
  D0=D0_init;
  if(ED!=NULL) delete ED;
  ED=new MatrixMTL<double>(Tbar+1,shockn);
  ED->setRow(0,D0);
  for(int t=1;t<=Tbar;++t) {
    D0=shockTran->primedot(D0);
    ED->setRow(t,D0);
  }

  int n=1;
  for(ignore=int(nonstatparams[14]);ignore<3;ignore++) {
//  for(ignore=2;ignore<3;ignore++) {
     n=1;
     if(ignore==1) { 
      #ifdef COUT_DEBUG
        cout << "Nonstationary: Compute with approximated profit function"<< endl;
      #endif
      #ifdef DEBUG
        *myfile << "Nonstationary: Compute with approximated profit function"<< endl;
      #endif
    } else {
      #ifdef COUT_DEBUG
        cout << "Nonstationary: Compute with full profit function"<< endl;
      #endif
      #ifdef DEBUG
        *myfile << "Nonstationary: Compute with full profit function"<< endl;
      #endif
    }
    while(1) {
      r1 = times(&t);
      #ifdef COUT_DEBUG
        if(n % 50 ==0)
          cout << "\nNonstationary: iteration #" << n <<endl;
      #endif
      #ifdef DEBUG
        *myfile << "\nNonstationary: iteration #" << n <<endl;
      #endif

      lambda1=lambda0;

      /*** Reset tolerance for lambda ***/
      double Delta0=0, Delta1=0;

      /*** Update continuation probability matrix ***/
      contprobMatrix0=contprobMatrix1;

      computeState(iotaMatrix0,rhoMatrix0,lambda1,s);
      /*** Init. V_{Tbar+1} ***/
      for(int x=0;x<xmax_subtract;++x) { 
        VMatrix.setRow((Tbar+1)*x+Tbar+1,VInit);
      }
      tloop(rhoMatrix1, iotaMatrix1, pMatrix, lambda1, VMatrix, s, d, Delta0, Delta1);
      r2 = times(&u);

      #ifdef COUT_DEBUG
        if(n % 50 ==0) {
          cout << "Iota stop: " << norm(iotaMatrix0-iotaMatrix1) << "\t\t Rho stop = "
            << norm(rhoMatrix0-rhoMatrix1) << endl;
          cout << "Lambda stop: Delta0 = " << Delta0 << ", Delta1 = " 
            << Delta1 << ", norm = " << norm(lambda1-lambda0)<< endl;
          cout << "Time of the iteration: " << r2-r1 <<endl;
        }
      #endif

      #ifdef DEBUG
        *myfile << "Iota stop: " << norm(iotaMatrix0-iotaMatrix1) << "\t\t Rho stop = "
          << norm(rhoMatrix0-rhoMatrix1) << endl;
        *myfile << "Lambda stop: Delta0 = " << Delta0 << ", Delta1 = "<< Delta1 <<  ", norm = " 
          << norm(lambda1-lambda0)<< endl;
        *myfile << "Time of the iteration: " << r2-r1 <<endl;
      #endif

      /*** Stopping criterion ***/
      if ((norm(iotaMatrix0-iotaMatrix1) < nonstatparams[1]) && 
        (norm(rhoMatrix0-rhoMatrix1) < nonstatparams[0]) &&
        (Delta0<nonstatparams[2]) && (Delta1<nonstatparams[2])) { 

        break;
      }

      if(n>nonstatparams[7]) break;

      #ifdef COUT_DEBUG
        if(n % 50 ==0) {
          cout << "Update steps: " << (1/(pow(n,nonstatparams[4])+nonstatparams[6])) << " " 
            << (1/(pow(n,nonstatparams[3])+nonstatparams[5])) << endl;
        }
      #endif

      #ifdef DEBUG
        *myfile << "Update steps: " << (1/(pow(n,nonstatparams[4])+nonstatparams[6])) << " " 
          << (1/(pow(n,nonstatparams[3])+nonstatparams[5])) << endl;
      #endif

      lambda0+=(lambda1-lambda0)/(pow(n,nonstatparams[4])+nonstatparams[6]);
      rhoMatrix0+=(rhoMatrix1-rhoMatrix0)/(pow(n,nonstatparams[3])+nonstatparams[5]);
      iotaMatrix0+=(iotaMatrix1-iotaMatrix0)/(pow(n,nonstatparams[3])+nonstatparams[5]);

      n++;
//      cout << s.getRow(Tbar+1); getchar();
    }
  }

  if(rhoMatrix_global!=NULL) {
    delete rhoMatrix_global;
  }
  rhoMatrix_global = new MatrixMTL<double>((Tbar+1)*xmax_subtract,xmax);
  *rhoMatrix_global = rhoMatrix1;

  if(iotaMatrix_global!=NULL) {
    delete iotaMatrix_global;
  }
  iotaMatrix_global = new MatrixMTL<double>((Tbar+1)*xmax_subtract,xmax);
  *iotaMatrix_global = iotaMatrix1;

  if(lambdaVector_global!=NULL) {
    delete lambdaVector_global;
  }
  lambdaVector_global = new VectorMTL<double>(Tbar+1);
  *lambdaVector_global = lambda1;

  if(V_global!=NULL) {
    delete V_global;
  }
  V_global = new MatrixMTL<double>((Tbar+2)*xmax_subtract,xmax);
  *V_global = VMatrix;

  if(s_global!=NULL) {
    delete s_global;
  }

  if(nonstatparams[19]==2) {
    s_global = new MatrixMTL<double>((Tbar+2)*(xmax_subtract+1),xmax);
  } else if(nonstatparams[18]==3) {
    s_global = new MatrixMTL<double>((Tbar+2)*xmax,xmax);
  } else {
    s_global = new MatrixMTL<double>((Tbar+2)*xmax_subtract,xmax);
  }
  *s_global = s;

  if(p_global!=NULL) {
    delete p_global;
  }
  p_global = new MatrixMTL<double>((Tbar+1)*xmax_subtract,xmax);
  *p_global = pMatrix;
//  cout << *profitMatrix_global;
}
/*************************************************************************
 * This function takes oblivious value function as input and calculates: *
 * a) TbarOut - length of the horizon of non-stationary equilibrium      *
 * b) index - maximum market size                                        *
 * DISABLED                                                              *
 *************************************************************************/
/*
void CompOE_nonstat::computeT(VectorMTL<double> *V,VectorMTL<double> *iotaInit,VectorMTL<double> *rhoInit,double lambdaInit, int &t, int &sizeOfV) {
  sizeOfV = V->getSize();
  CompOE *oe = new CompOE;
  oe->initialize(control, prof_fun, transition, constants, init, convtol);
  oe->setOutput(myfile);

  // Apply multiplier //
  int sizeOfV_old = sizeOfV;
  sizeOfV = int(sizeOfV*nonstatparams[8]);
  for(int i=sizeOfV_old;i<sizeOfV;i++) {
    V->addElement((*V)[sizeOfV_old-1]);
    iotaInit->addElement((*iotaInit)[sizeOfV_old-1]);
    rhoInit->addElement((*rhoInit)[sizeOfV_old-1]);
  }

  while(1) {
    // Check if the size of V is enought to calcutate Tbar //
    t = int(ceil((sizeOfV-constants[3])/nonstatparams[11])); 
    if(t<nonstatparams[12]) {
      sizeOfV=int(constants[3]+nonstatparams[12]*nonstatparams[11]+nonstatparams[9]);
      *myfile << "Current size of V cannot support starting index" <<endl;
      *myfile << "New size: " << sizeOfV << endl << endl;
      #ifdef DEBUG
        cout << "Current size of V cannot support starting index" <<endl;
        cout << "New size: " << sizeOfV << endl << endl;
      #endif
      oe->recompute(*iotaInit,*rhoInit,lambdaInit,sizeOfV);
      V = oe->getV();
    } else if(pow(constants[2],t-nonstatparams[12])*(*V)[sizeOfV-1]>nonstatparams[7]) {
      #ifdef DEBUG
        cout << "Current size of V cannot reach desired precision" <<endl;
        cout << "V(x^e+t w) = " << (*V)[sizeOfV-1] <<endl;
        cout << "xmax = " << sizeOfV << "\t" << "Tbar = " << t << "\t"<< "Epsilon = " << pow(constants[2],t-nonstatparams[12])*(*V)[sizeOfV-1] << endl;
      #endif
      *myfile << "Current size of V cannot reach desired precision" <<endl;
      *myfile << "V(x^e+t w) = " << (*V)[sizeOfV-1] <<endl;
      *myfile << "xmax = " << sizeOfV << "\t" << "Tbar = " << t << "\t"<< "Epsilon = " << pow(constants[2],t-nonstatparams[12])*(*V)[sizeOfV-1] << endl;
//      getchar();
      sizeOfV+=int(nonstatparams[9]);
      #ifdef DEBUG
        cout << "New size: " << sizeOfV << endl << endl;
      #endif
      *myfile << "New size: " << sizeOfV << endl << endl;
      oe->recompute(*iotaInit,*rhoInit,lambdaInit,sizeOfV);
      V = oe->getV();
      iotaInit = oe->getIota();
      rhoInit = oe->getRho();
    } else {
      break;
    }
  }
  delete oe;
}*/

stackItem *CompOE_nonstat::searchStack(VectorMTL<double> &s0, VectorMTL<double> &D0) {
  stack<stackItem *> *searchStack = new stack<stackItem *>();
  VectorMTL<double> *sstate;
  VectorMTL<double> *sD0;

  stackItem *output = NULL;
  stackItem *temp;

//  cout << "Search stack" << endl;

  while (!stackResolving->empty()) {
    temp = (stackItem *) stackResolving->top();
    sstate = temp->state;
    sD0 = temp->D0;
/*
    cout << "Candidate" <<endl;
    cout << *sstate;
    cout << *sD0;
    cout << "Match" << endl;
    cout << s0;
    cout << D0;
*/
    if(output==NULL) {
      if((diffNorm(s0,*sstate)==0) && (diffNorm(D0,*sD0)==0)) {
        output = temp;
//        cout << "Found stack element" << endl;
      }
    }
    stackResolving->pop();
    searchStack->push(temp);
  }

  delete stackResolving;
  stackResolving=searchStack;

  return output;
}



void CompOE_nonstat::computeStatsNonstat(double *bounds, int Tbar, int xmax, MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &rhoMatrix,
      VectorMTL<double> &lambda, MatrixMTL<double> &pMatrix, VectorMTL<double> &s0_init,
      VectorMTL<double> &VInit, VectorMTL<double> &tildes, VectorMTL<double> &D0) {
  // Initialize vector size for subtracting
  if(nonstatparams[18]==2) {
    xmax_subtract=xmax;
  } else {
    xmax_subtract=1;
  }

  int L=bounds[10];
  int M=bounds[11];

  shockn=shockTran->getHeight();

  VectorMTL<double> iota(xmax);
  VectorMTL<double> rho(xmax);

  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);

  VectorMTL<double> proftildes(xmax);
  VectorMTL<double> prices(xmax);
  VectorMTL<double> pricesOut(xmax);

  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> tranMatrix(xmax,xmax);
    MatrixMTL<double> contTranMatrix(xmax,xmax);
    MatrixMTL3D<double> prcontMatrix(xmax,xmax,Tbar);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranMatrix(xmax);
    TriDiagMatrixMTL<double> contTranMatrix(xmax);
    TriDiagMatrix3D<double> prcontMatrix(xmax,Tbar);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> tranMatrix;
    SparseMatrixMTL<double> contTranMatrix;
    SparseMatrix3D<double> prcontMatrix(Tbar);
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif

  MatrixMTL<double> temp(xmax);
  VectorMTL<double> profsim(xmax);

  double tol1=bounds[1]/(1+bounds[1]);

  double prodsursum=0;
  double prodsursqr=0;
  double conssursum=0;
  double conssursqr=0;
  double totalsursum=0;
  double totalsursqr=0;
  double invsum=0;
  double invsqr=0;

  double c1sum=0;
  double c1sqr=0;
  double c2sum=0;
  double c2sqr=0;
  double c4sum=0;
  double c4sqr=0;
  double c10sum=0;
  double c10sqr=0;
  double c20sum=0;
  double c20sqr=0;

  double hhi50sum=0;
  double hhi50sqr=0;


  if (firmsnumberavg!=NULL) delete firmsnumberavg;
  if (firmsnumbervar!=NULL) delete firmsnumbervar;
  if (firmsnumberpre!=NULL) delete firmsnumberpre;
  if (firmsnumberpor!=NULL) delete firmsnumberpor;
  firmsnumberavg = new VectorMTL<double>(xmax);
  firmsnumbervar = new VectorMTL<double>(xmax);
  firmsnumberpre = new VectorMTL<double>(xmax);
  firmsnumberpor = new VectorMTL<double>(xmax);
  if(bounds[12]==1) {
    if (prodsuravg_path!=NULL) delete prodsuravg_path;
    if (prodsurvar_path!=NULL) delete prodsurvar_path;
    if (prodsurpre_path!=NULL) delete prodsurpre_path;
    prodsuravg_path = new VectorMTL<double>(M);
    prodsurvar_path = new VectorMTL<double>(M);
    prodsurpre_path = new VectorMTL<double>(M);

    if (conssuravg_path!=NULL) delete conssuravg_path;
    if (conssurvar_path!=NULL) delete conssurvar_path;
    if (conssurpre_path!=NULL) delete conssurpre_path;
    conssuravg_path = new VectorMTL<double>(M);
    conssurvar_path = new VectorMTL<double>(M);
    conssurpre_path = new VectorMTL<double>(M);

    if (totalsuravg_path!=NULL) delete totalsuravg_path;
    if (totalsurvar_path!=NULL) delete totalsurvar_path;
    if (totalsurpre_path!=NULL) delete totalsurpre_path;
    totalsuravg_path = new VectorMTL<double>(M);
    totalsurvar_path = new VectorMTL<double>(M);
    totalsurpre_path = new VectorMTL<double>(M);

    if (c1avg_path!=NULL) delete c1avg_path;
    if (c1var_path!=NULL) delete c1var_path;
    if (c1pre_path!=NULL) delete c1pre_path;
    c1avg_path = new VectorMTL<double>(M);
    c1var_path = new VectorMTL<double>(M);
    c1pre_path = new VectorMTL<double>(M);

    if (c2avg_path!=NULL) delete c2avg_path;
    if (c2var_path!=NULL) delete c2var_path;
    if (c2pre_path!=NULL) delete c2pre_path;
    c2avg_path = new VectorMTL<double>(M);
    c2var_path = new VectorMTL<double>(M);
    c2pre_path = new VectorMTL<double>(M);

    if (c4avg_path!=NULL) delete c4avg_path;
    if (c4var_path!=NULL) delete c4var_path;
    if (c4pre_path!=NULL) delete c4pre_path;
    c4avg_path = new VectorMTL<double>(M);
    c4var_path = new VectorMTL<double>(M);
    c4pre_path = new VectorMTL<double>(M);

    if (c10avg_path!=NULL) delete c10avg_path;
    if (c10var_path!=NULL) delete c10var_path;
    if (c10pre_path!=NULL) delete c10pre_path;
    c10avg_path = new VectorMTL<double>(M);
    c10var_path = new VectorMTL<double>(M);
    c10pre_path = new VectorMTL<double>(M);

    if (c20avg_path!=NULL) delete c20avg_path;
    if (c20var_path!=NULL) delete c20var_path;
    if (c20pre_path!=NULL) delete c20pre_path;
    c20avg_path = new VectorMTL<double>(M);
    c20var_path = new VectorMTL<double>(M);
    c20pre_path = new VectorMTL<double>(M);

    if (hhi50avg_path!=NULL) delete hhi50avg_path;
    if (hhi50var_path!=NULL) delete hhi50var_path;
    if (hhi50pre_path!=NULL) delete hhi50pre_path;
    hhi50avg_path = new VectorMTL<double>(M);
    hhi50var_path = new VectorMTL<double>(M);
    hhi50pre_path = new VectorMTL<double>(M);

    if (invavg_path!=NULL) delete invavg_path;
    if (invvar_path!=NULL) delete invvar_path;
    if (invpre_path!=NULL) delete invpre_path;
    invavg_path = new VectorMTL<double>(M);
    invvar_path = new VectorMTL<double>(M);
    invpre_path = new VectorMTL<double>(M);

    if (firmsnumberavg_path!=NULL) delete firmsnumberavg_path;
    if (firmsnumbervar_path!=NULL) delete firmsnumbervar_path;
    if (firmsnumberpre_path!=NULL) delete firmsnumberpre_path;
    firmsnumberavg_path = new MatrixMTL<double>(M,xmax);
    firmsnumbervar_path = new MatrixMTL<double>(M,xmax);
    firmsnumberpre_path = new MatrixMTL<double>(M,xmax);
  }

  VectorMTL<double> firmsnumbersum(xmax);
  VectorMTL<double> firmsnumbersqr(xmax);

  firmsnumbersum=0;
  firmsnumbersqr=0;

  VectorMTL<double> prodsursum_path(M);
  VectorMTL<double> prodsursqr_path(M);
  VectorMTL<double> conssursum_path(M);
  VectorMTL<double> conssursqr_path(M);
  VectorMTL<double> totalsursum_path(M);
  VectorMTL<double> totalsursqr_path(M);
  VectorMTL<double> invsum_path(M);
  VectorMTL<double> invsqr_path(M);

  VectorMTL<double> c1sum_path(M);
  VectorMTL<double> c1sqr_path(M);
  VectorMTL<double> c2sum_path(M);
  VectorMTL<double> c2sqr_path(M);
  VectorMTL<double> c4sum_path(M);
  VectorMTL<double> c4sqr_path(M);
  VectorMTL<double> c10sum_path(M);
  VectorMTL<double> c10sqr_path(M);
  VectorMTL<double> c20sum_path(M);
  VectorMTL<double> c20sqr_path(M);

  VectorMTL<double> hhi50sum_path(M);
  VectorMTL<double> hhi50sqr_path(M);
  
  MatrixMTL<double> firmsnumbersum_path(M,xmax);
  MatrixMTL<double> firmsnumbersqr_path(M,xmax);
  
  prodsursum_path=0;
  prodsursqr_path=0;
  conssursum_path=0;
  conssursqr_path=0;
  totalsursum_path=0;
  totalsursqr_path=0;
  invsum_path=0;
  invsqr_path=0;

  c1sum_path=0;
  c1sqr_path=0;
  c2sum_path=0;
  c2sqr_path=0;
  c4sum_path=0;
  c4sqr_path=0;
  c10sum_path=0;
  c10sqr_path=0;
  c20sum_path=0;
  c20sqr_path=0;

  hhi50sum_path=0;
  hhi50sqr_path=0;

  firmsnumbersum_path=0;
  firmsnumbersqr_path=0;

  double c1, c2, c4, c10, c20, c50, hhi50;
  double firms;

  MatrixMTL<double> *g=NULL;

  // Start simulation
  double boundspre=tol1+1;

  RanGenLib P;
  int n=1;

  stackItem *item = NULL;


  VectorMTL<double> state(xmax);
  VectorMTL<double> newstate(xmax);

  state=s0_init;

  VectorMTL<double> Dvector(shockn);
  
  // No resolving - compute once
  if(bounds[13]==0) { // Without resolving
     main_loop(xmax, Tbar, VInit, iotaMatrix, rhoMatrix, state, tildes, pMatrix, lambda, D0);
     iotaMatrix=(*iotaMatrix_global);
     rhoMatrix=(*rhoMatrix_global);

  }

  while((boundspre>tol1) || 
    (n<=bounds[4])) {

    #ifdef COUT_DEBUG
      cout << "Resolving iteration: " << n << ", TOL: "<< boundspre << endl;
    #endif
    #ifdef DEBUG
      *myfile << "Resolving iteration: " << n << ", TOL: "<< boundspre << endl;
    #endif


    if (n>bounds[3]) break;

    // Reset state
    state=s0_init;
    int d=genDistr(P,D0);
    Dvector=0;
    Dvector[d]=1;

    double prodsurrun=0;
    double conssurrun=0;
    double totalsurrun=0;
    double invrun=0;

    double c1run=0;
    double c2run=0;
    double c4run=0;
    double c10run=0;
    double c20run=0;

    double hhi50run=0;

    VectorMTL<double> firmsnumberrun(xmax);
    firmsnumberrun=0;

    VectorMTL<double> prodsurrun_path(M);
    VectorMTL<double> conssurrun_path(M);
    VectorMTL<double> totalsurrun_path(M);
    VectorMTL<double> invrun_path(M);

    VectorMTL<double> c1run_path(M);
    VectorMTL<double> c2run_path(M);
    VectorMTL<double> c4run_path(M);
    VectorMTL<double> c10run_path(M);
    VectorMTL<double> c20run_path(M);

    VectorMTL<double> hhi50run_path(M);

    MatrixMTL<double> firmsnumberrun_path(M,xmax);

    prodsurrun_path=0;
    conssurrun_path=0;
    totalsurrun_path=0;
    invrun_path=0;

    c1run_path=0;
    c2run_path=0;
    c4run_path=0;
    c10run_path=0;
    c20run_path=0;

    hhi50run_path=0;

    firmsnumberrun_path=0;
    
    double beta=1.0;

    for(int smalln=0;smalln<L+M;++smalln) {
      int time_offset;
      if(bounds[13]==1) { // With resolving
        // Use t=0 if resolving
        time_offset=0;

        item=searchStack(state,Dvector);
        if(item==NULL) {
          cout << "Not found in the stack, " << n << " " << smalln << endl;
          main_loop(xmax, Tbar, VInit, iotaMatrix, rhoMatrix, state, tildes, pMatrix, lambda, Dvector);
        
          // Create a new stack item
          VectorMTL<double> *stackState = new VectorMTL<double>(xmax);
          MatrixMTL<double> *stackIota = new MatrixMTL<double>((Tbar+1)*xmax_subtract,xmax);
          MatrixMTL<double> *stackRho = new MatrixMTL<double>((Tbar+1)*xmax_subtract,xmax);
          VectorMTL<double> *stackD0 = new VectorMTL<double>(shockn);
    
          *stackState=state;
          *stackD0=Dvector;
          *stackIota=(*iotaMatrix_global);
          *stackRho=(*rhoMatrix_global);

//        cout << *iotaMatrix_global;
//        cout << *stackIota;
//        getchar();


          item = new stackItem;
          item->state = stackState;
          item->iota = stackIota;
          item->rho = stackRho;
          item->D0 = stackD0;

          stackResolving->push(item);

//        cout << *(item->iota);
//        getchar();
        } else {
          // We need to recompute path of state if the equilibrium is not recomputed
          // Otherwise the states do not correspond to the right Dvector
          ED->setRow(0,Dvector);
          for(int t=1;t<=Tbar;++t) {
            Dvector=shockTran->primedot(Dvector);
            ED->setRow(t,Dvector);
          }
        }

        iotaMatrix = (*(item->iota));
        rhoMatrix = (*(item->rho));
      } else {
        // Use the right t if not resolving
        time_offset=MIN(Tbar,smalln);
      }

      // Compute profits at initial simulated state
      prices=pMatrix.getRow(0);
      if(smalln>=L) {

        double prodsur, conssur, inv;
        VectorMTL<double> ms(xmax), profit(xmax);

        setShock(time_offset);
        compProfAndStats_extra(state,prices,pricesOut,profit,ms,prodsur,conssur);
        restore();

        // add investment 
        inv=0; 
        for(int x=0;x<xmax;x++) {
          int i1;
          if(nonstatparams[18]==2) {
            i1=x*(Tbar+1)+time_offset;
          } else {
            i1=time_offset;
          }      
          inv+=state[x]*(iotaMatrix[i1][x]);
        }

        // Calculate concetration ratios
        double totalms=0;

        totalms=sum(ms*state);
        if(totalms>0) {
          ms/=totalms;

          c1=0, c2=0, c4=0, c10=0, c20=0, c50=0;
          firms = 0;
          for(int i=xmax-1;i>=0;i--) {
            // Need more firms?
            if(firms<1) {
              // Add ms of all firms at i but up to the needed number 
              c1+=MIN(state[i],1-firms)*ms[i];
            }
            if(firms<2) {
              // Add ms of all firms at i but up to the needed number 
              c2+=MIN(state[i],2-firms)*ms[i];
            }
            if(firms<4) {
              // Add ms of all firms at i but up to the needed number
              c4+=MIN(state[i],4-firms)*ms[i];
            }
            if(firms<10) {
              // Add ms of all firms at i but up to the needed number 
              c10+=MIN(state[i],10-firms)*ms[i];
            }
            if(firms<20) {
              // Add ms of all firms at i but up to the needed number 
              c20+=MIN(state[i],20-firms)*ms[i];
            }
            if(firms<50) {
              // Add ms of all firms at i but up to the needed number 
              c50+=MIN(state[i],50-firms)*ms[i];
            }
            firms+=state[i];
          }

          hhi50=0;
          for(int x=0;x<xmax;x++) {
            hhi50+=10000*ms[x]*ms[x]*state[x];
          }
        }

        prodsurrun+=beta*prodsur;
        conssurrun+=beta*conssur;
        totalsurrun+=beta*(prodsur+conssur);
        invrun+=beta*inv;

        c20run+=c20;
        c10run+=c10;
        c4run+=c4;
        c2run+=c2;
        c1run+=c1;
        hhi50run+=hhi50;

        //cout << invrun;
        //cout << state;
        //getchar();

        if(bounds[12]==1) {
          /*if(smalln==0) {
            cout << prodsur << endl;
            cout << Dvector << endl;
            cout << *ED << endl;
            cout << state << endl;
            getchar();
          }*/
          prodsurrun_path[smalln]=prodsur;
          conssurrun_path[smalln]=conssur;
          totalsurrun_path[smalln]=prodsur+conssur;
          invrun_path[smalln]=inv;
          c20run_path[smalln]=c20;
          c10run_path[smalln]=c10;
          c4run_path[smalln]=c4;
          c2run_path[smalln]=c2;
          c1run_path[smalln]=c1;

          hhi50run_path[smalln]=hhi50;

          beta*=constants[2];
        }
      } // smalln>L


      // Simulate next state
      newstate=0;
      for(int x=0;x<xmax;++x) {
        int i1;
        if(nonstatparams[18]==2) {
          i1=x*(Tbar+1)+time_offset;
        } else {
          i1=time_offset;
        }
        iota = iotaMatrix.getRow(i1);
        rho = rhoMatrix.getRow(i1);
        continuationProb(rho, prcont, condexp);
        tranProb(iota, tranMatrix, contTranMatrix, prcont);
        for(int j=0;j<state[x];++j) {
          int xprime = genDistr(P,contTranMatrix.getRow(x));
          newstate[xprime]++;
        }

        // Record previous state
        firmsnumberrun[x]+=state[x];

        if(bounds[12]==1) {
          firmsnumberrun_path[smalln][x]=state[x];
        }
      }

      int entrants;
      // Simulate entry
      if(control[2]>0) {
        entrants = 0;
      } else {
        if(control[1]==2) {
          double p;
          if(ceil(lambda[0])!=floor(lambda[0])) {
            p=(ceil(lambda[0])-lambda[0])/(ceil(lambda[0])-floor(lambda[0]));
          } else {
            p=0;
          }
          if(P.genUniform()>p) {
            entrants=int(ceil(lambda[0]));
          } else {
            entrants=int(floor(lambda[0]));
          }
        } else {
          entrants = P.genPoisson(lambda[0]);
        }
      }

      // Add entry
      newstate[int(constants[3])-1]+=entrants;

      // Prepare for next iteration
      state=newstate;
      d = genDistr(P,shockTran->getRow(d));
      Dvector=0;
      Dvector[d]=1;
      
    
      //cout << "State: ";
      //cout << state << endl;
      //cout << Dvector << endl;
    } // End of smalln loop

    if(bounds[12]==0) {
      prodsurrun/=M;
      conssurrun/=M;
      totalsurrun/=M;
    
//    if(control[2]==0) entraterun/=M;
      invrun/=M;
    }
    c20run/=M;
    c10run/=M;
    c4run/=M;
    c2run/=M;
    c1run/=M;
    hhi50run/=M;
    firmsnumberrun/=M;

    prodsursum+=prodsurrun;
    conssursum+=conssurrun;
    totalsursum+=(prodsurrun+conssurrun);
    invsum+=invrun;

    prodsursqr+=prodsurrun*prodsurrun;
    conssursqr+=conssurrun*conssurrun;
    totalsursqr+=(prodsurrun+conssurrun)*(prodsurrun+conssurrun);
    invsqr+=invrun*invrun;

    c20sum+=c20run;
    c10sum+=c10run;
    c4sum+=c4run;
    c2sum+=c2run;
    c1sum+=c1run;
    hhi50sum+=hhi50run;
    firmsnumbersum+=firmsnumberrun;

    c20sqr+=c20run*c20run;
    c10sqr+=c10run*c10run;
    c4sqr+=c4run*c4run;
    c2sqr+=c2run*c2run;
    c1sqr+=c1run*c1run;
    hhi50sqr+=hhi50run*hhi50run;
    firmsnumbersqr+=firmsnumberrun*firmsnumberrun;

    if(bounds[12]==1) {
      prodsursum_path+=prodsurrun_path;
      conssursum_path+=conssurrun_path;
      totalsursum_path+=totalsurrun_path;
      invsum_path+=invrun_path;

      prodsursqr_path+=prodsurrun_path*prodsurrun_path;
      conssursqr_path+=conssurrun_path*conssurrun_path;
      totalsursqr_path+=totalsurrun_path*totalsurrun_path;
      invsqr_path+=invrun_path*invrun_path;

      c20sum_path+=c20run_path;
      c10sum_path+=c10run_path;
      c4sum_path+=c4run_path;
      c2sum_path+=c2run_path;
      c1sum_path+=c1run_path;
      hhi50sum_path+=hhi50run_path;
      firmsnumbersum_path+=firmsnumberrun_path;

      c20sqr_path+=c20run_path*c20run_path;
      c10sqr_path+=c10run_path*c10run_path;
      c4sqr_path+=c4run_path*c4run_path;
      c2sqr_path+=c2run_path*c2run_path;
      c1sqr_path+=c1run_path*c1run_path;
      hhi50sqr_path=hhi50run_path*hhi50run_path;
      firmsnumbersqr_path+=firmsnumberrun_path*firmsnumberrun_path;
    }

    if(n>bounds[4]) {
      compAvgPre(prodsursum,prodsursqr,n,prodsuravg,prodsurpre,prodsurvar);
      compAvgPre(conssursum,conssursqr,n,conssuravg,conssurpre,conssurvar);
      compAvgPre(totalsursum,totalsursqr,n,totalsuravg,totalsurpre,totalsurvar);
      compAvgPre(invsum,invsqr,n,invavg,invpre,invvar);
    
      boundspre=prodsurpre;
      boundspre=MAX(conssurpre,boundspre);
      boundspre=MAX(totalsurpre,boundspre);
      boundspre=MAX(invpre,boundspre);

      compAvgPre(c1sum,c1sqr,n,c1avg,c1pre,c1var);
      compAvgPre(c2sum,c2sqr,n,c2avg,c2pre,c2var);
      compAvgPre(c4sum,c4sqr,n,c4avg,c4pre,c4var);
      compAvgPre(c10sum,c10sqr,n,c10avg,c10pre,c10var);
      compAvgPre(c20sum,c20sqr,n,c20avg,c20pre,c20var);

      boundspre=MAX(c1pre,boundspre);
      boundspre=MAX(c2pre,boundspre);
      boundspre=MAX(c4pre,boundspre);
      boundspre=MAX(c10pre,boundspre);
      boundspre=MAX(c20pre,boundspre);

      compAvgPre(hhi50sum,hhi50sqr,n,hhi50avg,hhi50pre,hhi50var);

      boundspre=MAX(hhi50pre,boundspre);

      compAvgPre(firmsnumbersum,firmsnumbersqr,n,*firmsnumberavg,*firmsnumberpre,*firmsnumbervar);
     
      if(bounds[12]==1) {
        compAvgPre(prodsursum_path,prodsursqr_path,n,*prodsuravg_path,*prodsurpre_path,*prodsurvar_path);
        compAvgPre(conssursum_path,conssursqr_path,n,*conssuravg_path,*conssurpre_path,*conssurvar_path);
        compAvgPre(totalsursum_path,totalsursqr_path,n,*totalsuravg_path,*totalsurpre_path,*totalsurvar_path);
        compAvgPre(invsum_path,invsqr_path,n,*invavg_path,*invpre_path,*invvar_path);

        compAvgPre(c1sum_path,c1sqr_path,n,*c1avg_path,*c1pre_path,*c1var_path);
        compAvgPre(c2sum_path,c2sqr_path,n,*c2avg_path,*c2pre_path,*c2var_path);
        compAvgPre(c4sum_path,c4sqr_path,n,*c4avg_path,*c4pre_path,*c4var_path);
        compAvgPre(c10sum_path,c10sqr_path,n,*c10avg_path,*c10pre_path,*c10var_path);
        compAvgPre(c20sum_path,c20sqr_path,n,*c20avg_path,*c20pre_path,*c20var_path);

        compAvgPre(hhi50sum_path,hhi50sqr_path,n,*hhi50avg_path,*hhi50pre_path,*hhi50var_path);

        compAvgPre(firmsnumbersum_path,firmsnumbersqr_path,n,*firmsnumberavg_path,*firmsnumberpre_path,*firmsnumbervar_path);
      } 

      //boundspre=MAX(max(*firmsnumberpre),boundspre);

      cout << prodsuravg << endl;
      cout << conssuravg << endl;
      cout << invavg << endl;
    }

    n++;
  }

  if(g!=NULL) delete g;
}


void CompOE_nonstat::computeBoundsNonstat(double *bounds, MatrixMTL<double> &iotaMatrix, MatrixMTL<double> &rhoMatrix,
  MatrixMTL<double> &sMatrix, VectorMTL<double> &lambdaVector, MatrixMTL<double> &pMatrix) {

  xmax = pMatrix.getLength();
  int Tbar = pMatrix.getHeight()-1;

  VectorMTL<double> iota(xmax);
  VectorMTL<double> rho(xmax);

  VectorMTL<double> prcont(xmax);
  VectorMTL<double> condexp(xmax);

  VectorMTL<double> tildes(xmax);
  VectorMTL<double> proftildes(xmax);
  VectorMTL<double> prices(xmax);

  VectorMTL<double> term2(xmax);

  VectorMTL<double> bound1sum(xmax), bound1sqr(xmax), bound1sum_sim(xmax);
  VectorMTL<double> bound2sum(xmax), bound2sqr(xmax), bound2sum_sim(xmax);
  VectorMTL<double> bound3sum(xmax), bound3sqr(xmax), bound3sum_sim(xmax);

  VectorMTL<double> prof_oe(xmax);
  // Determine kmax
  prices = pMatrix.getRow(Tbar);
  tildes = sMatrix.getRow(Tbar+1);
  compProf(tildes, prices, prof_oe);

  int kmax=int(MAX(xmax+1,log(0.01*(1.0-constants[2])/prof_oe[xmax-1])/log(constants[2])));
  kmax=MAX(Tbar+2,kmax); // It must be at least Tbar+2

//  int kmax=100;

  #if TRANSITION_MATRIX == 0 
    MatrixMTL<double> tranMatrix(xmax,xmax);
    MatrixMTL<double> contTranMatrix(xmax,xmax);
    MatrixMTL<double> contTranMatrixOE(xmax,xmax);
    MatrixMTL<double> contTranMatrix_infty(xmax,xmax);
    MatrixMTL<double> contTranMatrix_temp(xmax,xmax);
    MatrixMTL3D<double> prcontMatrix(xmax,xmax,Tbar);
  #elif TRANSITION_MATRIX == 1 
    TriDiagMatrixMTL<double> tranMatrix(xmax);
    TriDiagMatrixMTL<double> contTranMatrix(xmax);
    TriDiagMatrixMTL<double> contTranMatrixOE(xmax);
    TriDiagMatrixMTL<double> contTranMatrix_infty(xmax);
    TriDiagMatrixMTL<double> contTranMatrix_temp(xmax);
    TriDiagMatrix3D<double> prcontMatrix(xmax,Tbar);
  #elif TRANSITION_MATRIX == 2 
    SparseMatrixMTL<double> tranMatrix;
    SparseMatrixMTL<double> contTranMatrix;
    SparseMatrixMTL<double> contTranMatrixOE;
    SparseMatrixMTL<double> contTranMatrix_infty;
    SparseMatrixMTL<double> contTranMatrix_temp;
    SparseMatrix3D<double> prcontMatrix(Tbar);
  #else 
    #error Invalid value for TRANSITION_MATRIX
  #endif

  MatrixMTL<double> temp(xmax);
  VectorMTL<double> profsim(xmax);

  MatrixMTL3D<double> disc_Freq(xmax,xmax,kmax);
  MatrixMTL<double> disc_Freq_OE(xmax,xmax);

  MatrixMTL<double> proftildesMatrix(Tbar+1,xmax);
  VectorMTL<double> difprofit(xmax);
  VectorMTL<double> difprofitpos(xmax);
  MatrixMTL<double> profitPrecomp(xmax);

  if (bound1avg_nonstat!=NULL) delete bound1avg_nonstat;
  if (bound1var_nonstat!=NULL) delete bound1var_nonstat;
  if (bound1pre_nonstat!=NULL) delete bound1pre_nonstat;
  if (bound1por_nonstat!=NULL) delete bound1por_nonstat;

  bound1avg_nonstat = new VectorMTL<double>(xmax);
  bound1var_nonstat = new VectorMTL<double>(xmax);
  bound1pre_nonstat = new VectorMTL<double>(xmax);
  bound1por_nonstat = new VectorMTL<double>(xmax);

  if (bound2avg_nonstat!=NULL) delete bound2avg_nonstat;
  if (bound2var_nonstat!=NULL) delete bound2var_nonstat;
  if (bound2pre_nonstat!=NULL) delete bound2pre_nonstat;
  if (bound2por_nonstat!=NULL) delete bound2por_nonstat;

  bound2avg_nonstat = new VectorMTL<double>(xmax);
  bound2var_nonstat = new VectorMTL<double>(xmax);
  bound2pre_nonstat = new VectorMTL<double>(xmax);
  bound2por_nonstat = new VectorMTL<double>(xmax);

  if (bound3avg_nonstat!=NULL) delete bound3avg_nonstat;
  if (bound3var_nonstat!=NULL) delete bound3var_nonstat;
  if (bound3pre_nonstat!=NULL) delete bound3pre_nonstat;
  if (bound3por_nonstat!=NULL) delete bound3por_nonstat;

  bound3avg_nonstat = new VectorMTL<double>(xmax);
  bound3var_nonstat = new VectorMTL<double>(xmax);
  bound3pre_nonstat = new VectorMTL<double>(xmax);
  bound3por_nonstat = new VectorMTL<double>(xmax);

  double tol1=bounds[1]/(1+bounds[1]);

  bound1sum = 0;
  bound1sqr = 0;
  bound2sum = 0;
  bound2sqr = 0;
  bound3sum = 0;
  bound3sqr = 0;

  double prodsursum=0;
  double prodsursqr=0;
  double conssursum=0;
  double conssursqr=0;
  double totalsursum=0;
  double totalsursqr=0;
  double invsum=0;
  double invsqr=0;

  MatrixMTL<double> *g=NULL;

  int computebound2 = 1;

  // First compute deterministic part 2

  // 1) Precompute the multiplication matrices and compute non-stationary part of term2 sum
  disc_Freq[0].eye();

  int xmax_ext = xmax * int(bounds[7]);

  tildes = sMatrix.getRow(0);
  prices = pMatrix.getRow(0);

  // Initialize term2
  compProf(tildes, prices, term2);
  proftildesMatrix.setRow(0,term2);

  for(int t=0;t<Tbar;t++) {
    rho = rhoMatrix.getRow(t);
    iota = iotaMatrix.getRow(t);
    continuationProb(rho, prcont, condexp);
    tranProb(iota, tranMatrix, contTranMatrix, prcont);

    // Save transition matrix for later
    prcontMatrix[t]=contTranMatrix;

    // Compute discounted frequency
    contTranMatrix*=constants[2];
    disc_Freq[t+1]=disc_Freq[t].dot(contTranMatrix);

    // Compute profits for t+1
    tildes = sMatrix.getRow(t+1);
    prices = pMatrix.getRow(t+1);

    compProf(tildes, prices, proftildes);

    // Save profit for later
    proftildesMatrix.setRow(t+1,proftildes);
 
    term2+=disc_Freq[t+1].dot(proftildes);
  }

  // Compute the discounted frequency for adding OE bounds at the end
  rho = rhoMatrix.getRow(Tbar); // OE rho
  iota = iotaMatrix.getRow(Tbar); // OE iota
  continuationProb(rho, prcont, condexp);
  tranProb(iota, tranMatrix, contTranMatrixOE, prcont);

  iota = 1e20;
  prcont = 1.0;
  tranProb(iota, tranMatrix, contTranMatrix_infty, prcont);

  contTranMatrix_temp=contTranMatrixOE;
  contTranMatrix_temp*=-constants[2];

  contTranMatrix_temp.addDiag(1);

  if(!contTranMatrix_temp.inverse(temp)) {
    cout << "Bound calculation routine error: Cannot invert the discount Matrix" << endl;
    exit(0);
  }

  // Compute more of x-transition matrices for simulation of the markov chain beyond Tbar
  for(int t=Tbar+1;t<kmax;t++) {
    disc_Freq[t]=disc_Freq[t-1].dot(contTranMatrixOE);
    disc_Freq[t]*=constants[2];
  }

  // Discount the stationary frequency // ADD ADDITIONAL Pbeta
  disc_Freq_OE=disc_Freq[Tbar+1].dot(temp);

  // Add the stationary sum of profits at tildes_oe to term2
  term2+=disc_Freq_OE.dot(prof_oe);


  // Compute the parameters for the simulation of OE at the end of the sum
  MatrixMTL<double> Prob(1,xmax);
  double p=0;

  VectorMTL<double> sta_distr(xmax);

  if(control[2]>0) {
    sta_distr = tildes/(control[2]-1);
  } else {
    if(control[1]==2) {
      int time=1;
      MatrixMTL<double> A(xmax,xmax);
      A.eye();

      for(int i=0;i<xmax;i++) {
        Prob[0][i]=A[int(constants[3])][i];
      }
      A=A.dot(contTranMatrix);

      if (bounds[6]<=sum(Prob.getRow(0))) {
        while(time<bounds[5]) {
          Prob.extraRow(1);
          for(int i=0;i<xmax;i++) {		// row time of matrix Prob is a vector with probs of being
            Prob[time][i]=A[int(constants[3])-1][i];	// in each state after time periods in the industry
          }
          A=A.dot(contTranMatrix);

          if (bounds[6]>sum(Prob.getRow(time))) {
            break;
          }
          // Compute prob. to randomize number of entrants if lambda non-integer
          if(ceil(lambdaVector[Tbar])!=floor(lambdaVector[Tbar])) {
            p=(ceil(lambdaVector[Tbar])-lambdaVector[Tbar])/(ceil(lambdaVector[Tbar])-floor(lambdaVector[Tbar]));
          } else {
            p=0;
          }
          if(time==bounds[5]) {
            cout << "Time limit reached when computing distribution to sample states with fixed number of entrants\n";
          }
          time++;
        }
      }
    }
  }

  g = new MatrixMTL<double>(kmax+1,kmax+1);

  for (int i=0; i<=kmax; i++) {
    for (int m=0;m<=kmax;m++) {
      (*g)[i][m]= binopdf(m,i,1-transition[1]);
    }
  }

  VectorMTL<int> bound3_x(xmax);

  // Start simulation
  double boundspre=tol1+1;

  RanGenLib P;
  int n=1;

  while((boundspre>tol1) || 
    (n<=bounds[4])) {

    #ifdef COUT_DEBUG
      cout << "Bound iteration: " << n << ", TOL: "<< boundspre << endl;
    #endif
    #ifdef DEBUG
      *myfile << "Bound iteration: " << n << ", TOL: "<< boundspre << endl;
    #endif


    if (n>bounds[3]) break; 

    VectorMTL<double> term3(xmax);

    // Simulate industry evolution

    // Simulate starting state
    VectorMTL<double> state(xmax);
    state = sMatrix.getRow(0);

    // Compute profits at initial simulated state
    prices=pMatrix.getRow(0);

    double prodsur, conssur;
    VectorMTL<double> ms(xmax), profit_extra(xmax);

    VectorMTL<double> state_extra(xmax), tildes_extra(xmax), pricesOut(xmax);
    state_extra=sMatrix.getRow(0);

    // Add extra firm if fixed number of firms
    if(control[2]>0)
      state_extra[(int) nonstatparams[17]]++;

    compProfAndStats_extra(state_extra,prices,pricesOut,profit_extra,ms,prodsur,conssur);
    double prodsursim=prodsur;
    double conssursim=conssur;
    double totalsursim=(prodsur+conssur);

    // Initialize investment 
    double invsim=0;  
    for(int x=0;x<xmax;x++) {
      invsim+=state_extra[x]*(iotaMatrix[0][x]);
    }

    compProf(state, prices, profsim);

    // Create difprofit for this industry path
    proftildes=proftildesMatrix.getRow(0);
    profsim-=proftildes;

    for(int x=0;x<xmax;x++) {
        bound3_x[x]=x;
        bound1sum_sim[x]= MACRO__POSITIVE(profsim[x]);
        bound2sum_sim[x]= MACRO__POSITIVE(profsim[x]);
        bound3sum_sim[x]= MACRO__POSITIVE(profsim[x]);
    }


    // Initialize term3, disc_Freq[0]=I
    term3=proftildes;

    double beta = constants[2];

    // Simulate next states, Tbar+1 in the loop because last state goes forever as oe
    for(int t=1;t<kmax;t++) {
      // Draw new state
      for(int x=0;x<xmax;x++) {
        bound3_x[x]=genDistr(P,contTranMatrix_infty.getRow(bound3_x[x]));
      }

      // Simulate evolution
      if(t>Tbar) {
        tildes.genMarkov(P,contTranMatrixOE,state);
        lambda = lambdaVector[Tbar];
        tildes_extra.genMarkov(P,contTranMatrixOE,state_extra);

        // Sum the investment
        if(nonstatparams[16]>0) {
          if(nonstatparams[16]>t) {
            for(int x=0;x<xmax;x++) {
              invsim+=tildes_extra[x]*(iotaMatrix[Tbar][x]);
            }
          }
        } else {
          for(int x=0;x<xmax;x++) {
            invsim+=tildes_extra[x]*(beta*iotaMatrix[Tbar][x]);
          }
        }
      } else {
        tildes.genMarkov(P,prcontMatrix[t-1],state);
        lambda = lambdaVector[t-1];
        tildes_extra.genMarkov(P,prcontMatrix[t-1],state_extra);

        if(nonstatparams[16]>0) {
          if(nonstatparams[16]>t) {
            for(int x=0;x<xmax;x++) {
              invsim+=tildes_extra[x]*(beta*iotaMatrix[t][x]);
            }
          } 
        } else {
          if(t==kmax-1) {
            for(int x=0;x<xmax;x++) {
              invsim+=tildes_extra[x]*(beta*iotaMatrix[t][x])/(1-constants[2]);
            }
          } else {
            for(int x=0;x<xmax;x++) {
              invsim+=tildes_extra[x]*(beta*iotaMatrix[t][x]);
            }
          }
        }
      }

      int entrants;
      // Simulate entry
      if(control[2]>0) {
        entrants = 0;
      } else {
        if(control[1]==2) {
          double p;
          if(ceil(lambda)!=floor(lambda)) {
            p=(ceil(lambda)-lambda)/(ceil(lambda)-floor(lambda));
          } else {
            p=0;
          }
          if(P.genUniform()>p) {
             entrants=int(ceil(lambda));
          } else {
             entrants=int(floor(lambda));
          }
        } else {
          entrants = P.genPoisson(lambda);
        }
      }

      // Add entry
      tildes[int(constants[3])-1]+=entrants;

      // Compute profits at simulated state
      if(t>Tbar) {
        prices=pMatrix.getRow(Tbar);
      } else {
        prices=pMatrix.getRow(t);
      }

      compProfAndStats_extra(tildes_extra,prices,pricesOut,profit_extra,ms,prodsur,conssur);
      if(nonstatparams[16]>0) {
        if(nonstatparams[16]>t) {
          prodsursim+=prodsur;
          conssursim+=conssur;
          totalsursim+=(prodsur+conssur);
        }  
      } else {
        prodsursim+=beta*prodsur;
        conssursim+=beta*conssur;
        totalsursim+=beta*(prodsur+conssur);
      }

      compProf(tildes, prices, profsim);

      // Add discounted profits times unconditional transition matrix to term3
      term3+=disc_Freq[t].dot(profsim);

      // Create difprofit for this industry path
      if(t<=Tbar) {
        proftildes=proftildesMatrix.getRow(t);
        profsim-=proftildes;
      } else {
        profsim-=prof_oe;
      }

      if(computebound2>0) {
        for(int i=0;i<xmax_ext-1;i++) {
          if(MAX(profsim[i],0)-MAX(profsim[i+1],0)>bounds[9]*proftildes[i]) {
            #ifdef COUT_DEBUG
            cout << "Delta_y not increasing (" << MAX(profsim[i],0)-MAX(profsim[i+1],0) << ") tol=" << bounds[9]*proftildes[i] <<
              ") for t=" << t << " and y=" << i << endl;
            #endif
            #ifdef DEBUG
            *myfile << "Delta_y not increasing (" << MAX(profsim[i],0)-MAX(profsim[i+1],0) << ") tol=" << bounds[9]*proftildes[i] <<
              ") for t=" << t << " and y=" << i << endl;
            #endif
            computebound2 = 0;
            *myfile << tildes << endl;
            *myfile << sMatrix.getRow(t) << endl;
          }
        }
      }

      for(int x=0;x<xmax;x++) {
        // Compute bound1
        int lowx = MAX(x-int(bounds[8])*t,0);
        int highx = MIN(x+int(bounds[8])*t,xmax_ext-1);

        bound1sum_sim[x]+=beta*MACRO__POSITIVE(max(profsim.subVector(lowx,highx)));

        if(computebound2==1) {
          // Compute bound2
          if(int(bounds[8])==1) {
            for(int y=x;y<=x+t;y++) {
              bound2sum_sim[x]+=beta*(*g)[t][y-x]*MAX(profsim[MIN(y,xmax_ext-1)],0);
            }
          } else {
            bound2sum_sim[x]=0;
          }

          // Compute bound3
          bound3sum_sim[x]+=beta*MAX(profsim[bound3_x[x]],0);
        } else {
            bound2sum_sim[x]=0;
            bound3sum_sim[x]=0;
        }
      }

      // Prepare for next iteration
      state=tildes;
      state_extra=tildes_extra;
      beta*=constants[2];
    }

    bound1sum += (bound1sum_sim + term2 - term3);
    bound1sqr += (bound1sum_sim + term2 - term3)*(bound1sum_sim + term2 - term3);

    if(computebound2==1) {
      if(int(bounds[8])==1) {
        bound2sum += (bound2sum_sim + term2 - term3);
        bound2sqr += (bound2sum_sim + term2 - term3)*(bound2sum_sim + term2 - term3);
      }
      bound3sum += (bound3sum_sim + term2 - term3);
      bound3sqr += (bound3sum_sim + term2 - term3)*(bound3sum_sim + term2 - term3);
    }

    if(nonstatparams[16]>0) {
      prodsursim/=nonstatparams[16];
      conssursim/=nonstatparams[16];
      invsim/=nonstatparams[16];
    } else {
      prodsursim+=beta/(1-constants[2])*prodsur;
      conssursim+=beta/(1-constants[2])*conssur;
      totalsursim+=beta/(1-constants[2])*(conssur+prodsur);

    }

    prodsursum+=prodsursim;
    prodsursqr+=prodsursim*prodsursim;
    conssursum+=conssursim;
    conssursqr+=conssursim*conssursim;
    totalsursum+=prodsursim+conssursim;
    totalsursqr+=(prodsursim+conssursim)*(prodsursim+conssursim);

    invsum+=invsim;
    invsqr+=invsim*invsim;
//    cout << invsim << endl << invsum << endl << invsqr << endl;

//    if(n>=bounds[4]) {
      if(n>2) {
      compAvgPre(bound1sum,bound1sqr,n,*bound1avg_nonstat,*bound1pre_nonstat,*bound1var_nonstat);
        if(computebound2!=0) {
          if(int(bounds[8])==1) {
            compAvgPre(bound2sum,bound2sqr,n,*bound2avg_nonstat,*bound2pre_nonstat,*bound2var_nonstat);
          } else {
            *bound2avg_nonstat=0;
            *bound2pre_nonstat=0;
            *bound2var_nonstat=0;
          }
          compAvgPre(bound3sum,bound3sqr,n,*bound3avg_nonstat,*bound3pre_nonstat,*bound3var_nonstat);
        } else {
          *bound2avg_nonstat=0;
          *bound2pre_nonstat=0;
          *bound2var_nonstat=0;

          *bound3avg_nonstat=0;
          *bound3pre_nonstat=0;
          *bound3var_nonstat=0;
        }
        boundspre=max(*bound1pre_nonstat);
        double pretemp;
        if((pretemp=max(*bound2pre_nonstat))>boundspre) boundspre=pretemp;
        if((pretemp=max(*bound3pre_nonstat))>boundspre) boundspre=pretemp;

        compAvgPre(prodsursum,prodsursqr,n,prodsurOut_nonstat,prodsurpre_nonstat,prodsurvar_nonstat);
        compAvgPre(conssursum,conssursqr,n,conssurOut_nonstat,conssurpre_nonstat,conssurvar_nonstat);
        compAvgPre(totalsursum,totalsursqr,n,totalsurOut_nonstat,totalsurpre_nonstat,totalsurvar_nonstat);
        compAvgPre(invsum,invsqr,n,invOut_nonstat,invpre_nonstat,invvar_nonstat);
    }
    n++;
  }

  if(g!=NULL) delete g;
}

CompOE_nonstat::~CompOE_nonstat() {
  if(profitMatrix_global!=NULL) {
    delete profitMatrix_global;
  }
  if(rhoMatrix_global!=NULL) {
    delete rhoMatrix_global;
  }
  if(iotaMatrix_global!=NULL) {
    delete iotaMatrix_global;
  }
  if(lambdaVector_global!=NULL) {
    delete lambdaVector_global;
  }
  if(V_global!=NULL) {
    delete V_global;
  }
  if(s_global!=NULL) {
    delete s_global;
  }
  if(p_global!=NULL) {
    delete p_global;
  }

  stackItem *temp;
  while (!stackResolving->empty()) {
    temp = (stackItem *) stackResolving->top();
    delete temp->state;
    delete temp->iota;
    delete temp->rho;
    delete temp;
    stackResolving->pop();
  }
  delete stackResolving;

  if (bound1avg_nonstat!=NULL) delete bound1avg_nonstat;
  if (bound1var_nonstat!=NULL) delete bound1var_nonstat;
  if (bound1pre_nonstat!=NULL) delete bound1pre_nonstat;
  if (bound1por_nonstat!=NULL) delete bound1por_nonstat;

  if (bound2avg_nonstat!=NULL) delete bound2avg_nonstat;
  if (bound2var_nonstat!=NULL) delete bound2var_nonstat;
  if (bound2pre_nonstat!=NULL) delete bound2pre_nonstat;
  if (bound2por_nonstat!=NULL) delete bound2por_nonstat;

  if (bound3avg_nonstat!=NULL) delete bound3avg_nonstat;
  if (bound3var_nonstat!=NULL) delete bound3var_nonstat;
  if (bound3pre_nonstat!=NULL) delete bound3pre_nonstat;
  if (bound3por_nonstat!=NULL) delete bound3por_nonstat;

  if(ED!=NULL) delete ED;
}
